/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import java.util.StringTokenizer;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.mom.EnumCertCategory;

public class CertSpec {
    private int category = -1;
    private String fileName = null;
    private String serialNumber = null;
    public String fingerprint = null;
    public static final String FILE_NAME = "fileName";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String FINGERPRINT = "fingerprint";
    public static final String CATEGORY = "category";
    public static final int SERIALNUMBER_MAX = 40;

    public CertSpec() throws MoAccessException {
    }

    public CertSpec(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 4) {
            throw new ValueOutOfRangeException("Missing member in certSpec", "Security");
        }
        if (!(struct.getValue(FILE_NAME) instanceof String)) {
            throw new WrongAttributeTypeException(FILE_NAME, "Security");
        }
        this.fileName = (String)struct.getValue(FILE_NAME);
        if (!(struct.getValue(SERIAL_NUMBER) instanceof String)) {
            throw new WrongAttributeTypeException(SERIAL_NUMBER, "Security");
        }
        this.serialNumber = (String)struct.getValue(SERIAL_NUMBER);
        if (!(struct.getValue(FINGERPRINT) instanceof String)) {
            throw new WrongAttributeTypeException(FINGERPRINT, "Security");
        }
        this.fingerprint = (String)struct.getValue(FINGERPRINT);
        if (!(struct.getValue(CATEGORY) instanceof Integer)) {
            throw new WrongAttributeTypeException(CATEGORY, "Security");
        }
        this.category = (Integer)struct.getValue(CATEGORY);
        this.check();
    }

    protected int getCategory() {
        return this.category;
    }

    protected String getSerialNumber() {
        return this.serialNumber;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFingerprint() {
        return this.fingerprint;
    }

    private void check() throws MoAccessException {
        if (this.serialNumber == null || this.serialNumber.length() < 1 || this.serialNumber.length() > 40) {
            throw new ValueOutOfRangeException("serialNumber String too long/empty", "Security");
        }
        if (this.fileName == null || this.fileName.length() > 255) {
            throw new ValueOutOfRangeException("fileName String too long", "Security");
        }
        if (this.fingerprint == null || this.fingerprint.length() > 127) {
            throw new ValueOutOfRangeException("fingerprint String too long", "Security");
        }
        MoAttributeValidator.checkEnumAttribute((String)CATEGORY, (int)this.category, (int[])EnumCertCategory.VALUES_ARRAY, (String)"Security");
    }

    private boolean checkFingerprint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("MD5") == 0) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
                return stringTokenizer2.countTokens() == 16;
            }
            if (string2.indexOf("SHA-1") == 0 || string2.indexOf("SHA1") == 0) {
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ":");
                return stringTokenizer3.countTokens() == 20;
            }
            return false;
        }
        return false;
    }
}

