/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.mom.EnumCertEnrollMode;
import se.ericsson.cello.security.mom.EnumKeyLength;

public class EnrollmentData {
    private String enrollmentServerURL = null;
    private String caFingerPrint = null;
    private String distinguishedName = null;
    private String challengePassword = null;
    private int rollbackTimeout = 10;
    private int keyLength = 0;
    private int enrollmentMode = 0;
    private String certificateAuthorityDn = "";
    public static final String ENROLLMENT_SERVER_URL = "enrollmentServerURL";
    public static final String CA_FINGER_PRINT = "caFingerPrint";
    public static final String DISTINGUISHED_NAME = "distinguishedName";
    public static final String CHALLENGE_PASSWORD = "challengePassword";
    public static final String ROLLBACK_TIMEOUT = "rollbackTimeOut";

    public EnrollmentData() throws MoAccessException {
    }

    public EnrollmentData(Struct struct) throws MoAccessException {
        Object object;
        String[] stringArray = struct.getNames();
        if (stringArray.length < 5 || stringArray.length > 8) {
            throw new ValueOutOfRangeException("Wrong number of members in enrollmentData", "Security");
        }
        if (!(struct.getValue(ENROLLMENT_SERVER_URL) instanceof String)) {
            throw new WrongAttributeTypeException(ENROLLMENT_SERVER_URL, "Security");
        }
        this.enrollmentServerURL = (String)struct.getValue(ENROLLMENT_SERVER_URL);
        if (!(struct.getValue(CA_FINGER_PRINT) instanceof String)) {
            throw new WrongAttributeTypeException(CA_FINGER_PRINT, "Security");
        }
        this.caFingerPrint = (String)struct.getValue(CA_FINGER_PRINT);
        if (!(struct.getValue(DISTINGUISHED_NAME) instanceof String)) {
            throw new WrongAttributeTypeException(DISTINGUISHED_NAME, "Security");
        }
        this.distinguishedName = (String)struct.getValue(DISTINGUISHED_NAME);
        if (!(struct.getValue(CHALLENGE_PASSWORD) instanceof String)) {
            throw new WrongAttributeTypeException(CHALLENGE_PASSWORD, "Security");
        }
        this.challengePassword = (String)struct.getValue(CHALLENGE_PASSWORD);
        if (!(struct.getValue(ROLLBACK_TIMEOUT) instanceof Integer)) {
            throw new WrongAttributeTypeException(ROLLBACK_TIMEOUT, "Security");
        }
        this.rollbackTimeout = (Integer)struct.getValue(ROLLBACK_TIMEOUT);
        try {
            object = struct.getValue("keyLength");
            if (!(object instanceof Integer)) {
                throw new WrongAttributeTypeException("keyLength", "Security");
            }
            this.keyLength = (Integer)object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.keyLength = 0;
        }
        try {
            object = struct.getValue("enrollmentMode");
            if (!(object instanceof Integer)) {
                throw new WrongAttributeTypeException("enrollmentMode", "Security");
            }
            this.enrollmentMode = (Integer)object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.enrollmentMode = 0;
        }
        try {
            object = struct.getValue("certificateAuthorityDn");
            if (!(object instanceof String)) {
                throw new WrongAttributeTypeException("certificateAuthorityDn", "Security");
            }
            this.certificateAuthorityDn = (String)object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.certificateAuthorityDn = "";
        }
        this.check();
    }

    protected int getRollbackTimeOut() {
        return this.rollbackTimeout;
    }

    protected String getEnrollmentServerURL() {
        return this.enrollmentServerURL;
    }

    protected String getCaFingerPrint() {
        return this.caFingerPrint;
    }

    protected String getDistinguishedName() {
        return this.distinguishedName;
    }

    protected String getChallengePassword() {
        return this.challengePassword;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    protected int getEnrollmentMode() {
        return this.enrollmentMode;
    }

    protected String getCertificateAuthorityDn() {
        return this.certificateAuthorityDn;
    }

    private void check() throws MoAccessException {
        if (this.enrollmentServerURL == null || this.enrollmentServerURL.length() > 255) {
            throw new ValueOutOfRangeException("enrollmentServerURL String too long", "Security");
        }
        if (this.distinguishedName == null || this.distinguishedName.length() > 511 || this.distinguishedName.length() < 1) {
            throw new ValueOutOfRangeException("distinguishedName String too long/empty. ", "Security");
        }
        if (this.caFingerPrint == null || this.caFingerPrint.length() > 127) {
            throw new ValueOutOfRangeException("caFingerPrint String format invalid/null", "Security");
        }
        if (this.challengePassword == null || this.challengePassword.length() > 21) {
            throw new ValueOutOfRangeException("challengePassword String format invalid/null", "Security");
        }
        if (!MoAttributeValidator.isWithinEnum((int)this.keyLength, (int[])EnumKeyLength.VALUES_ARRAY)) {
            throw new ValueOutOfRangeException("keyLength", "Security");
        }
        MoAttributeValidator.checkIntegerAttribute((String)ROLLBACK_TIMEOUT, (int)this.rollbackTimeout, (int)0, (int)240, (String)"Security");
        if (!MoAttributeValidator.isWithinEnum((int)this.enrollmentMode, (int[])EnumCertEnrollMode.VALUES_ARRAY)) {
            throw new ValueOutOfRangeException("enrollmentModeInvalid value.", "Security");
        }
        if (!this.certificateAuthorityDn.equals("") && this.certificateAuthorityDn.length() > 511) {
            throw new ValueOutOfRangeException("certificateAuthorityDnInvalid value.", "Security");
        }
    }
}

