/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import java.util.ArrayList;
import java.util.HashSet;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.security.RealTimeSecLogMoGen;
import se.ericsson.cello.security.StructServerConfigImpl;
import se.ericsson.cello.transaction.Coordinator;

public class RealTimeSecLogMoImpl
extends RealTimeSecLogMoGen {
    private static final String VALIDATED_DOMAIN_NAME = "ValidatedDomainName";

    public RealTimeSecLogMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public RealTimeSecLogMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void actionAddExternalServer(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getExtServerListConfig(coordinator);
        Struct[] structArray2 = new Struct[structArray.length + 1];
        for (int i = 0; i < structArray.length; ++i) {
            structArray2[i] = structArray[i];
        }
        structArray2[i] = struct;
        this.validateExtServerListConfig(structArray2, null);
        StructParameter structParameter = StructServerConfigImpl.toStructParameter(struct, "RealTimeSecLog", "extServerListConfigElement");
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    public void actionDeleteExternalServer(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getExtServerListConfig(coordinator);
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string2 = (String)struct.getValue("serverName");
            if (!string2.equals(string)) continue;
            bl = true;
            ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
            StringParameter stringParameter = new StringParameter("extServerListConfigElement_serverName", string, 255);
            arrayList.add(stringParameter);
            this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 102, arrayList);
        }
        if (!bl) {
            throw new ActionNotAllowedException("RealTimeSecLog", "ServerName: " + string + " not found.");
        }
    }

    protected void validateExtServerListConfig(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (structArray.length > 2) {
            throw new MaxNumberExceededException("Only 2 external servers are allowed to be configured.", "RealTimeSecLog");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < structArray.length; ++i) {
            RealTimeSecLogMoImpl.checkServerAddress((String)structArray[i].getValue("extServerAddress"));
            String string = (String)structArray[i].getValue("serverName");
            if (hashSet.contains(string)) {
                throw new ValueOutOfRangeException("Duplicate server name " + string + " in " + "extServerListConfig", "RealTimeSecLog");
            }
            hashSet.add(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkServerAddress(String string) throws MoAccessException {
        if (string.equals("")) {
            return;
        }
        if (string.startsWith("[")) {
            int n = string.indexOf("]");
            int n2 = string.lastIndexOf(":");
            if (n <= 0 || n2 <= n || n2 >= string.length() - 2) throw new ValueOutOfRangeException("extServerAddress", "RealTimeSecLog");
            Ipv6Address.validate((String)string.substring(1, n));
            RealTimeSecLogMoImpl.checkPortNo(string.substring(n + 2));
            return;
        } else if (Ipv6Address.isIpv6((String)string)) {
            Ipv6Address.validate((String)string);
            return;
        } else if (Ipv6Address.isIpv4((String)string)) {
            int n = string.indexOf(":");
            if (n != -1) {
                Ipv6Address.validate((String)string.substring(0, n));
                RealTimeSecLogMoImpl.checkPortNo(string.substring(n + 1));
                return;
            } else {
                Ipv6Address.validate((String)string);
            }
            return;
        } else {
            int n = string.indexOf(":");
            if (n >= 0) {
                RealTimeSecLogMoImpl.checkDomainName(string.substring(0, n));
                RealTimeSecLogMoImpl.checkPortNo(string.substring(n + 1));
                return;
            } else {
                RealTimeSecLogMoImpl.checkDomainName(string);
            }
        }
    }

    private static void checkPortNo(String string) throws ValueOutOfRangeException {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValueOutOfRangeException("extServerAddress", "RealTimeSecLog");
        }
    }

    public static void checkDomainName(String string) throws ValueOutOfRangeException {
        char c = string.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            for (int i = 1; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '.') continue;
                throw new ValueOutOfRangeException("extServerAddress", "RealTimeSecLog");
            }
        } else {
            throw new ValueOutOfRangeException("extServerAddress", "RealTimeSecLog");
        }
    }

    public static void create(ManagedObject managedObject, String string, Coordinator coordinator, FroProxy froProxy, InitialMaoContext initialMaoContext, MaoFroIndicationHandler maoFroIndicationHandler) throws MoCanNotBeCreatedException {
        throw new MoCanNotBeCreatedException("RealTimeSecLog");
    }
}

