/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.AccountInfo;
import se.ericsson.cello.security.CertSpec;
import se.ericsson.cello.security.EnrollmentData;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.cello.security.SecurityParameterFilter;
import se.ericsson.cello.security.ipom_vlsmi;
import se.ericsson.cello.security.mom.StructActiveUserDefProfilesInfo;
import se.ericsson.cello.security.mom.StructInstalledUserDefProfilesInfo;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SecurityMoImpl
extends CelloMao
implements SecurityMo,
LogContentInspector {
    private MoData data;
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    private static SecurityMoImpl instance = null;
    private static final String THE_ONLY_SECURITY_ID = "1";
    private static final int THE_ONLY_FRO_ID = 1;
    private static final int AUTH_CACHE_TIME_OUT_DEFAULT = 60;
    private static final int AUTH_CACHE_TIME_OUT_MIN = 15;
    private static final int AUTH_CACHE_TIME_OUT_MAX = 480;
    private static final int IPOM_VLSMI_MAX_AA_FILE_NAME_LENGTH = 256;
    private static final int DOWNLOAD_DURATION_MIN = 5;
    private static final int DOWNLOAD_DURATION_MAX = 600;
    private static final int SEC_LEVEL_3_TM_MIN = 5;
    private static final int SEC_LEVEL_3_TM_MAX = 300;
    private static final int IPADDR_MAX = 10;
    protected static final int CATEGORY_MIN = 0;
    protected static final int CATEGORY_MAX = 5;
    private static final int CERT_EXPIR_WARN_TIME_MIN = 2;
    private static final int CERT_EXPIR_WARN_TIME_MAX = 365;
    protected static final int ROLLBACK_TIMEOUT_MIN = 0;
    protected static final int ROLLBACK_TIMEOUT_MAX = 240;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_UNDEF = 0;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_FTP_CLIENT = 1;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_TELNET_ON = 2;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_DBG_ON = 3;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_USERDB = 4;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_CERT = 5;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_LEVEL_DECLINED = 6;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_USERDB_FAIL = 7;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_CERT_FAIL = 8;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_USERDB_STATUS = 9;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_INSTALL_CERT_STATUS = 10;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_CRED_EXPIRATION = 11;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_CRED_INSTALLED = 12;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_CRED_ROLLBACKED = 13;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_TRUSTED_CERTIFICATE_FAULT_INFO = 14;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_PEER_CERTIFICATE_FAULT_INFO = 15;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_CERT_OK_WITHOUT_REVOCATION_CHECK = 16;
    private static final int IPOM_VLS_FRO_SPEC_EVENT_CRL_DOWNLOAD_FAILURE = 17;
    private static final String[] nodeCertInfoMembers = new String[]{"issuer", "notValidAfter", "notValidBefore", "serialNumber", "subject", "fingerprint"};
    private static final String[] certListMembers = new String[]{"category", "issuer", "notValidAfter", "notValidBefore", "serialNumber", "subject", "fingerprint"};
    private FroProxy proxy = null;
    TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipom_vlsmi.class.getName()));
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    protected SecurityMoImpl(FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, MaoFroIndicationHandler maoFroIndicationHandler2) throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("SystemFunctions")).getMo(), "Security", THE_ONLY_SECURITY_ID, null);
        this.proxy = froProxy;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        maoFroIndicationHandler2.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "Security");
        this.registerData();
    }

    private void registerData() {
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
            this.data = new MoData(this.getLocalDistinguishedName(), "Security", true, coordinator);
            this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
            this.data.setRevision(5100);
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            control.getTerminator().commit();
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)"start of Security failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"start of Security failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"start of Security failed", (Throwable)inactiveTransactionException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"start of Security failed", (Throwable)moAccessException);
        }
    }

    public SecurityMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, MaoFroIndicationHandler maoFroIndicationHandler2) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.proxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        maoFroIndicationHandler2.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "Security");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public int getRequestedSecurityLevel(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("requestedSecurityLevel", coordinator);
    }

    public int getOperationalSecurityLevel(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalSecurityLevel", coordinator);
    }

    public boolean getTelnetAndFTPServersActive(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("telnetAndFTPServersActive", coordinator);
    }

    public boolean getDebugPortsActive(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("debugPortsActive", coordinator);
    }

    public int getFileTransferClientMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("fileTransferClientMode", coordinator);
    }

    public String getCertEnrollErrorMsg(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("certEnrollErrorMsg", coordinator);
    }

    public int getCertEnrollState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("certEnrollState", coordinator);
    }

    public int getCertExpirWarnTime(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("certExpirWarnTime", coordinator);
    }

    public Struct getNodeCertificate(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("nodeCertificate", coordinator);
    }

    public int getAuthorizationCacheTimeOut(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("authorizationCacheTimeOut", coordinator);
    }

    public void setAuthorizationCacheTimeOut(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("authorizationCacheTimeOut", new Integer(n), coordinator);
    }

    public String getLocalAuthenticationFileVersion(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("localAuthenticationFileVersion", coordinator);
    }

    public String[] getAAServerIPAddressList(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("aAServerIPAddressList", coordinator);
    }

    public String getSecurityId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("SecurityId", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public boolean getLocalAADatabaseInstallationFailure(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("localAADatabaseInstallationFailure", coordinator);
    }

    public void setCertExpirWarnTime(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("certExpirWarnTime", new Integer(n), coordinator);
    }

    public void setLocalAADatabaseInstallationFailure(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("localAADatabaseInstallationFailure", new Boolean(bl), coordinator);
    }

    public boolean getTrustedCertificateInstallationFailure(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("trustedCertificateInstallationFailure", coordinator);
    }

    public void setTrustedCertificateInstallationFailure(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trustedCertificateInstallationFailure", new Boolean(bl), coordinator);
    }

    public Struct[] getInstalledTrustedCertificates(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("installedTrustedCertificates", coordinator);
    }

    public boolean getTargetMonitorPortActive(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("targetMonitorPortActive", coordinator);
    }

    public String getLocalAuthorizationFileVersion(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("localAuthorizationFileVersion", coordinator);
    }

    public boolean getCorbaSecurityActive(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("corbaSecurityActive", coordinator);
    }

    public int getCrlEarlyUpdateInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("crlEarlyUpdateInterval", coordinator);
    }

    public void setCrlEarlyUpdateInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("crlEarlyUpdateInterval", new Integer(n), coordinator);
    }

    public Struct getInstalledUserDefProfilesInfo(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("installedUserDefProfilesInfo", coordinator);
    }

    public Struct getActiveUserDefProfilesInfo(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("activeUserDefProfilesInfo", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        map = this.proxy.getAttributes(coordinator, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("SecurityId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("requestedSecurityLevel")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("requestedSecurityLevel");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalSecurityLevel")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("operationalSecurityLevel");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("telnetAndFTPServersActive")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("telnetAndFTPServersActive");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("debugPortsActive")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("debugPortsActive");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("targetMonitorPortActive")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("targetMonitorPortActive");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("corbaSecurityActive")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("corbaSecurityActive");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fileTransferClientMode")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("fileTransferClientMode");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("authorizationCacheTimeOut")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("authorizationCacheTimeOut");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localAuthenticationFileVersion")) {
                StringParameter stringParameter = (StringParameter)map.get("localAuthenticationFileVersion");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localAuthorizationFileVersion")) {
                StringParameter stringParameter = (StringParameter)map.get("localAuthorizationFileVersion");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trustedCertificateInstallationFailure")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("trustedCertificateInstallationFailure");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localAADatabaseInstallationFailure")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("localAADatabaseInstallationFailure");
                objectArray[i] = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aAServerIPAddressList")) {
                boolean bl = false;
                ArrayParameter arrayParameter = (ArrayParameter)map.get("aAServerIPAddressList");
                if (arrayParameter != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int j = 0; j < arrayParameter.size(); ++j) {
                        String string;
                        if (!(arrayParameter.get(j) instanceof StringParameter) || (string = ((StringParameter)arrayParameter.get(j)).getValue().toString()).equals("")) continue;
                        bl = true;
                        arrayList.add(string);
                    }
                    String[] stringArray2 = new String[arrayList.size()];
                    if (bl) {
                        objectArray[i] = arrayList.toArray(stringArray2);
                        continue;
                    }
                    objectArray[i] = new String[0];
                    continue;
                }
                objectArray[i] = new String[0];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("installedTrustedCertificates")) {
                if (map.get("installedTrustedCertificates") != null) {
                    objectArray[i] = this.convertCertListParam2Struct((ArrayParameter)map.get("installedTrustedCertificates"));
                    continue;
                }
                objectArray[i] = new Struct[0];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certEnrollState")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("certEnrollState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certEnrollErrorMsg")) {
                StringParameter stringParameter = (StringParameter)map.get("certEnrollErrorMsg");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nodeCertificate")) {
                if (map.get("nodeCertificate") != null) {
                    objectArray[i] = this.convertNodeCertInfo2Struct((StructParameter)map.get("nodeCertificate"));
                    continue;
                }
                Object[] objectArray2 = new Object[nodeCertInfoMembers.length];
                for (int j = 0; j < objectArray2.length; ++j) {
                    objectArray2[j] = "";
                }
                objectArray[i] = new StructImpl(nodeCertInfoMembers, objectArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certExpirWarnTime")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("certExpirWarnTime");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("installedUserDefProfilesInfo")) {
                objectArray[i] = this.convertInstalledUserDefInfo2Struct((StructParameter)map.get("installedUserDefProfilesInfo"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeUserDefProfilesInfo")) {
                objectArray[i] = this.convertActiveUserDefInfo2Struct((StructParameter)map.get("activeUserDefProfilesInfo"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoUpdateCertEnrollmentServer")) {
                if (map.get("autoUpdateCertEnrollmentServer") != null) {
                    StringParameter stringParameter = (StringParameter)map.get("autoUpdateCertEnrollmentServer");
                    objectArray[i] = stringParameter.getValue();
                    continue;
                }
                objectArray[i] = "";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("crlEarlyUpdateInterval")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("crlEarlyUpdateInterval");
                if (signedIntParameter == null) {
                    objectArray[i] = new Integer(60);
                    continue;
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Security");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? SecurityMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Security");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Security", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoUpdateCertEnrollmentServer")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? SecurityMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("autoUpdateCertEnrollmentServer", "Security");
                }
                String string = (String)objectArray[i];
                MoAttributeValidator.checkStringWithLength((String)string, (String)"autoUpdateCertEnrollmentServer", (String)"Security", (int)255, (int)0);
                arrayList.add(new StringParameter("autoUpdateCertEnrollmentServer", string));
                this.sendNotification("autoUpdateCertEnrollmentServer", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localAADatabaseInstallationFailure")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? SecurityMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("localAADatabaseInstallationFailure", "Security");
                }
                boolean bl = (Boolean)objectArray[i];
                if (bl) {
                    throw new ValueOutOfRangeException("localAADatabaseInstallationFailure can only be set to false. ", "Security");
                }
                arrayList.add(new SignedIntParameter("localAADatabaseInstallationFailure", MaoFroTypeConverter.boolean2int((boolean)bl)));
                this.sendNotification("localAADatabaseInstallationFailure", new Boolean(bl), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trustedCertificateInstallationFailure")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? SecurityMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("trustedCertificateInstallationFailure", "Security");
                }
                boolean bl = (Boolean)objectArray[i];
                if (bl) {
                    throw new ValueOutOfRangeException("trustedCertificateInstallationFailure can only be set to false. ", "Security");
                }
                arrayList.add(new SignedIntParameter("trustedCertificateInstallationFailure", MaoFroTypeConverter.boolean2int((boolean)bl)));
                this.sendNotification("trustedCertificateInstallationFailure", new Boolean(bl), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("authorizationCacheTimeOut")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? SecurityMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("authorizationCacheTimeOut", "Security");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"authorizationCacheTimeOut", (int)n, (int)15, (int)480, (String)"Security");
                arrayList.add(new SignedIntParameter("authorizationCacheTimeOut", n));
                this.sendNotification("authorizationCacheTimeOut", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certExpirWarnTime")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? SecurityMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("certExpirWarnTime", "Security");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"certExpirWarnTime", (int)n, (int)2, (int)365, (String)"Security");
                arrayList.add(new SignedIntParameter("certExpirWarnTime", n));
                this.sendNotification("certExpirWarnTime", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("crlEarlyUpdateInterval")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? SecurityMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("crlEarlyUpdateInterval", "Security");
                }
                int n = (Integer)objectArray[i];
                if (!(n >= 0 && n <= 0 || n >= 10 && n <= 1440)) {
                    throw new ValueOutOfRangeException("crlEarlyUpdateInterval", this.getType(), "" + n);
                }
                arrayList.add(new SignedIntParameter("crlEarlyUpdateInterval", n));
                this.sendNotification("crlEarlyUpdateInterval", objectArray[i], coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Security");
        }
        this.proxy.setAttributes(coordinator, 1, arrayList);
    }

    public void actionAdaptSecurityLevel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 7, null);
    }

    public void actionClearAuthorizationCache(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 5, null);
    }

    public void actionAddAAServerAddresses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        Object object;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayParameter arrayParameter = new ArrayParameter("aAServerIPAddressList");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        Iterator iterator = linkedHashSet.iterator();
        if (linkedHashSet.size() <= 10) {
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                Ipv6Address.validateHostName((String)object, (String)"Security");
                arrayParameter.add((Parameter)new StringParameter("aAServerIpAddress", (String)object, 255));
            }
        } else {
            throw new ValueOutOfRangeException(this.getClass().getName(), "SecurityMO", "The maximum number of AA server addresses is 10 distinct addresses only");
        }
        object = new ArrayList();
        ((ArrayList)object).add(arrayParameter);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 1, (Collection)object);
        this.sendAAServerIPAddressNotification(coordinator);
    }

    public void actionRemoveAAServerAddresses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayParameter arrayParameter = new ArrayParameter("aAServerIPAddressList");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        Iterator iterator = linkedHashSet.iterator();
        if (linkedHashSet.size() <= 10) {
            while (iterator.hasNext()) {
                arrayParameter.add((Parameter)new StringParameter("aAServerIpAddress", iterator.next().toString(), 255));
            }
        } else {
            throw new ValueOutOfRangeException(this.getClass().getName(), "SecurityMO", "The maximum number of AA server addresses is 10 distinct addresses only");
        }
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        arrayList.add(arrayParameter);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 2, arrayList);
        this.sendAAServerIPAddressNotification(coordinator);
    }

    public void actionInstallLocalAADatabase(String string, String string2, String string3, int n, Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.length() == 0) {
            throw new ValueOutOfRangeException("authenticationFileName", "Security");
        }
        arrayList.add(new StringParameter("authenticationFileName", string));
        if (string2.length() == 0) {
            throw new ValueOutOfRangeException("authorizationFileName", "Security");
        }
        arrayList.add(new StringParameter("authorizationFileName", string2));
        String string4 = this.checkDate(string3);
        arrayList.add(new StringParameter("startTime", string4));
        MoAttributeValidator.checkIntegerAttribute((String)"duration", (int)n, (int)5, (int)600, (String)"Security");
        arrayList.add(new SignedIntParameter("duration", n));
        ArrayParameter arrayParameter = this.createAccountInfoParameter(structArray, 10);
        arrayList.add(arrayParameter);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 3, arrayList);
    }

    public void actionInstallTrustedCertificates(Struct[] structArray, String string, int n, Struct[] structArray2, Coordinator coordinator) throws MoAccessException {
        Object object;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (structArray.length == 0) {
            throw new ValueOutOfRangeException("certSpecList", "Security");
        }
        ArrayParameter arrayParameter = new ArrayParameter("certSpecList");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < structArray.length; ++i) {
            object = new CertSpec(structArray[i]);
            StructParameter structParameter = new StructParameter("certSpec");
            structParameter.add((Parameter)new SignedIntParameter("category", ((CertSpec)object).getCategory()));
            structParameter.add((Parameter)new StringParameter("fileName", ((CertSpec)object).getFileName(), 255));
            structParameter.add((Parameter)new StringParameter("fingerprint", ((CertSpec)object).getFingerprint(), 127));
            structParameter.add((Parameter)new StringParameter("serialNumberSpec", ((CertSpec)object).getSerialNumber(), 40));
            arrayParameter.add((Parameter)structParameter);
        }
        arrayList.add(arrayParameter);
        String string2 = this.checkDate(string);
        arrayList.add(new StringParameter("startTime", string2, 24));
        MoAttributeValidator.checkIntegerAttribute((String)"duration", (int)n, (int)5, (int)600, (String)"Security");
        arrayList.add(new SignedIntParameter("duration", n));
        arrayList.add(this.createAccountInfoParameter(structArray2, 10));
        object = this.proxy.actionWithCfm(coordinator, 1, 4, arrayList);
    }

    public void actionCancelInstallLocalAADatabase(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 9, null);
    }

    public void actionSetSecurityLevel3(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"timeout", (int)n, (int)5, (int)300, (String)"Security");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("timeout", n));
        Map map = this.proxy.actionWithCfm(coordinator, 1, 6, arrayList);
    }

    public void actionRemoveTrustedCert(String string, String string2, int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"category", (int)n, (int)0, (int)5, (String)"Security");
        if (string.length() > 40) {
            throw new ValueOutOfRangeException("serialNumber", "Security");
        }
        if (string2.length() == 0 || string2.length() > 511) {
            throw new ValueOutOfRangeException("issuer", "Security");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("category", n));
        arrayList.add(new StringParameter("serialNumber", string, 40));
        arrayList.add(new StringParameter("issuer", string2, 512));
        Map map = this.proxy.actionWithCfm(coordinator, 1, 15, arrayList);
    }

    public void actionCancelInstallTrustedCertificates(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 10, null);
    }

    public void actionCancelSetSecurityLevel3(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 11, null);
    }

    public void actionInitCertEnrollment(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        EnrollmentData enrollmentData = new EnrollmentData(struct);
        StructParameter structParameter = new StructParameter("enrollmentData");
        structParameter.add((Parameter)new StringParameter("enrollmentServerURL", enrollmentData.getEnrollmentServerURL(), 255));
        structParameter.add((Parameter)new StringParameter("caFingerPrint", enrollmentData.getCaFingerPrint(), 127));
        structParameter.add((Parameter)new StringParameter("distinguishedName", enrollmentData.getDistinguishedName(), 511));
        structParameter.add((Parameter)new StringParameter("challengePassword", enrollmentData.getChallengePassword(), 31));
        structParameter.add((Parameter)new SignedIntParameter("rollbackTimeOut", enrollmentData.getRollbackTimeOut()));
        structParameter.add((Parameter)new SignedIntParameter("keyLength", enrollmentData.getKeyLength()));
        structParameter.add((Parameter)new SignedIntParameter("enrollmentMode", enrollmentData.getEnrollmentMode()));
        structParameter.add((Parameter)new StringParameter("certificateAuthorityDn", enrollmentData.getCertificateAuthorityDn(), 511));
        arrayList.add(structParameter);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 12, arrayList);
    }

    public void actionCancelCertEnrollment(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 13, null);
    }

    public void actionConfirmNewCreds(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 14, null);
    }

    public void actionInstallUserDefProfilesFile(Struct[] structArray, String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.createAccountInfoParameter(structArray, 10));
        arrayList.add(new StringParameter("fileName", string, 255));
        Map map = this.proxy.actionWithCfm(coordinator, 1, 16, arrayList);
    }

    public void actionRemoveUserDefProfilesFile(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 17, null);
    }

    public void actionActivateUserDefProfiles(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 18, null);
    }

    public void actionDeactivateUserDefProfiles(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, 1, 19, null);
    }

    private void sendAAServerIPAddressNotification(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"aAServerIPAddressList"};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, new Object[]{this.getAAServerIPAddressList(coordinator)}, coordinator);
    }

    private ArrayParameter createAccountInfoParameter(Struct[] structArray, int n) throws ValueOutOfRangeException, MoAccessException, IllegalParameterValueException, IpFormatException {
        if (structArray.length == 0 || structArray.length > n) {
            throw new ValueOutOfRangeException("accountInfoList", "Security");
        }
        ArrayParameter arrayParameter = new ArrayParameter("accountInfoList");
        for (int i = 0; i < structArray.length; ++i) {
            AccountInfo accountInfo = new AccountInfo(structArray[i]);
            StructParameter structParameter = new StructParameter("accountInfo");
            structParameter.add((Parameter)new StringParameter("remoteHost", accountInfo.getRemoteHost(), 255));
            structParameter.add((Parameter)new StringParameter("userID", accountInfo.getUserID(), 31));
            structParameter.add((Parameter)new StringParameter("password", accountInfo.getPassword(), 31));
            arrayParameter.add((Parameter)structParameter);
        }
        return arrayParameter;
    }

    private Struct convertInstalledUserDefInfo2Struct(StructParameter structParameter) {
        Object[] objectArray = new Object[InstalledUserDefProfilesInfoTagNames.length];
        if (structParameter != null) {
            objectArray[0] = ((StringParameter)structParameter.get(InstalledUserDefProfilesInfoTagNames[0])).getValue();
            objectArray[1] = ((StringParameter)structParameter.get(InstalledUserDefProfilesInfoTagNames[1])).getValue();
            objectArray[2] = new Integer(((SignedIntParameter)structParameter.get(InstalledUserDefProfilesInfoTagNames[2])).getValue());
        } else {
            objectArray[0] = "";
            objectArray[1] = "";
            objectArray[2] = new Integer(99);
        }
        return new StructImpl(StructInstalledUserDefProfilesInfo.ELEMENT_NAMES, objectArray);
    }

    private Struct convertActiveUserDefInfo2Struct(StructParameter structParameter) {
        Object[] objectArray = new Object[ActiveUserDefProfilesInfoTagNames.length];
        if (structParameter != null) {
            objectArray[0] = ((StringParameter)structParameter.get(ActiveUserDefProfilesInfoTagNames[0])).getValue();
            objectArray[1] = ((StringParameter)structParameter.get(ActiveUserDefProfilesInfoTagNames[1])).getValue();
            SignedIntParameter signedIntParameter = (SignedIntParameter)structParameter.get(ActiveUserDefProfilesInfoTagNames[2]);
            objectArray[2] = new Integer(signedIntParameter.getValue());
        } else {
            objectArray[0] = "";
            objectArray[1] = "";
            objectArray[2] = new Integer(0);
        }
        return new StructImpl(StructActiveUserDefProfilesInfo.ELEMENT_NAMES, objectArray);
    }

    private Struct[] convertCertListParam2Struct(ArrayParameter arrayParameter) throws MoAccessException {
        Struct[] structArray = new Struct[arrayParameter.size()];
        for (int i = 0; i < arrayParameter.size(); ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            structArray[i] = this.convertCertInfo2Struct(structParameter);
        }
        return structArray;
    }

    private Struct convertCertInfo2Struct(StructParameter structParameter) throws MoAccessException {
        Object[] objectArray = new Object[]{new Integer(((SignedIntParameter)structParameter.get("category")).getValue()), ((StringParameter)structParameter.get("issuer")).getValue(), ((StringParameter)structParameter.get("notValidAfter")).getValue(), ((StringParameter)structParameter.get("notValidBefore")).getValue(), ((StringParameter)structParameter.get("serialNumber")).getValue(), ((StringParameter)structParameter.get("subject")).getValue(), ((StringParameter)structParameter.get("fingerprint")).getValue()};
        StructImpl structImpl = new StructImpl(certListMembers, objectArray);
        return structImpl;
    }

    private Struct convertNodeCertInfo2Struct(StructParameter structParameter) throws MoAccessException {
        Object[] objectArray = new Object[]{((StringParameter)structParameter.get("issuer")).getValue(), ((StringParameter)structParameter.get("notValidAfter")).getValue(), ((StringParameter)structParameter.get("notValidBefore")).getValue(), ((StringParameter)structParameter.get("serialNumber")).getValue(), ((StringParameter)structParameter.get("subject")).getValue(), ((StringParameter)structParameter.get("fingerprint")).getValue()};
        StructImpl structImpl = new StructImpl(nodeCertInfoMembers, objectArray);
        return structImpl;
    }

    private String makeDate() {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    private String checkDate(String string) throws MoAccessException {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        String string2 = this.makeDate();
        if (string.length() == 1) {
            if (string.charAt(0) == '0') {
                return "0";
            }
            this.throwIllegalAttributeValueException("The length of the date parameter is invalid.");
        }
        if (string.length() != 14) {
            this.throwIllegalAttributeValueException("The length of the date parameter is invalid.");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            this.throwIllegalAttributeValueException("The content of the date parameter is invalid. Must be all digits");
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(8, 10));
        int n5 = Integer.parseInt(string.substring(10, 12));
        int n6 = Integer.parseInt(string.substring(12, 14));
        if (n < 2005) {
            this.throwIllegalAttributeValueException("The year of the date parameter is invalid.");
        }
        if (n2 < 1 || n2 > 12) {
            this.throwIllegalAttributeValueException("The month of the date parameter is invalid.");
        }
        if (n3 > 31 || n3 < 1) {
            this.throwIllegalAttributeValueException("The day of the date parameter is invalid.");
        }
        if (n2 == 2 && gregorianCalendar.isLeapYear(n)) {
            if (n3 > 29) {
                this.throwIllegalAttributeValueException("The day of the date parameter is invalid.");
            } else if (n3 > 28) {
                this.throwIllegalAttributeValueException("The day of the date parameter is invalid.");
            }
        }
        if (n4 > 23) {
            this.throwIllegalAttributeValueException("The hour of the date parameter is invalid.");
        }
        if (n5 > 59) {
            this.throwIllegalAttributeValueException("The minute of the date parameter is invalid.");
        }
        if (n6 > 59) {
            this.throwIllegalAttributeValueException("The second of the date parameter is invalid.");
        }
        if (string.compareTo(string2) < 0) {
            this.throwIllegalAttributeValueException("The input date preceeds current.");
        }
        return string;
    }

    public String getType() {
        return "Security";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return 1;
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        try {
            Map map = maoFroGenericEventInd.getParameters(TagNameDictionaries.getDefault());
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            String string = "";
            if (stringParameter != null) {
                string = stringParameter.getValue();
            }
            int n = maoFroGenericEventInd.getSpecificEvent();
            int n2 = 0;
            if (n == 4) {
                n2 = 7;
            } else if (n == 5) {
                n2 = 9;
            } else if (n == 7) {
                n2 = 8;
            } else if (n == 8) {
                n2 = 10;
            } else if (n == 11) {
                n2 = 26;
            } else if (n == 12) {
                n2 = 27;
            } else if (n == 13) {
                n2 = 28;
            } else if (n == 14) {
                n2 = 125;
            } else if (n == 15) {
                n2 = 127;
            } else if (n == 16) {
                n2 = 126;
            } else if (n == 17) {
                n2 = 128;
            }
            if (n2 == 0) {
                MessageLog.traceError(this.getClass(), (String)("Unknown event sent to SecurityMo :" + n));
                return;
            }
            AlarmManager.getReporter().reportEvent(n2, (ManagedObject)this, "", string, null);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            if (map.get("requestedSecurityLevel") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "requestedSecurityLevel", false);
            }
            if (map.get("operationalSecurityLevel") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "operationalSecurityLevel", false);
            }
            if (map.get("telnetAndFTPServersActive") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "telnetAndFTPServersActive", true);
            }
            if (map.get("debugPortsActive") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "debugPortsActive", true);
            }
            if (map.get("corbaSecurityActive") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "corbaSecurityActive", true);
            }
            if (map.get("targetMonitorPortActive") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "targetMonitorPortActive", true);
            }
            if (map.get("fileTransferClientMode") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "fileTransferClientMode", false);
            }
            if (map.get("localAuthenticationFileVersion") != null) {
                this.notificationForString(maoFroGenericParameterChdInd, "localAuthenticationFileVersion");
            }
            if (map.get("localAuthorizationFileVersion") != null) {
                this.notificationForString(maoFroGenericParameterChdInd, "localAuthorizationFileVersion");
            }
            if (map.get("installedTrustedCertificates") != null) {
                this.notificationForStructArray(maoFroGenericParameterChdInd, "installedTrustedCertificates");
            }
            if (map.get("localAADatabaseInstallationFailure") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "localAADatabaseInstallationFailure", true);
            }
            if (map.get("trustedCertificateInstallationFailure") != null) {
                this.notificationForSignedInt(maoFroGenericParameterChdInd, "trustedCertificateInstallationFailure", true);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            return SecurityParameterFilter.filterActionParameters(string, objectArray);
        }
        catch (Exception exception) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + exception));
            return null;
        }
    }

    private void notificationForStructArray(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd, String string) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            ArrayParameter arrayParameter = (ArrayParameter)map.get(string);
            if (arrayParameter != null) {
                String[] stringArray = new String[]{new String(string)};
                Struct[] structArray = this.convertCertListParam2Struct(arrayParameter);
                Object[] objectArray = new Object[]{structArray};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    private void notificationForString(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd, String string) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            StringParameter stringParameter = (StringParameter)map.get(string);
            if (stringParameter != null) {
                String[] stringArray = new String[]{new String(string)};
                Object[] objectArray = new Object[]{stringParameter.getValue()};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    private void notificationForSignedInt(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd, String string, boolean bl) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(string);
            String[] stringArray = new String[]{string};
            Object[] objectArray = new Object[1];
            if (bl) {
                Boolean bl2 = new Boolean(MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue()));
                objectArray[0] = bl2;
            } else {
                Integer n = new Integer(signedIntParameter.getValue());
                objectArray[0] = n;
            }
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private void throwIllegalAttributeValueException(String string) throws MoAccessException {
        throw new IllegalAttributeValueException(string, "startTime", "Security");
    }

    public String getAutoUpdateCertEnrollmentServer(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("autoUpdateCertEnrollmentServer", coordinator);
    }

    public void setAutoUpdateCertEnrollmentServer(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("autoUpdateCertEnrollmentServer", string, coordinator);
    }
}

