/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.StringHelper;

public class FileHelper {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$common$FileHelper == null ? (class$se$ericsson$crbs$common$FileHelper = FileHelper.class$("se.ericsson.crbs.common.FileHelper")) : class$se$ericsson$crbs$common$FileHelper;
    private static final int ALL_SUB_DIRS = Integer.MIN_VALUE;
    static /* synthetic */ Class class$se$ericsson$crbs$common$FileHelper;

    public static void createDirectoryTree(String dirName) throws FileException {
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new FileException("Could not create directory, " + StringHelper.doubleQuote(dir.getAbsolutePath()));
        }
    }

    public static void deleteDirectoryTree(File dir, int level) throws FileException {
        if (dir.exists()) {
            String directory = dir.getPath();
            for (int i = 0; i < level; ++i) {
                int index = directory.lastIndexOf(File.separator);
                if (index < 0) {
                    throw new FileException("To many levels upwards specified.");
                }
                directory = directory.substring(0, index);
            }
            FileHelper.deleteDirectoryTree(new File(directory));
        }
    }

    public static void deleteDirectoryTree(File dir) throws FileException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new FileException("Deletion must start from a directory.");
            }
            List<File> directoryFiles = Arrays.asList(dir.listFiles());
            for (int i = 0; i < directoryFiles.size(); ++i) {
                File currentFile = directoryFiles.get(i);
                if (currentFile.isDirectory()) {
                    FileHelper.deleteDirectoryTree(currentFile);
                    continue;
                }
                if (currentFile.delete()) continue;
                throw new FileException("Could not delete file: " + StringHelper.doubleQuote(currentFile.getPath()));
            }
            if (!dir.delete()) {
                throw new FileException("Could not delete directory: " + StringHelper.doubleQuote(dir.getPath()));
            }
            if (dir.exists() && !dir.delete()) {
                throw new FileException("Could not delete directory: " + StringHelper.doubleQuote(dir.getPath()));
            }
        }
    }

    public static void appendToFile(String filePath, String message) {
        FileHelper.writeToFile(filePath, message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String filePath, String message, boolean append) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            FileOutputStream fos = null;
            try {
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(filePath, append);
                if (message.endsWith("\n")) {
                    fos.write(message.getBytes());
                } else {
                    fos.write((message + "\n").getBytes());
                }
                fos.close();
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception ignoreToo) {}
            }
        }
    }

    public static long getTotalSize(String[] fileNames) {
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return FileHelper.getTotalSize(files);
    }

    public static long getTotalSize(File[] files) {
        long totalSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            totalSize += files[i].length();
        }
        return totalSize;
    }

    public static long getFileSize(File file) {
        long fileSize = 0L;
        if (file.isDirectory()) {
            List<File> directoryFiles = Arrays.asList(file.listFiles());
            for (int i = 0; i < directoryFiles.size(); ++i) {
                File currentFile = directoryFiles.get(i);
                if (currentFile.isDirectory()) {
                    fileSize += FileHelper.getFileSize(currentFile);
                    continue;
                }
                fileSize += currentFile.length();
            }
        } else {
            fileSize += file.length();
        }
        return fileSize;
    }

    public static List getFilesOfType(File file, String extension, int subLevels) {
        List allFiles = FileHelper.getDirectoryContents(file, subLevels);
        for (int i = allFiles.size() - 1; i >= 0; --i) {
            File tmpFile = (File)allFiles.get(i);
            if (!tmpFile.isDirectory() && tmpFile.getName().toLowerCase(Locale.getDefault()).endsWith(extension.toLowerCase(Locale.getDefault()))) continue;
            allFiles.remove(i);
        }
        return allFiles;
    }

    public static List getDirectoryContents(File file) {
        return FileHelper.getDirectoryContents(file, Integer.MIN_VALUE);
    }

    public static List getDirectoryContents(File file, int subLevels) {
        List<File> directoryFiles;
        ArrayList<File> allFiles = new ArrayList<File>();
        if (file.isDirectory()) {
            allFiles.add(file);
            directoryFiles = Arrays.asList(file.listFiles());
        } else {
            String dir = file.getPath().substring(0, file.getPath().length() - file.getName().length());
            directoryFiles = Arrays.asList(new File(dir).listFiles());
        }
        for (int i = 0; i < directoryFiles.size(); ++i) {
            File currentFile = directoryFiles.get(i);
            int nextLevels = subLevels == Integer.MIN_VALUE ? subLevels : subLevels - 1;
            if ((subLevels == Integer.MIN_VALUE || subLevels > 0) && currentFile.isDirectory()) {
                allFiles.addAll(FileHelper.getDirectoryContents(currentFile, nextLevels));
                continue;
            }
            if (currentFile.isDirectory()) continue;
            allFiles.add(currentFile);
        }
        return allFiles;
    }

    public static String getTimeStampedFileName(String prefix, String suffix, String extension) {
        String tmpExt = extension.startsWith(".") ? extension : "." + extension;
        return prefix + DateTimeHelper.getDateTime() + suffix + tmpExt;
    }

    public static String extractFileNameFromFilePath(String filePath) {
        int delimiter = filePath.lastIndexOf(File.separatorChar);
        return filePath.substring(delimiter + 1);
    }

    public static String extractFileDirFromFilePath(String filePath) {
        int delimiter = filePath.lastIndexOf(File.separatorChar);
        return filePath.substring(0, delimiter + 1);
    }

    public static void copyFile(File fileToCopyFrom, File fileToCopyTo) throws IOException {
        byte[] chunk = new byte[4096];
        FileInputStream fis = new FileInputStream(fileToCopyFrom);
        FileOutputStream fos = new FileOutputStream(fileToCopyTo);
        int readLength = fis.read(chunk);
        while (readLength > 0) {
            fos.write(chunk, 0, readLength);
            readLength = fis.read(chunk);
        }
        fis.close();
        fos.close();
    }

    public static String getInitialFileContents(File fileToRead, long numberOfBytesToRead) throws IOException {
        long truncatedBytesToRead = Math.min(numberOfBytesToRead, fileToRead.length());
        FileInputStream fis = new FileInputStream(fileToRead);
        int chunkSize = 1024;
        if (truncatedBytesToRead < (long)chunkSize) {
            chunkSize = (int)truncatedBytesToRead;
        }
        byte[] chunk = new byte[chunkSize];
        int readLength = 0;
        StringBuffer fileContents = new StringBuffer();
        long writtenNumberOfBytes = 0L;
        readLength = fis.read(chunk);
        while (readLength > 0) {
            if (writtenNumberOfBytes + (long)readLength > truncatedBytesToRead) {
                int lengthToWrite = (int)(truncatedBytesToRead - writtenNumberOfBytes);
                fileContents.append(new String(chunk, 0, lengthToWrite));
                writtenNumberOfBytes += (long)lengthToWrite;
            } else {
                fileContents.append(new String(chunk, 0, readLength));
                writtenNumberOfBytes += (long)readLength;
            }
            if (writtenNumberOfBytes >= truncatedBytesToRead) break;
            readLength = fis.read(chunk);
        }
        fis.close();
        return fileContents.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FileException(String message) {
            super(message);
        }

        public FileException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

