/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.AddAttributeAction;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class AddStructAttributeAction
implements MoDataAction {
    public static final String NAME_ELEMENT = "nameElement";
    public static final String TYPE_ELEMENT = "typeElement";
    public static final String DEFAULT_VALUE_ELEMENT = "defaultValueElement";
    public static final String ARRAY_LENGTH_ELEMENT = "arrayLengthElement";
    private static final String BOOLEAN = "boolean";
    private static final String BOOLEAN_ARRAY = "boolean[]";
    private static final String FLOAT = "float";
    private static final String FLOAT_ARRAY = "float[]";
    private static final String INTEGER = "integer";
    private static final String INTEGER_ARRAY = "integer[]";
    private static final String MO_REF = "moref";
    private static final String MO_REF_ARRAY = "moref[]";
    private static final String LONG = "long";
    private static final String LONG_ARRAY = "long[]";
    private static final String STRING = "string";
    private static final String STRING_ARRAY = "string[]";
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$AddStructAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$AddStructAttributeAction = AddStructAttributeAction.class$("se.ericsson.crbs.omf.aue.step2.actions.AddStructAttributeAction")) : class$se$ericsson$crbs$omf$aue$step2$actions$AddStructAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Map paramMap = new HashMap();
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$AddStructAttributeAction;

    public AddStructAttributeAction(Map argMap) {
        this.paramMap.putAll(argMap);
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        String name;
        logger.traceEnter(THIS_CLASS, "perform()");
        String structAttrName = AueUtil.getAndCheckParamMapString("name", this.paramMap, "No attribute name specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String isAvcNotifierStr = AueUtil.getAndCheckParamMapString("isAvcNotifier", this.paramMap, "No isAvcNotifier specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        boolean isAvcNotifier = Boolean.valueOf(isAvcNotifierStr);
        ArrayList<Attribute> elementList = new ArrayList<Attribute>();
        int moRefArrayLength = -1;
        int i = 1;
        while ((name = (String)this.paramMap.get(NAME_ELEMENT + i)) != null) {
            String arrayLengthStr;
            String defaultValue;
            String type = AueUtil.getAndCheckParamMapString(TYPE_ELEMENT + i, this.paramMap, "No attribute type specified for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
            if (type.equalsIgnoreCase(MO_REF) || type.equalsIgnoreCase(MO_REF_ARRAY)) {
                defaultValue = this.getParamMapString(DEFAULT_VALUE_ELEMENT + i);
                if (defaultValue != null) {
                    throw new CrbsAueException("Default value not allowed for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
                }
            } else {
                defaultValue = AueUtil.getAndCheckParamMapString(DEFAULT_VALUE_ELEMENT + i, this.paramMap, "No default value specified for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
                arrayLengthStr = this.getParamMapString(ARRAY_LENGTH_ELEMENT + i);
                if (arrayLengthStr != null) {
                    throw new CrbsAueException("Array length value not allowed for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
                }
            }
            if (type.equalsIgnoreCase(MO_REF_ARRAY)) {
                arrayLengthStr = AueUtil.getAndCheckParamMapString(ARRAY_LENGTH_ELEMENT + i, this.paramMap, "No array length specified for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
                moRefArrayLength = Integer.parseInt(arrayLengthStr);
            } else {
                arrayLengthStr = this.getParamMapString(ARRAY_LENGTH_ELEMENT + i);
                if (arrayLengthStr != null) {
                    throw new CrbsAueException("Array length value not allowed for struct element " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
                }
            }
            elementList.add(this.toAttribute(name, type, defaultValue, moRefArrayLength));
            ++i;
        }
        if (elementList.size() == 0) {
            throw new CrbsAueException("No struct elements specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        }
        AddStructAttributeInternalAction action = new AddStructAttributeInternalAction(structAttrName, isAvcNotifier, elementList);
        action.perform(moDataWrapper, converterContext, coordinator);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    protected final String getParamMapString(String key) {
        return (String)this.paramMap.get(key);
    }

    private Attribute toAttribute(String name, String type, String defaulValue, int moRefArrayLength) throws CrbsAueException {
        BooleanAttribute result = null;
        if (type.equalsIgnoreCase(BOOLEAN)) {
            result = new BooleanAttribute(name, false, Boolean.valueOf(defaulValue).booleanValue());
        } else if (type.equalsIgnoreCase(BOOLEAN_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            StringTokenizer st = new StringTokenizer(defaulValue, ",");
            while (st.hasMoreTokens()) {
                tmpResult.addElement((Attribute)new BooleanAttribute("", false, Boolean.valueOf(st.nextToken()).booleanValue()));
            }
            result = tmpResult;
        } else if (type.equalsIgnoreCase(FLOAT)) {
            result = new FloatAttribute(name, false, Float.parseFloat(defaulValue));
        } else if (type.equalsIgnoreCase(FLOAT_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            StringTokenizer st = new StringTokenizer(defaulValue, ",");
            while (st.hasMoreTokens()) {
                tmpResult.addElement((Attribute)new FloatAttribute("", false, Float.parseFloat(st.nextToken())));
            }
            result = tmpResult;
        } else if (type.equalsIgnoreCase(INTEGER)) {
            result = new IntegerAttribute(name, false, Integer.parseInt(defaulValue));
        } else if (type.equalsIgnoreCase(INTEGER_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            StringTokenizer st = new StringTokenizer(defaulValue, ",");
            while (st.hasMoreTokens()) {
                tmpResult.addElement((Attribute)new IntegerAttribute("", false, Integer.parseInt(st.nextToken())));
            }
            result = tmpResult;
        } else if (type.equalsIgnoreCase(LONG)) {
            result = new LongAttribute(name, false, Long.parseLong(defaulValue));
        } else if (type.equalsIgnoreCase(LONG_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            StringTokenizer st = new StringTokenizer(defaulValue, ",");
            while (st.hasMoreTokens()) {
                tmpResult.addElement((Attribute)new LongAttribute("", false, Long.parseLong(st.nextToken())));
            }
            result = tmpResult;
        } else if (type.equalsIgnoreCase(STRING)) {
            result = new StringAttribute(name, false, defaulValue);
        } else if (type.equalsIgnoreCase(STRING_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            StringTokenizer st = new StringTokenizer(defaulValue, ",");
            while (st.hasMoreTokens()) {
                String elementValue = st.nextToken();
                if (elementValue.startsWith("\"") && elementValue.endsWith("\"")) {
                    tmpResult.addElement((Attribute)new StringAttribute("", false, elementValue.substring(1, elementValue.length() - 1)));
                    continue;
                }
                throw new CrbsAueException("Format for default value of string array not valid for " + name + " in " + AueUtil.doubleQuote(this.getClass().getName()));
            }
            result = tmpResult;
        } else if (type.equalsIgnoreCase(MO_REF)) {
            result = new ReferenceAttribute(name, false);
        } else if (type.equalsIgnoreCase(MO_REF_ARRAY)) {
            SequenceAttribute tmpResult = new SequenceAttribute(name, false);
            for (int i = 0; i < moRefArrayLength; ++i) {
                tmpResult.addElement((Attribute)new ReferenceAttribute("", false));
            }
            result = tmpResult;
        } else {
            throw new CrbsAueException("Attribute type is not supported: " + type);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddStructAttributeInternalAction
    extends AddAttributeAction {
        private final String structAttrName;
        private final boolean isAvcNotifier;
        private final ArrayList elementList;

        public AddStructAttributeInternalAction(String structAttrName, boolean isAvcNotifier, ArrayList elementList) {
            this.structAttrName = structAttrName;
            this.isAvcNotifier = isAvcNotifier;
            this.elementList = elementList;
        }

        public Attribute createAttribute() {
            StructAttribute structAttribute = new StructAttribute(this.structAttrName, this.isAvcNotifier);
            Iterator itElements = this.elementList.iterator();
            while (itElements.hasNext()) {
                structAttribute.addElement((Attribute)itElements.next());
            }
            return structAttribute;
        }
    }
}

