/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.RealMoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.AddBooleanAttrAction;
import se.ericsson.cello.aueframework.converter.actions.AddLongAttrAction;
import se.ericsson.cello.aueframework.converter.actions.AddStringAttrAction;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class CloneMoAttributeAction
implements MoDataAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$CloneMoAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$CloneMoAttributeAction = CloneMoAttributeAction.class$("se.ericsson.crbs.omf.aue.step2.actions.CloneMoAttributeAction")) : class$se$ericsson$crbs$omf$aue$step2$actions$CloneMoAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private MoDataWrapper moDataWrapper;
    private ConverterContext converterContext;
    private Coordinator coordinator;
    private final Map argMap = new HashMap();
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$CloneMoAttributeAction;

    public CloneMoAttributeAction(Map argMap) {
        this.argMap.putAll(argMap);
    }

    public void perform(MoDataWrapper moDataWr, ConverterContext convContext, Coordinator coordinatorIn) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        this.moDataWrapper = moDataWr;
        this.converterContext = convContext;
        this.coordinator = coordinatorIn;
        String fromMoStr = (String)this.argMap.get("fromMo");
        logger.traceGeneral(THIS_CLASS, "CloneMoAttibuteAction fromMo:" + fromMoStr);
        String fromAttrStr = AueUtil.getAndCheckParamMapString("fromAttr", this.argMap, "The fromAttr is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        logger.traceGeneral(THIS_CLASS, "CloneMoAttibuteAction fromAttr:" + fromAttrStr);
        String toAttrStr = AueUtil.getAndCheckParamMapString("toAttr", this.argMap, "The toAttr is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        logger.traceGeneral(THIS_CLASS, "CloneMoAttibuteAction toAttr:" + toAttrStr);
        String isAvcNotifierStr = AueUtil.getAndCheckParamMapString("isAvcNotifier", this.argMap, "The isAvcNotifier is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        logger.traceGeneral(THIS_CLASS, "CloneMoAttibuteAction isAvcNotifier:" + isAvcNotifierStr);
        Attribute srcAttribute = null;
        srcAttribute = fromMoStr == null || "".equals(fromMoStr) ? this.moDataWrapper.getAttribute(fromAttrStr) : this.getRemoteMoAttribute(fromAttrStr, fromMoStr);
        if (srcAttribute == null) {
            throw new CrbsAueException("Attribute " + fromAttrStr + " do not exist!");
        }
        boolean isAvcNotifier = this.resolveIsAvcNotifier(isAvcNotifierStr, srcAttribute);
        this.resolveAndExecuteAction(fromAttrStr, toAttrStr, srcAttribute, isAvcNotifier);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private Attribute getRemoteMoAttribute(String attrName, String ldn) throws CrbsAueException {
        Attribute attribute = null;
        MoDataAccessor accessor = this.converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
            throw new CrbsAueException("MoDataAccessor accessor is null");
        }
        try {
            Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(ldn));
            if (mos != null) {
                this.checkJustOneInstance(mos, ldn);
                Iterator moIter = mos.iterator();
                while (moIter.hasNext()) {
                    RealMoDataWrapper realMoDataWrapper = (RealMoDataWrapper)moIter.next();
                    attribute = realMoDataWrapper.getAttribute(attrName);
                }
            }
            return attribute;
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
    }

    private void resolveAndExecuteAction(String fromAttrStr, String toAttrStr, Attribute srcAttribute, boolean isAvcNotifier) throws CrbsAueException {
        AddBooleanAttrAction moDataAction = null;
        if (srcAttribute instanceof BooleanAttribute) {
            boolean boolValue = ((BooleanAttribute)srcAttribute).getValue(this.coordinator);
            this.logCreateAction(toAttrStr, "AddBooleanAttrAction", isAvcNotifier, Boolean.toString(boolValue));
            moDataAction = new AddBooleanAttrAction(toAttrStr, isAvcNotifier, boolValue);
        } else if (srcAttribute instanceof LongAttribute) {
            long longValue = ((LongAttribute)srcAttribute).getValue(this.coordinator);
            this.logCreateAction(toAttrStr, "AddLongAttrAction", isAvcNotifier, Long.toString(longValue));
            moDataAction = new AddLongAttrAction(toAttrStr, isAvcNotifier, longValue);
        } else if (srcAttribute instanceof StringAttribute) {
            String stringValue = ((StringAttribute)srcAttribute).getValue(this.coordinator);
            this.logCreateAction(toAttrStr, "AddStringAttrAction", isAvcNotifier, stringValue);
            moDataAction = new AddStringAttrAction(toAttrStr, isAvcNotifier, stringValue);
        } else {
            throw new CrbsAueException("Found attribute " + fromAttrStr + " is not an Boolean/Long/String but a " + srcAttribute.getClass().toString());
        }
        logger.traceGeneral(THIS_CLASS, "Adding attribute " + toAttrStr);
        try {
            moDataAction.perform(this.moDataWrapper, this.converterContext, this.coordinator);
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
    }

    private boolean resolveIsAvcNotifier(String isAvcNotifierStr, Attribute srcAttribute) throws CrbsAueException {
        boolean isAvcNotifier = true;
        if (isAvcNotifierStr.equalsIgnoreCase("copy")) {
            isAvcNotifier = srcAttribute.isAVCNotifier();
        } else if (isAvcNotifierStr.equalsIgnoreCase("true") || isAvcNotifierStr.equalsIgnoreCase("false")) {
            isAvcNotifier = Boolean.valueOf(isAvcNotifierStr);
        } else {
            String errorMsg = "CloneMoAttibuteAction: The isAvcNotifier value is not recognised (copy/true/false):" + isAvcNotifierStr;
            logger.traceGeneral(THIS_CLASS, errorMsg);
            throw new CrbsAueException(errorMsg);
        }
        return isAvcNotifier;
    }

    private void logCreateAction(String toAttr, String actionStr, boolean isAvcNotifier, String value) {
        logger.traceGeneral(THIS_CLASS, "CloneMoAttibuteAction create " + actionStr + ":" + toAttr + ", " + Boolean.toString(isAvcNotifier) + ", " + value);
    }

    protected void checkJustOneInstance(Collection children, String ldn) throws CrbsAueException {
        if (children.size() > 1) {
            throw new CrbsAueException("More than 1 (" + children.size() + ") children of " + ldn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

