/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.RealMoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.actions.DeleteMoInstanceAction;

public class RemoveAttibuteMoReferenceWithChildren
implements MoDataAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$RemoveAttibuteMoReferenceWithChildren == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$RemoveAttibuteMoReferenceWithChildren = RemoveAttibuteMoReferenceWithChildren.class$("se.ericsson.crbs.omf.aue.step2.actions.RemoveAttibuteMoReferenceWithChildren")) : class$se$ericsson$crbs$omf$aue$step2$actions$RemoveAttibuteMoReferenceWithChildren;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$RemoveAttibuteMoReferenceWithChildren;

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Map paramMap = (Map)converterContext.getAttribute("moActionArgMap");
        String ldn = AueUtil.getAndCheckParamMapString("ldn", paramMap, "The LDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        logger.traceGeneral(THIS_CLASS, "RemoveAttibuteMoReferenceWithChildren ldn:" + ldn);
        String moRef = AueUtil.getAndCheckParamMapString("moRef", paramMap, "The MoRef is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        logger.traceGeneral(THIS_CLASS, "RemoveAttibuteMoReferenceWithChildren moRef:" + moRef);
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(ldn));
                if (mos != null) {
                    this.checkJustOneInstance(mos, ldn);
                    Iterator moIter = mos.iterator();
                    while (moIter.hasNext()) {
                        RealMoDataWrapper realMoDataWrapper = (RealMoDataWrapper)moIter.next();
                        Attribute attribute = realMoDataWrapper.getAttribute(moRef);
                        if (attribute == null) {
                            throw new CrbsAueException("Attribute " + moRef + " do not exist");
                        }
                        if (attribute instanceof ReferenceAttribute) {
                            this.deleteMoInstance(converterContext, coordinator, accessor, attribute);
                            continue;
                        }
                        throw new CrbsAueException("Found attribute " + moRef + " is not an MoRef but a " + attribute.getClass().toString());
                    }
                }
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void deleteMoInstance(ConverterContext converterContext, Coordinator coordinator, MoDataAccessor accessor, Attribute attribute) throws CrbsAueException {
        ReferenceAttribute refAtr = (ReferenceAttribute)attribute;
        String deleteLdn = refAtr.getReferenceAsLDN();
        logger.traceGeneral(THIS_CLASS, "RemoveAttibuteMoReferenceWithChildren refAtr:" + refAtr.getName() + " deleteLdn:" + deleteLdn);
        if (deleteLdn != null) {
            try {
                Collection deleteLdnChildren = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(deleteLdn));
                if (deleteLdnChildren != null) {
                    this.checkJustOneInstance(deleteLdnChildren, deleteLdn);
                    Iterator deleteLdnChildIter = deleteLdnChildren.iterator();
                    while (deleteLdnChildIter.hasNext()) {
                        RealMoDataWrapper deleteLdnRealMoDataWrapper = (RealMoDataWrapper)deleteLdnChildIter.next();
                        logger.traceGeneral(THIS_CLASS, "RemoveAttibuteMoReferenceWithChildren create DeleteMoInstanceAction:" + deleteLdn);
                        DeleteMoInstanceAction deleteMoInstanceAction = new DeleteMoInstanceAction(deleteLdn);
                        logger.traceGeneral(THIS_CLASS, "Deleting MO " + deleteLdn + " and all below");
                        deleteMoInstanceAction.perform((MoDataWrapper)deleteLdnRealMoDataWrapper, converterContext, coordinator);
                    }
                }
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
    }

    protected void checkJustOneInstance(Collection children, String ldn) throws CrbsAueException {
        if (children.size() > 1) {
            throw new CrbsAueException("More than 1 (" + children.size() + ") children of " + ldn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

