/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp;

import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.ConnectionFailedException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpClient;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.LoginFailedException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;

public class FtpClientImpl
implements FtpClient {
    private SshSftpService sshSftpService;
    private String title;
    private EmSftp sftp;

    public FtpClientImpl(LauncherData launcherData) throws FtpException {
        try {
            this.sshSftpService = (SshSftpService)launcherData.launcher.runResource("/cello/emas/sshservcfg.xml", launcherData.ipAddress, launcherData.properties, null);
            this.title = launcherData.cabinetViewer.toString();
        }
        catch (LauncherException launcherException) {
            throw new FtpException("Unable to start SSH SFTP Service", launcherException);
        }
    }

    @Override
    public void connect() throws ConnectionFailedException, LoginFailedException {
        if (this.sshSftpService == null) {
            throw new LoginFailedException("Unable to connect to the node, the SSH SFTP Service has not been started");
        }
        if (this.sftp == null || !this.sftp.isOpen()) {
            try {
                Trace.observation(this, "Opening connection to Sftp service");
                this.sftp = this.sshSftpService.getSftp(this.title);
            }
            catch (Exception exception) {
                throw new ConnectionFailedException("Unable to connect to the node", exception);
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.sftp != null && this.sftp.isOpen()) {
            Trace.observation(this, "Closing connection to Sftp service");
            this.sftp.exit();
        }
    }

    @Override
    public void get(String string, String string2) throws FtpException {
        if (this.sftp == null || !this.sftp.isOpen()) {
            throw new FtpException("Not connected to node");
        }
        try {
            Trace.observation(this, "Fetching file from " + string + " to " + string2);
            this.sftp.get(string, string2, null);
        }
        catch (EmSshException emSshException) {
            throw new FtpException("Unable to fetch file from " + string + " to " + string2, emSshException);
        }
        Trace.observation(this, "Fetch of file completed");
    }
}

