/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;

public class ClearTechnicianPresent
extends CabinetViewerAction {
    private static String ACTION_DISPLAY_NAME_TP = "Clear Technician Present";
    protected Mo mo = null;
    protected String ldn = null;
    private Mo nodeBFunctionMo = null;
    private String nodeBFunctionLdn = null;
    private String msg = null;

    public ClearTechnicianPresent(Operable operable) {
        super(operable, ACTION_DISPLAY_NAME_TP, "KEY_TECHNICIAN_PRESENT");
        this.init();
    }

    public ClearTechnicianPresent() {
        super(ACTION_DISPLAY_NAME_TP, "KEY_TECHNICIAN_PRESENT");
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.nodeBFunctionLdn = this.operable.getTargetMoLdnForTechnicianPresent();
        if (this.nodeBFunctionLdn != null) {
            this.nodeBFunctionMo = this.cmService.getMo(this.nodeBFunctionLdn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.confirmClearTechnicianPresent()) {
            this.performClearTechnicianPresentAction();
        }
    }

    protected String getLdn() {
        return this.nodeBFunctionLdn;
    }

    protected Mo getMo() {
        return this.nodeBFunctionMo;
    }

    private boolean confirmClearTechnicianPresent() {
        this.msg = "Please verify that field technician is not on RBS site.\nAre you sure you want to clear technician present?";
        if (this.isStartWithoutGui()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(null, this.msg, ACTION_DISPLAY_NAME_TP, 0, 3) == 0;
    }

    private void performClearTechnicianPresentAction() {
        Transaction transaction = null;
        try {
            CmService cmService = this.getCmService();
            transaction = cmService.createTransaction();
            NameValue[] nameValueArray = new NameValue[]{};
            this.nodeBFunctionMo.action("clearTechnicianPresent", nameValueArray, transaction);
            transaction.commit();
            Trace.observation(this, "ClearTechnicianPresent: " + this.operable.getViewableObjectName());
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    protected void performTheAction() {
    }
}

