/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ManualRestart {
    private String[] ranks;
    private String[] reasons;
    final JFrame parent;
    private JComboBox rankComboBox;
    private JComboBox reasonComboBox;
    private JTextArea infoTextArea;
    private JPanel panel;

    public ManualRestart(JFrame jFrame) {
        this.parent = jFrame;
        this.init();
        this.createPanel();
    }

    private void init() {
        this.ranks = new String[]{"Warm", "Refresh", "Cold", "Cold with test"};
        this.reasons = new String[]{"Planned Reconfiguration", "Unplanned Node external problems", "Unplanned Node upgrade problems", "Unplanned O&M issue", "Unplanned Cyclic recovery", "Unplanned Locked resources", "Unplanned Cold with HW test", "Unplanned Call processing degradation", "Unplanned Low coverage"};
    }

    private void createPanel() {
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)new JLabel("Rank:*"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.rankComboBox = new JComboBox<String>(this.ranks);
        this.rankComboBox.setName("rank");
        this.rankComboBox.setSelectedItem(null);
        this.panel.add((Component)this.rankComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panel.add((Component)new JLabel("Reason:*"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.reasonComboBox = new JComboBox<String>(this.reasons);
        this.reasonComboBox.setName("reason");
        this.reasonComboBox.setSelectedItem(null);
        this.panel.add((Component)this.reasonComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.panel.add((Component)new JLabel("Info:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.gridwidth = 2;
        this.infoTextArea = new JTextArea(new FixedSizePlainDocument(80));
        this.infoTextArea.setName("info");
        this.infoTextArea.setRows(3);
        this.infoTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.infoTextArea);
        this.panel.add((Component)jScrollPane, gridBagConstraints);
    }

    public boolean verifyInput() {
        if (this.getRank() == -1) {
            JOptionPane.showMessageDialog(this.parent, "Rank is mandatory");
            this.rankComboBox.requestFocus();
            return false;
        }
        if (this.getReason() == -1) {
            JOptionPane.showMessageDialog(this.parent, "Reason is mandatory");
            this.reasonComboBox.requestFocus();
            return false;
        }
        return true;
    }

    public void clear() {
        this.rankComboBox.setSelectedItem(null);
        this.reasonComboBox.setSelectedItem(null);
        this.infoTextArea.setText("");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public int getRank() {
        return this.rankComboBox.getSelectedIndex();
    }

    public int getReason() {
        return this.reasonComboBox.getSelectedIndex();
    }

    public String getInfo() {
        return this.infoTextArea.getText();
    }

    class FixedSizePlainDocument
    extends PlainDocument {
        int maxSize;

        public FixedSizePlainDocument(int n) {
            this.maxSize = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() + string.length() <= this.maxSize) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

