/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.HorizontalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.Label;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class BoardView
extends VoView {
    private Label label;
    private StateOrLedPanel stateOrLedPanel;

    public BoardView(VoData voData) {
        super(voData);
        this.setName(voData.getSpecificType());
        this.buildBoard();
    }

    public BoardView(String string) {
        super(string);
        this.buildBoard();
    }

    @Override
    public void setLabel(String string) {
        this.label.setText(string);
    }

    @Override
    public void setSelectionManager(VoSelectionManager voSelectionManager) {
        super.setSelectionManager(voSelectionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setSelectionManager(voSelectionManager);
        }
    }

    @Override
    public void setActionManager(ActionManager actionManager) {
        super.setActionManager(actionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setActionManager(actionManager);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setBackground(color);
        }
    }

    public void buildBoard() {
        super.initialise();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        VoData voData = this.getVoData();
        if (voData != null) {
            this.stateOrLedPanel = new StateOrLedPanel(voData, this.getToolTipText());
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 0, 2, 0);
            this.add((Component)this.stateOrLedPanel, gridBagConstraints);
        }
        if (voData != null && voData.getProperty("USE_HORIZONTAL_LABEL") != null) {
            this.label = new HorizontalLabel(this.getName());
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 2.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(2, 4, 2, 2);
            this.add((Component)((JComponent)((Object)this.label)), gridBagConstraints);
        } else {
            this.label = new VerticalLabel(this.getName());
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 3, 2, 4);
            this.add((Component)((JComponent)((Object)this.label)), gridBagConstraints);
        }
    }

    @Override
    public void setLedViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setLedViewActive();
        }
    }

    @Override
    public void setStateViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setStateViewActive();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.cleanUp();
        }
    }
}

