/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.GridMounting;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.HorizontalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class CabinetView
extends VoView {
    public static final String CABINET = "Cabinet";
    final JPanel contentPanel = new JPanel();
    private HorizontalLabel cabinetLabel;
    private VerticalLabel subrackLabel;

    public CabinetView(VoData voData) {
        super(voData);
        this.setName(voData.getSpecificType() + " " + CABINET);
        this.setToolTipText(voData.getSpecificType() + " " + CABINET);
        this.buildCabinet();
    }

    public CabinetView(VoData voData, String string) {
        super(voData);
        this.setName(voData.getSpecificType() + " " + CABINET + string);
        this.setToolTipText(voData.getSpecificType() + " " + CABINET + string);
        this.buildCabinet();
    }

    public CabinetView(String string) {
        super(string + " " + CABINET);
        this.buildCabinet();
    }

    public CabinetView(String string, String string2) {
        super(string + string2);
        if (string2.equals("Subrack")) {
            this.buildSubrack();
        } else {
            this.buildCabinet();
        }
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public void setLedViewActive() {
    }

    @Override
    public void setStateViewActive() {
    }

    protected JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected HorizontalLabel getCabinetLabel() {
        return this.cabinetLabel;
    }

    protected void setCabinetLabel(HorizontalLabel horizontalLabel) {
        this.cabinetLabel = horizontalLabel;
    }

    protected VerticalLabel getSubrackLabel() {
        return this.subrackLabel;
    }

    protected void setSubrackLabel(VerticalLabel verticalLabel) {
        this.subrackLabel = verticalLabel;
    }

    public void buildCabinet() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setOpaque(false);
        this.cabinetLabel = new HorizontalLabel(this.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.cabinetLabel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.contentPanel, (Object)gridBagConstraints);
    }

    public void buildSubrack() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setOpaque(false);
        this.subrackLabel = new VerticalLabel(this.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.subrackLabel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.contentPanel, (Object)gridBagConstraints);
    }

    public void add(VoView voView, GridBagConstraints gridBagConstraints) {
        this.contentPanel.add((Component)voView, gridBagConstraints);
    }

    @Override
    public void add(Component component, Object object) {
        if (object instanceof GridMounting) {
            GridMounting gridMounting = (GridMounting)object;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridMounting.getGridX();
            gridBagConstraints.gridy = gridMounting.getGridY();
            gridBagConstraints.gridwidth = gridMounting.getGridW();
            gridBagConstraints.gridheight = gridMounting.getGridH();
            gridBagConstraints.weightx = gridMounting.getRelativeWidth();
            gridBagConstraints.weighty = gridMounting.getRelativeHeight();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = component instanceof VoView ? ((VoView)component).getViewInsets() : new Insets(5, 5, 5, 5);
            this.contentPanel.add(component, gridBagConstraints);
        } else {
            super.add(component, object);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        Component[] componentArray = this.contentPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof VoView)) continue;
            VoView voView = (VoView)componentArray[i];
            voView.cleanUp();
        }
    }
}

