/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LED;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroupData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class LedGroupXml
extends LedGroup {
    private static final String WCDMA_SPEIND_STRUCT_MEMBER = "status";
    private static final String WCDMA_SPEIND_STRUCT_FILTER_MEMBER = "name";
    private static final String LTE_SPEIND_STRUCT_MEMBER = "indicatorStatus";
    private static final String LTE_SPEIND_STRUCT_FILTER_MEMBER = "indicatorName";
    private static final String SPEIND_STRUCT_FILTER_MEMBER_VALUE = "Support Unit Fault Indicator";

    public LedGroupXml(LedGroupData ledGroupData) {
        this.leds = new TreeMap();
        Iterator<LedGroupData.LedXml> iterator = ledGroupData.getLeds().iterator();
        while (iterator.hasNext()) {
            int n;
            LED lED = new LED();
            LedGroupData.LedXml ledXml = iterator.next();
            String string = ledXml.getAttribute();
            if (string != null) {
                lED.setAttribute(string);
                n = ledXml.getPosition();
                lED.setPosition(n);
                Map<Integer, List<Integer>> map = ledGroupData.getBlinkPattern();
                lED.setBlinkPattern(map);
                lED.setColor(ledXml.getColor());
                lED.update(1);
                this.leds.put(string, lED);
                continue;
            }
            n = ledXml.getPosition();
            lED.setPosition(n);
            lED.update(0);
            this.leds.put(Integer.toString(n), lED);
        }
    }

    @Override
    public void updateLedGroup(VoData voData) {
        this.voData = voData;
        this.updateFromProperty();
    }

    private void updateFromProperty() {
        Integer n = 1;
        String string = null;
        LED lED = null;
        se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue nameValue = this.voData.getPropertyValue("ledDataGroups");
        if (nameValue == null) {
            return;
        }
        Object object = nameValue.getValue();
        List<LedGroupData> list = LedGroupData.getListOfLedGroupData(object);
        for (LedGroupData ledGroupData : list) {
            for (LedGroupData.LedXml ledXml : ledGroupData.getLeds()) {
                string = ledXml.getAttribute();
                if (string == null || (lED = (LED)this.leds.get(string)) == null || !lED.getAttribute().equals(string)) continue;
                Object object2 = this.voData.getValue(nameValue.getName(), string);
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                } else if (object2 instanceof Struct[]) {
                    Struct[] structArray = (Struct[])object2;
                    NameValue nameValue2 = null;
                    NameValue nameValue3 = null;
                    for (int i = 0; i < structArray.length; ++i) {
                        String string2;
                        nameValue3 = structArray[i].getMember(WCDMA_SPEIND_STRUCT_FILTER_MEMBER);
                        if (nameValue3 != null && ((String)nameValue3.getValue()).equals(SPEIND_STRUCT_FILTER_MEMBER_VALUE) && (nameValue2 = structArray[i].getMember(WCDMA_SPEIND_STRUCT_MEMBER)) != null) {
                            string2 = nameValue2.getValue().toString();
                            n = new Integer(string2);
                            break;
                        }
                        if (nameValue3 != null || (nameValue3 = structArray[i].getMember(LTE_SPEIND_STRUCT_FILTER_MEMBER)) == null || !((String)nameValue3.getValue()).equals(SPEIND_STRUCT_FILTER_MEMBER_VALUE) || (nameValue2 = structArray[i].getMember(LTE_SPEIND_STRUCT_MEMBER)) == null) continue;
                        string2 = nameValue2.getValue().toString();
                        n = new Integer(string2);
                        break;
                    }
                    if (nameValue2 == null) {
                        n = 0;
                    }
                } else {
                    n = null;
                }
                if (n == null) {
                    lED.update(-1);
                    continue;
                }
                lED.update(n);
            }
        }
    }
}

