/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.ButtonGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.MoAttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.StructMemberExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ToStringConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.managers.ButtonGroupManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.restrictions.Restriction;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.TabbedAttribute;

public class TabbedFormPanel
extends JPanel
implements InfoPanel {
    private static final String UNLOCK_IN_TAB_STRING = " *";
    JTabbedPane tabbedPane;
    private String moTypeName;
    private String sortingMoType;
    private List<TabbedAttribute> moAttributes;
    private boolean showUnlockedInTab = false;
    private boolean showFaultInTab = false;
    private boolean showOperationalInTab = false;
    private String borderName;
    private List attributes;
    private List labels;
    private Map converters;
    private VoData vo;
    private String tabbedPaneIdentifier;
    private ToStringConverter defaultConverter;
    private CacheManager cacheManager;
    private String[] ldnsFiltered = null;
    final List<ButtonGroup> bgList = new ArrayList<ButtonGroup>();
    final TreeMap<Integer, List<ButtonGroupManager>> bgmPerTab = new TreeMap();
    final List<NameValue> labelsWithRestrictions = new ArrayList<NameValue>();
    final List<NameValue> tabbedLabelsWithRestrictions = new ArrayList<NameValue>();
    JTabbedPane btabbedPane;
    private String bmoTypeName;
    private String bsortingMoType;
    private List battributes;
    private List blabels;
    private String bborderName;
    private boolean isTabbedInPanel = false;
    final TreeMap<Integer, List<String>> labelsPerTab = new TreeMap();
    final TreeMap<Integer, String> mapWithTabNames = new TreeMap();

    public TabbedFormPanel(String string, String string2, String string3, List list, boolean bl, boolean bl2, boolean bl3) {
        this(null, string, string2, string3, list, bl, bl2, bl3);
    }

    public TabbedFormPanel(VoData voData, String string, String string2, String string3, List list, boolean bl, boolean bl2, boolean bl3) {
        this.vo = voData;
        this.borderName = string;
        this.moTypeName = string2;
        this.sortingMoType = string3;
        this.moAttributes = list;
        this.showUnlockedInTab = bl;
        this.showFaultInTab = bl2;
        this.showOperationalInTab = bl3;
        this.labels = new ArrayList();
        this.attributes = new ArrayList();
        this.blabels = new ArrayList();
        this.battributes = new ArrayList();
        this.converters = new HashMap();
        this.defaultConverter = new ToStringConverter();
    }

    @Override
    public boolean isVisible() {
        boolean bl = true;
        for (AttributeExtractor attributeExtractor : this.attributes) {
            if (attributeExtractor.isExisting()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void update(VoData voData) {
        try {
            this.removeAll();
            this.updateVo(voData);
            this.cacheManager = voData.getCvSession().getCacheManager();
            this.createPanel();
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to show panel " + this.borderName, exception);
        }
    }

    private void updateVo(VoData voData) {
        this.vo = voData;
        for (Object object : this.attributes) {
            object.setVo(voData);
        }
        for (AttributeExtractor attributeExtractor : this.battributes) {
            attributeExtractor.setVo(voData);
        }
    }

    public void addTabbedlabel(String string, Restriction restriction) {
        NameValue nameValue = new NameValue(string, restriction);
        this.tabbedLabelsWithRestrictions.add(nameValue);
    }

    public void add(String string, Restriction restriction) {
        NameValue nameValue = new NameValue(string, restriction);
        this.labelsWithRestrictions.add(nameValue);
    }

    public void add(String string, String string2, boolean bl) {
        if (bl) {
            this.blabels.add(string);
            this.battributes.add(new MoAttributeExtractor(this.vo, this.bmoTypeName, string2));
        } else {
            this.labels.add(string);
            this.attributes.add(new MoAttributeExtractor(this.vo, this.moTypeName, string2));
        }
    }

    public void add(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.blabels.add(string);
            this.battributes.add(new StructMemberExtractor(this.vo, this.bmoTypeName, string2, string3));
        } else {
            this.labels.add(string);
            this.attributes.add(new StructMemberExtractor(this.vo, this.moTypeName, string2, string3));
        }
    }

    public void addButtonGroup(ButtonGroup buttonGroup) {
        this.bgList.add(buttonGroup);
    }

    public void addtabbedInPanel(String string, String string2, String string3, boolean bl) {
        this.bborderName = string;
        this.bmoTypeName = string2;
        this.bsortingMoType = string3;
        this.isTabbedInPanel = bl;
    }

    protected boolean createTabbedInPanel(String string) {
        String[] stringArray = null;
        int n = 0;
        boolean bl = false;
        if (this.bborderName == null || this.bmoTypeName == null) {
            return true;
        }
        stringArray = this.vo.getLdns(this.bmoTypeName);
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        Arrays.sort(stringArray, new RdnComparator(this.bsortingMoType));
        n = stringArray.length;
        this.btabbedPane = new JTabbedPane();
        for (int i = 0; i < n; ++i) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            String string2 = stringArray[i];
            CachedMo cachedMo = this.cacheManager.getCachedMo(string2);
            Object object = cachedMo.getAttribute("plugInModuleRef");
            if (object == null || !object.toString().equals(string)) continue;
            if (!bl) {
                bl = true;
            }
            String string3 = this.getTabName(stringArray[i]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 10.0;
            gridBagConstraints2.anchor = 18;
            int n2 = this.battributes.size();
            for (int j = 0; j < n2; ++j) {
                String string4 = this.getLabel(j, true);
                Object object2 = this.getValue(j, stringArray[i], true);
                if (object2 == null || object2.equals("")) {
                    object2 = "-";
                }
                jPanel.add((Component)new JLabel(string4), gridBagConstraints);
                JTextField jTextField = new JTextField(object2.toString());
                jTextField.setEditable(false);
                jTextField.setBorder(null);
                jTextField.setBackground(this.getBackground());
                if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                    jTextField.setName(string4.toString() + "_Value" + "_" + string3);
                }
                jPanel.add((Component)jTextField, gridBagConstraints2);
                ++gridBagConstraints.gridy;
                ++gridBagConstraints2.gridy;
            }
            this.btabbedPane.addTab(string3, jPanel);
        }
        if (bl) {
            this.drawPanel(this.btabbedPane, this.bborderName);
        }
        return bl;
    }

    protected void createPanel() {
        Object object;
        Object object2;
        Object object3;
        int n;
        String[] stringArray = null;
        int n2 = 0;
        boolean bl = false;
        stringArray = this.vo.getLdns(this.moTypeName);
        this.ldnsFiltered = stringArray;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Arrays.sort(stringArray, new RdnComparator(this.sortingMoType));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.moAttributes != null && !this.moAttributes.isEmpty()) {
                CachedMo cachedMo = this.cacheManager.getCachedMo(stringArray[i]);
                n = 1;
                for (TabbedAttribute object42 : this.moAttributes) {
                    object3 = cachedMo.getAttribute(object42.getAttributeName());
                    object2 = null;
                    if (object3 instanceof String) {
                        object2 = (String)object3;
                    } else if (object3 instanceof Integer) {
                        object2 = String.valueOf(object3);
                    }
                    if (object2 != null && ((String)object2).equals(object42.getAttributeValue())) continue;
                    n = 0;
                    break;
                }
                if (n == 0) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        this.ldnsFiltered = stringArray2;
        n2 = stringArray2.length;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            object = stringArray2[n];
            CachedMo cachedMo = this.cacheManager.getCachedMo((String)object);
            object3 = cachedMo.getAttribute("plugInModuleRef");
            if (object3 == null || object3.toString().equals("") || "[Not readable]".equals(object3.toString())) continue;
            ++n3;
        }
        if (n3 > 0) {
            bl = true;
        }
        this.tabbedPane = new JTabbedPane();
        for (n = 0; n < n2; ++n) {
            Object object4;
            Object object5;
            Object object6;
            Object object72;
            object = new JPanel(new GridBagLayout());
            String string = stringArray2[n];
            object3 = this.getTabName(stringArray2[n]);
            object2 = new GridBagConstraints();
            ((GridBagConstraints)object2).gridy = 0;
            ((GridBagConstraints)object2).fill = 0;
            ((GridBagConstraints)object2).insets = new Insets(5, 5, 0, 0);
            ((GridBagConstraints)object2).anchor = 18;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 18;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 10.0;
            gridBagConstraints2.gridwidth = 5;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.anchor = 18;
            CachedMo cachedMo = this.cacheManager.getCachedMo(string);
            for (NameValue nameValue : this.tabbedLabelsWithRestrictions) {
                object72 = nameValue.getName();
                object6 = (Restriction)nameValue.getValue();
                boolean bl2 = object6.isValid(cachedMo, null);
                if (!bl2) continue;
                String string2 = new String((String)object72 + " " + (String)object3);
                object3 = string2;
            }
            this.mapWithTabNames.put(n, new String((String)object3));
            ArrayList arrayList2 = new ArrayList();
            for (Object object72 : this.labelsWithRestrictions) {
                object6 = ((NameValue)object72).getName();
                Restriction restriction = (Restriction)((NameValue)object72).getValue();
                boolean bl3 = restriction.isValid(cachedMo, null);
                if (!bl3) continue;
                ((Container)object).add((Component)new JLabel((String)object6), object2);
                ++((GridBagConstraints)object2).gridy;
                ++gridBagConstraints.gridy;
                arrayList2.add(object6);
            }
            this.labelsPerTab.put(n, arrayList2);
            int n4 = this.attributes.size();
            if ("EFuse_Controller".equals(this.sortingMoType)) {
                if (!bl) {
                    this.setBorder(null);
                    return;
                }
                object72 = cachedMo.getAttribute("plugInModuleRef");
                if (object72 != null && !object72.toString().equals("") && !"[Not readable]".equals(object72.toString())) continue;
            }
            if ("EFuse_Legacy".equals(this.sortingMoType) && (object72 = cachedMo.getAttribute("plugInModuleRef")) != null && !object72.toString().equals("") && !"[Not readable]".equals(object72.toString())) {
                this.setBorder(null);
                return;
            }
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            for (int i = 0; i < n4; ++i) {
                String string3 = this.getLabel(i, false);
                Iterator<ButtonGroup> iterator = this.getValue(i, stringArray2[n], false);
                if (iterator == null || iterator.equals("")) {
                    iterator = "-";
                }
                ((Container)object).add((Component)new JLabel(string3), object2);
                JTextField jTextField = new JTextField(iterator.toString());
                jTextField.setEditable(false);
                jTextField.setBorder(null);
                jTextField.setBackground(this.getBackground());
                if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                    jTextField.setName(string3.toString() + "_Value" + "_" + (String)object3);
                }
                ((Container)object).add((Component)jTextField, gridBagConstraints);
                if (string3.startsWith("Administrative state") && "Unlocked".equals(iterator)) {
                    bl4 = true;
                }
                object5 = "A HW fault exist in this unit (Steady on)";
                if (string3.startsWith("Fault indicator") && ((String)object5).equals(iterator)) {
                    bl5 = true;
                }
                object4 = "Enabled";
                if (string3.startsWith("Operational state") && ((String)object4).equals(iterator)) {
                    bl6 = true;
                }
                ++((GridBagConstraints)object2).gridy;
                ++gridBagConstraints.gridy;
                ++gridBagConstraints2.gridy;
            }
            ArrayList<ButtonGroupManager> arrayList3 = new ArrayList<ButtonGroupManager>();
            if (!this.bgList.isEmpty()) {
                int n5 = ((GridBagConstraints)object2).gridx;
                ((GridBagConstraints)object2).gridx += 2;
                for (ButtonGroup buttonGroup : this.bgList) {
                    object5 = new ButtonGroupManager(this.vo, stringArray2[n], (String)object3, buttonGroup);
                    arrayList3.add((ButtonGroupManager)object5);
                    object4 = ((ButtonGroupManager)object5).createButtonPanel();
                    if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                        ((Component)object4).setName("ButtonPanel_Value_" + (String)object3);
                    }
                    ((GridBagConstraints)object2).anchor = 14;
                    ((Container)object).add((Component)object4, object2);
                    ++((GridBagConstraints)object2).gridy;
                    ++gridBagConstraints.gridy;
                    ++gridBagConstraints2.gridy;
                }
                ((GridBagConstraints)object2).gridx = n5;
            }
            this.bgmPerTab.put(n, arrayList3);
            if (!this.bgList.isEmpty() && this.showUnlockedInTab && bl4) {
                object3 = (String)object3 + UNLOCK_IN_TAB_STRING;
            }
            if (this.isTabbedInPanel && this.createTabbedInPanel(stringArray2[n])) {
                ((Container)object).add((Component)this.btabbedPane, gridBagConstraints2);
            }
            this.tabbedPane.addTab((String)object3, (Component)object);
            if (this.showFaultInTab && bl5) {
                this.tabbedPane.addTab((String)object3, new AlarmIconForTab(), (Component)object);
            }
            if (this.showOperationalInTab && bl6) {
                this.tabbedPane.addTab((String)object3, new OperationalIconForTab(), (Component)object);
            }
            if (!this.showFaultInTab || !bl5 || !this.showOperationalInTab || !bl6) continue;
            this.tabbedPane.addTab((String)object3, new FaultAndOperationalIconForTab(), (Component)object);
        }
        this.tabbedPaneIdentifier = this.vo.getFullName() + this.sortingMoType;
        n = this.vo.getTabState(this.tabbedPaneIdentifier);
        this.tabbedPane.setSelectedIndex(n);
        this.tabbedPane.addChangeListener(new XalmTabChangeListener(this.tabbedPane, this.vo));
        this.drawPanel(this.tabbedPane, this.borderName);
    }

    void drawPanel(JTabbedPane jTabbedPane, String string) {
        jTabbedPane.setBorder(new TitledBorder(string));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 10.0, 10.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)jTabbedPane, gridBagConstraints);
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.setName(string + "_Group");
        }
    }

    public void addConverter(String string, ValueConverter valueConverter, boolean bl) {
        this.converters.put(string, valueConverter);
    }

    public String getTabName(int n) {
        String string = this.mapWithTabNames.get(n);
        if (string != null) {
            return string.toString();
        }
        return "";
    }

    public String getTabName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens() && !(string2 = (String)stringTokenizer.nextElement()).startsWith(this.sortingMoType + "=")) {
        }
        int n = string2.indexOf(61);
        String string3 = string2.substring(n + 1);
        return string3;
    }

    public VoData getVoData() {
        return this.vo;
    }

    public String getBorderName() {
        return this.borderName;
    }

    public String getMoTypeName() {
        return this.moTypeName;
    }

    public String getSortingMoType() {
        return this.sortingMoType;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public String[] getFilteredLdns() {
        return this.ldnsFiltered;
    }

    public String getLabel(int n, boolean bl) {
        if (bl) {
            return (String)this.blabels.get(n);
        }
        return (String)this.labels.get(n);
    }

    public TreeMap<Integer, List<String>> getLabelsPerTab() {
        return this.labelsPerTab;
    }

    public TreeMap<Integer, List<ButtonGroupManager>> getBgmPerTab() {
        return this.bgmPerTab;
    }

    public Object getValue(int n, String string, boolean bl) {
        AttributeExtractor attributeExtractor = null;
        attributeExtractor = bl ? (AttributeExtractor)this.battributes.get(n) : (AttributeExtractor)this.attributes.get(n);
        ValueConverter valueConverter = (ValueConverter)this.converters.get(attributeExtractor.getKey());
        Object object = null;
        if (attributeExtractor instanceof MoAttributeExtractor) {
            object = ((MoAttributeExtractor)attributeExtractor).get(string);
        } else if (attributeExtractor instanceof StructMemberExtractor) {
            object = ((StructMemberExtractor)attributeExtractor).get(string);
        }
        if (valueConverter == null) {
            valueConverter = this.defaultConverter;
        }
        Object object2 = valueConverter.convert(object);
        return object2;
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    private class XalmTabChangeListener
    implements ChangeListener {
        JTabbedPane jp;
        VoData voData;

        XalmTabChangeListener(JTabbedPane jTabbedPane, VoData voData) {
            this.jp = jTabbedPane;
            this.voData = voData;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = this.jp.getSelectedIndex();
            this.voData.setTabState(TabbedFormPanel.this.tabbedPaneIdentifier, n);
        }
    }

    private class OperationalIconForTab
    implements Icon {
        private final Color color = Color.GREEN;

        private OperationalIconForTab() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillOval(n, n2, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class FaultAndOperationalIconForTab
    implements Icon {
        private final Color operationalColor = Color.GREEN;
        private final Color faultColor = Color.RED;

        private FaultAndOperationalIconForTab() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.faultColor);
            graphics.fillOval(n, n2, 10, this.getIconHeight());
            graphics.setColor(this.operationalColor);
            graphics.fillOval(n + 12, n2, 10, this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 22;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class AlarmIconForTab
    implements Icon {
        private final Color color = Color.RED;

        private AlarmIconForTab() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillOval(n, n2, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    class RdnComparator
    implements Comparator {
        private String moType;

        public RdnComparator(String string) {
            this.moType = string;
            if (string.indexOf("*") != -1) {
                this.moType = this.moType.replace('*', ' ').trim();
            }
        }

        public int compare(Object object, Object object2) {
            String string = TabbedFormPanel.this.getTabName(object.toString());
            String string2 = TabbedFormPanel.this.getTabName(object2.toString());
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(string);
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string.compareTo(string2);
            }
            return n - n2;
        }
    }
}

