/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class TablePanel
extends JPanel
implements InfoPanel {
    private String moTypeName;
    private String borderName;
    private VoData vo;
    final List<ColumnItem> columnItems = new ArrayList<ColumnItem>();
    boolean isVisible = false;

    public TablePanel(String string, String string2) {
        this(null, string, string2);
    }

    public TablePanel(VoData voData, String string, String string2) {
        this.vo = voData;
        this.borderName = string;
        this.moTypeName = string2;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void update(VoData voData) {
        try {
            this.vo = voData;
            super.removeAll();
            this.updatePanel();
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to create table panel " + this.borderName, exception);
        }
    }

    public void addColumn(String string, String string2, String string3, String string4) {
        this.columnItems.add(new ColumnItem(string, string2, string3, string4));
    }

    private void updatePanel() {
        String[] stringArray = this.vo.getLdns(this.moTypeName);
        int n = this.columnItems.size();
        int n2 = stringArray.length;
        if (stringArray == null || stringArray.length == 0 || n == 0) {
            this.isVisible = false;
            return;
        }
        this.isVisible = true;
        Object[] objectArray = new Object[n];
        String[] stringArray2 = new String[n];
        int n3 = 0;
        for (ColumnItem columnItem : this.columnItems) {
            objectArray[n3] = columnItem.label;
            stringArray2[n3] = columnItem.attributeName;
            ++n3;
        }
        Object[][] objectArray2 = new Object[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                ColumnItem columnItem = this.columnItems.get(j);
                Object object = this.vo.getValue(stringArray[i], columnItem.structName);
                NameValue nameValue = null;
                if (object instanceof Struct) {
                    nameValue = ((Struct)object).getMember(columnItem.attributeName);
                }
                String string = "";
                if (nameValue != null && (string = (String)nameValue.getValue()) == null) {
                    string = "";
                }
                objectArray2[i][j] = string;
            }
        }
        JTable jTable = new JTable(new MyTableModel(objectArray2, objectArray));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add((Component)jScrollPane, "Center");
        this.setBorder(new TitledBorder(this.borderName));
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    class MyTableModel
    extends DefaultTableModel {
        public MyTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class ColumnItem {
        String label;
        String attributeName;
        String structName;
        String structType;

        ColumnItem(String string, String string2, String string3, String string4) {
            this.label = string;
            this.attributeName = string2;
            this.structName = string3;
            this.structType = string4;
        }
    }
}

