/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.managers;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AuxiliaryUnitRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogicalDeviceBoardLock;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogicalDeviceBoardRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogicalDeviceBoardUnlock;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.Button;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.ButtonGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.managers.ButtonManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class ButtonGroupManager {
    private String objectName;
    private String moType;
    private String moLdn;
    private String indexNo;
    private String attributeName;
    private ValueConverter converter;
    private List<ButtonManager> buttons = new ArrayList<ButtonManager>();
    private VoData voData;
    private JPanel p = new JPanel(new FlowLayout());

    public ButtonGroupManager(VoData voData, String string, String string2, ButtonGroup buttonGroup) {
        this.voData = voData;
        this.moLdn = string;
        this.indexNo = string2;
        this.objectName = buttonGroup.getObjectName();
        this.attributeName = buttonGroup.getAttribute();
        this.converter = buttonGroup.getConverter();
        String string3 = buttonGroup.getMoType();
        List<Button> list = buttonGroup.getButtons();
        String string4 = this.getConvertedValue();
        for (Button button : list) {
            ButtonManager buttonManager = new ButtonManager(button, string4);
            if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                buttonManager.setName(buttonManager.getText() + ":" + "_Value" + "_" + string2);
            }
            if (this.isReadOnlyMode()) {
                buttonManager.setEnabled(false);
            }
            this.addButton(buttonManager);
        }
        if (string3 != null) {
            this.moType = string3;
        }
    }

    private boolean isReadOnlyMode() {
        return this.voData.getCvSession().getAccessLevel() != 1;
    }

    private void addButton(ButtonManager buttonManager) {
        this.buttons.add(buttonManager);
        this.p.add(buttonManager);
        String string = buttonManager.getActionName();
        CabinetViewerAction cabinetViewerAction = null;
        String string2 = new String(" " + this.indexNo);
        if (this.objectName != null) {
            string2 = new String(this.objectName + " " + this.indexNo);
        }
        if (string.equalsIgnoreCase("Lock")) {
            cabinetViewerAction = new LogicalDeviceBoardLock((Operable)((Object)this.voData), this.moLdn, string2);
        } else if (string.equalsIgnoreCase("Unlock")) {
            cabinetViewerAction = new LogicalDeviceBoardUnlock((Operable)((Object)this.voData), this.moLdn, string2);
        } else if (string.equalsIgnoreCase("Restart")) {
            cabinetViewerAction = new LogicalDeviceBoardRestart((Operable)((Object)this.voData), this.moLdn, string2);
        } else if (string.equalsIgnoreCase("RestartAuxUnit")) {
            cabinetViewerAction = new AuxiliaryUnitRestart((Operable)((Object)this.voData), this.moLdn, string2);
        }
        if (cabinetViewerAction != null) {
            buttonManager.addActionListener(cabinetViewerAction);
        }
    }

    public JPanel createButtonPanel() {
        return this.p;
    }

    private String getConvertedValue() {
        if (this.moLdn == null || this.attributeName == null) {
            return null;
        }
        Object object = this.voData.getValue(this.moLdn, this.attributeName);
        return (String)this.converter.convert(object);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getMoLdn() {
        return this.moLdn;
    }

    public String getMoType() {
        return this.moType;
    }

    public List<ButtonManager> getButtons() {
        return this.buttons;
    }
}

