/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.session;

import javax.swing.JFrame;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.wcdma.rbs.cabinetviewer.common.ErrorDialog;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.guitestsupport.CabvEvent;
import se.ericsson.wcdma.rbs.cabinetviewer.guitestsupport.GuiTestEventTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSessionImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;

public class CvSessionController {
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_LAUNCHED = 3;
    private static final String[] NAMES_OF_STATES = new String[]{"IDLE", "PREPARING", "READY", "LAUNCHED"};
    private int launchState = 0;
    private CvSession cvSession;
    private MainWindowController mainWindowController;
    int sessionNumber;
    private int accessLevel;
    private ErrorInformation errorInfo;
    private LauncherData launcherData;
    private ProgressListenerInterface progressListenerInterface = null;
    private static final int PROGRESS_MAX = 15;

    public CvSessionController(int n, LauncherData launcherData, int n2, ProgressListenerInterface progressListenerInterface) {
        this.sessionNumber = n;
        this.launcherData = launcherData;
        this.accessLevel = n2;
        this.progressListenerInterface = progressListenerInterface;
        if (!this.isStartWithoutCaching()) {
            this.setState(1);
            this.doStepProgress(1);
            this.startSession();
        }
    }

    private void startSession() {
        this.cvSession = new CvSessionImpl(this, this.launcherData, this.accessLevel);
        VibManager vibManager = this.cvSession.getVibManager();
        vibManager.start(this.cvSession);
    }

    public VibManager getVibManager() {
        if (this.cvSession != null) {
            return this.cvSession.getVibManager();
        }
        return null;
    }

    private void stopSession() {
        if (this.mainWindowController != null) {
            this.mainWindowController.exit();
            this.mainWindowController = null;
        }
        this.cvSession.dispose();
        this.cvSession = null;
        this.launcherData.launcher.onExit(this.launcherData.cabinetViewer);
        Trace.observation(this, "Session is closed");
    }

    public void setCvSession(CvSession cvSession) {
        this.cvSession = cvSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStepProgress(int n) {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            if (this.progressListenerInterface != null && n <= 15) {
                String string = "";
                if (n == 1) {
                    string = "Launching";
                } else if (n == 2 || n == 3) {
                    string = "Connecting to node";
                } else if (n >= 4 && n <= 14) {
                    string = "Reading information";
                } else if (n == 15) {
                    string = "Finished";
                }
                String string2 = "Cabinet Viewer: " + string;
                this.progressListenerInterface.setProgress(string2, n, 15);
                int n2 = n * 100 / 15;
                Trace.observation(this, "Progress step : " + string2 + ", " + n2 + "%");
            }
        }
    }

    private void stopProgress() {
        if (this.progressListenerInterface != null) {
            this.progressListenerInterface.close();
            Trace.observation(this, "Progress window is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readyForLaunch() {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            this.mainWindowController = new MainWindowController(this.cvSession, this.launcherData);
            switch (this.launchState) {
                case 1: {
                    this.setState(2);
                    this.stopProgress();
                    if (this.isStartWithoutGui()) break;
                    this.mainWindowController.show();
                    this.setState(3);
                    break;
                }
                case 0: 
                case 2: 
                case 3: {
                    this.unexpectedEvent("readyForLaunch");
                    break;
                }
                default: {
                    this.unrecognisedState("readyForLaunch");
                }
            }
        }
    }

    private boolean isStartWithoutGui() {
        return System.getProperty("START_CABV_WITHOUT_GUI") != null;
    }

    private boolean isStartWithoutCaching() {
        return System.getProperty("START_CABV_WITHOUT_CACHING") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String string, Exception exception) {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            Trace.error(this, string, exception);
            switch (this.launchState) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    this.setError(string, exception);
                    this.stopSession();
                    this.stopProgress();
                    this.setState(0);
                    break;
                }
                case 3: {
                    this.showErrorDialog(string, exception);
                    this.stopSession();
                    this.setState(0);
                    break;
                }
                default: {
                    this.unrecognisedState("error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            Trace.observation(this, "Exiting RBS " + this.launcherData.ipAddress + ". From state  " + this.launchState);
            switch (this.launchState) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.stopSession();
                    this.stopProgress();
                    this.setState(0);
                    break;
                }
                default: {
                    this.unrecognisedState("exit");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            Trace.observation(this, "State transition : " + NAMES_OF_STATES[this.launchState] + " > " + NAMES_OF_STATES[n]);
            this.launchState = n;
        }
    }

    public void setStateForTest(int n, String string) {
        Trace.observation(this, "Set the state for " + string);
        this.setState(n);
    }

    private void unrecognisedState(String string) {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            this.error(null, null);
            throw new Error("Unrecognised state:" + this.launchState + " when handling event:" + string);
        }
    }

    private void unexpectedEvent(String string) {
        CvSessionController cvSessionController = this;
        synchronized (cvSessionController) {
            this.error(null, null);
            throw new Error("Unexpected event:" + string + " in state:" + NAMES_OF_STATES[this.launchState]);
        }
    }

    public void showErrorDialog(ErrorInformation errorInformation) {
        this.showErrorDialog(errorInformation.slogan, errorInformation.exception);
    }

    public void showErrorDialog(String string, Exception exception) {
        if (this.mainWindowController != null && this.mainWindowController.getMainWindow() != null) {
            this.showErrorDialogWithMainWindowAsParent(string, exception);
            this.mainWindowController.getStatusNotifier().hideStatus();
            return;
        }
        StringBuffer stringBuffer = this.getStackTraceElements(exception);
        ErrorDialog errorDialog = new ErrorDialog(null, "Cabinet Viewer error", false, string, exception != null ? exception.toString() + "\n" + stringBuffer.toString() : "");
        errorDialog.setVisible(true);
    }

    public JFrame getMainWindofFrame() {
        if (this.mainWindowController != null) {
            return this.mainWindowController.getMainWindow();
        }
        return null;
    }

    private void showErrorDialogWithMainWindowAsParent(String string, Exception exception) {
        StringBuffer stringBuffer = this.getStackTraceElements(exception);
        ErrorDialog errorDialog = new ErrorDialog(this.mainWindowController.getMainWindow(), "Cabinet Viewer error", true, string, exception != null ? exception.toString() + "\n" + stringBuffer.toString() : "");
        errorDialog.setVisible(true);
    }

    private StringBuffer getStackTraceElements(Exception exception) {
        StackTraceElement[] stackTraceElementArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (exception != null && (stackTraceElementArray = exception.getStackTrace()) != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(stackTraceElementArray[i] + "\n");
            }
        }
        return stringBuffer;
    }

    public void sendNotification(String string, String string2) {
        GuiTestEventTypes guiTestEventTypes = GuiTestEventTypes.getInstance();
        CabvEvent cabvEvent = new CabvEvent(string, this, guiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), string2, null);
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            ((EmNotificationServiceInterface)this.launcherData.launcher).sendNotification((EmEventInterface)cabvEvent);
        }
    }

    private void setError(String string, Exception exception) {
        if (this.errorInfo != null) {
            this.errorInfo = new ErrorInformation(string, exception);
        }
    }

    private class ErrorInformation {
        public String slogan;
        public Exception exception;

        public ErrorInformation(String string, Exception exception) {
            this.slogan = string;
            this.exception = exception;
        }
    }
}

