/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.session;

import java.util.logging.Logger;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiController;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSessionController;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;

public class CvSessionImpl
implements CvSession {
    private CvSessionController cvSessionController;
    private int accessLevel;
    private CacheManager cacheManager;
    private NealManager nealManager;
    private VibManager vibManager;
    private ColiHandler coliHandler;
    private FtpFactory ftpFactory;
    private LauncherData launcherData;

    public CvSessionImpl(CvSessionController cvSessionController, LauncherData launcherData, int n) {
        this.cvSessionController = cvSessionController;
        this.launcherData = launcherData;
        this.accessLevel = n;
        this.nealManager = new NealManager(launcherData, cvSessionController);
        this.cacheManager = new CacheManager(this.nealManager);
        this.vibManager = new VibManager();
        this.ftpFactory = this.getFtpFactory(launcherData);
    }

    @Override
    public ColiHandler getColiHandler() {
        if (this.coliHandler == null) {
            if (System.getProperty("use_cabv_stub") != null && System.getProperty("use_cabv_stub").equals("true")) {
                this.coliHandler = this.createColiHandlerStub();
            }
            if (this.coliHandler == null) {
                this.coliHandler = new ColiController(this);
            }
        }
        return this.coliHandler;
    }

    private FtpFactory getFtpFactory(LauncherData launcherData) {
        FtpFactory ftpFactory = null;
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            try {
                Class<?> clazz = Class.forName("cabvstub.StubbedFtpFactory");
                ftpFactory = (FtpFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).finest("Failed to initialize stubbed ftp manager");
                ftpFactory = new FtpManager(launcherData);
            }
        } else {
            ftpFactory = new FtpManager(launcherData);
        }
        return ftpFactory;
    }

    @Override
    public void dispose() {
        this.vibManager.halt();
        this.vibManager = null;
        if (this.coliHandler != null) {
            this.coliHandler.stop();
        }
        this.coliHandler = null;
        this.cacheManager = null;
        this.nealManager = null;
        this.ftpFactory = null;
    }

    @Override
    public boolean isColiHandlerStarted() {
        return this.coliHandler == null;
    }

    @Override
    public CvSessionController getCvSessionController() {
        return this.cvSessionController;
    }

    @Override
    public String getIpAddress() {
        return this.launcherData.ipAddress;
    }

    @Override
    public int getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public NealManager getNealManager() {
        return this.nealManager;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public VibManager getVibManager() {
        return this.vibManager;
    }

    @Override
    public FtpFactory getFtpFactory() {
        return this.ftpFactory;
    }

    private ColiHandler createColiHandlerStub() {
        ColiHandler coliHandler = null;
        try {
            Class<?> clazz = Class.forName("cabvstub.ColiHandlerStub");
            coliHandler = (ColiHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            Trace.error(this, "Error: Unable to create Coli stub. Reason: ", exception);
        }
        return coliHandler;
    }

    @Override
    public LauncherData getLauncherData() {
        return this.launcherData;
    }
}

