/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.BoardView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.CabinetView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.ContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.GridMounting;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LabelView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalViewController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.Selectable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SlotView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SubrackView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.UnitView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalBoardView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalSubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalSubrackView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.RbsViewVirtualSectorFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;

public class PhysicalViewFactory
extends RbsViewVirtualSectorFactory {
    final ActionManager actionManager;
    private PhysicalViewController controller;
    private List listOfVos;

    public PhysicalViewFactory(ActionManager actionManager, CvSession cvSession) {
        super(cvSession);
        this.actionManager = actionManager;
    }

    public PhysicalView newPhysicalView(List list, VoRelationship voRelationship) {
        this.listOfVos = list;
        this.controller = new PhysicalViewController();
        Object object = this.createContainment(list, voRelationship, null, null);
        if (object instanceof PhysicalView) {
            return (PhysicalView)object;
        }
        PhysicalView physicalView = new PhysicalView(this.controller);
        if (object instanceof VoView) {
            physicalView.add((VoView)object);
        }
        return physicalView;
    }

    @Override
    protected Object newObject(Object object, ViewableObject viewableObject, VoRelationship voRelationship) {
        Container container = (Container)object;
        JPanel jPanel = null;
        if (voRelationship != null) {
            if (voRelationship.getGeneralType().equals("PhysicalView")) {
                jPanel = new PhysicalView(this.controller);
            }
            if (voRelationship.getGeneralType().equals("Cabinet")) {
                jPanel = this.newCabinet(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("Subrack") && voRelationship.getProperty("KEY_VERTICAL_SUBRACK") == null) {
                jPanel = this.newSubrack(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("Subrack") && voRelationship.getProperty("KEY_VERTICAL_SUBRACK") != null) {
                jPanel = this.newVerticalSubrack(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("Unit")) {
                jPanel = this.newUnit(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("Container")) {
                jPanel = this.newContainer(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("VirtualContainer")) {
                jPanel = this.newVirtualContainer(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("VirtualHorizontalContainer")) {
                jPanel = this.newVirtualHorizontalContainer(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("VirtualMinimizedContainer")) {
                jPanel = this.newVirtualMinimizedContainer(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("VirtualSectorContainer")) {
                jPanel = this.newVirtualSectorContainer(container, viewableObject, voRelationship);
            } else if (voRelationship.getGeneralType().equals("Label")) {
                jPanel = this.newLabel(container, viewableObject, voRelationship);
            }
        } else if (viewableObject.getGeneralType().equals("Board")) {
            jPanel = this.newBoard(container, viewableObject, voRelationship);
        } else if (viewableObject.getGeneralType().equals("Unit")) {
            jPanel = this.newUnit(container, viewableObject, voRelationship);
        } else if (viewableObject.getGeneralType().equals("SectorUnit")) {
            jPanel = this.newSectorUnit(container, viewableObject, voRelationship);
        } else if (viewableObject.getGeneralType().equals("Slot")) {
            jPanel = this.newSlot(container, viewableObject);
        }
        if (jPanel instanceof VoView) {
            VoView voView = (VoView)jPanel;
            voView.setActionManager(this.actionManager);
            if (viewableObject != null) {
                this.controller.add(viewableObject, (VoView)jPanel);
            } else if (voRelationship.getProperty("GENERIC_CONTAINER") != null || jPanel instanceof ContainerView) {
                if (voRelationship.getProperty("AUTONOMOUS") != null) {
                    voView.setToolTipText(voRelationship.getSpecificType() + " is an autonomous unit");
                }
                voView.setInstallationState(1);
            } else if (voRelationship.getProperty("AUTONOMOUS") != null) {
                voView.setInstallationState(1);
                voView.setToolTipText(voRelationship.getSpecificType() + " is an autonomous unit");
            } else if (voRelationship.getGeneralType().equals("VirtualMinimizedContainer")) {
                voView.setToolTipText(null);
            } else {
                voView.setInstallationState(2);
                voView.setToolTipText(voRelationship.getSpecificType() + " is not installed");
            }
        }
        return jPanel;
    }

    public VoView newCabinet(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VibManager vibManager = this.getCvSession().getVibManager();
        CabinetView cabinetView = viewableObject != null ? (vibManager.getMultiConfig() ? new CabinetView(viewableObject, viewableObject.getPrefix()) : new CabinetView(viewableObject)) : new CabinetView(voRelationship.getSpecificType());
        if (container != null) {
            container.add((Component)cabinetView, voRelationship.getPosition());
        }
        return cabinetView;
    }

    public VoView newContainer(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        Object object;
        boolean bl = true;
        if (voRelationship.getProperty("HIDE_IF_NO_CHILDREN") != null) {
            bl = false;
            object = voRelationship.getChildren();
            ListIterator listIterator = object.listIterator();
            while (listIterator.hasNext()) {
                VoRelationship voRelationship2 = (VoRelationship)listIterator.next();
                String string = voRelationship2.getSpecificType();
                if (!this.isVoExisting(string)) continue;
                bl = true;
                break;
            }
        }
        object = new ContainerView(voRelationship.getSpecificType());
        if (container != null && bl) {
            container.add((Component)object, voRelationship.getPosition());
        }
        return object;
    }

    protected boolean isVoExisting(String string) {
        for (ViewableObject viewableObject : this.listOfVos) {
            if (!viewableObject.getSpecificType().equals(string)) continue;
            return true;
        }
        return false;
    }

    public VoView newUnit(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        Hashtable hashtable = null;
        if (voRelationship != null) {
            hashtable = voRelationship.getPropertiess();
        }
        UnitView unitView = viewableObject != null ? new UnitView(viewableObject, hashtable) : new UnitView(voRelationship.getSpecificType(), hashtable);
        GridMounting gridMounting = null;
        if (voRelationship != null) {
            gridMounting = voRelationship.getPosition();
        }
        if (gridMounting instanceof GridMounting) {
            GridMounting gridMounting2 = gridMounting;
            unitView.setRelativeSize(gridMounting2.getRelativeWidth(), gridMounting2.getRelativeHeight());
        }
        if (container != null) {
            container.add((Component)unitView, gridMounting);
        }
        return unitView;
    }

    public VoView newLabel(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        LabelView labelView = new LabelView(voRelationship.getSpecificType());
        if (container != null) {
            container.add((Component)labelView, voRelationship.getPosition());
        }
        return labelView;
    }

    public VoView newBoard(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VoView voView = null;
        if (container instanceof SubrackView) {
            Serializable serializable;
            Object object;
            BoardView boardView;
            voView = boardView = new BoardView(viewableObject);
            boardView.copyProperties(viewableObject.getProperties());
            String string = viewableObject.getPrefix();
            int n = 1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SubrackView subrackView = (SubrackView)container;
            if (viewableObject.getProperty("NO_SLOT") != null) {
                subrackView.addWithoutSlot(boardView);
            } else {
                subrackView.addToSlot(boardView, n);
            }
            Object object2 = viewableObject.getProperty("MULTI_UNIT_BOARD");
            if (object2 instanceof ViewableObject[]) {
                object = (ViewableObject[])object2;
                for (int i = 0; i < ((ViewableObject[])object).length; ++i) {
                    serializable = new BoardView(object[i]);
                    ((JComponent)serializable).setToolTipText(n + ":" + object[i].getSpecificType());
                    ((VoView)serializable).setActionManager(this.actionManager);
                    this.controller.add(object[i], (Selectable)((Object)serializable));
                    subrackView.addToSlot((VoView)serializable, n);
                }
            }
            if ((object = viewableObject.getProperty("SLOTLESS_MULTI_UNIT_BOARD")) instanceof ViewableObject[]) {
                Object object3 = object;
                serializable = (Integer)viewableObject.getProperty("SLOTLESS_MULTI_UNIT_BOARD_SLOT");
                for (int i = 0; i < ((ViewableObject[])object3).length; ++i) {
                    BoardView boardView2 = new BoardView(object3[i]);
                    boardView2.setToolTipText(serializable + ":" + object3[i].getSpecificType());
                    ((VoView)boardView2).setActionManager(this.actionManager);
                    this.controller.add(object3[i], boardView2);
                    subrackView.addToSlot(boardView2, (Integer)serializable);
                }
            }
        } else if (container instanceof VerticalSubrackView) {
            Serializable serializable;
            Object object;
            VerticalBoardView verticalBoardView = new VerticalBoardView(viewableObject);
            voView = verticalBoardView;
            verticalBoardView.copyProperties(viewableObject.getProperties());
            String string = viewableObject.getPrefix();
            int n = 1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            VerticalSubrackView verticalSubrackView = (VerticalSubrackView)container;
            if (viewableObject.getProperty("NO_SLOT") != null) {
                verticalSubrackView.addWithoutSlot(verticalBoardView);
            } else {
                verticalSubrackView.addToSlot(verticalBoardView, n);
            }
            Object object4 = viewableObject.getProperty("MULTI_UNIT_BOARD");
            if (object4 instanceof ViewableObject[]) {
                object = (ViewableObject[])object4;
                for (int i = 0; i < ((ViewableObject[])object).length; ++i) {
                    serializable = new VerticalBoardView(object[i]);
                    ((JComponent)serializable).setToolTipText(n + ":" + object[i].getSpecificType());
                    ((VoView)serializable).setActionManager(this.actionManager);
                    this.controller.add(object[i], (Selectable)((Object)serializable));
                    verticalSubrackView.addToSlot((VoView)serializable, n);
                }
            }
            if ((object = viewableObject.getProperty("SLOTLESS_MULTI_UNIT_BOARD")) instanceof ViewableObject[]) {
                Object object5 = object;
                serializable = (Integer)viewableObject.getProperty("SLOTLESS_MULTI_UNIT_BOARD_SLOT");
                for (int i = 0; i < ((ViewableObject[])object5).length; ++i) {
                    VerticalBoardView verticalBoardView2 = new VerticalBoardView(object5[i]);
                    verticalBoardView2.setToolTipText(serializable + ":" + object5[i].getSpecificType());
                    ((VoView)verticalBoardView2).setActionManager(this.actionManager);
                    this.controller.add(object5[i], verticalBoardView2);
                    verticalSubrackView.addToSlot(verticalBoardView2, (Integer)serializable);
                }
            }
        } else if (container instanceof VirtualContainerView) {
            BoardView boardView;
            voView = boardView = new BoardView(viewableObject);
            boardView.copyProperties(viewableObject.getProperties());
            VoRelationship voRelationship2 = viewableObject.getCurrentVoRelationship();
            Object object = voRelationship2.getProperty("SUBRACK_LAYOUT");
            SubrackLayout subrackLayout = null;
            if (object instanceof SubrackLayout && object != null) {
                subrackLayout = (SubrackLayout)object;
            }
            if (container != null) {
                ((VirtualContainerView)container).addVirtualSlot(boardView, subrackLayout);
            }
        } else {
            Trace.error(this, "Can't add to " + container);
        }
        return voView;
    }

    public VoView newSlot(Container container, ViewableObject viewableObject) {
        SlotView slotView = new SlotView(viewableObject);
        slotView.copyProperties(viewableObject.getProperties());
        slotView.setName("");
        if (container instanceof SubrackView) {
            String string = viewableObject.getPrefix();
            int n = Integer.parseInt(string);
            SubrackView subrackView = (SubrackView)container;
            subrackView.addToSlot(slotView, n);
        } else if (container instanceof VerticalSubrackView) {
            String string = viewableObject.getPrefix();
            int n = Integer.parseInt(string);
            VerticalSubrackView verticalSubrackView = (VerticalSubrackView)container;
            verticalSubrackView.addToSlot(slotView, n);
        } else {
            Trace.error(this, "Can't add to " + container);
        }
        return slotView;
    }

    public VoView newSubrack(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        Object object = voRelationship.getProperty("SUBRACK_LAYOUT");
        SubrackLayout subrackLayout = null;
        if (object instanceof SubrackLayout) {
            subrackLayout = (SubrackLayout)object;
        }
        Hashtable hashtable = null;
        if (voRelationship != null) {
            hashtable = voRelationship.getPropertiess();
        }
        SubrackView subrackView = viewableObject != null ? new SubrackView(viewableObject, subrackLayout, hashtable) : new SubrackView(voRelationship.getSpecificType(), hashtable);
        GridMounting gridMounting = null;
        if (voRelationship != null) {
            gridMounting = voRelationship.getPosition();
        }
        if (gridMounting instanceof GridMounting) {
            GridMounting gridMounting2 = gridMounting;
            subrackView.setRelativeSize(gridMounting2.getRelativeWidth(), gridMounting2.getRelativeHeight());
        }
        if (container != null) {
            container.add((Component)subrackView, gridMounting);
        }
        return subrackView;
    }

    public VoView newVerticalSubrack(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        Object object = voRelationship.getProperty("SUBRACK_LAYOUT");
        VerticalSubrackLayout verticalSubrackLayout = null;
        if (object instanceof SubrackLayout) {
            verticalSubrackLayout = (VerticalSubrackLayout)object;
        }
        Hashtable hashtable = null;
        if (voRelationship != null) {
            hashtable = voRelationship.getPropertiess();
        }
        VerticalSubrackView verticalSubrackView = viewableObject != null ? new VerticalSubrackView(viewableObject, verticalSubrackLayout, hashtable) : new VerticalSubrackView(voRelationship.getSpecificType(), hashtable);
        GridMounting gridMounting = null;
        if (voRelationship != null) {
            gridMounting = voRelationship.getPosition();
        }
        if (gridMounting instanceof GridMounting) {
            GridMounting gridMounting2 = gridMounting;
            verticalSubrackView.setRelativeSize(gridMounting2.getRelativeWidth(), gridMounting2.getRelativeHeight());
        }
        if (container != null) {
            container.add((Component)verticalSubrackView, gridMounting);
        }
        return verticalSubrackView;
    }
}

