/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.GridMounting;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SectorUnitView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualHorizontalContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualMinimizedContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualSectorContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.RbsViewFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorNamesComparator;

public abstract class RbsViewVirtualSectorFactory
extends RbsViewFactory {
    private static final double MAX_WIDTH_OF_SECTOR_CONTAINER = 508.0;
    private double preferSize = 0.0;
    private List currentVoList;
    private String currentSector;
    private int currentXPosition;
    private int currentYPosition;

    public RbsViewVirtualSectorFactory(CvSession cvSession) {
        super(cvSession);
    }

    protected String[] getEquippedSectors(VoRelationship voRelationship) {
        Object object;
        Object object2 = null;
        String string = this.getCvSession().getVibManager().getVimModel().getMimModel().getMoTypeForSectors();
        object2 = string != null && !string.equals("") ? string : voRelationship.getMoTypeNameForNoOfSectors();
        if (object2 == null) {
            return new String[0];
        }
        if (object2 instanceof List && (object = (List)object2).size() == 1) {
            object2 = object.get(0);
        }
        object = this.getCvSession().getCacheManager();
        List<CachedMo> list = ((CacheManager)object).getCachedMosOfType(object2.toString());
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray2 = list.get(i);
            String string2 = stringArray2.getLdn();
            String[] stringArray3 = string2.split("=");
            stringArray[i] = new String(stringArray3[stringArray3.length - 1]);
        }
        Arrays.sort(stringArray, new SectorNamesComparator());
        StringBuffer stringBuffer = new StringBuffer();
        for (String string3 : stringArray) {
            stringBuffer.append("\"" + string3 + "\",");
        }
        Trace.observation(this, "Found sectors: " + stringBuffer.toString());
        return stringArray;
    }

    protected int getNumberOfSectors(VoRelationship voRelationship) {
        String[] stringArray = this.getEquippedSectors(voRelationship);
        return stringArray.length;
    }

    @Override
    protected void buildAllVirtualSectorContainersAutomatically(VoRelationship voRelationship, List list, ViewableObject viewableObject, Object object, Object object2, String string) {
        Object object3 = object2;
        String string2 = voRelationship.getVirtualGeneralType();
        List list2 = voRelationship.getVirtualSpecificTypes();
        this.currentVoList = new ArrayList();
        boolean bl = false;
        if (string2 == null || list2 == null) {
            return;
        }
        String[] stringArray = this.getEquippedSectors(voRelationship);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object4 = object;
            this.currentSector = stringArray[i];
            if (this.currentSector == null) continue;
            for (Object e : list2) {
                Iterator iterator = list.iterator();
                ViewableObject viewableObject2 = null;
                while (iterator.hasNext()) {
                    ViewableObject viewableObject3 = (ViewableObject)iterator.next();
                    if (!viewableObject3.isMatching(string2, e.toString()) || !this.currentSector.equals(viewableObject3.usedBySectorNo())) continue;
                    String string3 = viewableObject3.getPositionRefValue("positionRefName");
                    if (!String.valueOf(string).equals(string3) && !"".equals(string3)) continue;
                    if (!bl) {
                        bl = true;
                        VibManager vibManager = this.getCvSession().getVibManager();
                        if (vibManager.getMultiConfig() && !"".equals(string)) {
                            object3 = this.newVirtualContainer((Container)object3, null, "Cabinet " + string + " " + "Sector" + "s");
                        } else if (!vibManager.getMultiConfig() || "".equals(string)) {
                            object3 = this.newVirtualContainer((Container)object3, null, "Sectors");
                        }
                        if (object3 instanceof VoView) {
                            ((VoView)object3).setInstallationState(1);
                        }
                    }
                    viewableObject3.setPrefixVisible(false);
                    if (object4 == null) {
                        object4 = this.newObject(object3, null, voRelationship);
                    }
                    this.newObject(object4, viewableObject3, null);
                    viewableObject2 = viewableObject3;
                    this.currentVoList.add(viewableObject3);
                    if (viewableObject == null) continue;
                    viewableObject.addChild(viewableObject2);
                }
            }
            if (object4 == null || !(object4 instanceof VirtualSectorContainerView)) continue;
            ((VirtualSectorContainerView)object4).addPushUpJPanel();
        }
    }

    protected VoView newVirtualContainer(Container container, ViewableObject viewableObject, String string) {
        VirtualContainerView virtualContainerView = new VirtualContainerView(string);
        double d = this.getPreferSize();
        if (container != null && container instanceof PhysicalView) {
            PhysicalView physicalView = (PhysicalView)container;
            GridMounting gridMounting = new GridMounting(1, 1);
            physicalView.addSectorContainer(virtualContainerView, gridMounting, d);
            if (!physicalView.isProferSize()) {
                this.clearPreferSize();
                physicalView.setProferSizeFlag(true);
            }
        }
        return virtualContainerView;
    }

    protected VoView newVirtualHorizontalContainer(Container container, ViewableObject viewableObject, String string) {
        VirtualHorizontalContainerView virtualHorizontalContainerView = new VirtualHorizontalContainerView(string);
        if (container != null) {
            GridMounting gridMounting = new GridMounting(1, 1);
            container.add((Component)virtualHorizontalContainerView, gridMounting);
        }
        return virtualHorizontalContainerView;
    }

    protected VoView newVirtualMinimizedContainer(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VirtualMinimizedContainerView virtualMinimizedContainerView = new VirtualMinimizedContainerView(voRelationship.getSpecificType());
        if (container != null) {
            GridMounting gridMounting = voRelationship.getPosition();
            if (gridMounting == null) {
                gridMounting = new GridMounting(1, 1);
            }
            container.add((Component)virtualMinimizedContainerView, gridMounting);
        }
        return virtualMinimizedContainerView;
    }

    protected VoView newVirtualContainer(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VirtualContainerView virtualContainerView = null;
        virtualContainerView = voRelationship.getSpecificType().equals("DU") ? new VirtualContainerView(voRelationship.getSpecificType(), "Subrack") : new VirtualContainerView(voRelationship.getSpecificType());
        if (container != null) {
            GridMounting gridMounting = voRelationship.getPosition();
            if (gridMounting == null) {
                gridMounting = new GridMounting(1, 1);
            }
            container.add((Component)virtualContainerView, gridMounting);
        }
        return virtualContainerView;
    }

    protected VoView newVirtualHorizontalContainer(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VirtualHorizontalContainerView virtualHorizontalContainerView = new VirtualHorizontalContainerView(voRelationship.getSpecificType());
        if (container != null) {
            GridMounting gridMounting = voRelationship.getPosition();
            if (gridMounting == null) {
                gridMounting = new GridMounting(1, 1);
            }
            container.add((Component)virtualHorizontalContainerView, gridMounting);
        }
        return virtualHorizontalContainerView;
    }

    protected VoView newVirtualSectorContainer(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        VirtualSectorContainerView virtualSectorContainerView = new VirtualSectorContainerView(voRelationship.getSpecificType(), this.currentSector);
        double d = container.getPreferredSize().getWidth();
        this.preferSize += d;
        if (d >= 508.0 && this.currentYPosition < 1) {
            ++this.currentYPosition;
            this.currentXPosition = 0;
        }
        if (container != null) {
            GridMounting gridMounting = new GridMounting(this.currentXPosition, this.currentYPosition);
            container.add((Component)virtualSectorContainerView, gridMounting);
            ++this.currentXPosition;
        }
        return virtualSectorContainerView;
    }

    protected VoView newSectorUnit(Container container, ViewableObject viewableObject, VoRelationship voRelationship) {
        Hashtable hashtable = null;
        if (voRelationship != null) {
            hashtable = voRelationship.getPropertiess();
        }
        SectorUnitView sectorUnitView = viewableObject != null ? new SectorUnitView(viewableObject, hashtable) : new SectorUnitView(voRelationship.getSpecificType(), hashtable);
        GridMounting gridMounting = null;
        if (voRelationship != null) {
            gridMounting = voRelationship.getPosition();
        }
        if (gridMounting instanceof GridMounting) {
            GridMounting gridMounting2 = gridMounting;
            sectorUnitView.setRelativeSize(gridMounting2.getRelativeWidth(), gridMounting2.getRelativeHeight());
        }
        if (container != null) {
            container.add((Component)sectorUnitView, gridMounting);
        }
        return sectorUnitView;
    }

    @Override
    protected void clearCurrentXY() {
        this.currentXPosition = 0;
        this.currentYPosition = 0;
    }

    protected double getPreferSize() {
        return this.preferSize;
    }

    protected void clearPreferSize() {
        this.preferSize = 0.0;
    }

    @Override
    protected List getCurrentVoList() {
        return this.currentVoList;
    }
}

