/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationConsumer;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationship;

public class ReferencedMoRelationship
extends MoRelationship {
    private String refAttributeName;
    private String criticalRefAttributeName;
    private List<String> refAttributeNameChoice;
    private List<String> refAttributeNames;

    public ReferencedMoRelationship(String string, String string2, int n, int n2, CabinetViewerMimModel cabinetViewerMimModel) {
        super(string, n, n2, cabinetViewerMimModel);
        this.refAttributeName = string2;
    }

    public ReferencedMoRelationship(String string, String string2, String string3, int n, int n2, CabinetViewerMimModel cabinetViewerMimModel) {
        super(string, n, n2, cabinetViewerMimModel);
        this.criticalRefAttributeName = string3;
        this.refAttributeName = string2;
    }

    public ReferencedMoRelationship(String string, List<String> list, int n, int n2, CabinetViewerMimModel cabinetViewerMimModel) {
        super(string, n, n2, cabinetViewerMimModel);
        this.refAttributeNameChoice = list;
    }

    public ReferencedMoRelationship(String string, int n, int n2, List<String> list, CabinetViewerMimModel cabinetViewerMimModel) {
        super(string, n, n2, cabinetViewerMimModel);
        this.refAttributeNames = list;
    }

    public String getRefAttributeName() {
        return this.refAttributeName;
    }

    public String getCritialRefAttributeName() {
        return this.refAttributeName;
    }

    @Override
    public void setParent(MoRelationship moRelationship) {
        String string = moRelationship.getMoType();
        CabinetViewerMimModel cabinetViewerMimModel = this.getMimModel();
        if (this.criticalRefAttributeName != null) {
            cabinetViewerMimModel.setCachingPrioCritial(string, this.criticalRefAttributeName);
        }
        if (this.refAttributeName != null && this.getMinCardinality() > 0) {
            cabinetViewerMimModel.setCachingPrioHigh(string, this.refAttributeName);
        }
        if (this.refAttributeNameChoice != null && this.getMinCardinality() > 0) {
            for (String string2 : this.refAttributeNameChoice) {
                cabinetViewerMimModel.setCachingPrioHigh(string, string2);
            }
        }
        super.setParent(moRelationship);
    }

    @Override
    public boolean doMatching(CachedMo cachedMo, MoRelationConsumer moRelationConsumer) {
        String string = null;
        if (this.criticalRefAttributeName != null) {
            string = this.criticalRefAttributeName;
        } else if (this.refAttributeName != null) {
            string = this.refAttributeName;
        } else {
            if (this.refAttributeNameChoice != null) {
                return this.followOneAttribute(cachedMo, moRelationConsumer);
            }
            if (this.refAttributeNames != null) {
                return this.followAllAttributes(cachedMo, moRelationConsumer);
            }
        }
        return this.continueDoMatching(cachedMo, moRelationConsumer, string);
    }

    private boolean followOneAttribute(CachedMo cachedMo, MoRelationConsumer moRelationConsumer) {
        for (String string : this.refAttributeNameChoice) {
            int n = moRelationConsumer.getSizeOfCurrentMatchedElements();
            boolean bl = this.continueDoMatching(cachedMo, moRelationConsumer, string);
            if (bl) {
                moRelationConsumer.clearMismatchFlag();
                return bl;
            }
            moRelationConsumer.setSizeOfMatchedElements(n);
        }
        return false;
    }

    private boolean followAllAttributes(CachedMo cachedMo, MoRelationConsumer moRelationConsumer) {
        boolean bl = false;
        for (String string : this.refAttributeNames) {
            int n = moRelationConsumer.getSizeOfCurrentMatchedElements();
            boolean bl2 = this.continueDoMatching(cachedMo, moRelationConsumer, string);
            if (bl2) {
                moRelationConsumer.clearMismatchFlag();
                bl = true;
                continue;
            }
            moRelationConsumer.setSizeOfMatchedElements(n);
        }
        return bl;
    }

    private boolean changeValueBetweenRiPortRef(CachedMo cachedMo) {
        boolean bl = false;
        CachedMo[] cachedMoArray = cachedMo.getReferenced("riPortRef1");
        CachedMo[] cachedMoArray2 = cachedMo.getReferenced("riPortRef2");
        String string = ((Object)cachedMoArray[0]).toString();
        String string2 = ((Object)cachedMoArray2[0]).toString();
        if (cachedMoArray[0] != null && cachedMoArray2[0] != null) {
            if (string.indexOf("AuxPlugInUnit") != -1 && string2.indexOf("AuxPlugInUnit") != -1) {
                bl = false;
                if (string.indexOf("DATA_1") != -1 && string2.indexOf("DATA_2") != -1) {
                    bl = true;
                } else if (string2.indexOf("DATA_1") == -1 && (string.indexOf("DATA_1") != -1 || string.indexOf("DATA_2") != -1)) {
                    bl = true;
                }
            } else if (string.indexOf("AuxPlugInUnit") != -1 && string2.indexOf("PlugInUnit") != -1) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean continueDoMatching(CachedMo cachedMo, MoRelationConsumer moRelationConsumer, String string) {
        ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>();
        CachedMo[] cachedMoArray = cachedMo.getReferenced(string);
        if (cachedMoArray != null) {
            for (int i = 0; i < cachedMoArray.length; ++i) {
                if (cachedMoArray[i] == null) continue;
                String string2 = cachedMoArray[i].getMoType();
                if (cachedMo.getMoType().equals("RiLink") && this.changeValueBetweenRiPortRef(cachedMo)) {
                    CachedMo[] cachedMoArray2;
                    if ("riPortRef1".equals(string)) {
                        cachedMoArray2 = cachedMo.getReferenced("riPortRef2");
                        cachedMoArray[i] = cachedMoArray2[0];
                    } else if ("riPortRef2".equals(string)) {
                        cachedMoArray2 = cachedMo.getReferenced("riPortRef1");
                        cachedMoArray[i] = cachedMoArray2[0];
                    }
                }
                if (string2 == null || !string2.equals(this.getMoType())) continue;
                arrayList.add(cachedMoArray[i]);
            }
        }
        List list = this.filterMos(arrayList);
        if (this.failTemplateOnConstraints) {
            return false;
        }
        boolean bl = this.checkRules(list, moRelationConsumer);
        if (bl) {
            this.storeAttributes(cachedMo);
            bl = this.matchToSubRelationships(list, moRelationConsumer);
        }
        return bl;
    }
}

