/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.Observer;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiHandlerListener;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiThreadCounter;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.CommandHandlingSession;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoViewManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.ProgressWindow;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.ProgressWindowListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.ProgressWindowManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.StatusNotifListener;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoJobQueue;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorViewerFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.state.StateManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.vim.VimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelXml;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelLoadingException;

public class VibManager
implements Observer,
Runnable,
ColiHandlerListener,
ColiThreadCounter,
ProgressWindowListener {
    private static final String NODE_B_FUNCTION_LDN = "ManagedElement=1,NodeBFunction=1";
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String EQUIPMENT_SUPPORT_FUNCTION_LDN = "ManagedElement=1,EquipmentSupportFunction=1";
    static final int FREQUENCY_OF_COLI_DIALOGS = 300000;
    private static final long DEFAULT_WAIT_AFTER_STOP = 1500L;
    private VimModel vimModel;
    private VimModel multipleVimModel;
    private boolean isMultiConfig = false;
    static final int CRITERIA_OF_MULTI_CONFIGURATION = 2;
    private CvSession cvSession;
    private volatile Thread cachingThread;
    private volatile boolean isStopped = false;
    private List<ViewableObject> voList;
    private ColiHandler coliHandler;
    private VoJobQueue voJobQue;
    private volatile boolean isRefreshStopped = false;
    private boolean initialCachingDone = false;
    final ProgressWindowManager progressManager;
    private StatusNotifListener statusNotifier = null;
    private int cachedMaxProgress = 0;
    private int cachedProgressValue = 0;
    public boolean bRefreshProgressActive = false;
    final HashMap savedTabIndexes = new HashMap();
    final Hashtable coliAttributeListeners = new Hashtable();
    final Hashtable coliLogListeners = new Hashtable();
    final Hashtable coliLogOperable = new Hashtable();
    private List coliInitialCachingQue = new ArrayList();
    private MainWindowController mwcReference = null;
    final StateManager stateManager;
    private AbstractSectorViewerManager sectorViewerManager = null;
    private boolean isSectorViewerSupported = false;
    final double lastColiDialgTime = System.currentTimeMillis() - 300000L;
    private int numberOfColiThreadsRunning = 0;
    private long timeWhenStopButtonPressed = 0L;

    public VibManager() {
        this.voJobQue = new VoJobQueue(this);
        this.stateManager = new StateManager(this);
        this.progressManager = new ProgressWindowManager(this);
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public AbstractSectorViewerManager getSectorViewerManager() {
        return this.sectorViewerManager;
    }

    public boolean isSectorViewerSupported() {
        return this.isSectorViewerSupported;
    }

    @Override
    public void run() {
        this.performInitialCaching();
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setStoppedFlag() {
        this.isStopped = true;
        if (this.coliHandler != null) {
            this.coliHandler.stop();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CvSession getCvSession() {
        return this.cvSession;
    }

    public VimModel getVimModel() {
        return this.vimModel;
    }

    public void setStatusNotifier(StatusNotifListener statusNotifListener) {
        this.statusNotifier = statusNotifListener;
        this.statusNotifier.setProgressMaximum(this.cachedMaxProgress);
        this.statusNotifier.setProgressValue(this.cachedProgressValue);
        this.statusNotifier.showStatus();
    }

    public List getAllVos() {
        ArrayList<Object> arrayList = this.voList != null ? new ArrayList<ViewableObject>(this.voList) : new ArrayList();
        return arrayList;
    }

    private void cacheProductName() throws Exception {
        CacheManager cacheManager = this.cvSession.getCacheManager();
        double d = System.currentTimeMillis();
        CachedMo cachedMo = cacheManager.getCachedMo(MANAGED_ELEMENT_LDN);
        String[] stringArray = new String[]{"productName"};
        cachedMo.cacheAttributesAtInitialStart(stringArray, null);
        Object object = cachedMo.getAttribute("productName");
        if (object != null) {
            this.vimModel.getMimModel().setRbsType(object.toString());
        }
        Trace.timeObservation(this, "Caching of  productName in MO ManagedElement=1 took (ms);", (double)System.currentTimeMillis() - d);
    }

    private String getRbsProductName() {
        CacheManager cacheManager = this.cvSession.getCacheManager();
        CachedMo cachedMo = cacheManager.getCachedMo(MANAGED_ELEMENT_LDN);
        return (String)cachedMo.getAttribute("productName");
    }

    public VoRelationship getTopVORelationship() {
        String string = this.vimModel.getRbsProductName();
        if (string == null || string.equals("")) {
            string = this.getRbsProductName();
            string = string != null && !string.equals("") ? string.toUpperCase(Locale.US).trim() : "DefaultRbs";
            this.vimModel.setRbsProductName(string);
        }
        VoRelationship voRelationship = this.vimModel.getRbs(string);
        return voRelationship;
    }

    public void start(CvSession cvSession) {
        this.cvSession = cvSession;
        this.initialCachingDone = false;
        this.cachingThread = new Thread((Runnable)this, "VibManager");
        this.isStopped = false;
        this.cachingThread.start();
    }

    public void halt() {
        this.isStopped = true;
        this.voJobQue.halt();
        NealManager nealManager = this.cvSession.getNealManager();
        nealManager.disconnectFromNode();
        if (this.cachingThread != null && this.cachingThread.isAlive()) {
            Trace.observation(this, "Stop of initial caching thread pending...");
        }
        this.voJobQue = null;
        this.cachingThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialCaching() {
        String string = "connecting to node";
        try {
            double d;
            this.doSetProgressMaximum(22);
            this.doStepProgress();
            NealManager nealManager = this.cvSession.getNealManager();
            double d2 = System.currentTimeMillis();
            double d3 = System.currentTimeMillis();
            Trace.startTimeObservation(this, "Time observation started! ", d2);
            if (!this.isStopped) {
                string = "connecting to node";
                Trace.observation(this, "Performing => " + string);
                d = System.currentTimeMillis();
                this.doStepProgress();
                try {
                    nealManager.connectToNode();
                }
                catch (Exception exception) {
                    this.cvSession.getCvSessionController().error("Unable to establish connection with the RBS.", exception);
                    Trace.observation(this, "Initial Caching thread has stopped");
                    return;
                }
                this.doStepProgress();
                Trace.timeObservation(this, "connectToNode() took (ms);", (double)System.currentTimeMillis() - d);
            }
            if (!this.isStopped) {
                string = "caching high prio MOs";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.cacheHiPrioMOs();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "loading VIM";
                Trace.observation(this, "Performing => " + string);
                d3 = d = (double)System.currentTimeMillis();
                List list = this.getCabinetProductName();
                this.vimModel = this.isMultiConfig ? new VimModelXml(this.cvSession.getLauncherData(), list) : new VimModelXml(this.cvSession.getLauncherData());
                this.cacheProductName();
                this.vimModel.setRbsProductName(this.getRbsProductName());
                this.doStepProgress();
                this.vimModel.load();
                this.doStepProgress();
                Trace.timeObservation(this, "Preparing VIM took (ms);", (double)System.currentTimeMillis() - d);
            }
            if (!this.isStopped) {
                string = "loading the model from the RBS node";
                Trace.observation(this, "Performing => " + string);
                boolean bl = this.vimModel.waitForLoadingComplete();
                this.doStepProgress();
                if (!bl) {
                    Exception exception = this.vimModel.getLoadingError();
                    throw exception;
                }
                Trace.timeObservation(this, "Loading the model took (ms);", (double)System.currentTimeMillis() - d3);
            }
            if (!this.isStopped) {
                string = "loading MIM";
                Trace.observation(this, "Performing => " + string);
                d = System.currentTimeMillis();
                this.getCvSession().getCacheManager().setMimData(this.vimModel.getMimModel());
                Trace.timeObservation(this, "Loading of Mim took (ms);", (double)System.currentTimeMillis() - d);
            }
            if (!this.isStopped) {
                string = "caching critical prio attributes";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.cacheCriticalPrioAttributes();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "Discover all Vos!";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.discoverAllVos();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "Running the StateView Factory";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.runStateViewFactory();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "ready for launch";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.cvSession.getCvSessionController().readyForLaunch();
                Trace.timeObservation(this, "Ready to launch! total preparation took (ms);", (double)System.currentTimeMillis() - d2);
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "caching low prio MO's";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.cacheLowPrioMOs();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "starting VO job queue";
                Trace.observation(this, "Performing => " + string);
                this.voJobQue.start();
                this.doStepProgress();
            }
            if (!this.isStopped) {
                string = "caching all attributes";
                Trace.observation(this, "Performing => " + string);
                d = System.currentTimeMillis();
                this.doStepProgress();
                List list = this.getAllVos();
                this.voJobQue.refreshAllVos(list);
                this.doStepProgress();
                Trace.timeObservation(this, "Total refresh time took (ms);", (double)System.currentTimeMillis() - d);
            }
            if (!this.isStopped) {
                JPanel[] jPanelArray;
                string = "loading the Summary model from the RBS node";
                Trace.observation(this, "Performing => " + string);
                d = System.currentTimeMillis();
                this.vimModel.loadSummary();
                this.doStepProgress();
                boolean bl = this.vimModel.waitForLoadingOfSummaryComplete();
                if (!bl) {
                    jPanelArray = this.vimModel.getLoadingErrorForSummary();
                    Trace.warning(this, " Loading of the Summary model from the RBS node has failed. Using Hard Coded panels instead.", (Exception)jPanelArray);
                }
                Trace.timeObservation(this, "Loading the Summary model took (ms);", (double)System.currentTimeMillis() - d);
                jPanelArray = this.vimModel.getSummaryPanels();
                this.getMainWindowController().setSummaryPanels(jPanelArray);
            }
            if (!this.isStopped) {
                string = "Running the SectorViewer Factory";
                Trace.observation(this, "Performing => " + string);
                this.doStepProgress();
                this.runSectorViewerFactory();
                this.doStepProgress();
                if (this.isSectorViewerSupported) {
                    this.getMainWindowController().setUpSectorViewer();
                }
            }
            Trace.timeObservation(this, "Total initial caching took (ms);", (double)System.currentTimeMillis() - d2);
            this.initialCachingDone = true;
        }
        catch (InterruptedException interruptedException) {
            Trace.observation(this, "Initial Caching thread was interrupted");
        }
        catch (ModelLoadingException modelLoadingException) {
            String string2 = "Cabinet viewer was unable to start because of\nconnection problems with the RBS.\n\nPlease check the network connection.\nIf it possible to access the web page\nhttp://" + this.cvSession.getNealManager().getIpAddress() + "/em/index.html\n" + "then the connection is OK.";
            this.cvSession.getCvSessionController().error(string2, modelLoadingException);
            this.doHideStatus();
            Trace.error(this, "Error occured whilst " + string, modelLoadingException);
        }
        catch (Exception exception) {
            Trace.warning(this, exception.toString());
            if (!this.isStopped) {
                this.cvSession.getCvSessionController().error("Error occured whilst " + string, exception);
                this.doHideStatus();
            }
        }
        finally {
            Trace.observation(this, "Initial Caching thread has stopped");
        }
        this.doStepProgress();
    }

    private void cacheHiPrioMOs() throws Exception {
        CachedMo cachedMo;
        double d;
        CacheManager cacheManager = this.cvSession.getCacheManager();
        double d2 = d = (double)System.currentTimeMillis();
        cacheManager.cacheMo(MANAGED_ELEMENT_LDN, this);
        CachedMo cachedMo2 = cacheManager.getCachedMo(MANAGED_ELEMENT_LDN);
        String[] stringArray = new String[]{"userLabel"};
        cachedMo2.cacheAttributesAtInitialStart(stringArray, null);
        cachedMo2.cacheChildren(1, this);
        CachedMo cachedMo3 = cacheManager.getCachedMo("ManagedElement=1,Equipment=1");
        Trace.timeObservation(this, "Caching of  MO ManagedElement=1,Equipment=1 took (ms);", (double)System.currentTimeMillis() - d2);
        d2 = System.currentTimeMillis();
        cachedMo3.cacheChildren(10, this);
        int n = cacheManager.getNumCachedMos();
        Trace.timeObservation(this, "Caching of branch ManagedElement=1,Equipment=1 (" + n + " MOs) took (ms);", (double)System.currentTimeMillis() - d2);
        int n2 = 0;
        if (this.isExisting("ManagedElement=1,SwitchFabric=1")) {
            d2 = System.currentTimeMillis();
            cacheManager.cacheMo("ManagedElement=1,SwitchFabric=1", this);
            CachedMo cachedMo4 = cacheManager.getCachedMo("ManagedElement=1,SwitchFabric=1");
            cachedMo4.cacheChildren(2, this);
            n2 = cacheManager.getNumCachedMos() - n;
            Trace.timeObservation(this, "Caching of branch ManagedElement=1,SwitchFabric=1 (" + n2 + " MOs) took (ms);", (double)System.currentTimeMillis() - d2);
        }
        int n3 = 0;
        if (this.isExisting(EQUIPMENT_SUPPORT_FUNCTION_LDN)) {
            d2 = System.currentTimeMillis();
            cacheManager.cacheMo(EQUIPMENT_SUPPORT_FUNCTION_LDN, this);
            cachedMo = cacheManager.getCachedMo(EQUIPMENT_SUPPORT_FUNCTION_LDN);
            cachedMo.cacheChildren(2, this);
            n3 = cacheManager.getNumCachedMos() - n - n2;
            Trace.timeObservation(this, "Caching of branch ManagedElement=1,EquipmentSupportFunction=1 (" + n3 + " MOs) took (ms);", (double)System.currentTimeMillis() - d2);
        }
        if (this.isExisting(NODE_B_FUNCTION_LDN)) {
            d2 = System.currentTimeMillis();
            cacheManager.cacheMo(NODE_B_FUNCTION_LDN, this);
            cachedMo = cacheManager.getCachedMo(NODE_B_FUNCTION_LDN);
            cachedMo.cacheChildren(2, this);
            int n4 = cacheManager.getNumCachedMos() - n - n2 - n3;
            Trace.timeObservation(this, "Caching of branch ManagedElement=1,NodeBFunction=1 (" + n4 + " MOs) took (ms);", (double)System.currentTimeMillis() - d2);
        }
        d2 = System.currentTimeMillis();
        cacheManager.cacheMo("ManagedElement=1,IpSystem=1", this);
        cachedMo = cacheManager.getCachedMo("ManagedElement=1,IpSystem=1");
        if (cachedMo != null) {
            cachedMo.cacheChildren(10, this);
            Trace.timeObservation(this, "Caching of IpSystem and children took (ms);", (double)System.currentTimeMillis() - d2);
        }
        try {
            cacheManager.cacheMo("ManagedElement=1,IpOam=1", this);
            cacheManager.cacheMo("ManagedElement=1,IpOam=1,Ip=1", this);
            cacheManager.cacheMo("ManagedElement=1,IpOam=1,Ip=1,EthernetLink=1", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cacheManager.cacheMo("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.timeObservation(this, "Caching high prio MOs took (ms);", (double)System.currentTimeMillis() - d);
    }

    public void discoverAllVos() {
        CacheManager cacheManager = this.cvSession.getCacheManager();
        double d = System.currentTimeMillis();
        VoFactory voFactory = new VoFactory();
        this.voList = voFactory.createVos(this, this.vimModel, cacheManager);
        int n = cacheManager.getNumCachedMos();
        double d2 = (double)System.currentTimeMillis() - d;
        Trace.timeObservation(this, "VO Factory for (" + n + " MOs) took (ms);", d2);
    }

    public void runStateViewFactory() {
        double d = System.currentTimeMillis();
        Hashtable hashtable = this.vimModel.getStateViewHash();
        InfoViewManager infoViewManager = new InfoViewManager(hashtable);
        StateViewFactory stateViewFactory = new StateViewFactory(infoViewManager);
        stateViewFactory.matchView(this.voList);
        Trace.timeObservation(this, "Running the StateView Factory took (ms);", (double)System.currentTimeMillis() - d);
    }

    public void runSectorViewerFactory() {
        double d = System.currentTimeMillis();
        CacheManager cacheManager = this.cvSession.getCacheManager();
        List<VoTemplate> list = this.vimModel.getVoTemplatesForSectorViewer();
        if (list == null || list.isEmpty()) {
            Trace.timeObservation(this, "Running the Sector Viewer Factory terminated. XML-files for Sector Viewer do NOT exist! total preparation took (ms);", (double)System.currentTimeMillis() - d);
            return;
        }
        this.sectorViewerManager = SectorViewerFactory.getSectorViewerManager(cacheManager, this.vimModel.getMimModel());
        if (this.sectorViewerManager != null) {
            this.sectorViewerManager.doMatching(list, this.getAllVos());
            this.isSectorViewerSupported = true;
        }
        Trace.timeObservation(this, "Running the Sector Viewer Factory took (ms);", (double)System.currentTimeMillis() - d);
    }

    private void cacheLowPrioMOs() throws Exception {
        CacheManager cacheManager = this.cvSession.getCacheManager();
        int n = cacheManager.getNumCachedMos();
        double d = System.currentTimeMillis();
        cacheManager.cacheMo("ManagedElement=1,SwManagement=1", this);
        CachedMo cachedMo = cacheManager.getCachedMo("ManagedElement=1,SwManagement=1");
        d = System.currentTimeMillis();
        cachedMo.cacheChildren(10, this);
        int n2 = cacheManager.getNumCachedMos();
        int n3 = n2 - n;
        Trace.timeObservation(this, "Caching of branch ManagedElement=1,SwManagement=1 (" + n3 + " MOs) took (ms);", (double)System.currentTimeMillis() - d);
        Trace.observation(this, "Total number of cached  MOs:" + n2);
    }

    private void cacheCriticalPrioAttributes() {
        Object object;
        Object object2;
        Object object3;
        CacheManager cacheManager = this.cvSession.getCacheManager();
        List list = cacheManager.getAllCachedMos();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = System.currentTimeMillis();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.isStopped) continue;
            object3 = (CachedMo)iterator.next();
            object2 = object3.getMoType();
            object = this.vimModel.getMimModel();
            String[] stringArray = ((CabinetViewerMimModel)object).getCritialPrioAttributeNames((String)object2);
            if (stringArray.length <= 0) continue;
            try {
                if (!object3.isInitialCachingDone()) {
                    ++n;
                    n2 += stringArray.length;
                    object3.cacheAllAttributesAtInitialStart(null);
                    continue;
                }
                ++n3;
            }
            catch (Exception exception) {
                Trace.warning(this, "Unable to cache critical prio attributes. " + exception.toString());
            }
        }
        object3 = this.getAllVos();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (ViewableObject)object2.next();
            ((ViewableObject)object).notifyAllVoListeners(2);
        }
        Trace.timeObservation(this, "Caching of critical prio attributes (" + n2 + " attributes in " + n + " MOs, already cached MOs: " + n3 + ") took (ms);", (double)System.currentTimeMillis() - d);
    }

    public void refreshViewableObject(ViewableObject viewableObject) {
        this.isRefreshStopped = false;
        Trace.observation(this, "Refreshing " + viewableObject.getViewableObjectName());
        viewableObject.cachingJobPending();
        this.voJobQue.putInQueue(viewableObject);
    }

    public void stopRefreshViewableObject() {
        this.doSetStatusMessage("Refresh is stopping...");
        this.timeWhenStopButtonPressed = System.currentTimeMillis();
        this.voJobQue.orderStopMoRefresh();
        this.isRefreshStopped = true;
    }

    public void prioritiseCaching(ViewableObject viewableObject) {
        if (this.initialCachingDone) {
            this.voJobQue.prioritise(viewableObject);
        } else {
            this.voJobQue.putInQueue(viewableObject);
        }
    }

    public void doCacheBoardLogs(boolean bl, boolean bl2, ViewableObject viewableObject, LogListener logListener) throws Exception {
        if (!this.coliInitialCachingQue.isEmpty()) {
            throw new Exception("Caching is still in progress");
        }
        String string = viewableObject.getTargetLdn("KEY_COLI_ACTIONS");
        this.coliLogListeners.put(string, logListener);
        this.coliLogOperable.put(string, viewableObject);
        if (string == null) {
            throw new Exception("Not supported by this object");
        }
        this.coliHandler = this.cvSession.getColiHandler();
        this.coliHandler.cacheAllData(new String[0], new String[0], this);
        String[] stringArray = viewableObject.getLdns("PlugInUnit");
        if (stringArray.length == 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("te log read");
            }
            if (bl2) {
                arrayList.add("llog -l");
            }
            this.progressManager.createProgressWindow(string, "Cabinet Viewer", "Fetching log(s) from node...");
            boolean bl3 = this.coliHandler.cacheDeviceBoardLogData(string, arrayList, this);
            if (!bl3) {
                this.progressManager.stopProgressWindow(string);
                throw new Exception("The save log function is busy with another job");
            }
            CommandHandlingSession commandHandlingSession = this.coliHandler.getCurrentDbSession();
            this.progressManager.setCommandHandlingSession(string, commandHandlingSession);
            return;
        }
        String[] stringArray2 = viewableObject.getLdns("AuxPlugInUnit");
        if (stringArray2.length == 1) {
            String[] stringArray3 = this.getAtfLdns(viewableObject, stringArray2[0]);
            if (stringArray3 == null) {
                Trace.warning(this, "Coli doCacheLog() job discarded, Atf References are not available yet" + viewableObject.getFullName());
                throw new Exception("Caching is still in progress");
            }
            this.progressManager.createProgressWindow(string, "Cabinet Viewer", "Fetching trace & error logs from node...");
            boolean bl4 = this.coliHandler.cacheAuxiliaryUnitLogData(string, stringArray3, this);
            if (!bl4) {
                this.progressManager.stopProgressWindow(string);
                throw new Exception("The save log function is busy with another job");
            }
            CommandHandlingSession commandHandlingSession = this.coliHandler.getCurrentAuSession();
            this.progressManager.setCommandHandlingSession(string, commandHandlingSession);
            return;
        }
        Trace.warning(this, "Coli doCacheLog() job discarded, not supported for VO: " + viewableObject.getFullName());
        throw new Exception("Not supported for this object");
    }

    @Override
    public void progressActionPerformed(ProgressWindow progressWindow, ActionEvent actionEvent) {
        this.coliHandler.stop(progressWindow.getCommandHandlingSession());
    }

    public String getRestartLog(ViewableObject viewableObject) {
        String string = viewableObject.getTargetLdn("KEY_COLI_ACTIONS");
        return this.coliHandler.getDeviceBoardRestartLogData(string);
    }

    public String getTraceAndErrorLog(ViewableObject viewableObject) {
        String string = viewableObject.getTargetLdn("KEY_COLI_ACTIONS");
        String string2 = null;
        if (string.lastIndexOf("AuxPlugInUnit") > 0) {
            Trace.observation(this, "coliHandler.getAuxiliaryUnitLogData(" + string + ")");
            string2 = this.coliHandler.getAuxiliaryUnitLogData(string);
        } else {
            Trace.observation(this, "coliHandler.getDeviceBoardTraceAndErrorLogData(" + string + ")");
            string2 = this.coliHandler.getDeviceBoardTraceAndErrorLogData(string);
        }
        return string2;
    }

    public void doRefreshMoAttributes(ViewableObject viewableObject) {
        double d = System.currentTimeMillis();
        List list = viewableObject.getMos();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d2 = System.currentTimeMillis();
            if (this.isStopped) {
                Trace.observation(this, "VIB manager is stopped !");
                return;
            }
            CachedMo cachedMo = (CachedMo)iterator.next();
            String[] stringArray = this.vimModel.getAttributeNamesForMoType(cachedMo.getMoType());
            if (stringArray.length == 0) continue;
            try {
                CharSequence charSequence;
                if (!this.isStopped && !this.isRefreshStopped) {
                    charSequence = new StringBuffer("MO " + cachedMo.getMoType() + "=" + cachedMo.getName() + " , attribute (" + stringArray.length + ") caching took (ms);");
                    if (!cachedMo.isInitialCachingDone()) {
                        ((StringBuffer)charSequence).insert(0, "Initial Caching of ");
                        cachedMo.cacheAllAttributesAtInitialStart(null);
                    } else if (viewableObject.isReasonRefresh()) {
                        this.doSetStatusMessage("Refreshing " + cachedMo.getMoType());
                        ((StringBuffer)charSequence).insert(0, "Refresh required of ");
                        cachedMo.cacheAttributes(stringArray, null);
                    } else {
                        ((StringBuffer)charSequence).insert(0, "Initial Caching already done for ");
                    }
                } else {
                    charSequence = "Refresh/Caching stopped on " + cachedMo.getMoType() + ".";
                    return;
                }
                Trace.timeObservation(this, ((StringBuffer)charSequence).toString(), (double)System.currentTimeMillis() - d2);
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                Trace.error(this, "Connection to CabV server lost. " + oBJECT_NOT_EXIST.toString());
            }
            catch (Exception exception) {
                Trace.warning(this, exception.toString());
            }
            if (this.isRefreshStopped) continue;
            this.doStepProgressForRefresh();
        }
        Trace.timeObservation(this, "VO " + viewableObject.getFullName() + ", attribute caching took (ms);", (double)System.currentTimeMillis() - d);
        viewableObject.moCachingComplete();
    }

    private long howMuchToWait() {
        long l = 1500L - (System.currentTimeMillis() - this.timeWhenStopButtonPressed);
        return l > 0L ? l : 0L;
    }

    private String[] getAtfLdns(ViewableObject viewableObject, String string) {
        Mo mo = (Mo)viewableObject.getValue(string, "plugInUnitRef1");
        Mo mo2 = (Mo)viewableObject.getValue(string, "plugInUnitRef2");
        String[] stringArray = null;
        if (mo != null && mo2 == null) {
            stringArray = new String[]{mo.getLdn()};
        } else if (mo != null && mo2 != null) {
            stringArray = new String[]{mo.getLdn(), mo2.getLdn()};
        }
        return stringArray;
    }

    public void setMainWindowController(MainWindowController mainWindowController) {
        this.mwcReference = mainWindowController;
    }

    public MainWindowController getMainWindowController() {
        return this.mwcReference;
    }

    @Override
    public void done() {
    }

    @Override
    public void deviceBoardDataCached(String string) {
    }

    @Override
    public void auxiliaryUnitDataCached(String string) {
    }

    @Override
    public void allDataCached() {
    }

    @Override
    public void deviceBoardLogDataCached(String string) {
        if (!this.isStopped && !this.progressManager.hasProgressStopped(string)) {
            this.progressManager.stopProgressWindow(string);
            boolean bl = this.coliHandler.getDeviceBoardRestartLogData(string) != null;
            boolean bl2 = this.coliHandler.getDeviceBoardTraceAndErrorLogData(string) != null;
            Trace.observation(this, "deviceBoardLogDataCached(" + string + ")" + bl + ", " + bl2);
            this.notifyLogListeners(string);
        }
    }

    @Override
    public void auxiliaryUnitLogDataCached(String string) {
        if (!this.isStopped && !this.progressManager.hasProgressStopped(string)) {
            this.progressManager.stopProgressWindow(string);
            Trace.observation(this, "auxiliaryUnitLogDataCached(" + string + ")");
            this.notifyLogListeners(string);
        }
    }

    private void notifyLogListeners(String string) {
        Object v;
        if (!this.isStopped && (v = this.coliLogListeners.get(string)) instanceof LogListener) {
            LogListener logListener = (LogListener)v;
            Operable operable = (Operable)this.coliLogOperable.get(string);
            logListener.boardLogsObtained(operable);
        }
    }

    @Override
    public void pmDumpDataCached(String string) {
        Trace.observation(this, "Method pmDumpDataCached() not yet implemented.");
    }

    @Override
    public void coliCommunicationExceptionOccured(String string, Exception exception) {
        if (!this.progressManager.hasProgressStopped(string)) {
            this.progressManager.stopProgressWindow(string);
            Trace.observation(this, "coliCommunicationExceptionOccured(" + string + ")");
        }
        this.notifyLogExceptionListeners(string, exception);
        this.doStepProgress();
    }

    private void notifyLogExceptionListeners(String string, Exception exception) {
        Object v;
        if (!this.isStopped && (v = this.coliLogListeners.get(string)) instanceof LogListener) {
            LogListener logListener = (LogListener)v;
            this.coliLogOperable.get(string);
            logListener.boardLogsFailed(exception);
        }
    }

    public void setColiAttributeListener(String string, ViewableObject viewableObject) {
        if (viewableObject == null) {
            this.coliAttributeListeners.remove(string);
        } else {
            this.coliAttributeListeners.put(string, viewableObject);
        }
    }

    public void doSetStatusMessage(String string) {
        if (this.statusNotifier != null) {
            this.statusNotifier.setStatusMessage(string);
        }
    }

    public void doSetProgressValue(int n) {
        if (this.statusNotifier != null) {
            this.statusNotifier.setProgressValue(n);
        }
    }

    public void doSetProgressMaximum(int n) {
        if (this.statusNotifier != null) {
            this.statusNotifier.setProgressMaximum(n);
        } else {
            this.cachedMaxProgress = n;
        }
    }

    public int doGetProgressMaximum() {
        if (this.statusNotifier != null) {
            return this.statusNotifier.getProgressMaximum();
        }
        return this.cachedMaxProgress;
    }

    public void doShowStatus() {
        if (this.statusNotifier != null) {
            this.statusNotifier.showStatus();
        }
    }

    public void doHideStatus() {
        if (this.statusNotifier != null) {
            long l = this.howMuchToWait();
            if (l > 0L) {
                this.doHideStatus(l);
            } else {
                this.statusNotifier.hideStatus();
            }
        }
    }

    private void doHideStatus(final long l) {
        Trace.observation("Going to wait: " + l);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Trace.observation("Waiting before running hideStatus " + l);
                    Thread.sleep(l);
                    Trace.observation("Done Waiting " + l + ". Hiding status");
                    VibManager.this.statusNotifier.hideStatus();
                }
                catch (InterruptedException interruptedException) {
                    Trace.observation("Waiting interrupted");
                }
            }
        }).start();
    }

    public void doIncreaseProgressSize(int n) {
        this.doSetProgressMaximum(this.doGetProgressMaximum() + n);
    }

    public void doStepProgress() {
        if (this.statusNotifier != null) {
            this.statusNotifier.stepProgress();
        } else {
            ++this.cachedProgressValue;
            this.cvSession.getCvSessionController().doStepProgress(this.cachedProgressValue);
        }
    }

    public void doStepProgressForRefresh() {
        if (this.bRefreshProgressActive) {
            this.doStepProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void coliThreadStarted() {
        VibManager vibManager = this;
        synchronized (vibManager) {
            ++this.numberOfColiThreadsRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void coliThreadStopped() {
        VibManager vibManager = this;
        synchronized (vibManager) {
            --this.numberOfColiThreadsRunning;
            if (this.areAllJobsDone()) {
                this.doHideStatus();
            }
        }
    }

    public void reportVoQueueIsEmpty() {
        if (this.areAllJobsDone()) {
            this.doHideStatus();
            this.setStopRefreshEnabled(false);
        }
    }

    public void setStopRefreshEnabled(boolean bl) {
        if (this.statusNotifier != null) {
            this.statusNotifier.setStopRefreshEnabled(bl);
        }
    }

    private boolean areAllJobsDone() {
        return this.numberOfColiThreadsRunning <= 0 && this.voJobQue.getVoQueueLength() == 0 && this.initialCachingDone;
    }

    public boolean getInitialCachingDone() {
        return this.initialCachingDone;
    }

    public boolean isStateViewAvailable() {
        return this.vimModel.isStateViewAvailable();
    }

    public void setTabState(String string, int n) {
        Integer n2 = new Integer(n);
        this.savedTabIndexes.put(string, n2);
    }

    public int getTabState(String string) {
        Integer n = (Integer)this.savedTabIndexes.get(string);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    public boolean isVoJobQueueEmpty() {
        return this.voJobQue.isVoJobQueueEmpty();
    }

    public ViewableObject getVo(String string) {
        if (string.contains("RiPort") || string.contains("RiLink") || string.contains("DigitalCable")) {
            return null;
        }
        for (ViewableObject viewableObject : this.voList) {
            if (!viewableObject.contains(string)) continue;
            return viewableObject;
        }
        return null;
    }

    private boolean isExisting(String string) {
        try {
            Mo mo = this.getCvSession().getNealManager().getCmService().getMo(string);
            if (mo != null && mo.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean getMultiConfig() {
        return this.isMultiConfig;
    }

    protected List getCabinetList() {
        List<CachedMo> list = this.getCvSession().getCacheManager().getCachedMosOfType("Cabinet");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = ((Object)list.get(i)).toString();
            String[] stringArray = string.split("=");
            String string2 = new String(stringArray[stringArray.length - 1]);
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List getCabinetProductName() throws Exception {
        CacheManager cacheManager = this.cvSession.getCacheManager();
        String[] stringArray = new String[]{"productData"};
        List<CachedMo> list = this.getCvSession().getCacheManager().getCachedMosOfType("Cabinet");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.size() >= 2) {
            this.isMultiConfig = true;
        }
        Iterator<CachedMo> iterator = list.iterator();
        while (iterator.hasNext()) {
            CachedMo cachedMo;
            CachedMo cachedMo2 = cachedMo = iterator.next();
            cachedMo2.cacheAttributesAtInitialStart(stringArray, null);
            Object object = cachedMo2.getAttribute("productData");
            NameValue nameValue = ((Struct)object).getMember("productName");
            arrayList.add(nameValue.getStringValue());
        }
        return arrayList;
    }
}

