/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.BoardView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoLayoutData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoLayoutDataProvider;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.state.State;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.vim.VimModel;

public class ViewableObject
implements Operable,
VoData,
StateViewable {
    private static final int REFRESH_TIME_GAP = 3000;
    private MoMatchedData moMatchedData;
    final CachedMo topMo;
    final VoTemplate voTemplate;
    final VibManager vibManager;
    final String generalType;
    private String specificType;
    final List<ViewableObject> childVoList = new ArrayList<ViewableObject>();
    private ViewableObject parent;
    final Hashtable propertiesHash = new Hashtable();
    private List voDataListeners = new ArrayList();
    private List mos;
    private int prevCacheVersion;
    private String latestRefreshTime = "";
    private long latestRefresh;
    private volatile State state = null;
    private String targetLdnForRepairDeliveryNote = null;
    private String actionNameForReadRepairDeliveryNote = null;
    private String actionNameForWriteRepairDeliveryNote = null;
    private boolean isMatched = false;
    private StateView stateView = null;
    private final VoLayoutDataProvider voLayoutDataProvider;
    private REFRESH_REASON refreshReason = REFRESH_REASON.INITIAL_CACHING;
    private boolean isPrefixVisible = true;
    private String usedBySectorNo = null;
    private boolean isColiRefreshPending = false;
    private VoRelationship currentVoRelationship;

    public ViewableObject(MoMatchedData moMatchedData, CachedMo cachedMo, VoTemplate voTemplate, VibManager vibManager) {
        this.moMatchedData = moMatchedData;
        this.topMo = cachedMo;
        this.voTemplate = voTemplate;
        this.vibManager = vibManager;
        this.generalType = voTemplate.getGeneralType();
        this.specificType = voTemplate.getSpecificType();
        this.voLayoutDataProvider = new VoLayoutData(this);
        this.setStateToPending();
    }

    public String getGeneralType() {
        return this.generalType;
    }

    @Override
    public String getPrefix() {
        if (this.getProperty("CUSTOM_PREFIX_MO_TYPE") != null) {
            return this.getCustomPrefix();
        }
        return this.getTopMo().getName();
    }

    @Override
    public String getCustomPrefix() {
        String string = "";
        try {
            List list = null;
            list = (List)this.getProperty("CUSTOM_PREFIX_MO_TYPE");
            String string2 = (String)list.get(0);
            list = (List)this.getProperty("CUSTOM_PREFIX_ATTRIBUTE");
            String string3 = (String)list.get(0);
            NealManager nealManager = this.vibManager.getCvSession().getNealManager();
            CmService cmService = nealManager.getCmService();
            String[] stringArray = this.getLdns(string2);
            Mo mo = cmService.getMo(stringArray[0]);
            NameValue nameValue = mo.getAttribute(string3, null);
            list = (List)this.getProperty("CUSTOM_PREFIX_LABEL");
            String string4 = "";
            if (list != null) {
                string4 = (String)list.get(0) + " ";
            }
            string = string4 + nameValue.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public boolean isPrefixVisible() {
        return this.isPrefixVisible;
    }

    @Override
    public void setPrefixVisible(boolean bl) {
        this.isPrefixVisible = bl;
    }

    public String getPostfix() {
        return "";
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public void setMatched(boolean bl) {
        this.isMatched = bl;
    }

    @Override
    public String getGenericType() {
        return this.generalType;
    }

    @Override
    public String getSpecificType() {
        return this.specificType;
    }

    @Override
    public void setSpecificType(String string) {
        this.specificType = string;
    }

    @Override
    public String getCustomLable() {
        return this.voTemplate.getCustomLable();
    }

    @Override
    public void setCustomLabel(String string) {
        this.voTemplate.setCustomLable(string);
    }

    @Override
    public VoLayoutDataProvider getVoLayoutDataProvider() {
        return this.voLayoutDataProvider;
    }

    private String getDate() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public void cachingJobPending() {
        this.isColiRefreshPending = true;
        this.setStateToPending();
        this.notifyAllVoListeners(1);
        Trace.observation(this, "COLI & VO " + this.toString() + " state: " + this.state.getMessage());
    }

    public void moCachingComplete() {
        String string = this.getDate();
        this.setLatestRefreshTime(string);
        this.state = this.vibManager.getStateManager().getReadyState();
        this.state.notifyEnvironment(this);
        Trace.observation(this, "VO " + this.toString() + " state: " + this.state.getMessage());
    }

    public State getState() {
        return this.state;
    }

    private void setStateToPending() {
        this.state = this.vibManager.getStateManager().getRefreshPendingState();
    }

    public boolean isMatching(String string, String string2) {
        return string.equals(this.getGeneralType()) && string2.equals(this.getSpecificType());
    }

    public void addChild(ViewableObject viewableObject) {
        if (!this.childVoList.contains(viewableObject)) {
            this.childVoList.add(viewableObject);
            viewableObject.setParent(this);
        }
    }

    public void setParent(ViewableObject viewableObject) {
        this.parent = viewableObject;
    }

    public CachedMo getTopMo() {
        return this.topMo;
    }

    public boolean isCorrectPosition(VoRelationship voRelationship) {
        String string;
        String string2 = null;
        Object object = this.moMatchedData.getGlobalProperty("positionRefName");
        if (this.topMo.getMoType().equals("FanGroup")) {
            string = this.topMo.getLdn();
            int n = 44;
            int n2 = string.lastIndexOf(n);
            object = string.substring(0, n2);
        }
        return object == null || (string = object.toString()).length() <= 0 || string == "null" || string.endsWith(string2 = voRelationship.getProperty("POSITION").toString());
    }

    public List getMos() {
        CacheManager cacheManager = this.vibManager.getCvSession().getCacheManager();
        if (cacheManager == null) {
            return this.mos;
        }
        int n = cacheManager.getNumCachedMos();
        if (n != this.prevCacheVersion) {
            MoRelationship moRelationship = this.voTemplate.getMoRelationShip();
            this.moMatchedData = moRelationship.getMoMatchedData(this.topMo);
            this.mos = this.moMatchedData.getCachedMos();
            this.prevCacheVersion = n;
        }
        return this.mos;
    }

    public List getChildren() {
        return new ArrayList<ViewableObject>(this.childVoList);
    }

    public ViewableObject getParent() {
        return this.parent;
    }

    public void putProperty(String string, Object object) {
        this.propertiesHash.put(string, object);
    }

    public void putProperties(Hashtable hashtable) {
        this.propertiesHash.putAll(hashtable);
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.propertiesHash.get(string);
        if (object == null) {
            object = this.voTemplate.getProperty(string);
        }
        return object;
    }

    public Hashtable getProperties() {
        return this.propertiesHash;
    }

    @Override
    public String getFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPrefix();
        if (!"".equals(string)) {
            stringBuffer.append(string + ":");
        }
        if (this.specificType.equals("FAN") && this.getParent() != null) {
            stringBuffer.append(this.getParent().getSpecificType() + "_");
        }
        stringBuffer.append(this.specificType);
        String string2 = this.getPostfix();
        if (!"".equals(string2)) {
            stringBuffer.append("-" + string2);
        }
        if (this.generalType.equals("SectorUnit") && (this.usedBySectorNo != null || this.usedBySectorNo() != null)) {
            stringBuffer.insert(0, this.usedBySectorNo + ":" + "Sector" + "_");
        }
        return stringBuffer.toString();
    }

    public void print(boolean bl, boolean bl2) {
        this.print(bl, bl2, "");
    }

    private void print(boolean bl, boolean bl2, String string) {
        Trace.observation(this, string + this.getFullName());
        if (bl2) {
            List list = this.getMos();
            Iterator object = list.iterator();
            while (object.hasNext()) {
                CachedMo cachedMo = (CachedMo)object.next();
                String string2 = cachedMo.getMoType() + "=" + cachedMo.getName();
                Trace.observation(this, string + "> " + string2);
            }
        }
        if (bl) {
            for (ViewableObject viewableObject : this.childVoList) {
                viewableObject.print(bl, bl2, string + "\t");
            }
        }
    }

    public String getMoReport() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getMos();
        for (CachedMo cachedMo : list) {
            stringBuffer.append("\n");
            stringBuffer.append(cachedMo.getLdn());
        }
        return stringBuffer.toString();
    }

    public String getAttributesReport() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getMos();
        for (CachedMo cachedMo : list) {
            stringBuffer.append(cachedMo.getLdn());
            stringBuffer.append(cachedMo.getAttributesReport());
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public CvSession getCvSession() {
        return this.vibManager.getCvSession();
    }

    @Override
    public String getTargetMoLdnForRepairDeliveryNote() {
        int n = this.vibManager.getCvSession().getAccessLevel();
        switch (n) {
            case 1: {
                if (this.targetLdnForRepairDeliveryNote != null) {
                    return this.targetLdnForRepairDeliveryNote;
                }
                this.targetLdnForRepairDeliveryNote = this.getTargetLdnForRepairDeliveryNote();
                return this.targetLdnForRepairDeliveryNote;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    private String getTargetLdnForRepairDeliveryNote() {
        Hashtable<CachedMo, Object> hashtable = this.moMatchedData.getMosWithProperty("KEY_REPAIR_NOTE");
        if (hashtable == null) {
            return null;
        }
        Set<CachedMo> set = hashtable.keySet();
        int n = set.size();
        if (n > 1) {
            Trace.warning(this, "More than one MO has property KEY_REPAIR_NOTE\n" + set);
        }
        if (n > 0) {
            if (n == 1) {
                Object[] objectArray = set.toArray();
                CachedMo cachedMo = (CachedMo)objectArray[0];
                return cachedMo.getLdn();
            }
            Object[] objectArray = set.toArray();
            CachedMo cachedMo = (CachedMo)objectArray[0];
            for (int i = 1; i < n; ++i) {
                if (cachedMo.getLdn().length() <= ((CachedMo)objectArray[i]).getLdn().length()) continue;
                cachedMo = (CachedMo)objectArray[i];
            }
            return cachedMo.getLdn();
        }
        return null;
    }

    @Override
    public String getActionNameForReadRepairDeliveryNote() {
        if (this.actionNameForReadRepairDeliveryNote != null) {
            return this.actionNameForReadRepairDeliveryNote;
        }
        this.actionNameForReadRepairDeliveryNote = this.getActionNameForRepairDeliveryNote("KEY_REPAIR_NOTE_READ");
        return this.actionNameForReadRepairDeliveryNote;
    }

    @Override
    public String getActionNameForWriteRepairDeliveryNote() {
        if (this.actionNameForWriteRepairDeliveryNote != null) {
            return this.actionNameForWriteRepairDeliveryNote;
        }
        this.actionNameForWriteRepairDeliveryNote = this.getActionNameForRepairDeliveryNote("KEY_REPAIR_NOTE_WRITE");
        return this.actionNameForWriteRepairDeliveryNote;
    }

    private String getActionNameForRepairDeliveryNote(String string) {
        if (this.targetLdnForRepairDeliveryNote == null) {
            return null;
        }
        Hashtable<CachedMo, Object> hashtable = this.moMatchedData.getMosWithProperty(string);
        if (hashtable == null) {
            return null;
        }
        Set<CachedMo> set = hashtable.keySet();
        int n = set.size();
        if (n > 1) {
            Trace.warning(this, "More than one MO has property " + string + "\n" + set);
        }
        if (n > 0) {
            if (n == 1) {
                Object[] objectArray = set.toArray();
                CachedMo cachedMo = (CachedMo)objectArray[0];
                Object object = hashtable.get(cachedMo);
                if (object == null) {
                    return null;
                }
                if (object instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object;
                    Object e = arrayList.get(0);
                    if (e instanceof String) {
                        return e.toString();
                    }
                    return null;
                }
                return object.toString();
            }
            Object[] objectArray = set.toArray();
            CachedMo cachedMo = (CachedMo)objectArray[0];
            for (int i = 1; i < n; ++i) {
                if (cachedMo.getLdn().length() <= ((CachedMo)objectArray[i]).getLdn().length()) continue;
                cachedMo = (CachedMo)objectArray[i];
            }
            Object object = hashtable.get(cachedMo);
            if (object == null || !object.toString().contains(string)) {
                return null;
            }
            return object.toString();
        }
        return null;
    }

    @Override
    public String getTargetMoLdnForRestart() {
        int n = this.vibManager.getCvSession().getAccessLevel();
        switch (n) {
            case 1: {
                String string = this.getTargetLdn("KEY_RESTARTABLE");
                return string;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getTargetMoLdnForRestartCheck() {
        String string = this.getTargetMoLdnForRestart();
        if (string == null) {
            return null;
        }
        if (string.indexOf("PlugInUnit") != -1) {
            for (CachedMo cachedMo : this.mos) {
                CachedMo cachedMo2;
                if (cachedMo.getMoType().indexOf("DeviceGroup") == -1 || (cachedMo2 = cachedMo.getParent()) == null || !cachedMo2.getLdn().equals(string)) continue;
                return cachedMo.getLdn();
            }
        }
        return string;
    }

    @Override
    public String getTargetMoLdnForLockUnlock() {
        int n = this.vibManager.getCvSession().getAccessLevel();
        switch (n) {
            case 1: {
                String string = this.getTargetLdn("KEY_LOCKABLE");
                return string;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getTargetMoLdnForTest() {
        int n = this.vibManager.getCvSession().getAccessLevel();
        switch (n) {
            case 1: {
                String string = this.getTargetLdn("KEY_TESTABLE");
                return string;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getTargetMoLdnForCollectTraces() {
        String string = this.getTargetLdn("KEY_TRACES_COLLECTABLE");
        if (string != null) {
            CvSession cvSession = this.vibManager.getCvSession();
            CacheManager cacheManager = cvSession.getCacheManager();
            CachedMo cachedMo = cacheManager.getCachedMo("ManagedElement=1,NodeBFunction=1");
            if (cachedMo == null) {
                cachedMo = cacheManager.getCachedMo("ManagedElement=1,NodeManagementFunction=1");
            }
            if (cachedMo == null) {
                cachedMo = cacheManager.getCachedMo("ManagedElement=1,ENodeBFunction=1");
            }
            string = cachedMo.getLdn();
        }
        return string;
    }

    @Override
    public String getTargetMoLdnForSaveLogs() {
        String string = this.getTargetLdn("KEY_COLI_ACTIONS");
        return string;
    }

    @Override
    public String getTargetMoLdnForTechnicianPresent() {
        String string = this.getTargetLdn("KEY_TECHNICIAN_PRESENT");
        return string;
    }

    @Override
    public String getTargetMoLdnForAlarmSuppression() {
        String string = this.getTargetLdn("KEY_ALARM_SUPPRESSION");
        return string;
    }

    @Override
    public String getViewableObjectName() {
        return this.getFullName().replace(' ', '_');
    }

    @Override
    public String getDetails() {
        return this.getAttributesReport();
    }

    public void setLatestRefreshTime(String string) {
        this.latestRefreshTime = string;
    }

    @Override
    public String getLatestRefreshTime() {
        return this.latestRefreshTime;
    }

    public long getLatestRefresh() {
        return 0L;
    }

    @Override
    public void refresh() {
        if (this.isAlreadyRefreshed()) {
            return;
        }
        this.forcedRefresh();
    }

    @Override
    public void forcedRefresh() {
        this.refreshReason = REFRESH_REASON.PURE_REFRESH;
        this.vibManager.doSetStatusMessage("Refreshing...");
        this.vibManager.doSetProgressValue(0);
        this.vibManager.doSetProgressMaximum(this.countNumberOfMosColis());
        this.vibManager.bRefreshProgressActive = true;
        this.vibManager.doShowStatus();
        this.vibManager.setStopRefreshEnabled(true);
        this.vibManager.refreshViewableObject(this);
        this.refreshAllChildren();
    }

    private void pureRefresh() {
        if (this.isAlreadyRefreshed()) {
            return;
        }
        this.refreshReason = REFRESH_REASON.PURE_REFRESH;
        this.vibManager.refreshViewableObject(this);
        this.refreshAllChildren();
    }

    private void refreshAllChildren() {
        if (!this.childVoList.isEmpty()) {
            for (ViewableObject viewableObject : this.childVoList) {
                viewableObject.pureRefresh();
            }
        }
    }

    @Override
    public boolean isReasonRefresh() {
        return this.refreshReason.equals((Object)REFRESH_REASON.PURE_REFRESH);
    }

    private boolean isAlreadyRefreshed() {
        long l = System.currentTimeMillis();
        if (Math.abs(l - this.latestRefresh) < 3000L) {
            Trace.observation(this, "Already refreshed: " + this.getSpecificType());
            return true;
        }
        this.latestRefresh = l;
        return false;
    }

    public int countNumberOfMosColis() {
        int n = 0;
        List list = this.getMos();
        n = list.size();
        List list2 = this.getChildren();
        ViewableObject viewableObject = null;
        for (int i = 0; i < list2.size(); ++i) {
            viewableObject = (ViewableObject)list2.get(i);
            n += viewableObject.countNumberOfMosColis();
        }
        return n;
    }

    @Override
    public boolean supportsRepairDeliveryNote() {
        String string = this.getTargetMoLdnForRepairDeliveryNote();
        return string != null;
    }

    @Override
    public boolean supportsSavingTraceAndErrorLog() {
        return this.isColiActionSupported("getTraceAndErrorLog");
    }

    @Override
    public boolean supportsSavingRestartLog() {
        boolean bl = this.isColiActionSupported("getRestartLog");
        Trace.observation(this, "Support for Restart Log= " + bl + " for VO:" + this.getFullName());
        return bl;
    }

    @Override
    public boolean supportsSavingPostMortemLog() {
        return this.isColiActionSupported("getPostMortomLog");
    }

    @Override
    public void obtainPostMortemLog(String string, LogListener logListener) {
        throw new Error("not implemented");
    }

    @Override
    public void obtainBoardLogs(boolean bl, boolean bl2, LogListener logListener) throws Exception {
        this.vibManager.doCacheBoardLogs(bl, bl2, this, logListener);
    }

    @Override
    public String getRestartLog() {
        String string = this.vibManager.getRestartLog(this);
        return string;
    }

    @Override
    public String getTraceAndErrorLog() {
        String string = this.vibManager.getTraceAndErrorLog(this);
        return string;
    }

    @Override
    public String[] getLdns(String string) {
        String[] stringArray2;
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        if (string2.startsWith("*")) {
            string2 = string2.substring(1);
            bl = true;
        }
        if (string2.endsWith("*")) {
            string2 = string2.substring(0, string2.length() - 1);
            bl2 = true;
        }
        List list = this.getMos();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : list) {
            boolean bl3 = false;
            if (bl2 && bl) {
                if (stringArray2.getMoType().indexOf(string2) != -1) {
                    bl3 = true;
                }
            } else if (bl) {
                if (stringArray2.getMoType().endsWith(string2)) {
                    bl3 = true;
                }
            } else if (bl2) {
                if (stringArray2.getMoType().startsWith(string2)) {
                    bl3 = true;
                }
            } else if (stringArray2.getMoType().equals(string2)) {
                bl3 = true;
            }
            if (!bl3) continue;
            arrayList.add(stringArray2.getLdn());
        }
        stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    @Override
    public Object getValue(String string, String string2) {
        CvSession cvSession = this.vibManager.getCvSession();
        CacheManager cacheManager = cvSession.getCacheManager();
        CachedMo cachedMo = cacheManager.getCachedMo(string);
        if (cachedMo == null) {
            return null;
        }
        Object object = cachedMo.getAttribute(string2);
        return object;
    }

    @Override
    public Object[] getValues(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.getMos();
        for (int i = 0; i < list.size(); ++i) {
            CachedMo cachedMo = (CachedMo)list.get(i);
            Object object = this.getValue(cachedMo.getLdn(), string);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    @Override
    public boolean isExisting(String string) {
        String[] stringArray = this.getLdns(string);
        return stringArray.length > 0;
    }

    public boolean isColiActionSupported(String string) {
        List list;
        Object object = this.getMoPropertyValue("KEY_COLI_ACTIONS");
        return object instanceof List && (list = (List)object).contains(string);
    }

    @Override
    public boolean isMomLedSupported() {
        VimModel vimModel;
        boolean bl = false;
        if (this.vibManager != null && (vimModel = this.vibManager.getVimModel()) != null) {
            boolean bl2 = this.isExisting("PlugInUnit");
            boolean bl3 = this.isExisting("AuxPlugInUnit");
            if (bl2 || bl3 || this.isLedPropertyKeySet()) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isColiRefreshPending() {
        return this.isColiRefreshPending;
    }

    @Override
    public Object getMoPropertyValue(String string) {
        Hashtable<CachedMo, Object> hashtable = this.moMatchedData.getMosWithProperty(string);
        if (hashtable == null) {
            return null;
        }
        Set<CachedMo> set = hashtable.keySet();
        int n = set.size();
        if (n > 1) {
            Trace.warning(this, "More than one MO has property " + string + "\n" + set);
        }
        if (n > 0) {
            Object[] objectArray = set.toArray();
            return hashtable.get(objectArray[0]);
        }
        return null;
    }

    @Override
    public Hashtable<String, Object> getMoProperties(String string) {
        Hashtable<String, Object> hashtable = this.moMatchedData.getProperties(string);
        return hashtable;
    }

    public String getTargetLdn(String string) {
        Hashtable<CachedMo, Object> hashtable = this.moMatchedData.getMosWithProperty(string);
        if (hashtable == null) {
            return null;
        }
        Set<CachedMo> set = hashtable.keySet();
        int n = set.size();
        if (n > 1) {
            Trace.warning(this, "More than one MO has property " + string + "\n" + set);
        }
        if (n > 0) {
            Object[] objectArray = set.toArray();
            CachedMo cachedMo = (CachedMo)objectArray[0];
            return cachedMo.getLdn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllVoListeners(int n) {
        List list = this.voDataListeners;
        synchronized (list) {
            for (VoDataListener voDataListener : this.voDataListeners) {
                voDataListener.voDataChanged(this, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVoDataListener(VoDataListener voDataListener) {
        List list = this.voDataListeners;
        synchronized (list) {
            String string = null;
            if (!this.voDataListeners.contains(voDataListener)) {
                if (voDataListener instanceof BoardView) {
                    string = this.getTargetLdn("NOTIFY_UPDATE");
                    if (string != null) {
                        this.voDataListeners.add(voDataListener);
                    }
                } else {
                    this.voDataListeners.add(voDataListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVoDataListener(VoDataListener voDataListener) {
        List list = this.voDataListeners;
        synchronized (list) {
            this.voDataListeners.remove(voDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllVoDataListeners() {
        List list = this.voDataListeners;
        synchronized (list) {
            this.voDataListeners = new ArrayList();
        }
    }

    public String usedBySectorNo() {
        String string = new String("reservedBy");
        String string2 = new String("sectorRef");
        String string3 = new String("RfBranch");
        String string4 = new String("SectorEquipmentFunction");
        String string5 = new String("Sector");
        String[] stringArray = new String[]{string, string2};
        if (this.topMo == null) {
            return null;
        }
        Object object = this.moMatchedData.getGlobalProperty("sectorName");
        if (object != null && !object.equals("")) {
            this.usedBySectorNo = new String(object.toString());
            Trace.observation(this, this.getFullName() + " belongs to Sector Name: " + object);
            return this.usedBySectorNo;
        }
        for (CachedMo cachedMo = this.topMo; cachedMo != null; cachedMo = cachedMo.getParent()) {
            for (int i = 0; i < stringArray.length; ++i) {
                CachedMo[] cachedMoArray = cachedMo.getReferenced(stringArray[i]);
                if (cachedMoArray == null) continue;
                for (int j = 0; j < cachedMoArray.length; ++j) {
                    Object object2;
                    if (cachedMoArray[j] == null) continue;
                    String string6 = cachedMoArray[j].getMoType();
                    if (string6.equals(string3)) {
                        object2 = cachedMoArray[j].getReferenced(string);
                        if (object2 == null) continue;
                        for (int k = 0; k < ((CachedMo[])object2).length; ++k) {
                            String string7;
                            if (object2[k] == null || !(string7 = object2[k].getMoType()).equals(string4)) continue;
                            String string8 = object2[k].getName();
                            try {
                                this.usedBySectorNo = new String(string8);
                                return this.usedBySectorNo;
                            }
                            catch (Exception exception) {
                                Trace.error(this, "Unable to retreive sector number from: " + string8, exception);
                                return null;
                            }
                        }
                        continue;
                    }
                    if (!string6.equals(string5)) continue;
                    object2 = cachedMoArray[j].getName();
                    try {
                        this.usedBySectorNo = new String((String)object2);
                        return this.usedBySectorNo;
                    }
                    catch (Exception exception) {
                        Trace.error(this, "Unable to retreive sector number from: " + (String)object2, exception);
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public String getSectorAntennaId() {
        Object object;
        if (this.topMo == null) {
            return null;
        }
        String string = null;
        CachedMo cachedMo = this.topMo;
        Object object2 = this.moMatchedData.getGlobalProperty("sectorAntennaId");
        if (object2 != null && !object2.equals("")) {
            string = new String(object2.toString());
            return string;
        }
        Object object3 = this.getProperty("MOTYPE_NAME_NO_OF_SECTOR_ANTENNAS");
        String string2 = null;
        if (object3 instanceof List) {
            object = (List)object3;
            string2 = object.get(0).toString();
        }
        object = new String(string2.toString());
        while (cachedMo != null) {
            String string3 = cachedMo.getMoType();
            if (string3.equals(object)) {
                String string4 = cachedMo.getName();
                string = new String(string4);
                return string;
            }
            cachedMo = cachedMo.getParent();
        }
        return null;
    }

    public String getAntennaUnitId() {
        if (this.topMo == null) {
            return null;
        }
        String string = null;
        CachedMo cachedMo = this.topMo;
        Object object = this.moMatchedData.getGlobalProperty("antennaUnitId");
        if (object != null && !object.equals("")) {
            string = object.toString();
        }
        return string;
    }

    @Override
    public InfoView getInfoView(String string) {
        if (string != null && string.equals("stateView")) {
            return (InfoView)((Object)this.stateView);
        }
        return null;
    }

    @Override
    public Object getAdminState() {
        if (this.stateView != null) {
            return this.stateView.getAdminState(this);
        }
        return null;
    }

    @Override
    public Object getAvailabilityStatus() {
        if (this.stateView != null) {
            return this.stateView.getAvailabilityStatus(this);
        }
        return null;
    }

    @Override
    public Object getAvailabilityStatusString() {
        if (this.stateView != null) {
            return this.stateView.getAvailabilityStatusString(this);
        }
        return null;
    }

    @Override
    public Object getOperState() {
        if (this.stateView != null) {
            return this.stateView.getOperState(this);
        }
        return null;
    }

    @Override
    public void setStateView(StateView stateView) {
        this.stateView = stateView;
    }

    @Override
    public void setTabState(String string, int n) {
        this.vibManager.setTabState(string, n);
    }

    @Override
    public int getTabState(String string) {
        return this.vibManager.getTabState(string);
    }

    public boolean contains(String string) {
        for (CachedMo cachedMo : this.mos) {
            if (!cachedMo.getLdn().equals(string) && !string.endsWith(cachedMo.getLdn())) continue;
            return true;
        }
        return false;
    }

    public boolean isLedPropertyKeySet() {
        return this.getTargetLdn("KEY_GREEN_LED") != null || this.getTargetLdn("KEY_YELLOW_LED") != null || this.getTargetLdn("KEY_RED_LED") != null;
    }

    @Override
    public se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue getPropertyValue(String string) {
        Hashtable<CachedMo, Object> hashtable = this.moMatchedData.getMosWithProperty(string);
        if (hashtable == null) {
            return null;
        }
        Set<CachedMo> set = hashtable.keySet();
        int n = set.size();
        if (n > 1) {
            Trace.warning(this, "More than one MO has property " + string + "\n" + set);
        }
        CachedMo cachedMo = null;
        if (n <= 0) {
            return null;
        }
        Object object = set.toArray();
        cachedMo = (CachedMo)object[0];
        object = hashtable.get(cachedMo);
        se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue nameValue = new se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue(cachedMo.getLdn(), object);
        return nameValue;
    }

    public String getPositionRefValue(String string) {
        Object object = this.moMatchedData.getGlobalProperty(string);
        if (object == null) {
            Trace.observation(this, this.getFullName() + " has no positionRef attribute in global property");
            return "";
        }
        if (object.toString().equals("") || object.toString().equals("null")) {
            Trace.observation(this, this.getFullName() + " has no positionRef value");
            return "";
        }
        String string2 = object.toString();
        String[] stringArray = string2.split("=");
        String string3 = new String(stringArray[stringArray.length - 1]);
        return string3;
    }

    public void setCurrentVoRelationship(VoRelationship voRelationship) {
        this.currentVoRelationship = voRelationship;
    }

    public VoRelationship getCurrentVoRelationship() {
        return this.currentVoRelationship;
    }

    private static enum REFRESH_REASON {
        PURE_REFRESH,
        INITIAL_CACHING;

    }
}

