/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class AbstractSectorViewerData {
    private static final String KEY_CASCADED = "KEY_CASCADED";
    private static final String KEY_SEQUENCE_NO = "KEY_SEQUENCE_NO";
    private static final String KEY_AUTO_SEQUENCE_NO = "KEY_AUTO_SEQUENCE_NO";
    private static final String KEY_HIGHEST_AUTO_SEQUENCE_NO = "KEY_HIGHEST_AUTO_SEQUENCE_NO";
    private static final String KEY_CROSSCONNECTED = "KEY_CROSSCONNECTED";
    String sectorName;
    private String[] branchNames;
    private Map<String, List<CachedMo>> mapOfCachedMos = new HashMap<String, List<CachedMo>>();
    private Map<String, List<VoData>> mapOfVoData = new HashMap<String, List<VoData>>();
    private Map<String, List<VoView>> mapOfVoView = new HashMap<String, List<VoView>>();
    private Map<String, Map<CachedMo, Hashtable>> mapOfCachedMosWithProps = new HashMap<String, Map<CachedMo, Hashtable>>();
    private Map<String, Map<VoData, Hashtable>> mapOfVoDataWithProps = new HashMap<String, Map<VoData, Hashtable>>();
    int lowestSeqNumber = Integer.MAX_VALUE;
    private Map<VoData, String> voDataWithSequenceNumber = new HashMap<VoData, String>();
    private int currentSequenceNumber = 0;

    public AbstractSectorViewerData(String string, String[] stringArray) {
        this.sectorName = string;
        this.branchNames = stringArray;
        for (String string2 : stringArray) {
            ArrayList arrayList = new ArrayList();
            this.mapOfCachedMos.put(string2, arrayList);
            ArrayList arrayList2 = new ArrayList();
            this.mapOfVoData.put(string2, arrayList2);
            ArrayList arrayList3 = new ArrayList();
            this.mapOfVoView.put(string2, arrayList3);
            HashMap hashMap = new HashMap();
            this.mapOfCachedMosWithProps.put(string2, hashMap);
            HashMap hashMap2 = new HashMap();
            this.mapOfVoDataWithProps.put(string2, hashMap2);
        }
    }

    protected String[] getBranchNames() {
        return this.branchNames;
    }

    protected Map<String, List<VoData>> getMapOfVoData() {
        return this.mapOfVoData;
    }

    public int getNoOfUsedBranches() {
        int n = 0;
        for (String string : this.branchNames) {
            List<CachedMo> list = this.mapOfCachedMos.get(string);
            if (list.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public List<String> getUsedBranches() {
        Vector<String> vector = new Vector<String>();
        for (String string : this.branchNames) {
            List<CachedMo> list = this.mapOfCachedMos.get(string);
            if (list.isEmpty()) continue;
            vector.add(string);
        }
        return vector;
    }

    public List<CachedMo> getListOfCachedMos(String string) {
        return this.mapOfCachedMos.get(string);
    }

    public List<VoView> getListOfVoViews(String string) {
        return this.mapOfVoView.get(string);
    }

    private List<VoData> getListOfVoData() {
        ArrayList<VoData> arrayList = new ArrayList<VoData>();
        for (String string : this.branchNames) {
            List<VoData> list = this.mapOfVoData.get(string);
            for (VoData voData : list) {
                if (arrayList.contains(voData)) continue;
                arrayList.add(voData);
            }
        }
        return arrayList;
    }

    public boolean isCascaded(String string, VoView voView) {
        VoData voData = voView.getVoData();
        Map<VoData, Hashtable> map = this.mapOfVoDataWithProps.get(string);
        Hashtable hashtable = map.get(voData);
        return hashtable != null && hashtable.containsKey(KEY_CASCADED);
    }

    public boolean isCrossConnected(String string, VoView voView) {
        VoData voData = voView.getVoData();
        Map<VoData, Hashtable> map = this.mapOfVoDataWithProps.get(string);
        Hashtable hashtable = map.get(voData);
        return hashtable != null && hashtable.containsKey(KEY_CROSSCONNECTED);
    }

    public String getSequenceNumber(VoView voView) {
        VoData voData = voView.getVoData();
        return this.voDataWithSequenceNumber.get(voData);
    }

    public void addCachedMosWithProperties(String string, MoMatchedData moMatchedData) {
        if (string == null || moMatchedData == null) {
            return;
        }
        this.handleAutoSequenceNumber(moMatchedData);
        List<CachedMo> list = moMatchedData.getCachedMos();
        ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>();
        for (CachedMo cachedMo : list) {
            arrayList.add(cachedMo);
            Hashtable<String, Object> hashtable = moMatchedData.getProperties(cachedMo);
            this.putCachedMoProperties(string, cachedMo, hashtable);
        }
        this.addCachedMos(string, arrayList);
    }

    private void handleAutoSequenceNumber(MoMatchedData moMatchedData) {
        List<CachedMo> list = moMatchedData.getCachedMos();
        for (CachedMo cachedMo : list) {
            String string;
            Hashtable<String, Object> hashtable = moMatchedData.getProperties(cachedMo);
            if (hashtable == null) continue;
            if (hashtable.containsKey(KEY_AUTO_SEQUENCE_NO)) {
                hashtable.remove(KEY_AUTO_SEQUENCE_NO);
                ++this.currentSequenceNumber;
                string = String.valueOf(this.currentSequenceNumber);
                hashtable.put(KEY_SEQUENCE_NO, string);
                continue;
            }
            if (!hashtable.containsKey(KEY_HIGHEST_AUTO_SEQUENCE_NO)) continue;
            hashtable.remove(KEY_HIGHEST_AUTO_SEQUENCE_NO);
            ++this.currentSequenceNumber;
            string = String.valueOf(this.currentSequenceNumber);
            hashtable.put(KEY_SEQUENCE_NO, string);
            this.currentSequenceNumber = 0;
        }
    }

    private void addCachedMos(String string, List<CachedMo> list) {
        if (string == null || list == null) {
            return;
        }
        List<CachedMo> list2 = this.mapOfCachedMos.get(string);
        for (CachedMo cachedMo : list) {
            if (list2.contains(cachedMo)) continue;
            list2.add(cachedMo);
        }
        this.mapOfCachedMos.put(string, list2);
    }

    public void addVosWithProperties(List<ViewableObject> list) {
        for (String string : this.branchNames) {
            List<CachedMo> list2 = this.getListOfCachedMos(string);
            if (list2 == null) continue;
            for (CachedMo cachedMo : list2) {
                this.addVosWithProperties(string, list, cachedMo);
            }
        }
    }

    protected void addVosWithProperties(String string, List<ViewableObject> list, CachedMo cachedMo) {
        Map<CachedMo, Hashtable> map = this.mapOfCachedMosWithProps.get(string);
        Hashtable hashtable = map.get(cachedMo);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        map.put(cachedMo, new Hashtable(hashtable));
        String string2 = cachedMo.getMoType();
        String string3 = cachedMo.getLdn();
        block0: for (ViewableObject viewableObject : list) {
            String[] stringArray = viewableObject.getLdns(string2);
            if (stringArray == null || stringArray.length < 1) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string3)) continue;
                List<VoData> list2 = this.mapOfVoData.get(string);
                if (!list2.contains(viewableObject)) {
                    list2.add(viewableObject);
                }
                this.putVoDataProperties(string, viewableObject, new Hashtable(hashtable));
                continue block0;
            }
        }
    }

    private void putCachedMoProperties(String string, CachedMo cachedMo, Hashtable hashtable) {
        Map<CachedMo, Hashtable> map;
        Hashtable hashtable2 = hashtable;
        if (cachedMo == null) {
            return;
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        if (!(map = this.mapOfCachedMosWithProps.get(string)).containsKey(cachedMo)) {
            map.put(cachedMo, new Hashtable(hashtable2));
        } else {
            Hashtable hashtable3 = map.get(cachedMo);
            if (hashtable3 == null) {
                hashtable3 = new Hashtable();
            }
            hashtable3.putAll(new Hashtable(hashtable2));
        }
    }

    private void putVoDataProperties(String string, VoData voData, Hashtable hashtable) {
        if (voData == null) {
            return;
        }
        this.addToVoDataWithSequenceNumber(voData, hashtable);
        Map<VoData, Hashtable> map = this.mapOfVoDataWithProps.get(string);
        if (!map.containsKey(voData)) {
            map.put(voData, new Hashtable(hashtable));
        } else {
            Hashtable hashtable2 = map.get(voData);
            if (hashtable2 == null) {
                hashtable2 = hashtable;
            } else {
                hashtable2.putAll(new Hashtable(hashtable));
            }
        }
    }

    private void addToVoDataWithSequenceNumber(VoData voData, Hashtable hashtable) {
        Object object;
        if (hashtable == null || !hashtable.containsKey(KEY_SEQUENCE_NO)) {
            return;
        }
        Object v = hashtable.get(KEY_SEQUENCE_NO);
        if (v == null) {
            return;
        }
        String string = null;
        if (v instanceof List) {
            object = (List)v;
            string = object.get(0).toString();
        } else if (v instanceof String) {
            string = v.toString();
        }
        object = new String(string.toString());
        this.voDataWithSequenceNumber.put(voData, (String)object);
    }

    public void matchVoDataToVoView(VoData voData, VoView voView) {
        for (String string : this.branchNames) {
            List<VoData> list = this.mapOfVoData.get(string);
            if (list == null || !list.contains(voData)) continue;
            this.addVoView(string, voView);
        }
    }

    private void addVoView(String string, VoView voView) {
        List<VoView> list = this.mapOfVoView.get(string);
        if (!list.contains(voView)) {
            list.add(voView);
            this.mapOfVoView.put(string, list);
        }
    }

    public void reCalculateSequenceNumber() {
        int n;
        String string;
        List<VoData> list = this.getListOfVoData();
        this.lowestSeqNumber = Integer.MAX_VALUE;
        for (VoData voData : list) {
            string = this.voDataWithSequenceNumber.get(voData);
            if (string == null) continue;
            n = Integer.MAX_VALUE;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n >= this.lowestSeqNumber) continue;
            this.lowestSeqNumber = n;
        }
        for (VoData voData : list) {
            string = this.voDataWithSequenceNumber.get(voData);
            if (string == null) continue;
            n = Integer.MAX_VALUE;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = n - this.lowestSeqNumber + 1;
            String string2 = new String(Integer.toString(n2));
            this.voDataWithSequenceNumber.put(voData, string2);
        }
    }
}

