/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorBranchData;

public class AbstractSectorViewerModel {
    private Map<String, AbstractSectorViewerData> mapSectorViewerData = new HashMap<String, AbstractSectorViewerData>();
    private final String[] sectorNames;
    private final String[] branchNames;
    private final SectorBranchData.RADIO_STANDARD radio_standard;
    private Container topContainer;
    private Container taskBarContainer;
    private Container menuBarContainer;
    private Container scrollPane;

    public AbstractSectorViewerModel(String[] stringArray, String[] stringArray2, SectorBranchData.RADIO_STANDARD rADIO_STANDARD) {
        this.sectorNames = stringArray;
        this.branchNames = stringArray2;
        this.radio_standard = rADIO_STANDARD;
    }

    public void setGuiData(Container container, Container container2, Container container3, Container container4) {
        this.topContainer = container;
        this.taskBarContainer = container2;
        this.menuBarContainer = container3;
        this.scrollPane = container4;
    }

    public Container getTopContainer() {
        return this.topContainer;
    }

    public Container getTaskBarContainer() {
        return this.taskBarContainer;
    }

    public Container getJMenuBarContainer() {
        return this.menuBarContainer;
    }

    public String[] getSectorNames() {
        return this.sectorNames;
    }

    public String[] getBranchNames() {
        return this.branchNames;
    }

    public SectorBranchData.RADIO_STANDARD getRadioStandard() {
        return this.radio_standard;
    }

    public Map<String, AbstractSectorViewerData> getMapSectorViewerData() {
        return this.mapSectorViewerData;
    }

    public int getNoOfUsedBranches() {
        int n = 0;
        for (String string : this.sectorNames) {
            int n2 = 0;
            AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
            if (abstractSectorViewerData != null) {
                n2 = abstractSectorViewerData.getNoOfUsedBranches();
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public List<String> getSectorBranchNames(String string) {
        AbstractSectorViewerData abstractSectorViewerData = this.getMapSectorViewerData().get(string);
        return abstractSectorViewerData.getUsedBranches();
    }

    public List<CachedMo> getListOfCachedMos(String string, String string2) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            return abstractSectorViewerData.getListOfCachedMos(string2);
        }
        return new ArrayList<CachedMo>();
    }

    public List<VoView> getListOfVoViews(String string, String string2) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            return abstractSectorViewerData.getListOfVoViews(string2);
        }
        return new ArrayList<VoView>();
    }

    public void addCachedMosWithProperties(String string, String string2, MoMatchedData moMatchedData) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            abstractSectorViewerData.addCachedMosWithProperties(string2, moMatchedData);
        }
    }

    public void addVosWithProperties(List<ViewableObject> list) {
        for (String string : this.sectorNames) {
            AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
            if (abstractSectorViewerData == null) continue;
            abstractSectorViewerData.addVosWithProperties(list);
        }
    }

    public boolean isCascaded(String string, String string2, VoView voView) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            return abstractSectorViewerData.isCascaded(string2, voView);
        }
        return false;
    }

    public boolean isCrossConnected(String string, String string2, VoView voView) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            return abstractSectorViewerData.isCrossConnected(string2, voView);
        }
        return false;
    }

    public String getSequenceNumber(String string, String string2, VoView voView) {
        AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
        if (abstractSectorViewerData != null) {
            return abstractSectorViewerData.getSequenceNumber(voView);
        }
        return null;
    }

    public void matchListOfVoViews(List<VoView> list) {
        if (this.sectorNames == null || list == null) {
            return;
        }
        for (VoView voView : list) {
            VoData voData = voView.getVoData();
            if (voData == null) continue;
            for (String string : this.sectorNames) {
                AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
                if (abstractSectorViewerData == null) continue;
                abstractSectorViewerData.matchVoDataToVoView(voData, voView);
            }
        }
        this.reCalculateSequenceNumbers();
    }

    private void reCalculateSequenceNumbers() {
        if (this.sectorNames == null) {
            return;
        }
        for (String string : this.sectorNames) {
            AbstractSectorViewerData abstractSectorViewerData = this.mapSectorViewerData.get(string);
            if (abstractSectorViewerData == null) continue;
            abstractSectorViewerData.reCalculateSequenceNumber();
        }
    }

    public Container getScrollPane() {
        return this.scrollPane;
    }
}

