/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerData;

public class SectorViewerData
extends AbstractSectorViewerData {
    private static final String ATMA = "ATMAU";
    private static final String TMA = "ExternalTma";

    public SectorViewerData(String string, String[] stringArray) {
        super(string, stringArray);
    }

    @Override
    public void addVosWithProperties(List<ViewableObject> list) {
        super.addVosWithProperties(list);
        this.updateForDualTma();
    }

    private void updateForDualTma() {
        for (String string : this.getBranchNames()) {
            if (!this.hasDualTma(string)) continue;
            this.updateBranchForDualTma(string);
        }
    }

    private void updateBranchForDualTma(String string) {
        String string2 = "";
        if (string.equals(this.getBranchNames()[0])) {
            string2 = TMA;
        } else if (string.equals(this.getBranchNames()[1])) {
            string2 = ATMA;
        }
        List<VoData> list = this.getMapOfVoData().get(string);
        Iterator<VoData> iterator = list.iterator();
        VoData voData = null;
        while (iterator.hasNext()) {
            VoData voData2 = iterator.next();
            if (!voData2.getSpecificType().equals(string2)) continue;
            voData = voData2;
            break;
        }
        if (voData != null) {
            list.remove(voData);
        }
    }

    private boolean hasDualTma(String string) {
        List<VoData> list = this.getMapOfVoData().get(string);
        Iterator<VoData> iterator = list.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            VoData voData = iterator.next();
            String string2 = voData.getSpecificType();
            if (string2.equals(ATMA)) {
                bl = true;
                continue;
            }
            if (!string2.equals(TMA)) continue;
            bl2 = true;
        }
        return bl && bl2;
    }
}

