/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorBranchData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorViewerModel;

public class SectorViewerManager
extends AbstractSectorViewerManager {
    private Map<String, Integer> sectorToNoOfCarriers = new HashMap<String, Integer>();
    private static final Map<String, String[]> CARRIER_TO_SLOTNO_FOR_BBIF = new HashMap<String, String[]>();

    public SectorViewerManager(CacheManager cacheManager, List<CachedMo> list, String[] stringArray) {
        super(cacheManager, list, SectorBranchData.RADIO_STANDARD.WCDMA, stringArray);
        this.setInitialData();
    }

    @Override
    protected void setInitialData() {
        this.model = new SectorViewerModel(this.getSectorNames(), this.getBranchNames(), SectorBranchData.RADIO_STANDARD.WCDMA);
        for (CachedMo cachedMo : this.listOfsectorMo) {
            List list = cachedMo.getChildren("Carrier");
            int n = list.size();
            this.sectorToNoOfCarriers.put(cachedMo.getName(), n);
        }
    }

    @Override
    public void doMatching(List<VoTemplate> list, List<ViewableObject> list2) {
        for (CachedMo cachedMo : this.listOfsectorMo) {
            String string = cachedMo.getName();
            int n = this.sectorToNoOfCarriers.get(cachedMo.getName());
            for (VoTemplate voTemplate : list) {
                MoRelationship moRelationship = voTemplate.getMoRelationShip();
                for (String string2 : this.branchNames) {
                    moRelationship.clearGlobalProperties();
                    moRelationship.putGlobalProperty("currentBranch", string2);
                    MoMatchedData moMatchedData = moRelationship.getMoMatchedData(cachedMo);
                    if (moMatchedData.isEmpty()) continue;
                    this.model.addCachedMosWithProperties(string, string2, moMatchedData);
                }
            }
            if (!this.needMatchingForBbif(this.cacheMan)) continue;
            this.doMatchingForBbif(this.cacheMan, list, cachedMo, n);
        }
        this.model.addVosWithProperties(list2);
        this.traceObservation();
    }

    private boolean needMatchingForBbif(CacheManager cacheManager) {
        List<CachedMo> list = cacheManager.getCachedMosOfType("BbifBoard");
        List<CachedMo> list2 = cacheManager.getCachedMosOfType("RfifDeviceGroup");
        return !list.isEmpty() || !list2.isEmpty();
    }

    private void doMatchingForBbif(CacheManager cacheManager, List<VoTemplate> list, CachedMo cachedMo, int n) {
        List<CachedMo> list2 = cacheManager.getCachedMosOfType("Slot");
        for (CachedMo cachedMo2 : list2) {
            for (VoTemplate voTemplate : list) {
                MoRelationship moRelationship = voTemplate.getMoRelationShip();
                for (String string : this.branchNames) {
                    String[] stringArray = CARRIER_TO_SLOTNO_FOR_BBIF.get(String.valueOf(n));
                    moRelationship.putGlobalProperty("currentSlotNumber", stringArray);
                    moRelationship.putGlobalProperty("currentBranch", string);
                    MoMatchedData moMatchedData = moRelationship.getMoMatchedData(cachedMo2);
                    if (moMatchedData.isEmpty()) continue;
                    String string2 = cachedMo.getName();
                    this.model.addCachedMosWithProperties(string2, string, moMatchedData);
                }
            }
        }
    }

    static {
        CARRIER_TO_SLOTNO_FOR_BBIF.put("1", new String[]{"6"});
        CARRIER_TO_SLOTNO_FOR_BBIF.put("2", new String[]{"6", "7"});
    }
}

