/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.AbstractEquipment;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.AddAttributesElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.FallBackVoTemplateElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.UseTemplateElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class EquipmentElement
extends AbstractEquipment {
    private String moTypeForSector;
    private AddAttributesElement addAttributesElement;
    private List<UseTemplateElement> useTemplatesElements = new ArrayList<UseTemplateElement>();
    private List<FallBackVoTemplateElement> fallBackVoTemplates = new ArrayList<FallBackVoTemplateElement>();

    public EquipmentElement(Hashtable hashtable, Node node) {
        super(hashtable, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("sector")) {
                ArrayList<String> arrayList = Helper.getValuesFromNode(hashtable, node2, "moType");
                if (arrayList == null || arrayList.size() <= 0) continue;
                this.moTypeForSector = (String)arrayList.get(0);
                continue;
            }
            if (string.equals("addAttributes")) {
                this.addAttributesElement = new AddAttributesElement(this.getParams(), node2);
                continue;
            }
            if (string.equals("useTemplate")) {
                this.useTemplatesElements.add(new UseTemplateElement(this.getParams(), node2));
                continue;
            }
            if (!string.equals("fallbackVoTemplate")) continue;
            this.fallBackVoTemplates.add(new FallBackVoTemplateElement(this.getParams(), node2));
        }
    }

    public String getMoTypeForSector() {
        if (this.moTypeForSector != null) {
            return this.moTypeForSector;
        }
        return null;
    }

    public NameValue[] getAdditionalAttributes() {
        if (this.addAttributesElement != null) {
            return this.addAttributesElement.getAdditionalAttributes();
        }
        return null;
    }

    public List<UseTemplateElement> getUseTemplates() {
        return this.useTemplatesElements;
    }

    public List<FallBackVoTemplateElement> getFallbackVoTemplates() {
        return this.fallBackVoTemplates;
    }
}

