/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property;

import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.AndCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.ElseStatement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.EqualsCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.IfCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.NotCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.OrCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.StringCompareCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.ThenStatement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AbstractCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AndElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.ElseElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.EqualsElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.NotElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.OrElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.StringCompareElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.ThenElement;

public class IfElement
extends AbstractCondition {
    boolean result = true;
    private AndElement andElement;
    private OrElement orElement;
    private NotElement notElement;
    private EqualsElement equalsElement;
    private StringCompareElement stringCompareElement;
    private ThenElement thenElement;
    private ElseElement elseElement;

    public IfElement(Hashtable hashtable, Node node) {
        super(hashtable);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!this.isValidNodeName(string)) continue;
            if (string.equals("and")) {
                this.andElement = new AndElement(hashtable, node2);
                continue;
            }
            if (string.equals("or")) {
                this.orElement = new OrElement(hashtable, node2);
                continue;
            }
            if (string.equals("not")) {
                this.notElement = new NotElement(hashtable, node2);
                continue;
            }
            if (string.equals("equals")) {
                this.equalsElement = new EqualsElement(hashtable, node2);
                continue;
            }
            if (string.equals("contains")) {
                this.stringCompareElement = new StringCompareElement(hashtable, node2, "contains");
                continue;
            }
            if (string.equals("startsWith")) {
                this.stringCompareElement = new StringCompareElement(hashtable, node2, "startsWith");
                continue;
            }
            if (string.equals("endsWith")) {
                this.stringCompareElement = new StringCompareElement(hashtable, node2, "endsWith");
                continue;
            }
            if (string.equals("then")) {
                this.thenElement = new ThenElement(hashtable, node2);
                continue;
            }
            if (!string.equals("else")) continue;
            this.elseElement = new ElseElement(hashtable, node2);
        }
    }

    @Override
    public boolean evaluate() {
        this.result = this.andElement != null ? this.andElement.evaluate() : (this.orElement != null ? this.orElement.evaluate() : (this.notElement != null ? this.notElement.evaluate() : (this.equalsElement != null ? this.equalsElement.evaluate() : (this.stringCompareElement != null ? this.stringCompareElement.evaluate() : false))));
        if (this.result) {
            this.evaluateThen();
        } else {
            this.evaluateElse();
        }
        return this.result;
    }

    private void evaluateThen() {
        if (this.thenElement != null) {
            this.thenElement.execute(this.getParams());
        }
    }

    private void evaluateElse() {
        if (this.elseElement != null) {
            this.elseElement.execute(this.getParams());
        }
    }

    @Override
    public Hashtable getKeysAndValues() {
        if (this.result) {
            if (this.thenElement != null) {
                return this.thenElement.getKeysAndValues();
            }
        } else if (this.elseElement != null) {
            return this.elseElement.getKeysAndValues();
        }
        return new Hashtable();
    }

    @Override
    protected IfCondition createCondition() {
        AndCondition andCondition = null;
        if (this.andElement != null) {
            andCondition = this.andElement.createCondition();
        }
        OrCondition orCondition = null;
        if (this.orElement != null) {
            orCondition = this.orElement.createCondition();
        }
        NotCondition notCondition = null;
        if (this.notElement != null) {
            notCondition = this.notElement.createCondition();
        }
        EqualsCondition equalsCondition = null;
        if (this.equalsElement != null) {
            equalsCondition = this.equalsElement.createCondition();
        }
        StringCompareCondition stringCompareCondition = null;
        if (this.stringCompareElement != null) {
            stringCompareCondition = this.stringCompareElement.createCondition();
        }
        ThenStatement thenStatement = null;
        if (this.thenElement != null) {
            thenStatement = (ThenStatement)this.thenElement.createStatement();
        }
        ElseStatement elseStatement = null;
        if (this.elseElement != null) {
            elseStatement = (ElseStatement)this.elseElement.createStatement();
        }
        IfCondition ifCondition = new IfCondition(andCondition, orCondition, notCondition, equalsCondition, stringCompareCondition, thenStatement, elseStatement);
        return ifCondition;
    }
}

