/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.File;

public class CommandLineParameters {
    public static final String PROGNAME = "EmCertificatePatcher";
    private static final String DEFAULT_INSTALL_DIR = System.getProperty("user.home") + File.separatorChar + "Ericsson";
    private boolean optForce = false;
    private boolean optExtractLauncher = false;
    private boolean optInformation = false;
    private boolean optOss = false;
    private boolean optRollback = false;
    private boolean optDesign = false;
    private String[] optLaxPaths = new String[]{DEFAULT_INSTALL_DIR};

    public static void printUsage() {
        System.out.println("USAGE:");
        System.out.println("  > java -jar EmCertificatePatcher.jar [options] [<laxpaths>]");
        System.out.println("");
        System.out.println("Where");
        System.out.println("    [options] are zero or more of:");
        System.out.println("        -f,   --force           Copies the launcher.jar into the cache and modifies each");
        System.out.println("                                found LAX file without querying first.");
        System.out.println("        -i,   --information     Prints information about which LAX files that");
        System.out.println("                                can be modified. No changes will be made.");
        System.out.println("        -r,   --rollback        Restores the modified files to their original state.");
        System.out.println("");
        System.out.println("    <laxpaths>  Files or directories to scan for files with extension '.lax'.");
        System.out.println("                Directories are scanned recursively.");
        System.out.println("                Default is directory " + DEFAULT_INSTALL_DIR);
        System.out.println("");
        System.out.println("DESCRIPTION:");
        System.out.println("  Scans all found laxfiles for the cachedir and for the used version of launcher.jar.");
        System.out.println("  The new launcher.jar is stored in the correct dir under found cachedir(s).");
        System.out.println("  The <laxfiles> are updated with the location of the new launcher.jar.");
        System.out.println("");
    }

    public static void printProgramName() {
        System.out.println("EmCertificatePatcher - Patches Element Managers to fix \"Java Certificate Expired\" dec 2011");
    }

    public static void printHelp() {
        System.out.println("");
        CommandLineParameters.printUsage();
        System.exit(1);
    }

    public static void commandLineError(String msg) {
        System.out.println("");
        System.out.println("COMMAND LINE ERROR! " + msg);
        System.out.println("");
        CommandLineParameters.printUsage();
        System.exit(1);
    }

    public CommandLineParameters(String[] args) {
        CommandLineParameters.printProgramName();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-d".equals(arg) || "--design".equals(arg)) {
                this.optDesign = true;
                continue;
            }
            if ("-f".equals(arg) || "--force".equals(arg)) {
                this.optForce = true;
                continue;
            }
            if (arg.startsWith("-h") || arg.startsWith("--h")) {
                CommandLineParameters.printHelp();
                System.exit(1);
            }
            if ("-i".equals(arg) || "--information".equals(arg)) {
                this.optInformation = true;
                continue;
            }
            if ("-oss".equals(arg)) {
                this.optOss = true;
                continue;
            }
            if ("-r".equals(arg) || "--rollback".equals(arg)) {
                this.optRollback = true;
                continue;
            }
            if ("-xl".equals(arg) || "--extractlauncher".equals(arg)) {
                this.optExtractLauncher = true;
                continue;
            }
            if (arg.startsWith("-")) {
                CommandLineParameters.commandLineError("Unrecognized command line option: " + arg);
                continue;
            }
            this.optLaxPaths = new String[args.length - i];
            System.arraycopy(args, i, this.optLaxPaths, 0, this.optLaxPaths.length);
            return;
        }
    }

    public boolean isForceSet() {
        return this.optForce;
    }

    public boolean isExtractLauncherSet() {
        return this.optExtractLauncher;
    }

    public boolean isInformationSet() {
        return this.optInformation;
    }

    public boolean isOssSet() {
        return this.optOss;
    }

    public boolean isRollbackSet() {
        return this.optRollback;
    }

    public boolean isDesignSet() {
        return this.optDesign;
    }

    public String[] getLaxPaths() {
        return this.optLaxPaths;
    }
}

