/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import se.ericsson.security.launcher.ReusableLaunchable;
import se.ericsson.security.launcher.testmode.TmOverrideLib;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassLoader
extends URLClassLoader {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private ClassLoader interfaceClassLoader = null;
    private final String name;
    private static final String PACKAGE_PREFIX = "se.ericsson.security";
    private static final String[] launcherPackages = new String[]{"starter", "empatcher", "launcher", "utils"};

    public ApplicationClassLoader(String name, URL[] urls, ClassLoader parent, ClassLoader icl) {
        super(new URL[0], parent);
        this.addURLs(urls);
        this.name = name;
        this.interfaceClassLoader = icl;
        this.setContextClassLoader();
    }

    public void addURLs(URL[] urls) {
        URL[] urls_e = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < urls_e.length; ++j) {
                if (!urls[i].equals(urls_e[j])) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.addURL(urls[i]);
        }
    }

    @Override
    public void addURL(URL url) {
        if (TmUtilities.isClassLoadingFromJarsDisabled()) {
            LOG.finest("URL \"" + url.toString() + "\" is not added to the list of URLs that are searched for classes and resources.", new Object[0]);
            return;
        }
        URL overrideUrl = TmOverrideLib.getOverrideUrl(url);
        if (overrideUrl != null) {
            url = overrideUrl;
        }
        super.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (this.useLauncherClassloading(name)) {
            LOG.finest("Class " + name + " will be loaded bottom-up.", new Object[0]);
            try {
                if (this.interfaceClassLoader != null && (name.equals("se.ericsson.security.launcher.MetaLauncher") || name.equals("se.ericsson.security.launcher.LauncherException") || name.equals("se.ericsson.security.launcher.Launchable") || name.equals("se.ericsson.security.launcher.ReusableLaunchable") || name.equals("se.ericsson.security.launcher.download.DownloadListener") || name.startsWith("nexguitests") || name.endsWith("Interface"))) {
                    if (name.equals(ReusableLaunchable.class.getName())) {
                        ClassLoader classLoader = ReusableLaunchable.class.getClassLoader();
                        if (classLoader != null && classLoader.equals(this.interfaceClassLoader)) {
                            LOG.fine("The ReusableLaunchable is class loaded by the interface classloader", new Object[0]);
                            loadedClass = this.interfaceClassLoader.loadClass(name);
                        } else {
                            LOG.fine("The ReusableLaunchable is NOT class loaded by the interface classloader", new Object[0]);
                        }
                    } else {
                        loadedClass = this.interfaceClassLoader.loadClass(name);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (loadedClass == null) {
                try {
                    loadedClass = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                loadedClass = this.getParent().loadClass(name);
            }
        } else {
            LOG.finest("Class " + name + " will be loaded top-down.", new Object[0]);
            if (this.getParent() != null) {
                try {
                    loadedClass = this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                loadedClass = this.findClass(name);
            }
        }
        return loadedClass;
    }

    private boolean useLauncherClassloading(String name) {
        if (name.startsWith("nexguitests")) {
            return true;
        }
        for (String packageSuffix : launcherPackages) {
            String fullPackageName = "se.ericsson.security." + packageSuffix;
            if (!name.startsWith(fullPackageName)) continue;
            return true;
        }
        return false;
    }

    public void setContextClassLoader() {
        ApplicationClassLoader classloader = this;
        Thread.currentThread().setContextClassLoader(classloader);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream localIS = this.getLocalResourceAsStream(name);
        InputStream parentIS = this.getParent().getResourceAsStream(name);
        InputStream is = null;
        is = name.startsWith(PACKAGE_PREFIX.replace('.', '/')) ? (localIS != null ? localIS : parentIS) : (parentIS != null ? parentIS : localIS);
        return is;
    }

    private InputStream getLocalResourceAsStream(String name) {
        for (int i = 0; i < this.getURLs().length; ++i) {
            try {
                URL u = new URL("jar:" + this.getURLs()[i].toExternalForm() + "!/" + name);
                JarURLConnection juc = (JarURLConnection)u.openConnection();
                return juc.getInputStream();
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(":").append(Arrays.toString(this.getURLs()));
        return sb.toString();
    }
}

