/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.ericsson.security.launcher.ApplicationCacheInterface;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.ConfigurationException;
import se.ericsson.security.launcher.ConfigurationFile;
import se.ericsson.security.launcher.ConfigurationFileList;
import se.ericsson.security.launcher.SecurityException;
import se.ericsson.security.launcher.SecurityState;
import se.ericsson.security.launcher.VersionException;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.parser.ConfigurationAccess;
import se.ericsson.security.launcher.parser.ConfigurationAccessFactory;
import se.ericsson.security.launcher.parser.CustomApplJavaVersion;
import se.ericsson.security.launcher.parser.CustomApplParameters;
import se.ericsson.security.launcher.parser.EmApplication;
import se.ericsson.security.launcher.parser.EmApplicationConfiguration;
import se.ericsson.security.launcher.parser.EmApplicationFile;
import se.ericsson.security.launcher.parser.EmApplicationSee;
import se.ericsson.security.launcher.parser.ParserException;
import se.ericsson.security.launcher.parser.ParserInputEmptyException;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfiguration
implements ApplicationCacheInterface {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private String displayName = "";
    private short type = 0;
    private static final short TYPE_NONE = 0;
    private static final short TYPE_FRONT = 1;
    private static final short TYPE_BACK = 2;
    private ApplicationFileInterface launcherFile = null;
    private Cache cache = null;
    private SecurityState securityState = null;
    private URL NEAddress;
    private Properties applicationParameters;
    private String applicationEntrypointClass = "";
    private String SLSUrls = "";
    private String applicationName = "";
    private HashMap<String, ApplicationFileInterface> applicationJarFiles = new HashMap();
    private String configFileContent;
    private HashMap<String, ApplicationFileInterface> commonApplicationJarFiles = new HashMap();
    private Collection<ApplicationFileInterface> referencedXmlFiles = new Vector<ApplicationFileInterface>();
    private ApplicationFileInterface configurationFile;

    protected ApplicationConfiguration() {
        this.applicationParameters = new Properties();
    }

    private ApplicationConfiguration(URL url, Cache theCache, SecurityState ss, boolean topLevel) throws ConfigurationException {
        this();
        this.cache = theCache;
        this.NEAddress = url;
        ConfigurationFile confFile = ConfigurationFileList.getConfigurationFile(url.toExternalForm());
        if (confFile != null) {
            try {
                this.configFileContent = this.cache.getConfigurationFileAsString(this.NEAddress);
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
            this.setFromStoredConfigFile(confFile);
        } else {
            SecurityState ss_local = ConfigurationFileList.getGlobalSecurityState();
            if (ss == null && ss_local == null) {
                try {
                    this.securityState = new SecurityState(this.NEAddress);
                    ConfigurationFileList.setGlobalSecurityState(this.securityState);
                }
                catch (SecurityException e) {
                    throw new ConfigurationException("Could not get security state from NE", (Throwable)e);
                }
            } else {
                if (ss_local == null) {
                    ss_local = ss;
                    ConfigurationFileList.setGlobalSecurityState(ss);
                }
                this.securityState = ss_local;
            }
            this.readFromURL(this.NEAddress, topLevel);
        }
    }

    private ApplicationConfiguration(URL url, Cache theCache, boolean bootstrapper, boolean top_level) throws ConfigurationException {
        this();
        LOG.fine("url:" + url.toString(), new Object[0]);
        this.cache = theCache;
        this.NEAddress = url;
        if (bootstrapper) {
            this.readFromURLToFindOutLauncherRevision(this.NEAddress, top_level);
        } else {
            ConfigurationFile confFile = ConfigurationFileList.getConfigurationFile(url.toExternalForm());
            if (confFile != null) {
                this.setFromStoredConfigFile(confFile);
            } else {
                SecurityState ss_local = ConfigurationFileList.getGlobalSecurityState();
                if (ss_local == null) {
                    try {
                        this.securityState = new SecurityState(this.NEAddress);
                        ConfigurationFileList.setGlobalSecurityState(this.securityState);
                    }
                    catch (SecurityException e) {
                        throw new ConfigurationException("Could not get security state from NE", (Throwable)e);
                    }
                } else {
                    this.securityState = ss_local;
                }
                this.readFromURL(this.NEAddress, top_level);
            }
        }
    }

    public ApplicationConfiguration(URL url, Cache theCache, boolean bootstrapper) throws ConfigurationException {
        this(url, theCache, bootstrapper, true);
    }

    public ApplicationConfiguration(URL url, Cache theCache) throws ConfigurationException {
        this(url, theCache, (SecurityState)null);
    }

    protected ApplicationConfiguration(URL url, Cache theCache, SecurityState ss) throws ConfigurationException {
        this(url, theCache, ss, true);
    }

    public ApplicationConfiguration(URL url, Cache theCache, String theDisplayName) throws ConfigurationException {
        this(url, theCache);
        this.displayName = theDisplayName;
    }

    public ApplicationConfiguration(URL url, Cache theCache, String theDisplayName, SecurityState ss) throws ConfigurationException {
        this(url, theCache, ss);
        this.displayName = theDisplayName;
    }

    public ApplicationConfiguration(URL url, Cache theCache, String theDisplayName, boolean bootstrapper) throws ConfigurationException {
        this(url, theCache, bootstrapper);
        this.displayName = theDisplayName;
    }

    private void setFromStoredConfigFile(ConfigurationFile confFile) {
        ApplicationFile crt;
        int i;
        this.NEAddress = confFile.getNEAddress();
        this.SLSUrls = confFile.getSlsURLs();
        this.displayName = confFile.getDisplayName();
        this.securityState = confFile.getSecurityState();
        this.configurationFile = confFile.getTheConfigurationFile();
        this.applicationName = confFile.getApplicationName();
        this.applicationEntrypointClass = confFile.getApplicationClassName();
        this.launcherFile = confFile.getLauncherFile();
        this.referencedXmlFiles = confFile.getTheReferredConfigurationFiles();
        Vector<ApplicationFileInterface> applFiles = confFile.getApplicationFiles();
        Vector<ApplicationFileInterface> commonApplFiles = confFile.getCommonApplicationFiles();
        for (i = 0; i < applFiles.size(); ++i) {
            crt = (ApplicationFile)applFiles.elementAt(i);
            this.applicationJarFiles.put(crt.getName(), crt);
        }
        for (i = 0; i < commonApplFiles.size(); ++i) {
            crt = (ApplicationFile)commonApplFiles.elementAt(i);
            this.commonApplicationJarFiles.put(crt.getName(), crt);
        }
        this.applicationParameters = confFile.getApplicationParameters();
    }

    private void readFromURL(URL url, boolean topLevel) throws ConfigurationException {
        String content;
        LOG.fine("readFromURL: url: " + url.toString(), new Object[0]);
        try {
            content = this.cache.getConfigurationFileAsString(url);
            if (content == null || content.length() == 0) {
                throw new ConfigurationException("Could not get configuration file: " + url.getFile());
            }
        }
        catch (VersionException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new ConfigurationException("Could not get configuration file", (Throwable)e);
        }
        this.parseFile(content, url, topLevel);
        if (topLevel && this.launcherFile == null) {
            throw new ConfigurationException("Unable to find launcher.jar description");
        }
    }

    private void readFromURLToFindOutLauncherRevision(URL url, boolean topLevel) throws ConfigurationException {
        String contentForPartialParsing;
        try {
            contentForPartialParsing = this.cache.getConfigurationFileAsString(url);
        }
        catch (CacheException e) {
            throw new ConfigurationException("Could not get configuration file", (Throwable)e);
        }
        catch (VersionException e) {
            throw e;
        }
        this.parseFileToFindOutLauncherRevision(contentForPartialParsing, url, topLevel);
        if (topLevel && this.launcherFile == null) {
            throw new ConfigurationException("Bootstrapper: Unable to find launcher.jar description");
        }
    }

    private void parseFile(String input, URL parentUrl, boolean top_level) throws ConfigurationException {
        ApplicationConfiguration refAc;
        String urlRef;
        ApplicationFile appFile;
        CustomApplJavaVersion javaVersion;
        Collection<CustomApplParameters> applParameters;
        Collection<EmApplicationSee> launcherApplicationRef;
        Collection<EmApplicationFile> launcherApplicationFile;
        Collection<EmApplicationSee> emApplicationRefs;
        Collection<EmApplicationFile> emCommonApplicationFiles;
        Collection<EmApplicationFile> emApplicationFiles;
        EmApplicationConfiguration applConfig;
        EmApplication application;
        String filePath;
        String fileName;
        block38: {
            this.configFileContent = input;
            if (input == null || input.length() == 0) {
                throw new ConfigurationException("Could not parse file");
            }
            ConfigurationAccess ca = ConfigurationAccessFactory.getConfigurationAccess();
            try {
                ca.setFileContent(input);
            }
            catch (ParserInputEmptyException e) {
                // empty catch block
            }
            String path = parentUrl.getFile();
            fileName = path.substring(path.lastIndexOf("/") + 1);
            filePath = path.substring(0, path.lastIndexOf("/"));
            application = null;
            applConfig = null;
            emApplicationFiles = null;
            emCommonApplicationFiles = null;
            emApplicationRefs = null;
            launcherApplicationFile = null;
            launcherApplicationRef = null;
            applParameters = null;
            javaVersion = null;
            try {
                application = ca.getEmApplication();
                applConfig = ca.getEmApplicationConfiguration();
                emApplicationFiles = ca.getEmApplicationFile();
                emCommonApplicationFiles = ca.getEmCommonApplicationFile();
                emApplicationRefs = ca.getEmApplicationSee();
                launcherApplicationFile = ca.getEmLauncherFile();
                launcherApplicationRef = ca.getEmLauncherSee();
                applParameters = ca.getCustomApplParameters();
                javaVersion = ca.getCustomApplJavaVersion();
                if (top_level && launcherApplicationFile.isEmpty() && launcherApplicationRef.isEmpty()) {
                    throw new ConfigurationException("ApplicationConfiguration is faulty: missing both <EM_LAUNCHER_FILE> and <EM_LAUNCHER_SEE> tags");
                }
                if (!launcherApplicationFile.isEmpty() && !launcherApplicationRef.isEmpty()) {
                    throw new ConfigurationException("ApplicationConfiguration is faulty: conflicting <EM_LAUNCHER_FILE> and <EM_LAUNCHER_SEE> tags");
                }
                if (application.isSet() && !applConfig.isSet()) {
                    this.type = 1;
                    break block38;
                }
                if (!application.isSet() && applConfig.isSet()) {
                    this.type = (short)2;
                    break block38;
                }
                throw new ConfigurationException("ApplicationConfiguration is faulty: missing or conflicting <EM_APPLICATION> and <EM_APPLICATION_CONFIG_FILE> tags");
            }
            catch (ParserInputEmptyException e1) {
                throw new ConfigurationException("Could not find configuration file", (Throwable)e1);
            }
            catch (ParserException e1) {
                throw new ConfigurationException("Could not parse configuration file", (Throwable)e1);
            }
        }
        String javaCurrent = System.getProperty("java.version");
        String javaMin = javaVersion.getMin();
        String javaRec = javaVersion.getRecommended();
        if (!ApplicationConfiguration.javaVersionPossiblyGreaterThan(javaCurrent, javaMin)) {
            String tooOldJavaMsg = "The Java Runtime Environment version is too old. Minimum: " + javaMin;
            if (ApplicationConfiguration.javaVersionPossiblyGreaterThan(javaRec, javaMin)) {
                tooOldJavaMsg = tooOldJavaMsg + " (" + javaRec + " recommended)";
            }
            throw new ConfigurationException(tooOldJavaMsg);
        }
        String confFProdNr = "";
        String confFRev = "";
        ApplicationFile frontFile = null;
        switch (this.type) {
            case 1: {
                this.applicationEntrypointClass = application.getCustomApplInitClass();
                this.applicationName = application.getCustomApplName();
                confFProdNr = application.getCustomApplProdNo();
                confFRev = application.getCustomApplRev();
                this.configurationFile = new ApplicationFile(this.applicationName, "", confFProdNr, confFRev);
                frontFile = new ApplicationFile(fileName, filePath, confFProdNr, confFRev);
                int hash = input.replaceAll("\\W", "").hashCode();
                frontFile.setCheckSum(hash);
                this.referencedXmlFiles.add(frontFile);
                this.SLSUrls = this.securityState.getSLSUrls();
                break;
            }
            case 2: {
                confFProdNr = applConfig.getCustomApplProdNo();
                confFRev = applConfig.getCustomApplRev();
                this.configurationFile = new ApplicationFile(applConfig.getFileName(), filePath, confFProdNr, confFRev);
                break;
            }
            default: {
                LOG.severe("Unexpected configuration file type: should have been TYPE_FRONT or TYPE_BACK", new Object[0]);
            }
        }
        ConfigurationFile confFile = new ConfigurationFile(this.applicationName, this.applicationEntrypointClass);
        confFile.setNEAddress(parentUrl);
        confFile.setSecurityState(this.securityState);
        confFile.setSlsURLs(this.securityState.getSLSUrls());
        confFile.addTheConfigurationFile(this.configurationFile);
        if (frontFile != null) {
            confFile.addAReferredConfigurationFile(frontFile);
        }
        for (EmApplicationFile eFile : emApplicationFiles) {
            appFile = new ApplicationFile(eFile.getFileName(), eFile.getFilePath(), eFile.getFileProdNo(), eFile.getFileRev());
            LOG.finer("ApplicationFile: " + appFile, new Object[0]);
            if (this.applicationJarFiles.containsKey(eFile.getFileName())) {
                throw new ConfigurationException("File \"" + eFile.getFileName() + "\" defined multiple times");
            }
            this.applicationJarFiles.put(eFile.getFileName(), appFile);
            confFile.addApplicationFile(appFile);
        }
        LOG.finer("application wants " + this.applicationJarFiles.size() + " files", new Object[0]);
        for (EmApplicationFile eFile : emCommonApplicationFiles) {
            appFile = new ApplicationFile(eFile.getFileName(), eFile.getFilePath(), eFile.getFileProdNo(), eFile.getFileRev());
            LOG.finer("Common ApplicationFile: ".concat(((Object)appFile).toString()), new Object[0]);
            if (this.commonApplicationJarFiles.containsKey(eFile.getFileName())) {
                throw new ConfigurationException("File \"" + eFile.getFileName() + "\" defined multiple times");
            }
            this.commonApplicationJarFiles.put(eFile.getFileName(), appFile);
            confFile.addCommonApplicationFile(appFile);
        }
        LOG.finer("application wants " + this.applicationJarFiles.size() + " common files", new Object[0]);
        HashMap<EmApplicationSee, String> applicationReferences = new HashMap<EmApplicationSee, String>();
        HashMap<String, Object> xmlFileList = new HashMap<String, Object>();
        for (EmApplicationSee see : emApplicationRefs) {
            urlRef = parentUrl.getProtocol() + ":";
            if (parentUrl.getProtocol().equals("http")) {
                urlRef = urlRef + "//";
            }
            urlRef = urlRef + parentUrl.getAuthority() + see.getFilePath() + "/" + see.getFileName();
            LOG.finer("ApplicationSee: " + see.toString(), new Object[0]);
            applicationReferences.put(see, urlRef);
            xmlFileList.put(urlRef, see);
        }
        LOG.finer("application wants " + applicationReferences.size() + " references", new Object[0]);
        for (EmApplicationSee see : launcherApplicationRef) {
            urlRef = parentUrl.getProtocol() + ":";
            if (parentUrl.getProtocol().equals("http")) {
                urlRef = urlRef + "//";
            }
            urlRef = urlRef + parentUrl.getAuthority() + see.getFilePath() + "/" + see.getFileName();
            applicationReferences.put(see, urlRef);
            xmlFileList.put(urlRef, see);
        }
        LOG.finer("application wants " + xmlFileList.size() + " referenced XML files", new Object[0]);
        for (String urlRef2 : xmlFileList.keySet()) {
            try {
                URL xmlUrl = new URL(urlRef2);
                refAc = new ApplicationConfiguration(xmlUrl, this.cache, this.securityState, false);
                this.launcherFile = refAc.getLauncherFile();
                EmApplicationSee see = (EmApplicationSee)((Object)xmlFileList.put(urlRef2, refAc));
                ApplicationFile af = new ApplicationFile(see.getFileName(), see.getFilePath(), refAc.getConfigurationFile().getProductNumber(), refAc.getConfigurationFile().getRevision());
                confFile.addAReferredConfigurationFile(af);
                int hash = refAc.getConfigFileContent().replaceAll("\\W", "").hashCode();
                af.setCheckSum(hash);
                this.referencedXmlFiles.add(af);
            }
            catch (MalformedURLException e) {
                LOG.warning("Failed to create URL " + urlRef2, new Object[0]);
            }
        }
        for (CustomApplParameters para : applParameters) {
            this.applicationParameters.setProperty(para.getParameterName(), para.getValue());
        }
        for (EmApplicationSee see : emApplicationRefs) {
            urlRef = (String)applicationReferences.get(see);
            refAc = (ApplicationConfiguration)xmlFileList.get(urlRef);
            ApplicationFile af = (ApplicationFile)refAc.applicationJarFiles.get(see.getRefName());
            if (af == null) {
                af = (ApplicationFile)refAc.commonApplicationJarFiles.get(see.getRefName());
                if (af == null) {
                    throw new ConfigurationException("Unable to find <EM_APPLICATION_FILE> or <EM_COMMON_APPLICATION_FILE> for <EM_APPLICATION_SEE REF_NAME=\"" + see.getRefName() + "\" ... >");
                }
                if (this.commonApplicationJarFiles.containsKey(see.getRefName())) {
                    throw new ConfigurationException("File \"" + see.getRefName() + "\" defined multiple times");
                }
                this.commonApplicationJarFiles.put(see.getRefName(), af);
                confFile.addCommonApplicationFile(af);
            } else {
                if (this.applicationJarFiles.containsKey(see.getRefName())) {
                    throw new ConfigurationException("File \"" + see.getRefName() + "\" defined multiple times");
                }
                this.applicationJarFiles.put(see.getRefName(), af);
                confFile.addApplicationFile(af);
            }
            Properties referencedProps = refAc.getApplicationParameters();
            Enumeration<?> e = referencedProps.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (this.applicationParameters.containsKey(propName)) continue;
                this.applicationParameters.setProperty(propName, referencedProps.getProperty(propName));
            }
        }
        LOG.finer("application wants " + this.applicationJarFiles.size() + " files after resolving references", new Object[0]);
        String thisRev = this.getConfigurationFile().getRevision();
        this.applicationParameters.setProperty("CUSTOM_APPL_REV", thisRev);
        for (EmApplicationSee see : launcherApplicationRef) {
            String urlRef3 = (String)applicationReferences.get(see);
            ApplicationConfiguration refAc2 = (ApplicationConfiguration)xmlFileList.get(urlRef3);
            this.launcherFile = refAc2.getLauncherFile();
        }
        for (EmApplicationFile f : launcherApplicationFile) {
            this.launcherFile = new ApplicationFile(f.getFileName(), f.getFilePath(), f.getFileProdNo(), f.getFileRev());
        }
        confFile.setApplicationParameters(this.applicationParameters);
        confFile.setLauncherFile(this.launcherFile);
        ConfigurationFileList.addConfigurationFile(parentUrl.toExternalForm(), confFile);
    }

    private void parseFileToFindOutLauncherRevision(String contentForPartialParsing, URL parentUrl, boolean topLevel) throws ConfigurationException {
        ConfigurationAccess ca = ConfigurationAccessFactory.getConfigurationAccess();
        try {
            ca.setFileContentForPartialParsing(contentForPartialParsing);
        }
        catch (ParserInputEmptyException e) {
            // empty catch block
        }
        Collection<EmApplicationFile> launcherApplicationFile = null;
        Collection<EmApplicationSee> launcherApplicationRef = null;
        CustomApplJavaVersion javaVersion = null;
        try {
            launcherApplicationFile = ca.getEmLauncherFile();
            launcherApplicationRef = ca.getEmLauncherSee();
            javaVersion = ca.getCustomApplJavaVersion();
            if (topLevel && launcherApplicationFile.isEmpty() && launcherApplicationRef.isEmpty()) {
                throw new ConfigurationException("ApplicationConfiguration is faulty: missing both <EM_LAUNCHER_FILE> and <EM_LAUNCHER_SEE> tags");
            }
            if (!launcherApplicationFile.isEmpty() && !launcherApplicationRef.isEmpty()) {
                throw new ConfigurationException("ApplicationConfiguration is faulty: conflicting <EM_LAUNCHER_FILE> and <EM_LAUNCHER_SEE> tags");
            }
        }
        catch (ParserInputEmptyException e1) {
            throw new ConfigurationException("Could not find configuration file", (Throwable)e1);
        }
        catch (ParserException e1) {
            throw new ConfigurationException("Could not parse configuration file", (Throwable)e1);
        }
        String javaCurrent = System.getProperty("java.version");
        String javaMin = javaVersion.getMin();
        String javaRec = javaVersion.getRecommended();
        if (!ApplicationConfiguration.javaVersionPossiblyGreaterThan(javaCurrent, javaMin)) {
            String tooOldJavaMsg = "The Java Runtime Environment version is too old. Minimum: " + javaMin;
            if (ApplicationConfiguration.javaVersionPossiblyGreaterThan(javaRec, javaMin)) {
                tooOldJavaMsg = tooOldJavaMsg + " (" + javaRec + " recommended)";
            }
            throw new ConfigurationException(tooOldJavaMsg);
        }
        HashMap<String, Object> xmlFileList = new HashMap<String, Object>();
        for (EmApplicationSee see : launcherApplicationRef) {
            String urlRef = parentUrl.getProtocol() + ":";
            if (parentUrl.getProtocol().equals("http")) {
                urlRef = urlRef + "//";
            }
            urlRef = urlRef + parentUrl.getAuthority() + see.getFilePath() + "/" + see.getFileName();
            xmlFileList.put(urlRef, see);
        }
        for (String urlRef : xmlFileList.keySet()) {
            try {
                URL xmlUrl = new URL(urlRef);
                ApplicationConfiguration refAc = new ApplicationConfiguration(xmlUrl, this.cache, true, false);
                this.launcherFile = refAc.getLauncherFile();
                xmlFileList.put(urlRef, refAc);
            }
            catch (MalformedURLException e) {
                LOG.warning("Failed to create URL " + urlRef, new Object[0]);
            }
        }
        for (EmApplicationFile f : launcherApplicationFile) {
            this.launcherFile = new ApplicationFile(f.getFileName(), f.getFilePath(), f.getFileProdNo(), f.getFileRev());
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ApplicationFileInterface getLauncherFile() {
        return this.launcherFile;
    }

    protected static boolean javaVersionPossiblyGreaterThan(String big, String small) {
        if (big == null || small == null) {
            return true;
        }
        String[] b = big.split("\\.");
        String[] s = small.split("\\.");
        if (b.length == 0 || s.length == 0) {
            return true;
        }
        int bint = 0;
        int sint = 0;
        for (int i = 0; i < b.length; ++i) {
            boolean sNotNum;
            boolean bNotNum;
            try {
                bint = Integer.parseInt(b[i]);
                bNotNum = false;
            }
            catch (NumberFormatException e) {
                bNotNum = true;
            }
            try {
                sint = Integer.parseInt(s[i]);
                sNotNum = false;
            }
            catch (NumberFormatException e) {
                sNotNum = true;
            }
            if (!bNotNum && !sNotNum) {
                if (bint < sint) {
                    return false;
                }
                if (bint > sint) {
                    return true;
                }
            } else {
                String[] btemp = b[i].split("_");
                String[] stemp = s[i].split("_");
                if (btemp.length > 0 && stemp.length > 0) {
                    try {
                        bint = Integer.parseInt(btemp[0]);
                        sint = Integer.parseInt(stemp[0]);
                        if (sint > bint) {
                            return false;
                        }
                        if (bint > sint) {
                            return true;
                        }
                        if (s.length - 1 > i) {
                            return false;
                        }
                        if (b.length - 1 > i) {
                            return true;
                        }
                        if (btemp.length > 1 && stemp.length == 1) {
                            return true;
                        }
                        if (btemp.length == 1 && stemp.length > 1) {
                            return false;
                        }
                        if (btemp.length == 1 && stemp.length == 1) {
                            return true;
                        }
                        bint = Integer.parseInt(btemp[1]);
                        if (bint > (sint = Integer.parseInt(stemp[1]))) {
                            return true;
                        }
                        if (bint < sint) {
                            return false;
                        }
                    }
                    catch (NumberFormatException e) {
                        return true;
                    }
                }
            }
            if (i < s.length - 1) continue;
            return true;
        }
        return false;
    }

    boolean sameVersion(ApplicationConfiguration that) {
        ApplicationFile[] thatCfgFiles;
        ApplicationFile[] thatFiles;
        if (that == null) {
            return false;
        }
        if (!this.getConfigurationFile().equals(that.getConfigurationFile())) {
            LOG.fine("Difference found in config files:\n  this=" + this.getConfigurationFile().toString() + "\n that=" + that.getConfigurationFile().toString(), new Object[0]);
            return false;
        }
        ApplicationFile[] thisFiles = this.getApplicationFiles().toArray(new ApplicationFile[0]);
        if (thisFiles.length != (thatFiles = that.getApplicationFiles().toArray(new ApplicationFile[0])).length) {
            LOG.fine("File lists have different lengths: this=" + thisFiles.length + " that=" + thatFiles.length, new Object[0]);
            return false;
        }
        for (int i = 0; i < thisFiles.length; ++i) {
            if (thisFiles[i].equals(thatFiles[i])) continue;
            LOG.fine("Difference found:\n this=" + thisFiles[i] + "\n that=" + thatFiles[i], new Object[0]);
            return false;
        }
        ApplicationFile[] thisCfgFiles = this.getConfigurationFiles().toArray(new ApplicationFile[0]);
        if (thisCfgFiles.length != (thatCfgFiles = that.getConfigurationFiles().toArray(new ApplicationFile[0])).length) {
            LOG.fine("Config file lists have different lengths: this=" + thisCfgFiles.length + " that=" + thatCfgFiles.length, new Object[0]);
            return false;
        }
        for (int i = 0; i < thisCfgFiles.length; ++i) {
            if (thisCfgFiles[i].equals(thatCfgFiles[i])) continue;
            LOG.fine("Difference found in cfg files:\n this=" + thisCfgFiles[i] + "\n that=" + thatCfgFiles[i], new Object[0]);
            return false;
        }
        LOG.fine("Files are identical", new Object[0]);
        return true;
    }

    @Override
    public URL getNEAddress() {
        return this.NEAddress;
    }

    public void changeNE(String hostname) throws ConfigurationException {
        if (hostname == null || hostname.equals("")) {
            throw new ConfigurationException("Could not change network element since NEAddress was null/empty");
        }
        try {
            URL url;
            String regexp = "^(((?=(?>.*?::)(?!.*::)))(::)?([0-9A-F]{1,4}::?){0,5}|([0-9A-F]{1,4}:){6})(\u0002([0-9A-F]{1,4}(::?|$)){0,2}|((25[0-5]|(2[0-4]|1\\d|[1-9])?\\d)(\\.|$)){4}|[0-9A-F]{1,4}:[0-9A-F]{1,4})(?<![^:]:|\\.)\\z";
            Matcher match = Pattern.compile(regexp, 2).matcher(hostname);
            if (match.find()) {
                LOG.info("Using methods for ipv6.", new Object[0]);
                url = new URL(this.NEAddress.getProtocol(), hostname, -1, this.NEAddress.getPath());
            } else {
                url = new URL(this.NEAddress.getProtocol() + "://" + hostname + this.NEAddress.getPath());
            }
            this.securityState = new SecurityState(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Could not change network element due to URL fault.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Could not get security state", (Throwable)e);
        }
    }

    public String getApplicationClass() {
        return this.applicationEntrypointClass;
    }

    public String getSLSUrls() {
        return this.SLSUrls;
    }

    @Override
    public URL[] getSoftwareServers() {
        return null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Properties getApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public Collection<ApplicationFileInterface> getApplicationFiles() {
        return this.applicationJarFiles.values();
    }

    @Override
    public Collection<ApplicationFileInterface> getCommonApplicationFiles() {
        return this.commonApplicationJarFiles.values();
    }

    @Override
    public Collection<ApplicationFileInterface> getConfigurationFiles() {
        return this.referencedXmlFiles;
    }

    public SecurityState getSecuritystate() {
        return this.securityState;
    }

    public ApplicationFileInterface getConfigurationFile() {
        return this.configurationFile;
    }

    public String getConfigFileContent() {
        return this.configFileContent;
    }
}

