/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.security.launcher.ApplicationCacheInterface;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.Revision;
import se.ericsson.security.launcher.VersionException;
import se.ericsson.security.launcher.cache.CacheAccessException;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedApplication;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.launcher.cache.CachedFileNotFoundException;
import se.ericsson.security.launcher.cache.CachedJarFile;
import se.ericsson.security.launcher.cache.JarFileVerifier;
import se.ericsson.security.launcher.cache.SWServerList;
import se.ericsson.security.launcher.cache.TrustedCertificateManager;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.cache.VerifyListener;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.DownloadManager;
import se.ericsson.security.launcher.parser.ConfigurationAccess;
import se.ericsson.security.launcher.parser.ConfigurationAccessFactory;
import se.ericsson.security.launcher.parser.ParserException;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.investigator.resource.Resource;
import se.ericsson.security.starter.investigator.resource.ResourceInfo;
import se.ericsson.security.starter.investigator.resource.ResourceInfoFactory;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private static final String firstLauncherCxc = "CXC1721561";
    private static final String[] listOfOldReleasedLaunchersNotToUse = new String[]{"1", "2", "3", "4", "60", "61", "70", "71", "72", "73", "74", "75", "76", "77"};
    private static final String LAUNCHER_JAR_NAME = "launcher.jar";
    private static final String URL_DELIMITER = "/";
    private JarFileVerifier jarFileVerifier = null;
    private PropertyManager pm;
    private DownloadListener downloadListener;
    private DownloadManager downloadManager;
    private VerifyListener verifyListener;
    private SWServerList swServerList;

    public Cache(DownloadListener dl, VerifyListener vl, PropertyManager pm) {
        this.pm = pm;
        this.verifyListener = vl;
        this.downloadManager = new DownloadManager();
        this.downloadListener = dl;
        this.swServerList = new SWServerList(pm);
    }

    public CachedFile getFile(ApplicationFileInterface af, URL source, boolean explicitPath) throws VerifyException, CacheException {
        return this.getFile(af, source, explicitPath, true);
    }

    public CachedFile getFile(ApplicationFileInterface af, URL source, boolean explicitPath, boolean findAlreadyCachedFile) throws VerifyException, CacheException {
        CachedFile cachedFile;
        String reqFileName = af.getName();
        String reqCxc = af.getProductNumber();
        String reqRev = af.getRevision();
        LOG.fine("Requested file " + reqFileName + " with productnumber " + reqCxc + " and revision: " + reqRev, new Object[0]);
        if (reqFileName.equals(LAUNCHER_JAR_NAME) && (cachedFile = this.getLauncherCachedFile(reqCxc, reqRev)) != null) {
            return cachedFile;
        }
        if (findAlreadyCachedFile && (cachedFile = this.getFileFromCache(af, reqFileName, reqCxc, reqRev)) != null) {
            return cachedFile;
        }
        URL nodeUrl = this.constructNodeURL(af, source, explicitPath);
        CachedFile cachedFile2 = this.getFileFromSwServers(af, nodeUrl);
        if (cachedFile2 != null) {
            return cachedFile2;
        }
        return this.getJarFileFromURL(af, nodeUrl);
    }

    private URL constructNodeURL(ApplicationFileInterface af, URL source, boolean explicitPath) throws CacheException {
        URL nodeUrl = null;
        String path = !explicitPath ? this.getRemoteFilePath(af) : source.getPath();
        try {
            nodeUrl = new URL(source, path);
        }
        catch (MalformedURLException e) {
            throw new CacheException(Localizer.getString("download_from_ill_url") + " Directory=" + path + " on host=" + source.toExternalForm(), (Throwable)e);
        }
        return nodeUrl;
    }

    private CachedFile getLauncherCachedFile(String reqCxc, String reqRev) {
        boolean useExecutingLauncher = false;
        if (TmProperty.DISABLE_SECONDARY_LAUNCHER.getBoolean()) {
            useExecutingLauncher = true;
            LOG.fine("Running in testmode and executing Launcher shall continue to execute.", new Object[0]);
        } else if (this.isLauncherOldVersion(reqCxc, reqRev)) {
            useExecutingLauncher = true;
            LOG.warning("Required launcher revision is old. Will try to return CachedFile for executing jar file instead.", new Object[0]);
        }
        if (useExecutingLauncher) {
            try {
                CachedFile thisLauncherCachedFile = this.getCachedFileForExecutingLauncher();
                return thisLauncherCachedFile;
            }
            catch (Exception ex) {
                LOG.warning("Failed to get manifest data from executing launcher. Will continue with a try to load and use the launcher from node." + ex.getMessage(), new Object[0]);
            }
        }
        return null;
    }

    private CachedFile getFileFromCache(ApplicationFileInterface af, String reqFileName, String reqCxc, String reqRev) throws CacheException {
        try {
            LOG.fine("Getting file " + reqFileName + " with productnumber " + reqCxc + " and revision: " + reqRev, new Object[0]);
            CachedFile cf = this.getCachedFile(af);
            LOG.fine("File " + reqFileName + " already in the cache.", new Object[0]);
            return cf;
        }
        catch (CachedFileNotFoundException e) {
            LOG.fine("File " + reqFileName + " not in the cache so it has to be downloaded.", new Object[0]);
        }
        catch (CacheAccessException cae1) {
            LOG.fine("File " + this.getCacheFilePathPreferred(af) + " exists in the cache but with wrong file access. It will be deleted.", new Object[0]);
            try {
                this.deleteFileWithAccessRightProblems(af);
            }
            catch (CacheAccessException cae2) {
                String message = "The file " + this.getCacheFilePathPreferred(af) + " has not neccessary read access. " + "An attempt to delete the file failed. " + "The delete was done with the intention to force a new download of the file from the node, " + "You must modify the file access manually and set read access for all users. ";
                LOG.warning(message + cae2.getMessage(), new Object[0]);
                throw new CacheException(message, (Throwable)cae2);
            }
        }
        return null;
    }

    private boolean isLauncherOldVersion(String reqCxc, String reqRev) {
        boolean requiredRevIsOldVersion = false;
        if (reqCxc.equalsIgnoreCase(firstLauncherCxc)) {
            LOG.fine("Required CXC is the CXC1721561", new Object[0]);
            String[] numberStrs = reqRev.trim().split("[a-zA-Z]");
            if (numberStrs != null && numberStrs.length > 0) {
                int i;
                String firstNumberS = "";
                for (i = 0; i < numberStrs.length && (firstNumberS = numberStrs[i].trim()).length() <= 0; ++i) {
                }
                for (i = 0; i < listOfOldReleasedLaunchersNotToUse.length; ++i) {
                    if (!listOfOldReleasedLaunchersNotToUse[i].equalsIgnoreCase(firstNumberS)) continue;
                    requiredRevIsOldVersion = true;
                    LOG.fine("Found out that required launcher revision is an old one. (" + firstNumberS + ")", new Object[0]);
                    break;
                }
            }
        }
        return requiredRevIsOldVersion;
    }

    private void deleteFileWithAccessRightProblems(ApplicationFileInterface af) throws CacheAccessException {
        String cacheFileName = this.getCacheFilePathPreferred(af);
        File file = new File(cacheFileName);
        try {
            boolean deleted = file.delete();
            if (!deleted) {
                String message = "Can not delete " + cacheFileName + " which has incorrect access permissions. " + "The file must have read permissions for all users.";
                LOG.warning(message, new Object[0]);
                throw new CacheAccessException(message);
            }
            LOG.info("The file " + cacheFileName + " has been deleted.", new Object[0]);
        }
        catch (SecurityException se) {
            String message = "Can not delete " + cacheFileName + " which has incorrect access permissions. " + "The file must have read permissions for all users. " + "A SecurityException occurred when trying to delete the file. ";
            LOG.warning(message + se.getMessage(), new Object[0]);
            throw new CacheAccessException(message, (Throwable)se);
        }
    }

    public CachedFile getFileFromSwServers(ApplicationFileInterface af, URL source) {
        try {
            LOG.fine("SW server URL is " + source.toExternalForm(), new Object[0]);
            this.swServerList.readSWServerList(source);
        }
        catch (CacheException e) {
            LOG.warning("Got cache exception while readingSwServerList", e);
            return null;
        }
        String[] serverlist = this.swServerList.getSWServerList(source);
        LOG.fine("SW servers: " + Arrays.asList(serverlist).toString(), new Object[0]);
        for (int i = 0; i < serverlist.length; ++i) {
            String server = serverlist[i];
            try {
                if (server == null || server.equals("")) continue;
                try {
                    URL swURL = new URL(server + this.getSWServerFilePath(af, server, true));
                    CachedFile result = this.getJarFileFromURL(af, swURL);
                    LOG.fine("Downloaded from SW server: " + server + " (file name: " + af.getName() + ")", new Object[0]);
                    return result;
                }
                catch (IOException e) {
                    LOG.warning("Could not fetch file from SW server. Please check your configuration.", new Object[0]);
                    LOG.warning("The exception when getting file from sw server was: " + e.getMessage() + "\n Caused by: " + e.getCause(), new Object[0]);
                    this.swServerList.quarantineSWServer(server);
                    try {
                        URL swURL = new URL(server + this.getSWServerFilePath(af, server, false));
                        CachedFile result = this.getJarFileFromURL(af, swURL);
                        LOG.fine("Downloaded from SW server: " + server + " (file name: " + af.getName() + ")", new Object[0]);
                        return result;
                    }
                    catch (IOException e2) {
                        LOG.warning("Could not fetch file from SW server. Please check your configuration.", new Object[0]);
                        this.swServerList.quarantineSWServer(server);
                        continue;
                    }
                }
            }
            catch (CacheException e) {
                LOG.fine("This URL was not found when iterating SW servers: " + server, new Object[0]);
            }
        }
        LOG.warning("Could not find the file on any software server. This could mean that the servers are not connectable, or that the file is not present", new Object[0]);
        return null;
    }

    private CachedFile getCachedFile(ApplicationFileInterface af) throws CacheException, CacheAccessException, CachedFileNotFoundException {
        String cacheFileName = this.getCacheFilePathPreferred(af);
        File file = new File(cacheFileName);
        try {
            if (!file.exists()) {
                file = null;
                String message = "File " + cacheFileName + " does not exist in the cache";
                LOG.fine(message, new Object[0]);
                throw new CachedFileNotFoundException(message);
            }
            if (!file.canRead()) {
                String operatingSystem = System.getProperty("os.name");
                LOG.warning(operatingSystem + " Could not read the file: " + cacheFileName, new Object[0]);
                throw new CacheAccessException(cacheFileName + " has not got the necessary read permission.");
            }
        }
        catch (SecurityException secEx) {
            String message = cacheFileName + " has not got the necessary read permissions. " + "SecurityException when accessing the file. ";
            LOG.warning(message + secEx.getMessage(), new Object[0]);
            throw new CacheAccessException(message, (Throwable)secEx);
        }
        CachedJarFile cf = new CachedJarFile(cacheFileName, false);
        return cf;
    }

    public CachedFile getJarFileFromURL(ApplicationFileInterface af, URL source) throws VerifyException, CacheException {
        String cacheFileName = null;
        File tempFile = null;
        String action = "";
        File file = null;
        try {
            action = "Calculating cache directory from ApplicationFileInterface";
            cacheFileName = this.getCacheFilePathPreferred(af);
            LOG.finest("file name in cache: ".concat(cacheFileName), new Object[0]);
            LOG.finest("file name remote: ".concat(this.getRemoteFilePath(af)), new Object[0]);
            LOG.finest("file CXC and version according to ApplicationFileInterface: " + af.getProductNumber() + " " + af.getRevision(), new Object[0]);
            file = new File(cacheFileName);
            action = "Locating source URL for " + cacheFileName;
            if (source == null) {
                LOG.warning("Source not specified.", new Object[0]);
                throw new CacheException("Source not specified.");
            }
            action = "Creating the directories " + file.getParentFile() + " for the file " + af.getName();
            if (file.getParentFile().mkdirs()) {
                action = "Modyfing " + file.getAbsolutePath() + " parent directories";
                this.chmodCreated(file);
                LOG.fine(action + " succeded.", new Object[0]);
            }
            action = "Creating tempfile for " + af.getName();
            tempFile = File.createTempFile("tmp", af.getName(), file.getParentFile());
            tempFile.deleteOnExit();
            LOG.finest("Tempfile: " + tempFile.getAbsolutePath(), new Object[0]);
            action = "Downloading from " + af.getName() + " to the temporary file " + tempFile.getName();
            this.downloadManager.downloadToFile(source, tempFile, this.downloadListener);
            action = "Verifying the productnumber and revision for " + tempFile.getAbsolutePath();
            CachedJarFile cf = new CachedJarFile(tempFile.getAbsolutePath(), true);
            if (!cf.getAttributes().equals(af)) {
                this.deleteFileIfPossible(tempFile);
                String message = action + " failed. \n   Found    : " + cf.getAttributes().getProductNumber() + " " + cf.getAttributes().getRevision() + "\n   Expected : " + af.getProductNumber() + " " + af.getRevision() + "\n   " + tempFile.getName() + " was deleted.";
                if (TmProperty.OVERRIDE_LIB.isSet()) {
                    File overrideJar = new File(TmProperty.OVERRIDE_LIB.getValue(), af.getName());
                    if (overrideJar.canRead()) {
                        LOG.warning("Ignored error: " + message + "\n   Loading jar from " + overrideJar + " instead.", new Object[0]);
                        CachedFile overrideCf = new CachedFile(overrideJar.toString());
                        overrideCf.setAttributes(cf.getAttributes());
                        return overrideCf;
                    }
                    LOG.severe(message + "\n   Also failed to load jar from " + overrideJar, new Object[0]);
                }
                throw new CacheException(message);
            }
            action = "Retrieval of the jar-file verifier for \"launcher.jar\"";
            JarFileVerifier vf = this.getJarFileVerifier();
            LOG.fine(action + " succeded.", new Object[0]);
            action = "Verifying the downloaded jarfile " + af.getName();
            vf.verifyJarFile(tempFile, source);
            LOG.fine(action + " succeded.", new Object[0]);
            if (file.exists()) {
                this.deleteFileIfPossible(tempFile);
            } else {
                action = "Renaming the tempfile " + tempFile.getName() + " to " + file.getName();
                if (!this.renameFile(tempFile, file)) {
                    this.deleteFileIfPossible(tempFile);
                    throw new CacheException(action + " failed.");
                }
                LOG.fine(action + " succeded.", new Object[0]);
                action = "Setting read permission on " + file.getAbsolutePath();
                this.chmodFileForReading(file);
                LOG.fine(action + " succeded.", new Object[0]);
            }
        }
        catch (VerifyException ve) {
            this.deleteFileIfPossible(tempFile);
            String message = action + " failed.\n";
            LOG.warning("Verify exception: " + message + ve.getStackTrace(), new Object[0]);
            throw new VerifyException(message, (Throwable)ve);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            String fileInfo = this.fetchFileInfoIfPossible(tempFile);
            this.deleteFileIfPossible(tempFile);
            String message = action + " failed.\n" + fileInfo;
            LOG.warning("Exception: " + message + e.getStackTrace(), new Object[0]);
            throw new CacheException(message, (Throwable)e);
        }
        return new CachedJarFile(cacheFileName, false);
    }

    private String fetchFileInfoIfPossible(File file) {
        String fileInfo = "";
        String OsName = System.getProperty("os.name");
        try {
            if (file != null && (OsName.indexOf("Sun") != -1 || OsName.indexOf("Linux") != -1)) {
                fileInfo = this.runOsCommand("ls -l -d " + file.getAbsoluteFile());
                fileInfo = fileInfo + this.runOsCommand("ls -l -d " + file.getParent());
                String[] cmd = new String[]{"/bin/bash", "-c", "echo $USER"};
                fileInfo = fileInfo + this.runOsCommand(cmd);
                cmd = new String[]{"/bin/bash", "-c", "echo $GROUP"};
                fileInfo = fileInfo + this.runOsCommand(cmd);
            } else if (file != null && OsName.toLowerCase().indexOf("win") != -1) {
                String[] cmd = new String[]{"cmd.exe", "/c", "dir " + file.getAbsoluteFile()};
                fileInfo = this.runOsCommand(cmd);
            } else {
                if (file == null) {
                    fileInfo = "\nfile not found";
                }
                fileInfo = fileInfo + "\nOsName: " + OsName;
            }
        }
        catch (IOException e) {
            fileInfo = "\nException  while retrieving file info: " + e.getMessage();
        }
        return fileInfo;
    }

    private String runOsCommand(String[] cmd) throws IOException {
        String fileInfo = ">";
        String line = "";
        Process pr = Runtime.getRuntime().exec(cmd);
        BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        for (int i = 0; i < cmd.length; ++i) {
            fileInfo = fileInfo + cmd[i];
        }
        fileInfo = fileInfo + "\n";
        line = br.readLine();
        while (line != null) {
            fileInfo = fileInfo + line + "\n";
            line = br.readLine();
        }
        return fileInfo;
    }

    private String runOsCommand(String cmd) throws IOException {
        String fileInfo = ">";
        String line = "";
        Process pr = Runtime.getRuntime().exec(cmd);
        BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        fileInfo = fileInfo + cmd + "\n";
        line = br.readLine();
        while (line != null) {
            fileInfo = fileInfo + line + "\n";
            line = br.readLine();
        }
        return fileInfo;
    }

    private void chmodFileForReading(File file) throws Exception {
        if (!EmasUtilities.runningOnWindows()) {
            LOG.fine("Setting read access for file " + file.getAbsolutePath(), new Object[0]);
            Runtime rt = Runtime.getRuntime();
            rt.exec("chmod a+r " + file.toString());
        }
    }

    private void chmodCreated(File file) throws CacheAccessException {
        if (!EmasUtilities.runningOnWindows()) {
            Runtime rt = Runtime.getRuntime();
            String parent = file.getParentFile().toString();
            String grandParent = file.getParentFile().getParentFile().toString();
            try {
                rt.exec("chmod 775 " + grandParent);
                rt.exec("chmod 775 " + parent);
            }
            catch (Exception e) {
                String message = "Could not do 'chmod 775' on " + parent + " or on " + grandParent + ". ";
                LOG.warning(message + e.getMessage(), new Object[0]);
                throw new CacheAccessException(message, (Throwable)e);
            }
        }
    }

    public String getConfigurationFileAsString(URL url) throws VersionException, CacheException {
        return this.getConfigurationFileAsString(url, true, true);
    }

    public String getConfigurationFileAsString(URL url, boolean tryResourceFile, boolean findAlreadyCachedFile) throws VersionException, CacheException {
        LOG.info("getConfigurationFileAsString: ".concat(url.toString()), new Object[0]);
        LOG.fine("url: " + url.toString(), new Object[0]);
        String fileAsString = "";
        try {
            URLConnection connection = url.openConnection();
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode == 200) {
                fileAsString = this.downloadManager.downloadToString(url, this.downloadListener);
            } else if (tryResourceFile && (fileAsString = this.getConfigFileContentFromResource(url, this.downloadListener, findAlreadyCachedFile)) == null) {
                throw new CacheException("The file " + url.getFile() + " could not be downloaded.");
            }
            LOG.fine("DONE getConfigurationFileAsString", new Object[0]);
            return fileAsString;
        }
        catch (DownloadException e) {
            throw new VersionException("The configuration file " + url.getFile() + " could not be downloaded.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.fine(e.getMessage(), new Object[0]);
            throw new CacheException("Failed to download configuration file", (Throwable)e);
        }
    }

    public CachedApplication[] prepareApplication(ApplicationCacheInterface applicationConfiguration) throws CacheException {
        Class<?>[] interfaces;
        CachedApplication[] toReturn = new CachedApplication[2];
        CachedApplication application = new CachedApplication();
        CachedApplication commonApplication = new CachedApplication();
        Collection<ApplicationFileInterface> applicationFiles = applicationConfiguration.getApplicationFiles();
        Vector<String> missingFiles = new Vector<String>();
        for (ApplicationFileInterface applicationFile : applicationFiles) {
            try {
                application.add(this.getFile(applicationFile, applicationConfiguration.getNEAddress(), false));
            }
            catch (DownloadException e) {
                missingFiles.add(applicationFile.getName());
                LOG.warning(e.getMessage(), new Object[0]);
            }
        }
        if (!missingFiles.isEmpty()) {
            this.throwExceptionAboutMissingFiles(missingFiles);
        }
        Collection<Object> commonFiles = new ArrayList();
        for (Class<?> clazz : interfaces = applicationConfiguration.getClass().getInterfaces()) {
            if (clazz.getName().indexOf("ApplicationCacheInterface") == -1) continue;
            try {
                clazz.getMethod("getCommonApplicationFiles", null);
                commonFiles = applicationConfiguration.getCommonApplicationFiles();
                break;
            }
            catch (NoSuchMethodException nsme) {
                if (!(applicationConfiguration instanceof ApplicationConfiguration)) continue;
                try {
                    applicationConfiguration.getClass().getMethod("getCommonApplicationFiles", null);
                    commonFiles = ((ApplicationConfiguration)applicationConfiguration).getCommonApplicationFiles();
                    break;
                }
                catch (NoSuchMethodException nsme1) {
                    System.out.println("This should not happen! The class should have contained the method!!!");
                }
            }
        }
        missingFiles.clear();
        for (ApplicationFileInterface applicationFile : commonFiles) {
            try {
                commonApplication.add(this.getFile(applicationFile, applicationConfiguration.getNEAddress(), false));
            }
            catch (DownloadException e) {
                missingFiles.addElement(applicationFile.getName());
                LOG.warning(e.getMessage(), new Object[0]);
            }
        }
        if (!missingFiles.isEmpty()) {
            this.throwExceptionAboutMissingFiles(missingFiles);
        }
        toReturn[0] = application;
        toReturn[1] = commonApplication;
        return toReturn;
    }

    private void throwExceptionAboutMissingFiles(Vector<String> missingFiles) throws CacheException {
        StringBuffer exceptionMessage = new StringBuffer();
        exceptionMessage.append(Localizer.getString("could_not_find_files") + "; " + Localizer.getString("missing") + ": ");
        exceptionMessage.append(missingFiles.toString());
        throw new CacheException(exceptionMessage.toString());
    }

    private String getCacheFilePathPreferred(ApplicationFileInterface file) {
        String productNumber = file.getProductNumber();
        String revision = file.getRevision();
        String fileName = file.getName();
        return this.getFilePathInCache(productNumber, revision, fileName);
    }

    public boolean cacheConfigurationFile(String content, String productNumber, String revision, String fileName) {
        return false;
    }

    private void deleteFileIfPossible(File file) {
        if (file != null) {
            try {
                file.delete();
            }
            catch (Exception e) {
                LOG.fine("Unexpected exception during delete file " + file.getAbsolutePath(), new Object[0]);
            }
        }
    }

    private String getSWServerFilePath(ApplicationFileInterface file, String server, boolean preferred) {
        String fileName;
        String revision;
        String productNumber;
        if (preferred) {
            try {
                productNumber = URLEncoder.encode(Revision.rewritePreferred(file.getProductNumber()), "UTF-8");
                revision = URLEncoder.encode(Revision.rewritePreferred(file.getRevision()), "UTF-8");
                fileName = URLEncoder.encode(Revision.rewritePreferred(file.getName()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("URLEncoder did not recognize UTF-8. " + e, new Object[0]);
                productNumber = Revision.rewritePreferred(file.getProductNumber());
                revision = Revision.rewritePreferred(file.getRevision());
                fileName = Revision.rewritePreferred(file.getName());
            }
        } else {
            try {
                productNumber = URLEncoder.encode(Revision.rewriteAlternative(file.getProductNumber()), "UTF-8");
                revision = URLEncoder.encode(Revision.rewriteAlternative(file.getRevision()), "UTF-8");
                fileName = URLEncoder.encode(Revision.rewriteAlternative(file.getName()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("URLEncoder did not recognize UTF-8: " + e, new Object[0]);
                productNumber = Revision.rewriteAlternative(file.getProductNumber());
                revision = Revision.rewriteAlternative(file.getRevision());
                fileName = Revision.rewriteAlternative(file.getName());
            }
        }
        String separator = URL_DELIMITER;
        String filePath = "";
        if (!server.endsWith(separator)) {
            filePath = separator;
        }
        return filePath + productNumber + separator + revision + separator + fileName;
    }

    private String getFilePathInCache(String productNumber, String revision, String fileName) {
        String separator;
        String dir = this.pm.getString("se.ericsson.security.launcher.cachedirname", true);
        if (!dir.endsWith(separator = System.getProperty("file.separator"))) {
            dir = dir + separator;
        }
        productNumber = Revision.rewritePreferred(productNumber);
        revision = Revision.rewritePreferred(revision);
        return dir + productNumber + separator + revision + separator + fileName;
    }

    private String getRemoteFilePath(ApplicationFileInterface file) {
        String separator;
        String filePath = file.getFilePath();
        if (!filePath.endsWith(separator = URL_DELIMITER)) {
            filePath = filePath + separator;
        }
        return filePath + file.getName();
    }

    public String getConfigurationFileName(String productNumber, String revision) {
        String separator;
        String dirname = this.pm.getString("se.ericsson.security.launcher.cachedirname", true);
        if (!dirname.endsWith(separator = System.getProperty("file.separator"))) {
            dirname = dirname.concat(separator);
        }
        dirname = dirname.concat(productNumber).concat(separator);
        dirname = dirname.concat(revision);
        LOG.fine("dirname: " + dirname, new Object[0]);
        File[] files = new File(dirname).listFiles();
        if (files == null) {
            LOG.warning("Configuration file for " + productNumber + " " + revision + " does not exist.", new Object[0]);
            return null;
        }
        if (files.length != 1) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().startsWith(".")) continue;
                return files[i].getPath();
            }
            return null;
        }
        return files[0].getPath();
    }

    private synchronized JarFileVerifier getJarFileVerifier() throws VerifyException {
        if (this.jarFileVerifier == null) {
            TrustedCertificateManager trustCertManager = new TrustedCertificateManager();
            try {
                X509Certificate[] trustedCerts = trustCertManager.getTrustedcerts();
                this.jarFileVerifier = new JarFileVerifier(trustedCerts, this.verifyListener);
            }
            catch (LauncherException e) {
                LOG.severe(e.getMessage(), new Object[0]);
                LOG.severe("No trusted certificates found. launcher.jar should be signed.", new Object[0]);
                throw new VerifyException("No trusted certificates were found.", (Throwable)e);
            }
        }
        return this.jarFileVerifier;
    }

    private boolean renameFile(File fileToRename, File newFile) {
        for (int i = 0; i < 20; ++i) {
            LOG.fine("renameFile i: " + i, new Object[0]);
            if (fileToRename.renameTo(newFile)) {
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.fine("Interrupted while waiting for gc", new Object[0]);
            }
        }
        return false;
    }

    private CachedFile getCachedFileForExecutingLauncher() throws CacheException {
        LOG.fine("Getting a CachedFile object for the launcher.jar file which contains the code executing just now.", new Object[0]);
        URL installedLauncherUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        String launcherFileNameWithPath = installedLauncherUrl.getPath();
        launcherFileNameWithPath = launcherFileNameWithPath.replaceAll("%20", " ");
        CachedJarFile thisLauncherFile = new CachedJarFile(launcherFileNameWithPath, true);
        LOG.fine("This executable's launcherFileNameWithPath: " + launcherFileNameWithPath, new Object[0]);
        LOG.fine("    file: " + thisLauncherFile.getFileName(), new Object[0]);
        LOG.fine("    cxc: " + thisLauncherFile.getAttributes().getProductNumber(), new Object[0]);
        LOG.fine("    rev: " + thisLauncherFile.getAttributes().getRevision(), new Object[0]);
        return thisLauncherFile;
    }

    private String getConfigFileContentFromResource(URL configFilePath, DownloadListener listener, boolean findAlreadyCachedFile) throws IOException, VersionException, VerifyException, CacheException {
        LOG.entering(configFilePath, listener);
        String configFileAsString = null;
        String protocol = configFilePath.getProtocol();
        String host = configFilePath.getHost();
        int port = configFilePath.getPort();
        URL emapplicationUrl = new URL(protocol, host, port, "/em/emapplications.xml");
        String fileContents = this.downloadManager.downloadToString(emapplicationUrl, listener);
        ArrayList<Resource> resourceList = ResourceInfoFactory.parseResources(fileContents);
        if (resourceList.isEmpty()) {
            LOG.warning("Couldn't get list of resources", new Object[0]);
        }
        for (Resource resource : resourceList) {
            String resStr;
            if (!resource.getResourceType().equals("ConfigFiles")) continue;
            ResourceInfo info = resource.getResourceRef();
            if (info.getProductNumber().equals("") || info.getProductRevision().equals("")) {
                if (info.getDirectoryFile().equals("") || info.getDirectoryPath().equals("")) {
                    throw new CacheException("No product number and revision specified for\n" + info.getResourceFileName() + "." + "\nFilename of the specified reference file isn't set.");
                }
                LOG.info("Product number or revision is empty string. Will get the product data from referenced file instead.", new Object[0]);
                Resource result = this.fetchResourceInformationFromReferredFile(configFilePath, resource);
                resource.setResourceRef(result.getResourceRef());
                resource.setResourcePath(result.getResourcePath());
            } else {
                LOG.info("Product number and revision isn't empty string.", new Object[0]);
            }
            if ((resStr = this.downloadAndGetContentOfResource(configFilePath, resource, findAlreadyCachedFile)) == null) continue;
            configFileAsString = resStr;
            break;
        }
        if (configFileAsString == null) {
            LOG.warning("Return a reference to a emasresources.jar that might work.", new Object[0]);
            configFileAsString = this.downloadAndGetContentOfResource(configFilePath, this.fetchResourceInformationFromReferredFile(configFilePath, this.getDummyResource()), true);
        }
        LOG.exiting(configFileAsString);
        return configFileAsString;
    }

    private Resource getDummyResource() {
        Resource resource = new Resource("ConfigFiles");
        resource.setResourceName("EmasConfigFiles");
        resource.setResourcePath("/cello/emas");
        ResourceInfo resInfo = new ResourceInfo("emasresources.jar");
        resInfo.setDirectoryPath("/cello/emas");
        resInfo.setDirectoryFile("CPPClientConfig.xml");
        resource.setResourceRef(resInfo);
        return resource;
    }

    private String downloadAndGetContentOfResource(URL configFilePath, Resource resource, boolean findAlreadyCachedFile) throws IOException {
        String configFileAsString = null;
        String protocol = configFilePath.getProtocol();
        String host = configFilePath.getHost();
        int port = configFilePath.getPort();
        URL sourceUrl = new URL(protocol, host, port, resource.getResourceRef().getDirectoryPath());
        ApplicationFile af = new ApplicationFile(resource.getResourceRef().getResourceFileName(), resource.getResourceRef().getDirectoryPath(), resource.getResourceRef().getProductNumber(), resource.getResourceRef().getProductRevision());
        try {
            CachedFile cachedFile = this.getFile(af, sourceUrl, false, findAlreadyCachedFile);
            JarFile jar = new JarFile(cachedFile.getFileName());
            configFileAsString = this.getFileInJar(configFilePath.getFile(), jar);
            if (configFileAsString != null) {
                LOG.fine("Found file " + configFilePath.getFile() + " in " + jar.getName(), new Object[0]);
            }
        }
        catch (CacheException e) {
            LOG.warning("The file " + af.getName() + " could not be found.", e);
        }
        return configFileAsString;
    }

    private Resource fetchResourceInformationFromReferredFile(URL configFilePath, Resource res) {
        ResourceInfo info = res.getResourceRef();
        String path = info.getDirectoryPath() + URL_DELIMITER + info.getDirectoryFile();
        String protocol = configFilePath.getProtocol();
        String host = configFilePath.getHost();
        int port = configFilePath.getPort();
        try {
            URL resourceRefUrl = new URL(protocol, host, port, path);
            ConfigurationAccess ca = ConfigurationAccessFactory.getConfigurationAccess();
            ca.setFileContent(this.getConfigurationFileAsString(resourceRefUrl, false, true));
            res = ca.getEmConfiurationSee(res);
        }
        catch (VersionException e) {
            LOG.warning("Got VersionException", e);
        }
        catch (CacheException e) {
            LOG.warning("Got CacheException", e);
        }
        catch (MalformedURLException e) {
            LOG.warning("Got MalformedURLException", e);
        }
        catch (ParserException e) {
            LOG.warning("Got ParserException", e);
        }
        return res;
    }

    private String getFileInJar(String fileName, JarFile jar) throws IOException {
        String jarEntry = null;
        JarEntry entry = jar.getJarEntry(fileName);
        if (entry != null) {
            InputStream instr = jar.getInputStream(entry);
            long size = entry.getSize();
            byte[] byteBuffer = new byte[(int)size];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (instr.read(byteBuffer) != -1) {
                out.write(byteBuffer);
            }
            jarEntry = out.toString();
            try {
                instr.close();
                out.close();
            }
            catch (IOException e) {
                LOG.warning("Stream could not be closed. ", e.getMessage());
            }
        }
        return jarEntry;
    }
}

