/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadFeedbackListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.utils.EmLogger;

public class DownloadManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void downloadToFile(URL remoteFile, File localFile, DownloadListener listener) throws DownloadException, IOException {
        long lastModified;
        block77: {
            IOException ioe22;
            boolean willDoReadOperation;
            String path;
            String remoteFileName;
            boolean failed;
            int port;
            FileOutputStream fos;
            block75: {
                InputStream in;
                block74: {
                    Channel inRbs;
                    block73: {
                        AbstractInterruptibleChannel fileChannel;
                        block72: {
                            LOG.fine("downloadToFile: " + remoteFile.toExternalForm() + " " + localFile, new Object[0]);
                            URLConnection urlConnection = null;
                            in = null;
                            fos = null;
                            lastModified = -1L;
                            port = -1;
                            failed = false;
                            remoteFileName = remoteFile.toExternalForm();
                            path = "";
                            willDoReadOperation = true;
                            fileChannel = null;
                            inRbs = null;
                            try {
                                LOG.fine("Opening connection to url: " + remoteFile.toExternalForm(), new Object[0]);
                                urlConnection = remoteFile.openConnection();
                                urlConnection.setUseCaches(false);
                                try {
                                    path = remoteFile.getFile();
                                    port = remoteFile.getPort();
                                    if (listener instanceof DownloadFeedbackListener) {
                                        ((DownloadFeedbackListener)((Object)listener)).connecting(remoteFile.getHost() + (port != -1 ? String.valueOf(port) : ""), path.substring(path.lastIndexOf("/") + 1));
                                    }
                                    urlConnection.connect();
                                }
                                catch (IOException e) {
                                    LOG.warning("Could not connect to: " + remoteFile.getHost(), new Object[0]);
                                    IOException resentExc = new IOException("Could not connect to node " + remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : "") + " to download " + path);
                                    resentExc.setStackTrace(e.getStackTrace());
                                    resentExc.initCause(e);
                                    throw resentExc;
                                }
                                if (urlConnection instanceof HttpURLConnection) {
                                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                                    lastModified = httpURLConnection.getLastModified();
                                    int responseCode = httpURLConnection.getResponseCode();
                                    if (responseCode != 200) {
                                        failed = true;
                                        if (listener instanceof DownloadFeedbackListener) {
                                            ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                        } else {
                                            listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                                        }
                                        LOG.fine("HTTP Code: " + responseCode, new Object[0]);
                                        if (responseCode == 404) {
                                            throw new FileNotFoundException("File " + remoteFileName + " not found on server");
                                        }
                                        throw new DownloadException("Failed to download " + remoteFileName + ". HTTP Code: " + responseCode);
                                    }
                                }
                                int totalLength = urlConnection.getContentLength();
                                in = urlConnection.getInputStream();
                                fos = new FileOutputStream(localFile);
                                inRbs = Channels.newChannel(in);
                                ByteBuffer bb = ByteBuffer.allocate(32768);
                                fileChannel = fos.getChannel();
                                int progress = 0;
                                int read = 0;
                                while ((read = inRbs.read(bb)) >= 0) {
                                    bb.flip();
                                    willDoReadOperation = false;
                                    ((FileChannel)fileChannel).write(bb);
                                    bb.clear();
                                    willDoReadOperation = true;
                                    listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                                }
                                willDoReadOperation = false;
                                Object var21_25 = null;
                                if (failed) break block72;
                            }
                            catch (Throwable throwable) {
                                block84: {
                                    IOException ioe22;
                                    Object var21_26 = null;
                                    if (!failed) {
                                        if (listener instanceof DownloadFeedbackListener) {
                                            ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                        } else {
                                            listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                        }
                                    }
                                    if (fileChannel != null) {
                                        try {
                                            try {
                                                fileChannel.close();
                                            }
                                            catch (IOException ioe22) {
                                                LOG.warning("Failed to close fileChannel.", new Object[0]);
                                                Object var24_31 = null;
                                                in = null;
                                            }
                                            Object var24_30 = null;
                                            in = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var24_32 = null;
                                            in = null;
                                            throw throwable2;
                                        }
                                    }
                                    if (inRbs != null) {
                                        try {
                                            try {
                                                inRbs.close();
                                            }
                                            catch (IOException ioe22) {
                                                LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                                Object var26_41 = null;
                                                in = null;
                                            }
                                            Object var26_40 = null;
                                            in = null;
                                        }
                                        catch (Throwable throwable3) {
                                            Object var26_42 = null;
                                            in = null;
                                            throw throwable3;
                                        }
                                    }
                                    if (in != null) {
                                        try {
                                            try {
                                                in.close();
                                            }
                                            catch (IOException ioe22) {
                                                LOG.warning("Failed to close inputstream.", new Object[0]);
                                                Object var28_49 = null;
                                                in = null;
                                            }
                                            Object var28_48 = null;
                                            in = null;
                                        }
                                        catch (Throwable throwable4) {
                                            Object var28_50 = null;
                                            in = null;
                                            throw throwable4;
                                        }
                                    }
                                    if (fos != null) {
                                        fos.close();
                                        Object var30_56 = null;
                                        try {
                                            if (failed && localFile.exists()) {
                                                LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                                boolean deleteOk = localFile.delete();
                                                if (!deleteOk) {
                                                    LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                }
                                            }
                                        }
                                        catch (SecurityException e) {
                                            LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                        }
                                        fos = null;
                                        {
                                            break block84;
                                            catch (IOException ioe22) {
                                                LOG.warning("Failed to close outputstream.", new Object[0]);
                                                Object var30_57 = null;
                                                try {
                                                    if (failed && localFile.exists()) {
                                                        LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                                        boolean deleteOk = localFile.delete();
                                                        if (!deleteOk) {
                                                            LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                        }
                                                    }
                                                }
                                                catch (SecurityException e) {
                                                    LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                }
                                                fos = null;
                                            }
                                        }
                                        catch (Throwable throwable5) {
                                            Object var30_58 = null;
                                            try {
                                                if (failed && localFile.exists()) {
                                                    LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                                    boolean deleteOk = localFile.delete();
                                                    if (!deleteOk) {
                                                        LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                    }
                                                }
                                            }
                                            catch (SecurityException e) {
                                                LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                            }
                                            fos = null;
                                            throw throwable5;
                                        }
                                    }
                                }
                                throw throwable;
                            }
                            if (listener instanceof DownloadFeedbackListener) {
                                ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                            } else {
                                listener.finished(path.substring(path.lastIndexOf("/") + 1));
                            }
                        }
                        if (fileChannel != null) {
                            try {
                                try {
                                    fileChannel.close();
                                }
                                catch (IOException ioe22) {
                                    LOG.warning("Failed to close fileChannel.", new Object[0]);
                                    Object var24_28 = null;
                                    in = null;
                                    break block73;
                                }
                                Object var24_27 = null;
                                in = null;
                            }
                            catch (Throwable throwable) {
                                Object var24_29 = null;
                                in = null;
                                throw throwable;
                            }
                        }
                    }
                    if (inRbs != null) {
                        try {
                            try {
                                inRbs.close();
                            }
                            catch (IOException ioe22) {
                                LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                Object var26_38 = null;
                                in = null;
                                break block74;
                            }
                            Object var26_37 = null;
                            in = null;
                        }
                        catch (Throwable throwable) {
                            Object var26_39 = null;
                            in = null;
                            throw throwable;
                        }
                    }
                }
                if (in != null) {
                    try {
                        try {
                            in.close();
                        }
                        catch (IOException ioe22) {
                            LOG.warning("Failed to close inputstream.", new Object[0]);
                            Object var28_46 = null;
                            in = null;
                            break block75;
                        }
                        Object var28_45 = null;
                        in = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_47 = null;
                        in = null;
                        throw throwable;
                    }
                }
            }
            if (fos != null) {
                fos.close();
                Object var30_53 = null;
                try {
                    if (failed && localFile.exists()) {
                        LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                        boolean deleteOk = localFile.delete();
                        if (!deleteOk) {
                            LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                }
                catch (SecurityException e) {
                    LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                }
                fos = null;
                {
                    break block77;
                    catch (IOException ioe22) {
                        LOG.warning("Failed to close outputstream.", new Object[0]);
                        Object var30_54 = null;
                        try {
                            if (failed && localFile.exists()) {
                                LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                boolean deleteOk = localFile.delete();
                                if (!deleteOk) {
                                    LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                        }
                        catch (SecurityException e) {
                            LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                        fos = null;
                        break block77;
                    }
                }
                catch (Throwable throwable) {
                    Object var30_55 = null;
                    try {
                        if (failed && localFile.exists()) {
                            LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                            boolean deleteOk = localFile.delete();
                            if (!deleteOk) {
                                LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                    }
                    catch (SecurityException e) {
                        LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                    }
                    fos = null;
                    throw throwable;
                }
            }
            break block77;
            {
                catch (IOException e) {
                    failed = true;
                    String message = !willDoReadOperation ? "Failed to write data to " + localFile.getAbsolutePath() + " during download from " + remoteFileName : "Failed reading data from " + remoteFileName + " during download to " + localFile.getAbsolutePath();
                    LOG.severe(message, new Object[0]);
                    if (listener instanceof DownloadFeedbackListener) {
                        ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                    } else {
                        listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                    }
                    throw new DownloadException(message, (Throwable)e);
                }
            }
        }
        if (lastModified > 0L && localFile.isFile() && !localFile.setLastModified(lastModified)) {
            LOG.warning("Failed to set last modified of " + localFile, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadToString(URL remoteFile, DownloadListener listener) throws DownloadException, IOException {
        String string;
        InputStream in;
        block24: {
            LOG.fine("remoteFile: " + remoteFile.toString(), new Object[0]);
            LOG.fine("downloadToString: " + remoteFile.toExternalForm(), new Object[0]);
            URLConnection urlConnection = null;
            in = null;
            int port = -1;
            boolean failed = false;
            String remoteFileName = remoteFile.toExternalForm();
            String path = "";
            ReadableByteChannel inRbs = null;
            StringBuffer strBuffCont = null;
            try {
                try {
                    HttpURLConnection httpURLConnection;
                    int responseCode;
                    LOG.fine("Opening connection to url: " + remoteFile.toExternalForm(), new Object[0]);
                    urlConnection = remoteFile.openConnection();
                    urlConnection.setUseCaches(false);
                    try {
                        path = remoteFile.getFile();
                        port = remoteFile.getPort();
                        LOG.fine("path: " + path, new Object[0]);
                        LOG.fine("port: " + port, new Object[0]);
                        if (listener instanceof DownloadFeedbackListener) {
                            ((DownloadFeedbackListener)((Object)listener)).connecting(remoteFile.getHost() + (port != -1 ? String.valueOf(port) : ""), path.substring(path.lastIndexOf("/") + 1));
                        }
                        urlConnection.connect();
                        LOG.fine("Done urlConnection.connect()", new Object[0]);
                    }
                    catch (IOException e) {
                        LOG.warning("Could not connect to: " + remoteFile.getHost(), new Object[0]);
                        IOException resentExc = new IOException("Could not connect to node " + remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : "") + " to download " + path);
                        resentExc.setStackTrace(e.getStackTrace());
                        resentExc.initCause(e);
                        throw resentExc;
                    }
                    if (urlConnection instanceof HttpURLConnection && (responseCode = (httpURLConnection = (HttpURLConnection)urlConnection).getResponseCode()) != 200) {
                        failed = true;
                        if (listener instanceof DownloadFeedbackListener) {
                            ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                        } else {
                            listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                        }
                        LOG.fine("HTTP Code: " + responseCode, new Object[0]);
                        if (responseCode != 404) throw new DownloadException("Failed to download " + remoteFileName + ". HTTP Code: " + responseCode);
                        throw new FileNotFoundException("File " + remoteFileName + " not found on server");
                    }
                    int totalLength = urlConnection.getContentLength();
                    in = urlConnection.getInputStream();
                    ByteBuffer bb = ByteBuffer.allocate(4096);
                    Charset charset = Charset.forName("UTF-8");
                    CharsetDecoder decoder = charset.newDecoder();
                    CharBuffer charBuffer = null;
                    inRbs = Channels.newChannel(in);
                    strBuffCont = new StringBuffer();
                    int progress = 0;
                    int read = 0;
                    while ((read = inRbs.read(bb)) >= 0) {
                        bb.flip();
                        charBuffer = decoder.decode(bb);
                        strBuffCont.append(charBuffer.toString());
                        bb.clear();
                        listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                    }
                    string = strBuffCont.toString();
                    Object var20_26 = null;
                    if (failed) break block24;
                }
                catch (IOException e) {
                    failed = true;
                    String message = "Failed reading data from " + remoteFileName;
                    LOG.severe(message, new Object[0]);
                    if (!(listener instanceof DownloadFeedbackListener)) {
                        listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                        throw new DownloadException(message, (Throwable)e);
                    }
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                    throw new DownloadException(message, (Throwable)e);
                }
                catch (Exception e) {
                    throw new DownloadException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var20_27 = null;
                if (!failed) {
                    if (listener instanceof DownloadFeedbackListener) {
                        ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                    } else {
                        listener.finished(path.substring(path.lastIndexOf("/") + 1));
                    }
                }
                if (in == null) throw throwable;
                try {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        LOG.warning("Failed to close inputstream.", new Object[0]);
                        Object var23_32 = null;
                        in = null;
                        throw throwable;
                    }
                    Object var23_31 = null;
                    in = null;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var23_33 = null;
                    in = null;
                    throw throwable2;
                }
            }
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
            } else {
                listener.finished(path.substring(path.lastIndexOf("/") + 1));
            }
        }
        if (in == null) return string;
        try {}
        catch (Throwable throwable) {
            Object var23_30 = null;
            in = null;
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            LOG.warning("Failed to close inputstream.", new Object[0]);
            return string;
        }
        in.close();
        return string;
    }

    public InputStream downloadToInputStream(URL remoteFile) throws DownloadException {
        try {
            InputStream is = remoteFile.openConnection().getInputStream();
            return is;
        }
        catch (IOException e) {
            throw new DownloadException("Could not download: " + remoteFile.toExternalForm(), (Throwable)e);
        }
    }
}

