/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

import se.ericsson.security.launcher.eprops.AbstractionLevel;
import se.ericsson.security.launcher.eprops.EKey;

public interface EKEY {
    public static final AbstractionLevel.PresentationLevel PL_MESSAGE = AbstractionLevel.PresentationLevel.MESSAGE;
    public static final AbstractionLevel.PresentationLevel PL_DETAIL = AbstractionLevel.PresentationLevel.DETAIL;
    public static final AbstractionLevel.PresentationLevel PL_NONE = AbstractionLevel.PresentationLevel.NONE;
    public static final AbstractionLevel AL_CAUSAL_USER = new AbstractionLevel("User Level - High", PL_MESSAGE, 100, "Causual user");
    public static final AbstractionLevel AL_PROFESIONAL_USER = new AbstractionLevel("User Level - Detailed", PL_MESSAGE, 200, "Professional user");
    public static final AbstractionLevel AL_DESIGNER = new AbstractionLevel("Designer Level", 1000, "Designer abstraction level");
    public static final AbstractionLevel AL_ENVIRONMENT = new AbstractionLevel("Execution Environment", 1100, "Execution environment for the executing program");
    public static final AbstractionLevel AL_REVISION_INFORMATION = new AbstractionLevel("Revision information", 2000, "Revision information from currently connected node");
    public static final AbstractionLevel AL_STACK_TRACES = new AbstractionLevel("Stack traces", AbstractionLevel.PresentationLevel.DETAIL, 2100, "Stackdump from current error");
    public static final AbstractionLevel AL_OTHER = new AbstractionLevel("Other", AbstractionLevel.PresentationLevel.NONE, 3000, "Other");
    public static final AbstractionLevel AL_HIDDEN = new AbstractionLevel("Hidden", AbstractionLevel.PresentationLevel.NONE, 100000, "Should not be part of error messages");
    public static final EKey PROBLEM_USER_LEVEL = new EKey("Problem", AL_CAUSAL_USER, "A description of the problem that caused the error");
    public static final EKey LIKELY_REASON = new EKey("Likely reason", AL_PROFESIONAL_USER, "The likely reason for the problem that caused the error");
    public static final EKey RECOMMENDED_USER_ACTION = new EKey("Recommendation", AL_PROFESIONAL_USER, "Possible workaround for the problem");
    public static final EKey INPUT_FILE = new EKey("Input file", AL_PROFESIONAL_USER, "The input file involved in the error");
    public static final EKey OUTPUT_FILE = new EKey("Output file", AL_PROFESIONAL_USER, "The output file involved in the error");
    public static final EKey IP_ADDRESS = new EKey("IP Address", AL_PROFESIONAL_USER, "The IP Address of the connected node");
    public static final EKey APPLICATION = new EKey("Application", AL_PROFESIONAL_USER, "The application where the error occurred");
    public static final EKey PROGRESS = new EKey("Progress", AL_PROFESIONAL_USER, "The last reported progress message");
    public static final EKey ACTION = new EKey("Failing action", AL_PROFESIONAL_USER, "The action that failed");
    public static final EKey MO = new EKey("ManagedObject", AL_PROFESIONAL_USER, "The Logical Distinguished Name (LDN) of the MO that was involved in the error");
    public static final EKey MOM_URL = new EKey("MOM_URL", AL_PROFESIONAL_USER, "URL to MOM on the node, used by the application");
    public static final EKey DTD_URL = new EKey("DTD_URL", AL_PROFESIONAL_USER, "URL to MOM DTD on the node, used by the application");
    public static final EKey MOM_PATH = new EKey("MOM_PATH", AL_PROFESIONAL_USER, "Path in cach to MOM used by the application");
    public static final EKey DTD_PATH = new EKey("DTD_PATH", AL_PROFESIONAL_USER, "Path in cach to MOM used by the application");
    public static final EKey MOM_VER = new EKey("MOM_VER", AL_PROFESIONAL_USER, "Version of MOM used by the application");
    public static final EKey ADDITIONAL_INFO = new EKey("Additional Info", AL_PROFESIONAL_USER, "Additional information related to the error");
    public static final EKey PROBLEM_DESIGNER_LEVEL = new EKey("Problem, Low level", AL_DESIGNER, "The problem that caused the error");
    public static final EKey MIB = new EKey("MIB", AL_DESIGNER, "The MIB file used when connecting to simulated node");
    public static final EKey MOM_FOR_MIB = new EKey("MOM_FOR_MIB", AL_DESIGNER, "The MOM file used when parsing the MIB of a simulated node");
    public static final EKey BAD_VALUE_DESCRIPTION = new EKey("Bad value - Description", AL_DESIGNER, "The type and name of the bad value");
    public static final EKey BAD_VALUE_EXPECTED = new EKey("Bad value - Expected", AL_DESIGNER, "The expected value");
    public static final EKey BAD_VALUE_ACTUAL = new EKey("Bad value - Actual", AL_DESIGNER, "The actual value");
    public static final EKey JAVA_METHOD = new EKey("Failing method", AL_DESIGNER, "The name of the failing java method");
    public static final EKey JAVA_PROBLEM = new EKey("Failing method  - Problem", AL_DESIGNER, "The problem on java method level");
    public static final EKey JAVA_PARAMS = new EKey("Failing Method  - Params", AL_DESIGNER, "Parameters for the failing java method");
    public static final EKey JAVA_INFO = new EKey("Failing Method  - Additional info", AL_DESIGNER, "Additional information on method level");
    public static final EKey MO_OP = new EKey("Failing MoOp", AL_DESIGNER, "The MO operation that failed");
    public static final EKey MO_OP_PROBLEM = new EKey("Failing MoOp    - Problem", AL_DESIGNER, "The problem on MO operation level");
    public static final EKey MO_OP_PARAMS = new EKey("Failing MoOp    - Params", AL_DESIGNER, "The parameters to the MO operation");
    public static final EKey MO_OP_INFO = new EKey("Failing MoOp    - Additional info", AL_DESIGNER, "Additional info to the MO operation");
    public static final EKey NODE_TYPE = new EKey("Node Type", AL_ENVIRONMENT, "The type of the connected node");
    public static final EKey HOSTNAME = new EKey("Host Name", AL_ENVIRONMENT, "The IP address or DNS name used to connect to the node");
    public static final EKey RECONNECT_IP_ADDRESS = new EKey("Reconnect IP Address", AL_ENVIRONMENT, "The IP address or DNS name used in the last attempt to reconnect to the node");
    public static final EKey ENV_DATE_TIME = new EKey("Date, time and timezone", AL_ENVIRONMENT, "The date, time (and timezone?) when the error occured");
    public static final EKey ENV_USER = new EKey("User ID", AL_ENVIRONMENT, "The user ID of the logged on user");
    public static final EKey ENV_GROUPS = new EKey("User groups", AL_ENVIRONMENT, "The user groups that the logged on user belongs to");
    public static final EKey ENV_LOCAL_HOST = new EKey("HOST", AL_ENVIRONMENT, "The hostname of the computer we are executing on");
    public static final EKey ENV_LOCAL_DISPLAY = new EKey("DISPLAY", AL_ENVIRONMENT, "The value of the DISPLAY environment variable of the computer we are executing on");
    public static final EKey ENV_COMMAND_LINE = new EKey("Command line", AL_ENVIRONMENT, "The command line arguments used to start this program");
    public static final EKey ENV_INSTALL_DIR = new EKey("Install dir", AL_ENVIRONMENT, "The install directory of this program");
    public static final EKey ENV_CASHE_DIR = new EKey("Cache dir", AL_ENVIRONMENT, "The directory that this program uses to cache files from the node");
    public static final EKey ENV_CLASSPATH = new EKey("java.class.path", AL_ENVIRONMENT, "The System.Property java.class.path");
    public static final EKey ENV_EXT_DIRS = new EKey("java.ext.dirs", AL_ENVIRONMENT, "The System.Property java.ext.dirs");
    public static final EKey ENV_TESTMODE_CFG_FILES = new EKey("TESTMODE_CFG_FILES", AL_ENVIRONMENT, "The environment variable that controls LauncherTestMode");
    public static final EKey ENV_TESTMODE_CFG = new EKey("TESTMODE_CFG", AL_ENVIRONMENT, "The configuration that controls LauncherTestMode");
    public static final EKey ENV_OTHER_ENV = new EKey("OTHER_ENV", AL_ENVIRONMENT, "Other additional environment variables of interest.");
    public static final EKey ENV_OTHER_PROP = new EKey("OTHER_ENV", AL_ENVIRONMENT, "Other additional System Properties of interest.");
    public static final EKey REV_UP = new EKey("Upgrade Package Revision", AL_REVISION_INFORMATION, "The CXP number and revision of the Upgrade Package currently executing on the node");
    public static final EKey REV_CV_CURRENT = new EKey("Current Configuration Version", AL_REVISION_INFORMATION, "The name of the Configuration Version (CV) that was executing when the error occurred");
    public static final EKey REV_CV_ROLLBACK = new EKey("Roll-back Configuration Version", AL_REVISION_INFORMATION, "The name of the last created roll-back Configuration Version (CV)");
    public static final EKey REV_CV_INITIAL = new EKey("Initial Configuration Version", AL_REVISION_INFORMATION, "");
    public static final EKey REV_OS_VERSION = new EKey("OS version", AL_REVISION_INFORMATION, "The type and version of the Operating System that we are executing on");
    public static final EKey REV_JAVA_VERSION = new EKey("Java version", AL_REVISION_INFORMATION, "The version of the JVM that we are executing on");
    public static final EKey REV_JAR_FILES = new EKey("Jar file revisions", AL_REVISION_INFORMATION, "The product number and revision of the load modules started when the error occured");
    public static final EKey REV_MOM = new EKey("MOM file", AL_REVISION_INFORMATION, "MOM download path, MOM Revision and DTD revision");
    public static final EKey CAUGHT_EXCEPTION = new EKey("Caught Exception", AL_STACK_TRACES, "Stack trace of the exception that caused the error");
    public static final EKey STACK_OF_STARTING_THREAD = new EKey("Starting thread", AL_STACK_TRACES, "Stack trace from the thread that started the crashed thread");
    public static final EKey EXCEPTION_THAT_CAUSED_RETRY = new EKey("Exception that caused retry", AL_STACK_TRACES, "Stack trace of the original exception that caused the retry");
    public static final EKey INTERNAL_ERROR = new EKey("INTERNAL ERROR", AL_CAUSAL_USER, "Type of the unhandled, unexpected programming error that occured");
    public static final boolean PREFER_DEEPEST = true;
}

