/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.testmode;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.testmode.TmException;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmTestMode;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.launcher.util.PropertyConstants;
import se.ericsson.security.utils.CliArguments;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmPropertiesLoader {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final String CONFIG_FILES = "TESTMODE_CFG_FILES";
    private static final String ROOT_DIR_TOKEN = "%ROOT_DIR%";
    private static TreeMap<TmProperty, String> usedProperties = new TreeMap();

    public static void loadProperties() throws TmException {
        Properties cliProperties = CliArguments.CLI_ARGUMENTS.getProperties();
        EProps rev = EProps.getRevisionProperties();
        EProps ep = new EProps();
        try {
            ep.put(EKEY.ACTION, "Loading testmode properties from files defined by environment variable");
            String configFilesStr = System.getenv(CONFIG_FILES);
            if (configFilesStr != null) {
                rev.set(EKEY.ENV_TESTMODE_CFG_FILES, "From ENV : TESTMODE_CFG_FILES=" + configFilesStr);
                ep.set(EKEY.ENV_TESTMODE_CFG_FILES, "From ENV : TESTMODE_CFG_FILES=" + configFilesStr);
                TmPropertiesLoader.loadPropertiesFromFile("FILE (environment)", configFilesStr);
            }
            ep.put(EKEY.ACTION, "Loading testmode properties from files defined on command line");
            configFilesStr = cliProperties.getProperty(CONFIG_FILES);
            if (configFilesStr != null) {
                CliArguments.CLI_ARGUMENTS.removeProperty(CONFIG_FILES);
                rev.append(EKEY.ENV_TESTMODE_CFG_FILES, "\n   ", "From cmdline : " + configFilesStr);
                TmPropertiesLoader.loadPropertiesFromFile("FILE (property)", configFilesStr);
            }
            ep.put(EKEY.ACTION, "Removing parsed testmode arguments from command line arguments");
            ArrayList<String> validProperties = TmPropertiesLoader.storeAllValidProperties(cliProperties, "CLI", null);
            CliArguments.CLI_ARGUMENTS.removeProperties(validProperties);
            TmPropertiesLoader.setPropertiesAccordingToTestMode();
            String resultingConfig = TmProperty.toStringAll();
            LOG.finest(TmUtilities.getLogMessage("Loaded properties from config files and CLI arguments:\n   " + resultingConfig), new Object[0]);
            rev.put(EKEY.ENV_TESTMODE_CFG, "LauncherTestMode configuration: " + resultingConfig);
        }
        catch (Exception e) {
            ep.put(EKEY.PROBLEM_USER_LEVEL, "Failed loading configuration data at startup");
            ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "Failed parsing LauncherTestMode configuration data");
            ep.put(EKEY.JAVA_INFO, "Loaded so far : " + TmProperty.toStringAll());
            throw new TmException(null, ep, e);
        }
    }

    private static void loadPropertiesFromFile(String source, String filesStr) throws TmException {
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Load test mode config from file");
        try {
            String[] configFiles;
            for (String configFile : configFiles = filesStr.split(",")) {
                ep.put(EKEY.INPUT_FILE, configFile);
                FileInputStream fis = new FileInputStream(configFile);
                Properties properties = new Properties();
                properties.load(fis);
                ep.put(EKEY.ACTION, "Validate and store all test mode config from file");
                TmPropertiesLoader.storeAllValidProperties(properties, source, configFile);
            }
        }
        catch (IOException e) {
            LOG.finest(TmUtilities.getLogMessage("Failed loading test mode properties from file: '" + (String)ep.get(EKEY.INPUT_FILE) + "'"), e);
            throw new TmException("Failed loading test mode properties from file'", ep, e);
        }
    }

    private static ArrayList<String> storeAllValidProperties(Properties properties, String source, String configFile) throws TmException {
        ArrayList<String> validPropertyKeys = new ArrayList<String>();
        for (Object tmpKey : properties.keySet()) {
            TmProperty tmProperty;
            String key = (String)tmpKey;
            String value = properties.getProperty(key);
            if (value.contains(ROOT_DIR_TOKEN)) {
                value = value.replace(ROOT_DIR_TOKEN, PropertyConstants.PROPERTY_ROOT);
            }
            if ((tmProperty = TmPropertiesLoader.storeValue(key, value)) == null) continue;
            validPropertyKeys.add(key);
            TmPropertiesLoader.storeLogInfo(tmProperty, source, configFile);
        }
        return validPropertyKeys;
    }

    private static TmProperty storeValue(String key, String value) throws TmException {
        try {
            TmProperty tmProperty = Enum.valueOf(TmProperty.class, key);
            tmProperty.setValue(true, value);
            return tmProperty;
        }
        catch (IllegalArgumentException e) {
            LOG.finest(TmUtilities.getLogMessage("Property '" + key + "' is not recognized as a TESTMODE property"), new Object[0]);
            return null;
        }
    }

    private static void storeLogInfo(TmProperty semlaProperty, String source, String file) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n      ");
        sb.append(source);
        if (file != null) {
            sb.append("\n      ");
            sb.append(file);
        }
        usedProperties.put(semlaProperty, sb.toString());
    }

    private static void setPropertiesAccordingToTestMode() {
        if (!TmProperty.TEST_MODE.isSet()) {
            return;
        }
        switch (TmTestMode.getEnum(TmProperty.TEST_MODE.getValue())) {
            case BLACK: {
                TmProperty.HTTP_ROOT.reset();
                TmProperty.MIB.reset();
                TmProperty.MOM.reset();
                TmProperty.DISABLE_JARS.setValue(false, "false");
                TmProperty.DISABLE_SECONDARY_LAUNCHER.setValue(false, "false");
                TmProperty.DISABLE_SPLASH_WINDOW.setValue(false, "false");
                TmProperty.OVERRIDE_LIB.setValue(false, "");
                break;
            }
            case COMMIT: {
                TmProperty.HTTP_ROOT.setValue(false, "");
                TmProperty.MIB.setValue(false, "");
                TmProperty.MOM.setValue(false, "");
                TmProperty.DISABLE_JARS.setValue(false, "true");
                TmProperty.DISABLE_SECONDARY_LAUNCHER.setValue(false, "true");
                TmProperty.DISABLE_SPLASH_WINDOW.setValue(false, "true");
                TmProperty.OVERRIDE_LIB.setValue(false, "");
                break;
            }
            case ECLIPSE: {
                TmProperty.HTTP_ROOT.setValue(false, "");
                TmProperty.MIB.setValue(false, "");
                TmProperty.MOM.setValue(false, "");
                TmProperty.SEMLA.setValue(false, "");
                TmProperty.DISABLE_JARS.setValue(false, "true");
                TmProperty.DISABLE_SECONDARY_LAUNCHER.setValue(false, "true");
                TmProperty.DISABLE_SPLASH_WINDOW.setValue(false, "false");
                break;
            }
        }
    }
}

