/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.ui.TableSorter;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.starter.investigator.EmApplicationInfoFactory;
import se.ericsson.security.starter.investigator.NodeType;
import se.ericsson.security.starter.investigator.NodeTypeInvestigator;
import se.ericsson.security.starter.investigator.resource.ResourceInfo;
import se.ericsson.security.starter.investigator.resource.ResourceInfoFactory;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEAddressDialog
extends JFrame
implements ActionListener,
WindowListener {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final long serialVersionUID = -4618786069555287546L;
    private static final String HTTP = "http";
    private static final String PROTOCOL_ADDRESS_DIVIDER = "://";
    private int FAVO_PANE = 0;
    private int ALL_PANE = 1;
    private final int FAULTY_PANE = -1;
    private final String availableState = "Available";
    private final String notAvailableState = "Not available";
    private boolean includeNodeType = false;
    private String address = null;
    private String name = null;
    private String comment = null;
    private JFrame LaunchFrame;
    private Container LaunchContentPane;
    private Hashtable<String, TableElement> visitedURLsAll;
    private Hashtable<String, TableElement> visitedURLsFavo;
    private JTabbedPane tabbedPane;
    private JScrollPane scrollPaneAll;
    private JScrollPane scrollPaneFavo;
    private JTable allNodesList;
    private JTable favoNodesList;
    private JButton btRemove;
    private JButton btAdd;
    private JButton btConnect;
    private JButton btExit;
    private JTextField addressField;
    private JTextField nameField;
    private JTextField commentField;
    private static final boolean ALLOW_ROW_SELECTION = true;
    private TableSorter sorterAll;
    private TableSorter sorterFavo;
    private boolean waits = false;
    private boolean addressNotSet = true;
    private transient AddressFieldListener addrcaretListener = new AddressFieldListener();
    private transient AddressFieldFocusListener addrFocusListener = new AddressFieldFocusListener();
    private transient NameFieldListener namecaretListener = new NameFieldListener();
    private transient CommentFieldListener cmmtcaretListener = new CommentFieldListener();
    private transient TableListenerForAllNEs tableListenerForAllNEs = new TableListenerForAllNEs();
    private transient TableListenerForFavorites tableListenerForFavorites = new TableListenerForFavorites();
    private boolean tableListOwnsAddressfieldAll = false;
    private boolean tableListOwnsAddressfieldFavo = false;
    private transient PropertyManager pm = PropertyManager.getInstance(this.getClass().getClassLoader());
    private Image ericssonImage = null;
    private ImageIcon ericssonIcon = null;
    private JLabel iconLabel = null;
    private JPopupMenu popup = null;
    private JMenuItem cleanMenuItem = null;
    private JPanel availableEmAppsPanel = null;
    private boolean showAllFoundEmApplications = false;
    private volatile ArrayList<EmApplicationInfo> currentEmAppInfos;
    private ArrayList<ResourceInfo> currentResourceInfos;
    private NodeTypeInvestigator nodeTypeInvestigator;
    private volatile boolean stopAllThreads = false;
    private StateUpdater stateUpdater;

    public NEAddressDialog(String theIcon) {
        this(theIcon, false);
    }

    public NEAddressDialog(String theIcon, boolean checkAllEmApplications) {
        this.visitedURLsAll = new Hashtable(203);
        this.visitedURLsFavo = new Hashtable(203);
        this.showAllFoundEmApplications = checkAllEmApplications;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException e) {
            LOG.fine("InstantiationException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.fine("ClassNotFoundException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (UnsupportedLookAndFeelException e) {
            LOG.fine("UnsupportedLookAndFeelException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOG.fine("IllegalAccessException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        this.LaunchFrame = new JFrame();
        this.scrollPaneAll = new JScrollPane();
        this.scrollPaneFavo = new JScrollPane();
        this.btRemove = new JButton();
        this.btAdd = new JButton();
        this.addressField = new JTextField();
        this.addressField.setName("addressField");
        this.nameField = new JTextField();
        this.nameField.setName("nameField");
        this.commentField = new JTextField();
        this.commentField.setName("commentField");
        this.btConnect = new JButton();
        this.btExit = new JButton();
        this.btAdd.addActionListener(this);
        this.btRemove.addActionListener(this);
        this.btExit.addActionListener(this);
        this.btConnect.addActionListener(this);
        this.btConnect.setMnemonic(Localizer.getString("connect_mnemonic").charAt(0));
        this.btAdd.setMnemonic(Localizer.getString("add_mnemonic").charAt(0));
        this.btRemove.setMnemonic(Localizer.getString("remove_mnemonic").charAt(0));
        this.btExit.setMnemonic(Localizer.getString("exit_mnemonic").charAt(0));
        this.btConnect.setToolTipText(Localizer.getString("connect_tooltip"));
        this.btAdd.setToolTipText(Localizer.getString("add_tooltip"));
        this.btRemove.setToolTipText(Localizer.getString("remove_tooltip"));
        this.btExit.setToolTipText(Localizer.getString("exit_tooltip"));
        this.addressField.addCaretListener(this.addrcaretListener);
        this.addressField.addFocusListener(this.addrFocusListener);
        this.nameField.addCaretListener(this.namecaretListener);
        this.commentField.addCaretListener(this.cmmtcaretListener);
        PopupListener popupListener = new PopupListener();
        this.addressField.addMouseListener(popupListener);
        this.nameField.addMouseListener(popupListener);
        this.commentField.addMouseListener(popupListener);
        this.addressField.setToolTipText(Localizer.getString("address_tooltip"));
        this.nameField.setToolTipText(Localizer.getString("name_tooltip"));
        this.commentField.setToolTipText(Localizer.getString("comment_tooltip"));
        this.btConnect.setEnabled(false);
        this.btAdd.setEnabled(false);
        this.btRemove.setEnabled(false);
        this.LaunchFrame.setDefaultCloseOperation(3);
        this.LaunchFrame.setName("Launcher");
        this.LaunchFrame.setIconImage(new ImageIcon(theIcon).getImage());
        this.LaunchFrame.setTitle(Localizer.getString("neaddress"));
        this.LaunchContentPane = this.LaunchFrame.getContentPane();
        this.LaunchContentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.LaunchContentPane.add((Component)new JLabel(Localizer.getString("supply_ne")), gbc);
        Object[] columnNames = this.getColumnNames();
        DefaultTableModel dataModelAll = new DefaultTableModel(this.getURLs(this.ALL_PANE), columnNames){
            private static final long serialVersionUID = 9028608921944790715L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.sorterAll = new TableSorter(dataModelAll);
        this.allNodesList = new JTable(this.sorterAll);
        this.sorterAll.setTableHeader(this.allNodesList.getTableHeader());
        this.allNodesList.setBorder(new LineBorder(Color.black));
        this.allNodesList.setRowHeight(25);
        if (this.showAllFoundEmApplications) {
            if (this.includeNodeType) {
                this.allNodesList.getColumnModel().getColumn(2).setPreferredWidth(50);
                this.allNodesList.getColumnModel().getColumn(4).setPreferredWidth(30);
                this.allNodesList.getColumnModel().getColumn(3).setPreferredWidth(8);
                this.allNodesList.getColumnModel().getColumn(0).setPreferredWidth(120);
            } else {
                this.allNodesList.getColumnModel().getColumn(2).setPreferredWidth(50);
                this.allNodesList.getColumnModel().getColumn(3).setPreferredWidth(30);
                this.allNodesList.getColumnModel().getColumn(0).setPreferredWidth(120);
            }
        }
        this.allNodesList.getColumnModel().getColumn(2).setResizable(true);
        this.allNodesList.getColumnModel().getColumn(1).setResizable(true);
        this.allNodesList.getColumnModel().getColumn(0).setResizable(true);
        this.scrollPaneAll.setViewportView(this.allNodesList);
        this.scrollPaneAll.setVerticalScrollBarPolicy(20);
        this.allNodesList.setSelectionMode(0);
        ListSelectionModel rowSM1 = this.allNodesList.getSelectionModel();
        rowSM1.addListSelectionListener(this.tableListenerForAllNEs);
        DefaultTableModel tableModelForFavorites = new DefaultTableModel(this.getURLs(this.FAVO_PANE), columnNames){
            private static final long serialVersionUID = 9028608921944790716L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.sorterFavo = new TableSorter(tableModelForFavorites);
        this.favoNodesList = new JTable(this.sorterFavo);
        this.sorterFavo.setTableHeader(this.favoNodesList.getTableHeader());
        this.favoNodesList.setBorder(new LineBorder(Color.black));
        this.favoNodesList.setRowHeight(25);
        if (this.showAllFoundEmApplications) {
            if (this.includeNodeType) {
                this.favoNodesList.getColumnModel().getColumn(0).setPreferredWidth(120);
                this.favoNodesList.getColumnModel().getColumn(2).setPreferredWidth(50);
                this.favoNodesList.getColumnModel().getColumn(4).setPreferredWidth(30);
                this.favoNodesList.getColumnModel().getColumn(3).setPreferredWidth(8);
            } else {
                this.favoNodesList.getColumnModel().getColumn(0).setPreferredWidth(120);
                this.favoNodesList.getColumnModel().getColumn(2).setPreferredWidth(50);
                this.favoNodesList.getColumnModel().getColumn(3).setPreferredWidth(30);
            }
        }
        this.favoNodesList.getColumnModel().getColumn(2).setResizable(true);
        this.favoNodesList.getColumnModel().getColumn(1).setResizable(true);
        this.favoNodesList.getColumnModel().getColumn(0).setResizable(true);
        this.scrollPaneFavo.setViewportView(this.favoNodesList);
        this.scrollPaneFavo.setVerticalScrollBarPolicy(20);
        this.favoNodesList.setSelectionMode(0);
        ListSelectionModel rowSM2 = this.favoNodesList.getSelectionModel();
        rowSM2.addListSelectionListener(this.tableListenerForFavorites);
        this.tabbedPane = new JTabbedPane(1);
        if (tableModelForFavorites.getRowCount() < 1) {
            this.tabbedPane.add(Localizer.getString("allnodes"), this.scrollPaneAll);
            this.tabbedPane.add(Localizer.getString("favorites"), this.scrollPaneFavo);
            this.ALL_PANE = 0;
            this.FAVO_PANE = 1;
        } else {
            this.tabbedPane.add(Localizer.getString("favorites"), this.scrollPaneFavo);
            this.tabbedPane.add(Localizer.getString("allnodes"), this.scrollPaneAll);
            this.FAVO_PANE = 0;
            this.ALL_PANE = 1;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                NEAddressDialog.this.tabSelected();
            }
        });
        gbc.ipadx = 150;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 8;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.LaunchContentPane.add((Component)this.tabbedPane, gbc);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(new JLabel(Localizer.getString("address") + " *", 0));
        panel.add(new JLabel(Localizer.getString("name"), 0));
        panel.add(new JLabel(Localizer.getString("comment"), 0));
        gbc.ipadx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridheight = 1;
        this.LaunchContentPane.add((Component)panel, gbc);
        JPanel tfPanel = new JPanel(new GridLayout(1, 2));
        tfPanel.add(this.addressField);
        tfPanel.add(this.nameField);
        tfPanel.add(this.commentField);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridheight = 1;
        this.LaunchContentPane.add((Component)tfPanel, gbc);
        this.addButtons(gbc);
        if (this.showAllFoundEmApplications) {
            this.availableEmAppsPanel = new JPanel(new GridLayout(1, 1));
            gbc.weightx = 0.0;
            gbc.gridx = 6;
            gbc.gridy = 2;
            gbc.insets = new Insets(10, 10, 0, 10);
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 22;
            this.LaunchContentPane.add((Component)this.availableEmAppsPanel, gbc);
        }
        this.LaunchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escapeAction");
        this.LaunchFrame.getRootPane().getActionMap().put("escapeAction", new AbstractAction(){
            private static final long serialVersionUID = 279140378021263106L;

            public void actionPerformed(ActionEvent ae) {
                NEAddressDialog.this.btExit.doClick();
            }
        });
        this.LaunchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("F4"), "stopStateUpdater");
        this.LaunchFrame.getRootPane().getActionMap().put("stopStateUpdater", new AbstractAction(){
            private static final long serialVersionUID = -5403063620230312779L;

            public void actionPerformed(ActionEvent ae) {
                if (null != NEAddressDialog.this.stateUpdater) {
                    NEAddressDialog.this.stateUpdater.stopUpdating();
                }
            }
        });
        this.LaunchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "myRefreshAction");
        this.LaunchFrame.getRootPane().getActionMap().put("myRefreshAction", new AbstractAction(){
            private static final long serialVersionUID = 279140378021263106L;

            public void actionPerformed(ActionEvent ae) {
                LOG.finer("F5 pressed. Starting StateUpdater thread called F5_KeyPressed", new Object[0]);
            }
        });
        this.LaunchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enterAction");
        this.LaunchFrame.getRootPane().getActionMap().put("enterAction", new AbstractAction(){
            private static final long serialVersionUID = -4854265056842215560L;

            public void actionPerformed(ActionEvent ae) {
                JButton connectBtn = NEAddressDialog.this.LaunchFrame.getRootPane().getDefaultButton();
                if (connectBtn != null) {
                    connectBtn.doClick();
                }
            }
        });
        this.allNodesList.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        this.favoNodesList.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        FocusAdapter connectFocusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btConnect);
                if (NEAddressDialog.this.allNodesList.isFocusOwner() && NEAddressDialog.this.allNodesList.getSelectedRow() != -1 || NEAddressDialog.this.favoNodesList.isFocusOwner() && NEAddressDialog.this.favoNodesList.getSelectedRow() != -1) {
                    if (NEAddressDialog.this.showAllFoundEmApplications) {
                        if (null != NEAddressDialog.this.currentEmAppInfos) {
                            NEAddressDialog.this.btConnect.setEnabled(true);
                        }
                    } else {
                        NEAddressDialog.this.btConnect.setEnabled(true);
                    }
                }
            }
        };
        this.btConnect.addFocusListener(connectFocusAdapter);
        this.allNodesList.addFocusListener(connectFocusAdapter);
        this.favoNodesList.addFocusListener(connectFocusAdapter);
        this.btExit.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btExit);
            }
        });
        this.btAdd.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btAdd);
            }
        });
        this.btRemove.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btRemove);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = this.LaunchFrame.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.LaunchFrame.addWindowListener(this);
        this.LaunchFrame.pack();
        this.LaunchFrame.setLocationRelativeTo(this.LaunchFrame.getOwner());
        this.LaunchFrame.setVisible(true);
        this.popup = new JPopupMenu();
        this.cleanMenuItem = new JMenuItem(" Clear all input fields ");
        this.cleanMenuItem.addActionListener(this);
        this.popup.add(this.cleanMenuItem);
        if (this.showAllFoundEmApplications) {
            this.stateUpdater = new StateUpdater();
            this.nodeTypeInvestigator = new NodeTypeInvestigator();
            this.nodeTypeInvestigator.init();
        }
    }

    private String[] getColumnNames() {
        ArrayList<String> columnNameList = new ArrayList<String>();
        columnNameList.add(Localizer.getString("address"));
        columnNameList.add(Localizer.getString("name"));
        columnNameList.add(Localizer.getString("comment"));
        if (this.showAllFoundEmApplications) {
            if (this.includeNodeType) {
                columnNameList.add(Localizer.getString("type"));
            }
            columnNameList.add(Localizer.getString("state"));
        }
        return columnNameList.toArray(new String[columnNameList.size()]);
    }

    private void addButtons(GridBagConstraints gridBagConstrainst) {
        GridBagConstraints gbc = gridBagConstrainst;
        gbc.weightx = 0.0;
        if (this.showAllFoundEmApplications) {
            JPanel removeBPanel = new JPanel(new GridLayout(1, 1));
            this.btRemove.setText(Localizer.getString("remove"));
            removeBPanel.add(this.btRemove);
            gbc.fill = 0;
            gbc.anchor = 25;
            gbc.gridx = 6;
            gbc.gridy = 9;
            gbc.insets = new Insets(10, 5, 0, 10);
            this.LaunchContentPane.add((Component)removeBPanel, gbc);
            this.btAdd.setText(Localizer.getString("add"));
            JPanel addBPanel = new JPanel(new GridLayout(1, 1));
            addBPanel.add(this.btAdd);
            gbc.fill = 0;
            gbc.ipadx = 0;
            gbc.ipady = 0;
            gbc.gridx = 6;
            gbc.gridy = 11;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(5, 5, 0, 0);
            this.LaunchContentPane.add((Component)addBPanel, gbc);
            this.btConnect.setText(Localizer.getString("connect"));
            gbc.fill = 0;
            gbc.anchor = 25;
            gbc.weightx = 0.0;
            gbc.gridx = 6;
            gbc.gridy = 12;
            gbc.gridwidth = 1;
            gbc.ipadx = 0;
            gbc.insets = new Insets(7, 5, 0, 45);
            this.LaunchContentPane.add((Component)this.btConnect, gbc);
            this.btExit.setText(Localizer.getString("exit"));
            gbc.anchor = 26;
            gbc.weightx = 0.0;
            gbc.gridx = 7;
            gbc.gridy = 12;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(5, 0, 0, 10);
            this.LaunchContentPane.add((Component)this.btExit, gbc);
            this.ericssonImage = Toolkit.getDefaultToolkit().getImage(NEAddressDialog.class.getResource("ericsson_logo.gif"));
            this.ericssonIcon = new ImageIcon(this.ericssonImage);
            this.iconLabel = new JLabel("", this.ericssonIcon, 4);
            gbc.gridx = 7;
            gbc.gridy = 13;
            gbc.insets = new Insets(7, 0, 7, 5);
            this.LaunchContentPane.add((Component)this.iconLabel, gbc);
        } else {
            gbc.weightx = 0.0;
            this.btAdd.setText(Localizer.getString("add"));
            JPanel addBPanel = new JPanel(new GridLayout(1, 1));
            addBPanel.add(this.btAdd);
            gbc.gridx = 6;
            gbc.gridwidth = 1;
            gbc.gridy = 11;
            gbc.insets = new Insets(10, 15, 0, 10);
            this.LaunchContentPane.add((Component)addBPanel, gbc);
            JPanel removeBPanel = new JPanel(new GridLayout(1, 1));
            this.btRemove.setText(Localizer.getString("remove"));
            removeBPanel.add(this.btRemove);
            gbc.fill = 0;
            gbc.anchor = 14;
            gbc.gridx = 6;
            gbc.gridy = 9;
            gbc.insets = new Insets(10, 5, 0, 10);
            this.LaunchContentPane.add((Component)removeBPanel, gbc);
            JPanel lowerFakePanel = new JPanel(new GridLayout(1, 1));
            lowerFakePanel.add(new JLabel(""));
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.insets = new Insets(10, 0, 0, 10);
            gbc.gridy = 12;
            gbc.gridwidth = 5;
            this.LaunchContentPane.add((Component)lowerFakePanel, gbc);
            this.btConnect.setText(Localizer.getString("connect"));
            gbc.weightx = 0.0;
            gbc.gridx = 5;
            gbc.gridy = 12;
            gbc.gridwidth = -1;
            gbc.insets = new Insets(10, 0, 7, 0);
            this.LaunchContentPane.add((Component)this.btConnect, gbc);
            this.btExit.setText(Localizer.getString("exit"));
            gbc.anchor = 26;
            gbc.weightx = 0.0;
            gbc.gridx = 6;
            gbc.gridy = 12;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 15, 7, 10);
            this.LaunchContentPane.add((Component)this.btExit, gbc);
            this.ericssonImage = Toolkit.getDefaultToolkit().getImage(NEAddressDialog.class.getResource("ericsson_logo.gif"));
            this.ericssonIcon = new ImageIcon(this.ericssonImage);
            this.iconLabel = new JLabel("", this.ericssonIcon, 4);
            gbc.gridx = 6;
            gbc.gridy = 13;
            gbc.insets = new Insets(0, 0, 7, 5);
            this.LaunchContentPane.add((Component)this.iconLabel, gbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAddress() {
        if (this.addressNotSet) {
            try {
                NEAddressDialog nEAddressDialog = this;
                synchronized (nEAddressDialog) {
                    this.waits = true;
                    this.wait();
                    this.waits = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.LaunchFrame.setVisible(false);
        this.LaunchFrame.dispose();
        return this.address;
    }

    public void tabSelected() {
        Hashtable<String, TableElement> storedHash = null;
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab == -1) {
            return;
        }
        storedHash = selectedTab == this.ALL_PANE ? this.visitedURLsAll : this.visitedURLsFavo;
        this.updateTableList(selectedTab, storedHash);
        if (this.availableEmAppsPanel != null) {
            this.availableEmAppsPanel.removeAll();
            this.availableEmAppsPanel.revalidate();
            this.availableEmAppsPanel.repaint();
        }
    }

    private Object[][] getURLs(int tabSelected) {
        Object[][] tableElmts = null;
        String type_ = "";
        String state_ = "";
        int selectedTab = tabSelected;
        File file = null;
        Hashtable<String, TableElement> visitedURLs = null;
        try {
            String address_;
            String line;
            if (selectedTab == -1) {
                return new String[0][];
            }
            if (selectedTab == this.ALL_PANE) {
                file = new File(this.pm.getString("se.ericsson.security.launcher.visiteddb", true));
                visitedURLs = this.visitedURLsAll;
            } else {
                file = new File(this.pm.getString("se.ericsson.security.launcher.visitedfdb", true));
                visitedURLs = this.visitedURLsFavo;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            int tableSize = 0;
            while ((line = br.readLine()) != null) {
                String name_ = "";
                String comment_ = "";
                type_ = "";
                state_ = "";
                int spaceDelimiterPos = line.indexOf(" ");
                if (spaceDelimiterPos == -1) {
                    address_ = line;
                } else {
                    address_ = line.substring(0, spaceDelimiterPos);
                    int nameDelimiterPos = line.substring(spaceDelimiterPos + 1).indexOf(59);
                    if (nameDelimiterPos == -1) {
                        name_ = line.substring(spaceDelimiterPos + 1);
                    } else {
                        name_ = line.substring(spaceDelimiterPos + 1, spaceDelimiterPos + 1 + nameDelimiterPos);
                        comment_ = line.substring(spaceDelimiterPos + 1 + nameDelimiterPos + 1);
                        int semi = comment_.indexOf(";");
                        if (semi > -1) {
                            if (comment_.length() > semi + 1) {
                                type_ = comment_.substring(semi + 1);
                            }
                            comment_ = comment_.substring(0, semi);
                        }
                    }
                }
                TableElement element = new TableElement(address_, name_, comment_, type_, state_);
                TableElement savedElement = visitedURLs.get(address_);
                if (savedElement != null && !savedElement.getAddress().equals("")) continue;
                if (savedElement == null) {
                    ++tableSize;
                }
                visitedURLs.put(address_, element);
            }
            br.close();
            tableElmts = new String[tableSize][];
            Enumeration<String> addresses = visitedURLs.keys();
            for (int i = 0; i < tableSize; ++i) {
                address_ = addresses.nextElement();
                ArrayList<String> tableElementsList = new ArrayList<String>();
                tableElementsList.add(address_);
                tableElementsList.add(visitedURLs.get(address_).getName());
                tableElementsList.add(visitedURLs.get(address_).getComment());
                if (this.showAllFoundEmApplications && this.includeNodeType) {
                    tableElementsList.add(visitedURLs.get(address_).getType());
                }
                tableElmts[i] = tableElementsList.toArray(new String[tableElementsList.size()]);
            }
        }
        catch (IOException e) {
            LOG.fine("Exception when reading visited URLs from file: " + e.getMessage(), new Object[0]);
        }
        return tableElmts;
    }

    private void putURLs(int tabSelected) {
        LOG.finer("putURLs tabSelected: " + tabSelected + "Thread: " + Thread.currentThread().getName(), new Object[0]);
        int selectedTab = tabSelected;
        File file = null;
        Hashtable<String, TableElement> visitedURLs = null;
        try {
            boolean createdDirs;
            File parentDirectory;
            if (selectedTab == -1) {
                return;
            }
            if (selectedTab == this.ALL_PANE) {
                file = new File(this.pm.getString("se.ericsson.security.launcher.visiteddb", true));
                visitedURLs = this.visitedURLsAll;
            } else {
                file = new File(this.pm.getString("se.ericsson.security.launcher.visitedfdb", true));
                visitedURLs = this.visitedURLsFavo;
            }
            if (file.exists()) {
                file.delete();
            }
            if ((parentDirectory = file.getParentFile()) != null && !parentDirectory.exists() && !(createdDirs = parentDirectory.mkdirs())) {
                throw new IOException("Could not create visiteddb parent directory: " + parentDirectory.getName());
            }
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            Enumeration<String> addresses = visitedURLs.keys();
            while (addresses.hasMoreElements()) {
                int length;
                String row;
                String address_ = addresses.nextElement();
                String name_ = visitedURLs.get(address_).getName();
                String comment_ = visitedURLs.get(address_).getComment();
                if (this.showAllFoundEmApplications) {
                    String type_ = visitedURLs.get(address_).getType();
                    row = address_ + " " + name_ + ";" + comment_ + ";" + type_;
                    length = address_.length() + 1 + name_.length() + 1 + comment_.length() + 1 + type_.length();
                } else {
                    row = address_ + " " + name_ + ";" + comment_;
                    length = address_.length() + 1 + name_.length() + 1 + comment_.length();
                }
                bw.write(row, 0, length);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            LOG.finer("Exception while writing to visited urls file. " + e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Hashtable<String, TableElement> storedHash = null;
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab == -1) {
            return;
        }
        storedHash = selectedTab == this.ALL_PANE ? this.visitedURLsAll : this.visitedURLsFavo;
        if (e.getSource() == this.btConnect) {
            String addr = this.addressField.getText();
            this.putURLs(selectedTab);
            if (addr == null || addr.length() == 0) {
                return;
            }
            this.address = addr;
            this.addressNotSet = false;
        } else if (e.getSource() == this.btExit) {
            this.addressField.setText("");
            this.nameField.setText("");
            this.commentField.setText("");
            this.address = null;
            this.addressNotSet = false;
        } else {
            if (e.getSource() == this.btRemove) {
                this.removeFromTableLists(selectedTab);
                this.addressField.setText("");
                this.nameField.setText("");
                this.commentField.setText("");
                this.btRemove.setEnabled(false);
                this.btAdd.setEnabled(true);
                return;
            }
            if (e.getSource() == this.btAdd) {
                this.addToTableLists(selectedTab, storedHash);
                this.addressNotSet = false;
                return;
            }
            if (e.getSource() == this.cleanMenuItem) {
                this.addressField.setText("");
                this.nameField.setText("");
                this.commentField.setText("");
                return;
            }
        }
        NEAddressDialog nEAddressDialog = this;
        synchronized (nEAddressDialog) {
            if (this.waits) {
                this.notify();
            }
        }
    }

    private void addToTableLists(int selectedTab, Hashtable<String, TableElement> hash) {
        LOG.finer("addToTableLists selectedTab: " + selectedTab + "Thread: " + Thread.currentThread().getName(), new Object[0]);
        Hashtable<String, TableElement> storedHash = hash;
        String addr = this.addressField.getText();
        String name = this.nameField.getText();
        String cmmt = this.commentField.getText();
        if (addr == null || addr.length() == 0) {
            return;
        }
        this.address = addr;
        boolean alreadyIncluded = false;
        Set<Map.Entry<String, TableElement>> entries = storedHash.entrySet();
        for (Map.Entry<String, TableElement> entry : entries) {
            if (!entry.getKey().equals(addr)) continue;
            alreadyIncluded = true;
            TableElement element = this.includeNodeType ? new TableElement(addr, name, cmmt, entry.getValue().getType(), entry.getValue().getState()) : new TableElement(addr, name, cmmt, entry.getValue().getState());
            storedHash.put(addr, element);
            break;
        }
        if (!alreadyIncluded) {
            if (cmmt == null || cmmt.length() == 0) {
                cmmt = "";
            }
            if (name == null || name.length() == 0) {
                name = "";
            }
            String type = "";
            String state = "";
            TableElement element = new TableElement(addr, name, cmmt, type, state);
            storedHash.put(addr, element);
        }
        this.updateTableList(selectedTab, storedHash);
        this.addressField.requestFocus();
        if (selectedTab == this.FAVO_PANE) {
            this.putURLs(this.FAVO_PANE);
            storedHash = this.visitedURLsAll;
            this.addToTableLists(this.ALL_PANE, storedHash);
        } else {
            this.putURLs(this.ALL_PANE);
        }
    }

    private void removeFromTableLists(int selectedTab) {
        LOG.finer("removeFromTableLists selectedTab: " + selectedTab + "Thread: " + Thread.currentThread().getName(), new Object[0]);
        JTable tableList = null;
        if (selectedTab == this.ALL_PANE) {
            String keyToRemove;
            int i;
            tableList = this.allNodesList;
            int[] deleted = tableList.getSelectedRows();
            String[] removedKeys = new String[deleted.length];
            for (i = 0; i < deleted.length; ++i) {
                removedKeys[i] = keyToRemove = (String)tableList.getValueAt(deleted[i], 0);
                this.visitedURLsAll.remove(keyToRemove);
            }
            this.putURLs(this.ALL_PANE);
            this.updateTableList(this.ALL_PANE, this.visitedURLsAll);
            for (i = 0; i < deleted.length; ++i) {
                keyToRemove = removedKeys[i];
                this.visitedURLsFavo.remove(keyToRemove);
            }
            this.putURLs(this.FAVO_PANE);
            this.updateTableList(this.FAVO_PANE, this.visitedURLsFavo);
        } else {
            tableList = this.favoNodesList;
            int[] deleted = tableList.getSelectedRows();
            for (int i = 0; i < deleted.length; ++i) {
                String keyToRemove = (String)tableList.getValueAt(deleted[i], 0);
                this.visitedURLsFavo.remove(keyToRemove);
            }
            this.putURLs(this.FAVO_PANE);
            this.updateTableList(this.FAVO_PANE, this.visitedURLsFavo);
        }
    }

    private void updateTableList(int theTab, Hashtable<String, TableElement> tmpHash) {
        LOG.finer("updateTableList theTab: " + theTab + "Thread: " + Thread.currentThread().getName(), new Object[0]);
        if (!this.stopAllThreads) {
            Hashtable<String, TableElement> myTmpHash = tmpHash;
            TableSorter sorter = null;
            if (theTab == -1) {
                return;
            }
            sorter = theTab == this.ALL_PANE ? this.sorterAll : this.sorterFavo;
            DefaultTableModel model = (DefaultTableModel)sorter.getTableModel();
            model.setRowCount(0);
            Set<String> keySet = myTmpHash.keySet();
            Iterator<String> it = keySet.iterator();
            while (it.hasNext()) {
                ArrayList<String> rowDataList = new ArrayList<String>();
                String addr = it.next();
                TableElement element = myTmpHash.get(addr);
                rowDataList.add(addr);
                rowDataList.add(element.getName());
                rowDataList.add(element.getComment());
                if (this.showAllFoundEmApplications) {
                    if (this.includeNodeType) {
                        rowDataList.add(element.getType());
                    }
                    rowDataList.add(element.getState());
                }
                model.addRow(rowDataList.toArray(new String[rowDataList.size()]));
            }
        }
    }

    private void lookup(int tab, String fieldName, String lookFor, Hashtable<String, TableElement> lookInTable) {
        LOG.finer("lookup tab:" + tab + " fieldName:" + fieldName + " lookFor:" + lookFor + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        int selectedTab = tab;
        String beginning = lookFor;
        Hashtable<String, TableElement> soucrceHash = lookInTable;
        Hashtable<String, TableElement> tempHash = new Hashtable<String, TableElement>(100);
        try {
            Set<String> keySet = soucrceHash.keySet();
            if (keySet.isEmpty()) {
                return;
            }
            int indexInRowDataList = 0;
            String[] fieldnames = new String[]{this.addressField.getName(), this.nameField.getName(), this.commentField.getName()};
            for (int i = 0; i < fieldnames.length; ++i) {
                if (!fieldName.equalsIgnoreCase(fieldnames[i])) continue;
                indexInRowDataList = i;
                break;
            }
            Iterator<String> it = keySet.iterator();
            while (it.hasNext() && !this.stopAllThreads) {
                String key = it.next();
                TableElement element = soucrceHash.get(key);
                ArrayList<String> rowDataList = new ArrayList<String>();
                rowDataList.add(key);
                rowDataList.add(element.getName());
                rowDataList.add(element.getComment());
                if (this.showAllFoundEmApplications && this.includeNodeType) {
                    rowDataList.add(element.getType());
                }
                if (!((String)rowDataList.get(indexInRowDataList)).toLowerCase().startsWith(beginning.toLowerCase())) continue;
                tempHash.put(key, soucrceHash.get(key));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.stopAllThreads) {
            this.updateTableList(selectedTab, tempHash);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        this.address = null;
        this.addressNotSet = false;
        NEAddressDialog nEAddressDialog = this;
        synchronized (nEAddressDialog) {
            if (this.waits) {
                this.notify();
            }
        }
        this.stopAllThreads = true;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public String getSelectedEmApplicationIconFilePath(String defaultPath, URL hostUrl) {
        LOG.finer("getSelectedEmApplicationIconFilePath defaultPath: " + defaultPath + " hostUrl:" + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String theIconPath = defaultPath;
        if (null != this.currentEmAppInfos && null != this.currentResourceInfos) {
            for (int i = 0; i < this.currentEmAppInfos.size(); ++i) {
                if (!this.currentEmAppInfos.get(i).getButton().isSelected()) continue;
                byte[] iconbytes = this.getIconBytesForEmApplicationInfo(this.currentEmAppInfos.get(i), this.currentResourceInfos, hostUrl);
                String jarfilePath = this.getIconJarFilePath(this.currentEmAppInfos.get(i), this.currentResourceInfos, hostUrl);
                int filenamePlace = jarfilePath.indexOf(this.currentEmAppInfos.get(i).getIconResourceRefSee());
                if (filenamePlace <= -1) continue;
                String dir = jarfilePath.substring(0, filenamePlace);
                File iconFile = new File(dir + File.separator + this.currentEmAppInfos.get(i).getIconResourceName());
                if (iconFile.exists()) {
                    theIconPath = iconFile.getAbsolutePath();
                    LOG.finer("Icon file exists already: " + theIconPath, new Object[0]);
                    continue;
                }
                try {
                    FileOutputStream outStream = new FileOutputStream(iconFile);
                    outStream.write(iconbytes);
                    outStream.flush();
                    outStream.close();
                    theIconPath = iconFile.getAbsolutePath();
                    if (EmasUtilities.runningOnWindows()) continue;
                    Runtime rt = Runtime.getRuntime();
                    rt.exec("chmod a+r " + iconFile.toString());
                    continue;
                }
                catch (Exception e) {
                    LOG.finer("getSelectedEmApplicationIconFilePath, something got wrong when writing or chmodding icon file: " + e.getMessage(), new Object[0]);
                }
            }
        }
        return theIconPath;
    }

    private byte[] getIconBytesForEmApplicationInfo(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconBytesForEmApplicationInfo, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        byte[] iconAsBytes = new byte[]{};
        String jarFilePath = this.getIconJarFilePath(emApp, resourceInfos, hostUrl);
        if (jarFilePath.length() > 0) {
            iconAsBytes = this.nodeTypeInvestigator.getFileInJarAsByteArray(emApp.getIconResourcePath() + "/" + emApp.getIconResourceName(), jarFilePath);
        }
        return iconAsBytes;
    }

    private String getIconJarFilePath(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconJarFilePath, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String jarFilePath = "";
        jarFilePath = emApp.getIconResourceRefSee().equalsIgnoreCase("launcher.jar") ? this.nodeTypeInvestigator.getJarFilePathForThisLauncherJar() : this.getIconJarFilePathInCache(emApp, resourceInfos, hostUrl);
        return jarFilePath;
    }

    private String getIconJarFilePathInCache(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconJarFilePathInCache, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String iconRefSee = emApp.getIconResourceRefSee();
        String dirPath = "";
        String cxc = "";
        String rev = "";
        String jarFilePath = "";
        for (ResourceInfo iconResource : resourceInfos) {
            if (!iconResource.getResourceFileName().equalsIgnoreCase(iconRefSee)) continue;
            dirPath = iconResource.getDirectoryPath();
            cxc = iconResource.getProductNumber();
            rev = iconResource.getProductRevision();
        }
        if (cxc.length() > 0 && rev.length() > 0) {
            try {
                URL url = new URL(hostUrl.toString() + dirPath + "/" + iconRefSee);
                jarFilePath = this.nodeTypeInvestigator.getFile(url, iconRefSee, cxc, rev, this.pm);
            }
            catch (Exception e) {
                LOG.finer("getIconJarFilePathInCache did not find jar file path in cache to a resource file containing an icon.", new Object[0]);
            }
        }
        return jarFilePath;
    }

    public String getSelectedEmApplicationConfigFilePath(String defaultPath) {
        LOG.finer("getSelectedEmApplicationConfigFilePath, default: " + defaultPath, new Object[0]);
        String theAppPath = defaultPath;
        if (null != this.currentEmAppInfos) {
            for (int i = 0; i < this.currentEmAppInfos.size(); ++i) {
                if (!this.currentEmAppInfos.get(i).getButton().isSelected()) continue;
                theAppPath = this.currentEmAppInfos.get(i).getConfigFileName();
                LOG.finer("getSelectedEmApplicationConfigFilePath, found: " + theAppPath, new Object[0]);
                break;
            }
        }
        return theAppPath;
    }

    private void updatePanelWithAvailableEmApplications(final String anAddress) {
        LOG.finer("updatePanelWithAvailableEmApplications, anAddress: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        Runnable runner = new Runnable(){

            public void run() {
                LOG.finer("updatePanelWithAvailableEmApplications in runner. " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
                final ArrayList emapps = new ArrayList();
                final ArrayList resources = new ArrayList();
                final JPanel panel = NEAddressDialog.this.getPanelWithAvailableEmApplications(anAddress, emapps, resources);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LOG.finer("updatePanelWithAvailableEmApplications waiting for the lockForCurrentEmApp. ", new Object[0]);
                        if (NEAddressDialog.this.addressField.getText().equalsIgnoreCase(anAddress)) {
                            LOG.finer("updatePanelWithAvailableEmApplications before updating currentEmAppInfos. " + Thread.currentThread().getName(), new Object[0]);
                            NEAddressDialog.this.btConnect.setEnabled(false);
                            NEAddressDialog.this.currentEmAppInfos = emapps;
                            NEAddressDialog.this.currentResourceInfos = resources;
                            NEAddressDialog.this.availableEmAppsPanel.removeAll();
                            NEAddressDialog.this.availableEmAppsPanel.revalidate();
                            NEAddressDialog.this.availableEmAppsPanel.add(panel);
                            NEAddressDialog.this.availableEmAppsPanel.revalidate();
                            NEAddressDialog.this.availableEmAppsPanel.repaint();
                            if (null != emapps && emapps.size() > 0) {
                                NEAddressDialog.this.updateTableCellWithNodeTypeAndState(((EmApplicationInfo)emapps.get(0)).getNodeType(), anAddress, "Available");
                                NEAddressDialog.this.btConnect.setEnabled(true);
                                NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btConnect);
                            }
                        }
                    }
                });
            }
        };
        new Thread(runner, "updatePanelWithAvailableEmApplicationsThread").start();
    }

    private JPanel getPanelWithAvailableEmApplications(String anAddress, ArrayList<EmApplicationInfo> emappsToReturn, ArrayList<ResourceInfo> resourceInfosToReturn) {
        URL url;
        LOG.finer("getPanelWithAvailableEmApplications, address: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel nodeTypeLabel = new JLabel();
        panel.add((Component)nodeTypeLabel, "North");
        String fileContents = "";
        if (null != anAddress && null != (url = this.getUrl(anAddress))) {
            try {
                fileContents = this.nodeTypeInvestigator.getEmApplicationsFileContentsFromNode(url, "/em/emapplications.xml");
            }
            catch (Exception ex) {
                LOG.finer("getPanelWithAvailableEmApplications, caught exception when reading emapplications.xml from node. " + ex, new Object[0]);
                if (null != ex.getCause() && ex.getCause().getClass().equals(FileNotFoundException.class)) {
                    LOG.finer("getPanelWithAvailableEmApplications, the emapplications.xml was not found on the node.", new Object[0]);
                    NodeType nodeType = this.nodeTypeInvestigator.getNodeType(url);
                    if (NodeType.UNKNOWN == nodeType) {
                        panel.add(new JLabel("<html>No information available.<br>" + ex.getMessage() + "<br>"));
                        this.updateTableCellWithState(anAddress, "Not available");
                    } else {
                        fileContents = this.nodeTypeInvestigator.getDefaultEmApplicationsFileContents(nodeType);
                    }
                }
                panel.add(new JLabel("<html>No information available.<br>" + ex.getMessage() + "<br>"));
                this.updateTableCellWithState(anAddress, "Not available");
            }
            if ("" != fileContents) {
                LOG.finest("emapplications.xml file contents:\n    " + fileContents, new Object[0]);
                ArrayList<EmApplicationInfo> emApps = EmApplicationInfoFactory.constructEmAppInfos(fileContents);
                ArrayList<ResourceInfo> resInfos = ResourceInfoFactory.constructResourceInfos(fileContents);
                if (emApps.size() > 0) {
                    nodeTypeLabel.setText("Node type: " + emApps.get(0).getNodeType());
                    JPanel radioButtonPanel = this.putEmAppInfoButtonsInPanel(emApps, resInfos, url);
                    panel.add((Component)radioButtonPanel, "West");
                    emappsToReturn.addAll(emApps);
                }
                if (resInfos.size() > 0) {
                    resourceInfosToReturn.addAll(resInfos);
                }
            }
        }
        return panel;
    }

    private void updateTableCellWithNodeTypeAndState(String nodeType, String anAddress, String availability) {
        TableElement newElement;
        LOG.finer("updateTableCellWithNodeTypeAndState nodeType: " + nodeType, new Object[0]);
        TableElement element = this.visitedURLsAll.get(anAddress);
        if (null != element && (element.getType() != nodeType || element.getState() != availability)) {
            newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), nodeType, availability);
            this.visitedURLsAll.put(anAddress, newElement);
            this.allNodesList.getSelectionModel().removeListSelectionListener(this.tableListenerForAllNEs);
            this.updateTableRow(this.ALL_PANE, newElement);
            this.allNodesList.getSelectionModel().addListSelectionListener(this.tableListenerForAllNEs);
        }
        if (null != (element = this.visitedURLsFavo.get(anAddress)) && (element.getType() != nodeType || element.getState() != availability)) {
            newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), nodeType, availability);
            this.visitedURLsFavo.put(anAddress, newElement);
            this.favoNodesList.getSelectionModel().removeListSelectionListener(this.tableListenerForFavorites);
            this.updateTableRow(this.FAVO_PANE, newElement);
            this.favoNodesList.getSelectionModel().addListSelectionListener(this.tableListenerForFavorites);
        }
    }

    private void updateTableCellWithState(String anAddress, String availability) {
        TableElement newElement;
        LOG.finer("updateTableCellWithState anAddress is: " + anAddress + " availability is:" + availability, new Object[0]);
        TableElement element = this.visitedURLsAll.get(anAddress);
        if (null != element && element.getState() != availability) {
            newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), element.getType(), availability);
            this.visitedURLsAll.put(anAddress, newElement);
            this.updateTableRow(this.ALL_PANE, newElement);
        }
        if (null != (element = this.visitedURLsFavo.get(anAddress)) && element.getState() != availability) {
            newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), element.getType(), availability);
            this.visitedURLsFavo.put(anAddress, newElement);
            this.updateTableRow(this.FAVO_PANE, newElement);
        }
    }

    private void updateTableRow(final int tab, final TableElement element) {
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.finer("updateTableRow, tab: " + tab + " element address: " + element.getAddress(), new Object[0]);
            TableSorter sorter = null;
            if (tab == -1) {
                return;
            }
            sorter = tab == this.ALL_PANE ? this.sorterAll : this.sorterFavo;
            int selectedTab = this.tabbedPane.getSelectedIndex();
            JTable theTable = this.ALL_PANE == selectedTab ? this.allNodesList : this.favoNodesList;
            int selectedRow = theTable.getSelectedRow();
            String anAddress = element.getAddress();
            DefaultTableModel model = (DefaultTableModel)sorter.getTableModel();
            Vector<Vector> dataVector = model.getDataVector();
            for (int i = 0; i < dataVector.size() && !this.stopAllThreads; ++i) {
                String tmpAddr = (String)dataVector.elementAt(i).elementAt(0);
                if (!tmpAddr.equalsIgnoreCase(anAddress)) continue;
                model.setValueAt(element.getName(), i, 1);
                model.setValueAt(element.getComment(), i, 2);
                if (!this.showAllFoundEmApplications) break;
                if (this.includeNodeType) {
                    model.setValueAt(element.getType(), i, 3);
                    model.setValueAt(element.getState(), i, 4);
                    break;
                }
                model.setValueAt(element.getState(), i, 3);
                break;
            }
            try {
                theTable.setRowSelectionInterval(selectedRow, selectedRow);
            }
            catch (Exception ex) {
                LOG.fine("Exception in updateTableRow while doing setRowSelectionInterval: " + ex.getMessage(), new Object[0]);
            }
        } else {
            Runnable updater = new Runnable(){

                public void run() {
                    NEAddressDialog.this.updateTableRow(tab, element);
                }
            };
            SwingUtilities.invokeLater(updater);
        }
    }

    private URL getUrl(String host) {
        int port;
        URL url;
        if (host == null || host.equals("")) {
            return null;
        }
        try {
            url = new URL("http://" + host);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String anAddress = url.getHost();
        if (url.getPort() == -1) {
            int tmpPort = url.getDefaultPort();
            try {
                url = new URL(HTTP, anAddress, tmpPort, "");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (!this.isAddressAndPortValid(anAddress, port = url.getPort())) {
            return null;
        }
        return url;
    }

    private boolean isAddressAndPortValid(String anAddress, int port) {
        try {
            InetSocketAddress isa = new InetSocketAddress(anAddress, port);
            if (isa.isUnresolved()) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private JPanel putEmAppInfoButtonsInPanel(ArrayList<EmApplicationInfo> emAppInfos, ArrayList<ResourceInfo> resources, URL hostUrl) {
        LOG.finer("putEmAppInfoButtonsInPanel number of emAppInfos: " + emAppInfos.size() + " hostUrl: " + hostUrl, new Object[0]);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < emAppInfos.size(); ++i) {
            buttonGroup.add(emAppInfos.get(i).getButton());
            byte[] iconBytes = this.getIconBytesForEmApplicationInfo(emAppInfos.get(i), resources, hostUrl);
            JLabel label = new JLabel("");
            if (iconBytes.length > 0) {
                ImageIcon icon = new ImageIcon(iconBytes);
                label.setIcon(icon);
            } else {
                label.setPreferredSize(new Dimension(16, 10));
            }
            JPanel p = new JPanel(new FlowLayout(3));
            p.add(label);
            p.add(emAppInfos.get(i).getButton());
            radioButtonPanel.add(p);
        }
        return radioButtonPanel;
    }

    private void updateApplicationsPanel(String anAddress) {
        LOG.finer("updateApplicationsPanel, + anAddress: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        this.availableEmAppsPanel.removeAll();
        this.availableEmAppsPanel.add(new JLabel("Searching EM applications..."));
        this.availableEmAppsPanel.revalidate();
        this.availableEmAppsPanel.repaint();
        this.btConnect.setEnabled(false);
        LOG.finest("updateApplicationsPanel before setting currentEmAppInfos to null " + Thread.currentThread().getName(), new Object[0]);
        LOG.finest("updateApplicationsPanel got the lockForCurrentEmApp ", new Object[0]);
        this.currentEmAppInfos = null;
        this.currentResourceInfos = null;
        this.updatePanelWithAvailableEmApplications(anAddress);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StateUpdater
    implements Runnable {
        private volatile boolean stopWork = false;
        private volatile boolean working = false;

        StateUpdater() {
        }

        public boolean isUpdating() {
            LOG.finer("isUpdating returning " + this.working, new Object[0]);
            return this.working;
        }

        public void startUpdating() {
            LOG.finer("startUpdating called", new Object[0]);
            this.stopWork = false;
            if (!this.working) {
                LOG.finer("Starting new stateColumnUpdaterThread", new Object[0]);
                new Thread((Runnable)this, "stateColumnUpdaterThread").start();
            }
        }

        public void stopUpdating() {
            LOG.finer("Settin stopWork to true", new Object[0]);
            this.stopWork = true;
        }

        public void updateHashLists(final int tab, final Hashtable<String, TableElement> storedHash) {
            LOG.finer("updateHashLists: " + storedHash + " Thread: " + Thread.currentThread().getName(), new Object[0]);
            Enumeration<TableElement> elements = storedHash.elements();
            while (elements.hasMoreElements() && !NEAddressDialog.this.stopAllThreads && !this.stopWork) {
                TableElement tmpElem = elements.nextElement();
                URL url = NEAddressDialog.this.getUrl(tmpElem.getAddress());
                String refreshState = "Not available";
                if (null != url) {
                    boolean contact = NEAddressDialog.this.nodeTypeInvestigator.contactWithNode(url);
                    LOG.finest("StateUpdater contact is: " + contact, new Object[0]);
                    if (contact) {
                        refreshState = "Available";
                    }
                }
                TableElement element = new TableElement(tmpElem.getAddress(), tmpElem.getName(), tmpElem.getComment(), tmpElem.getType(), refreshState);
                storedHash.put(tmpElem.getAddress(), element);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    LOG.finer("updateHashLists caught InterruptedException in sleap", new Object[0]);
                }
            }
            LOG.finest("stopAllThreads: " + NEAddressDialog.this.stopAllThreads + " stopWork: " + this.stopWork, new Object[0]);
            if (!NEAddressDialog.this.stopAllThreads) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!NEAddressDialog.this.stopAllThreads) {
                            int selectedTab = NEAddressDialog.this.tabbedPane.getSelectedIndex();
                            JTable theTable = NEAddressDialog.this.ALL_PANE == selectedTab ? NEAddressDialog.this.allNodesList : NEAddressDialog.this.favoNodesList;
                            int selectedRow = theTable.getSelectedRow();
                            NEAddressDialog.this.updateTableList(tab, storedHash);
                            if (-1 != selectedRow) {
                                theTable.setRowSelectionInterval(selectedRow, selectedRow);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void run() {
            if (this.working) {
                LOG.finer("StateUpdater is already working. Will leave this run.", new Object[0]);
            } else if (NEAddressDialog.this.stopAllThreads) {
                LOG.finer("StateUpdater is already running. Will leave this run.", new Object[0]);
                LOG.finer("StateUpdater detects stopAllThreads. Will leave this run.", new Object[0]);
            } else if (this.stopWork) {
                LOG.finer("StateUpdater detects stopWork. Will leave this run.", new Object[0]);
                this.stopWork = false;
            } else {
                this.working = true;
                this.updateHashLists(NEAddressDialog.this.FAVO_PANE, NEAddressDialog.this.visitedURLsFavo);
                LOG.finer("StateUpdater called updateHashLists with pane " + NEAddressDialog.this.FAVO_PANE, new Object[0]);
                this.updateHashLists(NEAddressDialog.this.ALL_PANE, NEAddressDialog.this.visitedURLsAll);
                LOG.finer("StateUpdater called updateHashLists with pane " + NEAddressDialog.this.ALL_PANE, new Object[0]);
                this.working = false;
                this.stopWork = false;
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                NEAddressDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class TableElement {
        private String elementAddress;
        private String elementName;
        private String elementComment;
        private String elementType;
        private String elementState;

        public TableElement(String anAddress, String aName, String aComment, String aType, String aState) {
            this.elementAddress = anAddress;
            this.elementName = aName;
            this.elementComment = aComment;
            this.elementType = aType;
            this.elementState = aState;
        }

        public TableElement(String anAddress, String aName, String aComment, String aState) {
            this(anAddress, aName, aComment, "", aState);
        }

        public String getAddress() {
            return this.elementAddress;
        }

        public String getName() {
            return this.elementName;
        }

        public String getComment() {
            return this.elementComment;
        }

        public String getType() {
            return this.elementType;
        }

        public String getState() {
            return this.elementState;
        }
    }

    class CommentFieldListener
    implements CaretListener {
        CommentFieldListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void caretUpdate(CaretEvent e) {
            Hashtable soucrceHash = null;
            int selectedTab = NEAddressDialog.this.tabbedPane.getSelectedIndex();
            String searchString = null;
            final String inputField = NEAddressDialog.this.commentField.getName();
            searchString = NEAddressDialog.this.addressField.getText().trim();
            NEAddressDialog.this.btAdd.setEnabled(true);
            if (NEAddressDialog.this.addressField == null || searchString.equals("")) {
                NEAddressDialog.this.btAdd.setEnabled(false);
            }
            if (selectedTab == NEAddressDialog.this.ALL_PANE) {
                soucrceHash = NEAddressDialog.this.visitedURLsAll;
                if (NEAddressDialog.this.tableListOwnsAddressfieldAll) return;
                NEAddressDialog.this.allNodesList.clearSelection();
            } else {
                soucrceHash = NEAddressDialog.this.visitedURLsFavo;
                if (NEAddressDialog.this.tableListOwnsAddressfieldFavo) return;
                NEAddressDialog.this.favoNodesList.clearSelection();
            }
            final String lookupStr = NEAddressDialog.this.commentField.getText().trim();
            final Hashtable hash = soucrceHash;
            final int tab = selectedTab;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SearchRunner
            implements Runnable {
                SearchRunner() {
                }

                @Override
                public void run() {
                    if (!NEAddressDialog.this.stopAllThreads) {
                        NEAddressDialog.this.lookup(tab, inputField, lookupStr, hash);
                    }
                }
            }
            SearchRunner lookupRunner = new SearchRunner();
            lookupRunner.run();
        }
    }

    class NameFieldListener
    implements CaretListener {
        NameFieldListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void caretUpdate(CaretEvent e) {
            Hashtable soucrceHash = null;
            int selectedTab = NEAddressDialog.this.tabbedPane.getSelectedIndex();
            String searchString = null;
            final String inputField = NEAddressDialog.this.nameField.getName();
            searchString = NEAddressDialog.this.addressField.getText().trim();
            NEAddressDialog.this.btAdd.setEnabled(true);
            if (NEAddressDialog.this.addressField == null || searchString.equals("")) {
                NEAddressDialog.this.btAdd.setEnabled(false);
            }
            if (selectedTab == NEAddressDialog.this.ALL_PANE) {
                soucrceHash = NEAddressDialog.this.visitedURLsAll;
                if (NEAddressDialog.this.tableListOwnsAddressfieldAll) return;
                NEAddressDialog.this.allNodesList.clearSelection();
            } else {
                soucrceHash = NEAddressDialog.this.visitedURLsFavo;
                if (NEAddressDialog.this.tableListOwnsAddressfieldFavo) return;
                NEAddressDialog.this.favoNodesList.clearSelection();
            }
            final String lookupStr = NEAddressDialog.this.nameField.getText().trim();
            final Hashtable hash = soucrceHash;
            final int tab = selectedTab;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SearchRunner
            implements Runnable {
                SearchRunner() {
                }

                @Override
                public void run() {
                    NEAddressDialog.this.lookup(tab, inputField, lookupStr, hash);
                }
            }
            SearchRunner lookupRunner = new SearchRunner();
            lookupRunner.run();
        }
    }

    class AddressFieldListener
    implements CaretListener {
        AddressFieldListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void caretUpdate(CaretEvent e) {
            Hashtable soucrceHash = null;
            int selectedTab = NEAddressDialog.this.tabbedPane.getSelectedIndex();
            String searchString = null;
            final String inputField = NEAddressDialog.this.addressField.getName();
            searchString = NEAddressDialog.this.addressField.getText().trim();
            NEAddressDialog.this.btAdd.setEnabled(true);
            if (NEAddressDialog.this.addressField == null || searchString.equals("")) {
                NEAddressDialog.this.btAdd.setEnabled(false);
            }
            if (selectedTab == NEAddressDialog.this.ALL_PANE) {
                soucrceHash = NEAddressDialog.this.visitedURLsAll;
                if (NEAddressDialog.this.tableListOwnsAddressfieldAll) return;
                NEAddressDialog.this.allNodesList.clearSelection();
            } else {
                soucrceHash = NEAddressDialog.this.visitedURLsFavo;
                if (NEAddressDialog.this.tableListOwnsAddressfieldFavo) return;
                NEAddressDialog.this.favoNodesList.clearSelection();
            }
            final String lookupStr = searchString;
            final Hashtable hash = soucrceHash;
            final int tab = selectedTab;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SearchRunner
            implements Runnable {
                SearchRunner() {
                }

                @Override
                public void run() {
                    NEAddressDialog.this.lookup(tab, inputField, lookupStr, hash);
                }
            }
            SearchRunner lookupRunner = new SearchRunner();
            lookupRunner.run();
        }
    }

    class AddressFieldFocusListener
    implements FocusListener {
        AddressFieldFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (NEAddressDialog.this.showAllFoundEmApplications) {
                NEAddressDialog.this.availableEmAppsPanel.removeAll();
                NEAddressDialog.this.availableEmAppsPanel.revalidate();
                NEAddressDialog.this.availableEmAppsPanel.repaint();
            }
            NEAddressDialog.this.btConnect.setEnabled(false);
        }

        public void focusLost(FocusEvent e) {
            boolean validaddress;
            String address = NEAddressDialog.this.addressField.getText().trim();
            boolean bl = validaddress = null != NEAddressDialog.this.getUrl(address);
            if (validaddress) {
                if (NEAddressDialog.this.showAllFoundEmApplications) {
                    NEAddressDialog.this.updatePanelWithAvailableEmApplications(address);
                } else {
                    NEAddressDialog.this.btConnect.setEnabled(true);
                    NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btConnect);
                }
            }
        }
    }

    class TableListenerForFavorites
    implements ListSelectionListener {
        int[] prevSelectedIndices = new int[0];

        TableListenerForFavorites() {
        }

        void resetSelection() {
            this.prevSelectedIndices = new int[0];
        }

        public void valueChanged(ListSelectionEvent e) {
            LOG.finest("valueChanged in TableListenerForFavorites", new Object[0]);
            boolean newSelection = false;
            int[] newSelectedIndices = NEAddressDialog.this.favoNodesList.getSelectedRows();
            if (this.prevSelectedIndices.length != newSelectedIndices.length) {
                newSelection = true;
            } else {
                for (int n = 0; n < this.prevSelectedIndices.length; ++n) {
                    if (this.prevSelectedIndices[n] == newSelectedIndices[n]) continue;
                    newSelection = true;
                    break;
                }
            }
            if (newSelection) {
                this.prevSelectedIndices = newSelectedIndices;
                if (newSelectedIndices.length == 0 && NEAddressDialog.this.addressField.getText().length() < 1) {
                    NEAddressDialog.this.btConnect.setEnabled(false);
                    NEAddressDialog.this.btRemove.setEnabled(false);
                } else if (newSelectedIndices.length == 1) {
                    NEAddressDialog.this.btRemove.setEnabled(true);
                    NEAddressDialog.this.btConnect.setEnabled(true);
                    NEAddressDialog.this.btAdd.setEnabled(false);
                    NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btConnect);
                    int selectedRow = NEAddressDialog.this.favoNodesList.getSelectedRow();
                    NEAddressDialog.this.address = (String)NEAddressDialog.this.favoNodesList.getValueAt(selectedRow, 0);
                    NEAddressDialog.this.name = (String)NEAddressDialog.this.favoNodesList.getValueAt(selectedRow, 1);
                    NEAddressDialog.this.comment = (String)NEAddressDialog.this.favoNodesList.getValueAt(selectedRow, 2);
                    NEAddressDialog.this.tableListOwnsAddressfieldFavo = true;
                    NEAddressDialog.this.addressField.setText(NEAddressDialog.this.address);
                    NEAddressDialog.this.nameField.setText(NEAddressDialog.this.name);
                    NEAddressDialog.this.commentField.setText(NEAddressDialog.this.comment);
                    NEAddressDialog.this.tableListOwnsAddressfieldFavo = false;
                    LOG.finest("TableListenerForFavorites, one address selected: " + NEAddressDialog.this.address, new Object[0]);
                    if (NEAddressDialog.this.showAllFoundEmApplications) {
                        NEAddressDialog.this.updateApplicationsPanel(NEAddressDialog.this.address);
                    }
                } else if (newSelectedIndices.length > 1) {
                    NEAddressDialog.this.btRemove.setEnabled(true);
                    NEAddressDialog.this.btConnect.setEnabled(false);
                    NEAddressDialog.this.btAdd.setEnabled(false);
                    NEAddressDialog.this.tableListOwnsAddressfieldFavo = true;
                    NEAddressDialog.this.addressField.setText("");
                    NEAddressDialog.this.nameField.setText("");
                    NEAddressDialog.this.commentField.setText("");
                    NEAddressDialog.this.tableListOwnsAddressfieldFavo = false;
                }
            }
        }
    }

    class TableListenerForAllNEs
    implements ListSelectionListener {
        int[] prevSelectedIndices = new int[0];

        TableListenerForAllNEs() {
        }

        void resetSelection() {
            this.prevSelectedIndices = new int[0];
        }

        public void valueChanged(ListSelectionEvent e) {
            LOG.finest("valueChanged in TableListenerForAllNEs", new Object[0]);
            boolean newSelection = false;
            int[] newSelectedIndices = NEAddressDialog.this.allNodesList.getSelectedRows();
            if (this.prevSelectedIndices.length != newSelectedIndices.length) {
                newSelection = true;
            } else {
                for (int n = 0; n < this.prevSelectedIndices.length; ++n) {
                    if (this.prevSelectedIndices[n] == newSelectedIndices[n]) continue;
                    newSelection = true;
                    break;
                }
            }
            if (newSelection) {
                this.prevSelectedIndices = newSelectedIndices;
                if (newSelectedIndices.length == 0 && NEAddressDialog.this.addressField.getText().length() < 1) {
                    NEAddressDialog.this.btConnect.setEnabled(false);
                    NEAddressDialog.this.btRemove.setEnabled(false);
                } else if (newSelectedIndices.length == 1) {
                    NEAddressDialog.this.btRemove.setEnabled(true);
                    NEAddressDialog.this.btConnect.setEnabled(true);
                    NEAddressDialog.this.btAdd.setEnabled(false);
                    NEAddressDialog.this.LaunchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btConnect);
                    int selectedRow = NEAddressDialog.this.allNodesList.getSelectedRow();
                    NEAddressDialog.this.address = (String)NEAddressDialog.this.allNodesList.getValueAt(selectedRow, 0);
                    NEAddressDialog.this.name = (String)NEAddressDialog.this.allNodesList.getValueAt(selectedRow, 1);
                    NEAddressDialog.this.comment = (String)NEAddressDialog.this.allNodesList.getValueAt(selectedRow, 2);
                    NEAddressDialog.this.tableListOwnsAddressfieldAll = true;
                    NEAddressDialog.this.addressField.setText(NEAddressDialog.this.address);
                    NEAddressDialog.this.nameField.setText(NEAddressDialog.this.name);
                    NEAddressDialog.this.commentField.setText(NEAddressDialog.this.comment);
                    NEAddressDialog.this.tableListOwnsAddressfieldAll = false;
                    LOG.finest("valueChanged in TableListenerForAllNEs, address selected: " + NEAddressDialog.this.address, new Object[0]);
                    if (NEAddressDialog.this.showAllFoundEmApplications) {
                        NEAddressDialog.this.updateApplicationsPanel(NEAddressDialog.this.address);
                    }
                } else if (newSelectedIndices.length > 1) {
                    NEAddressDialog.this.btRemove.setEnabled(true);
                    NEAddressDialog.this.btConnect.setEnabled(false);
                    NEAddressDialog.this.btAdd.setEnabled(false);
                    NEAddressDialog.this.tableListOwnsAddressfieldAll = true;
                    NEAddressDialog.this.addressField.setText("");
                    NEAddressDialog.this.nameField.setText("");
                    NEAddressDialog.this.commentField.setText("");
                    NEAddressDialog.this.tableListOwnsAddressfieldAll = false;
                }
            }
        }
    }
}

