/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.cache.SplashVerifyListener;
import se.ericsson.security.launcher.cache.VerifyListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.SplashDownloadListener;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.ui.SplashWindowInterface;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public final class SplashWindow
extends JFrame
implements ProgressListenerInterface,
SplashWindowInterface {
    private static final long serialVersionUID = 7656944529696762059L;
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    transient DownloadListener downloadListener = null;
    transient VerifyListener verifyListener = null;
    volatile JLabel infoLabel;
    volatile JLabel productLabel;
    volatile JLabel versionLabel;
    volatile JLabel logoLabel;
    volatile JLabel statusLabel;
    volatile JLabel copyrightLabel;
    volatile JProgressBar progressBar;
    volatile JLabel progressLabel;
    volatile JPanel downloadFeedbackPanel;
    volatile JTextArea finfaTextArea;
    volatile JScrollPane finfaScrollPane;
    volatile JPanel progressPanel;
    JPanel framePanel;
    JPanel splashPanel;
    Color ericBlue = new Color(0, 40, 94);
    boolean firstText = true;
    private transient PropertyManager pm = PropertyManager.getInstance(this.getClass().getClassLoader());
    private Object updater = null;
    private String infoMsg = "";
    private String statusMsg = "";
    private String progressOp = "";
    private int progressSoFar;
    private int progressTotal;

    public SplashWindow(String cxcnumber, String revision) {
        this.logoLabel = new JLabel(new ImageIcon(this.getClass().getResource("splash_logo.png")));
        this.logoLabel.setLayout(new BoxLayout(this.logoLabel, 1));
        this.logoLabel.setPreferredSize(new Dimension(140, 297));
        this.logoLabel.setBorder(BorderFactory.createEmptyBorder());
        this.logoLabel.setBackground(this.ericBlue);
        StringBuffer version = new StringBuffer();
        version.append(cxcnumber);
        version.append(" Rev ").append(revision);
        String productName = this.pm.getString("se.ericsson.security.launcher.productname", false);
        this.productLabel = new JLabel(productName, 2);
        this.productLabel.setFont(new Font("Arial", 0, 20));
        this.productLabel.setForeground(Color.white);
        this.versionLabel = new JLabel(version.toString(), 2);
        this.versionLabel.setFont(new Font("Arial", 0, 12));
        this.versionLabel.setForeground(Color.white);
        this.infoLabel = new JLabel();
        this.infoLabel.setFont(new Font("Arial", 0, 12));
        this.infoLabel.setForeground(Color.white);
        this.infoLabel.setAlignmentX(0.0f);
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(new Font("Arial", 0, 12));
        this.statusLabel.setForeground(Color.white);
        this.progressLabel = new JLabel();
        this.progressLabel.setFont(new Font("Arial", 0, 12));
        this.progressLabel.setForeground(Color.white);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(Color.white);
        this.progressBar.setForeground(new Color(49, 156, 206));
        this.progressBar.setMinimum(0);
        this.progressBar.setPreferredSize(new Dimension(340, 10));
        this.copyrightLabel = new JLabel(this.pm.getString("se.ericsson.security.launcher.copyright", false));
        this.copyrightLabel.setFont(new Font("Arial", 0, 12));
        this.copyrightLabel.setForeground(Color.white);
        this.splashPanel = new JPanel();
        this.splashPanel.setPreferredSize(new Dimension(415, 297));
        this.splashPanel.setBackground(this.ericBlue);
        this.splashPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 60));
        this.splashPanel.setLayout(new BoxLayout(this.splashPanel, 1));
        this.splashPanel.add(Box.createVerticalStrut(50));
        this.splashPanel.add(this.productLabel);
        this.splashPanel.add(Box.createVerticalStrut(15));
        this.splashPanel.add(this.versionLabel);
        this.splashPanel.add(Box.createVerticalStrut(5));
        this.splashPanel.add(this.infoLabel);
        this.splashPanel.add(this.statusLabel);
        this.splashPanel.add(Box.createVerticalStrut(40));
        this.splashPanel.add(this.progressBar);
        this.splashPanel.add(Box.createVerticalStrut(5));
        this.splashPanel.add(this.progressLabel);
        this.splashPanel.add(Box.createVerticalStrut(55));
        this.splashPanel.add(this.copyrightLabel);
        this.framePanel = new JPanel();
        this.framePanel.setPreferredSize(new Dimension(555, 297));
        this.framePanel.setBackground(this.ericBlue);
        this.framePanel.setLayout(new BorderLayout());
        this.framePanel.add((Component)this.logoLabel, "West");
        this.logoLabel.setVerticalAlignment(1);
        this.framePanel.add((Component)this.splashPanel, "Center");
        this.setUndecorated(true);
    }

    public void showSplash() {
        LOG.entering(new Object[0]);
        Runnable r = new Runnable(){

            public void run() {
                Container contentPane = SplashWindow.this.getContentPane();
                contentPane.add((Component)SplashWindow.this.framePanel, "West");
                SplashWindow.this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension labelSize = SplashWindow.this.splashPanel.getPreferredSize();
                SplashWindow.this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
                boolean disableSplashWindow = TmProperty.DISABLE_SPLASH_WINDOW.getBoolean();
                LOG.fine("Splash window is {0} showed, due to Test Mode property DISABLE_SPLASH_WINDOW", disableSplashWindow ? "not" : "");
                SplashWindow.this.setVisible(!disableSplashWindow);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void removeSplash() {
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
                LOG.finer("close", new Object[0]);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setStatus(String statusString) {
        this.statusMsg = statusString;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.progressBar.setMaximum(10000);
                SplashWindow.this.progressBar.setValue(0);
                SplashWindow.this.progressBar.setIndeterminate(false);
                SplashWindow.this.progressLabel.setText("");
                SplashWindow.this.infoLabel.setText("");
                SplashWindow.this.statusLabel.setText(SplashWindow.this.statusMsg);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setInfo(String msg) {
        this.infoMsg = msg;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.statusLabel.setText("");
                SplashWindow.this.progressLabel.setText("");
                SplashWindow.this.progressBar.setMaximum(10000);
                SplashWindow.this.progressBar.setValue(0);
                SplashWindow.this.progressBar.setIndeterminate(false);
                SplashWindow.this.infoLabel.setText(SplashWindow.this.infoMsg);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setProgress(String operation, int sofar, int total) {
        this.progressOp = operation;
        this.progressSoFar = sofar;
        this.progressTotal = total;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.statusLabel.setText("");
                SplashWindow.this.infoLabel.setText("");
                SplashWindow.this.progressLabel.setText(SplashWindow.this.progressOp);
                if (SplashWindow.this.progressTotal == -1) {
                    SplashWindow.this.progressBar.setIndeterminate(true);
                } else {
                    if (SplashWindow.this.progressBar.getMaximum() != SplashWindow.this.progressTotal) {
                        SplashWindow.this.progressBar.setMaximum(SplashWindow.this.progressTotal);
                    }
                    SplashWindow.this.progressBar.setValue(SplashWindow.this.progressSoFar);
                    SplashWindow.this.progressBar.setIndeterminate(false);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized DownloadListener getDownloadListener() {
        if (this.downloadListener == null) {
            this.downloadListener = new SplashDownloadListener(this);
        }
        return this.downloadListener;
    }

    public synchronized VerifyListener getVerifyListener() {
        if (this.verifyListener == null) {
            this.verifyListener = new SplashVerifyListener(this);
        }
        return this.verifyListener;
    }

    public void setUpdater(Object updater) {
        this.updater = updater;
    }

    public Object getUpdater() {
        return this.updater;
    }

    public synchronized void close() {
        this.updater = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SplashWindow.this.removeSplash();
            }
        });
    }
}

