/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import se.ericsson.security.launcher.ApplicationClassLoader;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.ConfigurationException;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.ExceptionHandlerInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.MetaLauncher;
import se.ericsson.security.launcher.MetaLauncherInterface;
import se.ericsson.security.launcher.VersionedLauncherAdapter;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.launcher.cache.StubbedVerifyListener;
import se.ericsson.security.launcher.download.StubbedDownloadListener;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.ui.SplashWindow;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.AuthRequest;
import se.ericsson.security.starter.Authenticator;
import se.ericsson.security.starter.CloseConnectionRequest;
import se.ericsson.security.starter.ConnInfoHandler;
import se.ericsson.security.starter.Request;
import se.ericsson.security.starter.Response;
import se.ericsson.security.starter.ServerThreadGroup;
import se.ericsson.security.starter.Starter;
import se.ericsson.security.utils.EmLogger;

public class Server
implements Runnable,
MetaLauncherInterface {
    private static final EmLogger LOG = EmLogger.STARTER;
    private final boolean useSystemExit = !Boolean.getBoolean("se.ericsson.security.launcher.noExitOnError");
    private final boolean okToShowDialog = !Boolean.getBoolean("launchertest.silent");
    private int port = 0;
    private final String[] secret_dirs;
    private final String root_path;
    private final String remotePort;
    private boolean shutdown = false;
    private boolean isUp = false;
    private VersionedLauncherAdapter theLauncher;
    private final String hostname;
    private final PropertyManager pm;
    private SplashWindow splashWindow = null;
    private ClassLoader interfaceClassLoader;
    private String myCxc = "CXC1721561";
    private String myVersion = "Server";
    private ErrorDialog edial = null;
    private final ConnInfoHandler connInfoHandler;
    private Authenticator authenticator = null;
    private final ServerThreadGroup serverThreadGroup;
    private static final int SERVER_SOCKET_TIMEOUT = 100;
    public static final String firstLauncherCxc = "CXC1721561";
    public static final String[] listOfOldReleasedLaunchersNotToUse = new String[]{"1", "2", "3", "4", "60", "61", "70", "71", "72", "73", "74", "75", "76", "77"};
    public static boolean isRunning;

    public void onExit(VersionedLauncherInterface launcher) {
        this.shutdownServer();
    }

    public VersionedLauncherInterface getLauncher(Launchable app) {
        return (VersionedLauncherInterface)((Object)this.theLauncher);
    }

    public Launchable runApplication(String nameOrPath, String hostname, Properties arguments, Launchable parent_ref) throws LauncherException {
        this.edial = new ErrorDialog(Localizer.getString("launcher_rev_mismatch") + "\n" + Localizer.getString("restart_msg") + " - " + Localizer.getString("application_cannot_start"));
        this.edial.setVisible(this.okToShowDialog);
        throw new LauncherException("EM Launcher revision does not match the revision requested by the application!");
    }

    public Server(String[] secret_dirs, String root_path, String ne, String remotePort, ServerThreadGroup stg) {
        this(0, secret_dirs, root_path, ne, remotePort, stg);
    }

    public Server(int port, String[] secret_dirs, String root_path, String networkElement, String remotePort, ServerThreadGroup stg) {
        LOG.entering(port, secret_dirs, root_path, networkElement, remotePort, stg);
        isRunning = true;
        this.secret_dirs = secret_dirs;
        this.root_path = root_path;
        this.serverThreadGroup = stg;
        this.connInfoHandler = ConnInfoHandler.getInstance();
        MetaLauncher.setDelegate(this);
        this.pm = PropertyManager.getInstance(this.getClass().getClassLoader());
        try {
            Class<?> c = Class.forName("se.ericsson.security.launcher.LauncherInterface");
            this.interfaceClassLoader = c.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            LOG.severe("Unable to set Interface Class Loader " + e.getMessage(), new Object[0]);
        }
        this.port = port;
        this.hostname = networkElement;
        this.remotePort = remotePort;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public synchronized void shutdownServer() {
        this.shutdown = true;
    }

    public void run() {
        try {
            this.runServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runServer() throws IOException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
            serverSocket.setSoTimeout(100);
            this.port = serverSocket.getLocalPort();
            this.connInfoHandler.setPortLocal(this.port);
            this.isUp = true;
            Server server = this;
            synchronized (server) {
                if (Starter.isWaiting()) {
                    this.notify();
                }
            }
            this.serveConnections(serverSocket);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.connInfoHandler.deleteConnInfo();
            isRunning = false;
            if (this.useSystemExit) {
                System.exit(0);
            }
            throw throwable;
        }
    }

    private void serveConnections(ServerSocket serverSocket) {
        try {
            while (!this.shutdown) {
                Socket clientSocket;
                try {
                    clientSocket = serverSocket.accept();
                }
                catch (SocketTimeoutException ste) {
                    continue;
                }
                this.serveConnection(clientSocket);
            }
            serverSocket.close();
        }
        catch (IOException ioe) {
            System.out.println("An exception in serveConnections.");
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serveConnection(Socket clientSocket) throws IOException {
        ObjectInputStream in;
        block23: {
            ObjectOutputStream out = null;
            in = null;
            try {
                try {
                    out = new ObjectOutputStream(clientSocket.getOutputStream());
                    in = new ObjectInputStream(clientSocket.getInputStream());
                    Object o = null;
                    boolean done = false;
                    boolean isAuth = false;
                    while (!done && (o = in.readObject()) != null) {
                        Response resp = null;
                        if (o instanceof AuthRequest) {
                            resp = this.handleAuthRequest((AuthRequest)o, out, in, clientSocket.getLocalPort());
                            isAuth = resp.getStatus() == 0;
                        } else if (o instanceof Request) {
                            resp = this.handleRequest((Request)o, isAuth);
                        } else if (o instanceof CloseConnectionRequest) {
                            done = true;
                        } else {
                            resp = new Response(-1, "Unable to handle request");
                        }
                        if (done) continue;
                        out.writeObject(resp);
                    }
                    Object var9_11 = null;
                    if (out == null) break block23;
                }
                catch (EOFException e) {
                    Object var9_12 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    clientSocket.close();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var9_13 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    clientSocket.close();
                    return;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    Object var9_14 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    clientSocket.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                clientSocket.close();
                throw throwable;
            }
            out.close();
        }
        if (in != null) {
            in.close();
        }
        clientSocket.close();
    }

    private void mergeSystemProperties(Properties primarySystemProperties, Properties secondarySystemProperties) {
        LOG.fine("secondarySystemProperties:" + secondarySystemProperties, new Object[0]);
        LOG.fine("primarySystemProperties:" + primarySystemProperties, new Object[0]);
        secondarySystemProperties.putAll((Map<?, ?>)primarySystemProperties);
        System.setProperties(secondarySystemProperties);
        LOG.fine("new System.properites:" + System.getProperties(), new Object[0]);
    }

    private void runAnApplication(Response resp, Properties arguments, Properties callingProcessSysprops) throws LauncherException {
        block23: {
            LOG.fine("arguments:" + arguments, new Object[0]);
            String applPath = (String)arguments.get("applPath");
            arguments.remove("applPath");
            this.mergeSystemProperties(System.getProperties(), callingProcessSysprops);
            if (this.theLauncher == null) {
                URL url = null;
                try {
                    int httpPort = -1;
                    try {
                        httpPort = Integer.parseInt(this.remotePort);
                    }
                    catch (NumberFormatException e) {
                        httpPort = -1;
                    }
                    url = new URL("http", this.hostname, httpPort, applPath);
                    LOG.fine("URL made; " + url.toString(), new Object[0]);
                }
                catch (MalformedURLException e) {
                    this.edial = new ErrorDialog(Localizer.getString("invalid_conf_path") + " http://" + this.hostname + applPath + " - " + Localizer.getString("application_cannot_start"), e);
                    this.edial.setVisible(this.okToShowDialog);
                    if (resp == null) {
                        throw new ConfigurationException("Invalid configuration file path http://" + this.hostname + applPath, (Throwable)e);
                    }
                    resp.setExc(new ConfigurationException("Invalid configuration file path http://" + this.hostname + applPath, (Throwable)e));
                    resp.setStatus(3);
                    resp.setMsg("Invalid configuration file path http://" + this.hostname + applPath);
                    this.onExit(null);
                    return;
                }
                this.openSplash();
                this.splashWindow.setStatus(Localizer.getString("fetch_appl_config"));
                this.splashWindow.setProgress(Localizer.getString("downloading") + " " + url.toExternalForm(), 20, 100);
                ApplicationConfiguration applicationConfiguration = null;
                Cache cache = new Cache(new StubbedDownloadListener(), new StubbedVerifyListener(), this.pm);
                try {
                    LOG.fine("Will make new ApplicationConfiguration. url: " + url.toString(), new Object[0]);
                    applicationConfiguration = new ApplicationConfiguration(url, cache, true);
                }
                catch (ConfigurationException e) {
                    this.closeSplash();
                    this.edial = new ErrorDialog(e.getMessage() + " - " + Localizer.getString("application_cannot_start"), e);
                    this.edial.setVisible(this.okToShowDialog);
                    if (resp == null) {
                        throw e;
                    }
                    resp.setExc(new LauncherException("A configuration exception occurred. " + e.getMessage()));
                    resp.setStatus(6);
                    resp.setMsg("An exception occurred when downloading and/or parsing configuration file");
                    this.onExit(null);
                    return;
                }
                ApplicationFileInterface launcherFile = applicationConfiguration.getLauncherFile();
                String reqRev = launcherFile.getRevision();
                String reqCxc = launcherFile.getProductNumber();
                LOG.fine("Required EM Launcher according to configuration file: " + reqCxc + " " + reqRev, new Object[0]);
                boolean useExecutingLauncher = false;
                if (TmProperty.DISABLE_SECONDARY_LAUNCHER.getBoolean()) {
                    useExecutingLauncher = true;
                    LOG.fine("Running in testmode and executing Launcher shall continue to execute.", new Object[0]);
                } else if (this.isLauncherOldVersion(reqCxc, reqRev)) {
                    useExecutingLauncher = true;
                    LOG.fine("Required launcher revision is old", new Object[0]);
                }
                URL localJarURL = null;
                if (useExecutingLauncher) {
                    URL installedLauncherUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
                    LOG.fine("installedLauncherUrl: " + installedLauncherUrl, new Object[0]);
                    localJarURL = installedLauncherUrl;
                }
                try {
                    if (null == localJarURL) {
                        ApplicationFile af = new ApplicationFile(launcherFile.getName(), launcherFile.getFilePath(), launcherFile.getProductNumber(), launcherFile.getRevision());
                        URL remoteJarURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), launcherFile.getFilePath());
                        LOG.fine("Remote JAR file: " + remoteJarURL.toExternalForm(), new Object[0]);
                        CachedFile cf = cache.getFile(af, remoteJarURL, false);
                        localJarURL = new URL("file", "", cf.getFileName());
                    }
                    LOG.fine("Local JAR file: " + localJarURL.toExternalForm(), new Object[0]);
                    URL[] u = new URL[]{localJarURL};
                    ApplicationClassLoader acl = new ApplicationClassLoader("SecondaryLauncherFor:" + applPath, u, ClassLoader.getSystemClassLoader(), this.interfaceClassLoader);
                    this.theLauncher = new VersionedLauncherAdapter(acl);
                }
                catch (MalformedURLException e) {
                    this.closeSplash();
                    this.edial = new ErrorDialog(Localizer.getString("download_from_ill_url") + " " + Localizer.getString("application_cannot_start"), e);
                    this.edial.setVisible(this.okToShowDialog);
                    if (resp == null) {
                        throw new LauncherException("Illegal URL when trying to load launcher.jar file", (Throwable)e);
                    }
                    resp.setExc(new ConfigurationException("Illegal URL when trying to load launcher.jar file", (Throwable)e));
                    resp.setStatus(3);
                    resp.setMsg("Illegal URL when trying to load launcher.jar file");
                    this.onExit(null);
                    return;
                }
                catch (LauncherException e) {
                    this.closeSplash();
                    this.edial = new ErrorDialog(Localizer.getString("class_loading_exception") + " " + e.getMessage() + " - " + Localizer.getString("application_cannot_start"), e);
                    this.edial.setVisible(this.okToShowDialog);
                    if (resp == null) {
                        throw e;
                    }
                    resp.setStatus(4);
                    resp.setMsg("An exception in class loading " + e.getClass().getName() + " " + e.getMessage());
                    resp.setExc(e);
                    this.onExit(null);
                    return;
                }
                this.theLauncher.setMetaLauncher(this);
                this.closeSplash();
            }
            try {
                this.theLauncher.runApplication(applPath, this.hostname, arguments, null);
                if (resp != null) {
                    resp.setStatus(0);
                    resp.setMsg("OK");
                }
            }
            catch (LauncherException e) {
                if (resp == null) {
                    throw e;
                }
                resp.setStatus(5);
                resp.setMsg("An exception in runApplication " + e.getMessage());
                resp.setExc(e);
                if (!this.theLauncher.getRunningApplications().isEmpty()) break block23;
                this.onExit(null);
            }
        }
    }

    private boolean isLauncherOldVersion(String reqCxc, String reqRev) {
        boolean requiredRevIsOldVersion = false;
        if (reqCxc.equalsIgnoreCase(firstLauncherCxc)) {
            LOG.fine("Required CXC is the CXC1721561", new Object[0]);
            String[] numberStrs = reqRev.trim().split("[a-zA-Z]");
            if (numberStrs != null && numberStrs.length > 0) {
                int i;
                String firstNumberS = "";
                for (i = 0; i < numberStrs.length && (firstNumberS = numberStrs[i].trim()).length() <= 0; ++i) {
                }
                for (i = 0; i < listOfOldReleasedLaunchersNotToUse.length; ++i) {
                    if (!listOfOldReleasedLaunchersNotToUse[i].equalsIgnoreCase(firstNumberS)) continue;
                    requiredRevIsOldVersion = true;
                    LOG.fine("Found out that required launcher rev is old one. (" + firstNumberS + ")", new Object[0]);
                    break;
                }
            }
        }
        return requiredRevIsOldVersion;
    }

    public void handleRequestLocal(Properties args) throws LauncherException {
        this.runAnApplication(null, args, System.getProperties());
    }

    private Response handleAuthRequest(AuthRequest req, ObjectOutputStream out, ObjectInputStream in, int clientPort) {
        if (this.authenticator == null) {
            this.authenticator = Authenticator.getInstance();
            StringBuffer path = new StringBuffer(this.root_path);
            for (int i = 0; i < this.secret_dirs.length; ++i) {
                path.append(File.separator).append(this.secret_dirs[i]);
            }
            this.authenticator.init(path.toString(), this.hostname);
        }
        return this.authenticator.authenticateTheClient(out, in, clientPort);
    }

    private Response handleRequest(Request req, boolean isAuth) {
        Response resp = new Response();
        if (isAuth) {
            String method = req.getMethod();
            Object[] params = req.getParams();
            if (method.equals("runApplication")) {
                try {
                    this.runAnApplication(resp, (Properties)params[0], (Properties)params[1]);
                }
                catch (LauncherException e) {}
            }
        } else {
            resp.setStatus(1);
            resp.setMsg("User not authenticated");
        }
        return resp;
    }

    private void openSplash() {
        if (this.splashWindow == null) {
            this.splashWindow = new SplashWindow(this.myCxc, this.myVersion);
            this.splashWindow.showSplash();
            this.splashWindow.setUpdater(this);
        }
    }

    private void closeSplash() {
        if (this.splashWindow != null && this.splashWindow.getUpdater() == this) {
            this.splashWindow.close();
            this.splashWindow = null;
        }
    }

    public void setExceptionHandler(Launchable l, ExceptionHandlerInterface ehi) {
        this.serverThreadGroup.setExceptionHandler(l, ehi);
    }

    public static boolean isServerRunning() {
        return isRunning;
    }
}

