/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.LogManager;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.testmode.TmPropertiesLoader;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.launcher.testmode.TmUtilitiesExt;
import se.ericsson.security.launcher.ui.NEAddressDialog;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.Authenticator;
import se.ericsson.security.starter.CloseConnectionRequest;
import se.ericsson.security.starter.ConnInfoHandler;
import se.ericsson.security.starter.Request;
import se.ericsson.security.starter.Response;
import se.ericsson.security.starter.Server;
import se.ericsson.security.starter.ServerThreadGroup;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.starter.investigator.EmApplicationInfoFactory;
import se.ericsson.security.starter.investigator.NodeTypeInvestigator;
import se.ericsson.security.utils.CliArguments;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Starter {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final String HTTP = "http";
    private static final String LOGGING_CONFIG_FILE_KEY = "java.util.logging.config.file";
    private static final boolean OK_TO_CALL_SYSTEM_EXIT = !Boolean.getBoolean("se.ericsson.security.launcher.noExitOnError");
    private static final boolean OK_TO_SHOW_DIALOG = !Boolean.getBoolean("launchertest.silent");
    private static final String PROTOCOL_ADDRESS_DIVIDER = "://";
    private static final int SOCKET_TIMEOUT = 20000;
    private static final long START_TIME = System.currentTimeMillis();
    private static final String SYS_PROPERTY_APPLICATION_INDEX = "se.ericsson.security.launcher.applIndex";
    private static final String SYS_PROPERTY_DISPLAY_NAME = "se.ericsson.security.display_name";
    private static final String SYS_PROPERTY_ON_APPLICATION_SERVER = "se.ericsson.security.onapplicationserver";
    private static final String SYS_PROPERTY_ORIGINAL_APPLICATION_NAME = "se.ericsson.security.launcher.origAppName";
    private static boolean isWaiting = false;
    private Exception exceptionInLocalRunAppl = null;
    private PropertyManager propertyManager = PropertyManager.getInstance(this.getClass().getClassLoader());
    private boolean serverStartedByMe = false;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] argv) throws Exception {
        void var3_10;
        void var3_5;
        CliArguments.CLI_ARGUMENTS.initArguments(argv);
        EProps rev = EProps.getRevisionProperties();
        rev.set(EKEY.ENV_COMMAND_LINE, CliArguments.CLI_ARGUMENTS.toString());
        rev.set(EKEY.ENV_USER, System.getProperty("user.name"));
        rev.set(EKEY.REV_OS_VERSION, System.getProperty("os.name") + ", " + System.getProperty("os.arch") + ", " + System.getProperty("os.version"));
        rev.set(EKEY.REV_JAVA_VERSION, System.getProperty("java.vm.name") + ", " + System.getProperty("java.vm.version"));
        rev.set(EKEY.ENV_CASHE_DIR, System.getProperty("se.ericsson.security.launcher.cachedirname"));
        rev.set(EKEY.ENV_INSTALL_DIR, System.getenv("lax.root.install.dir"));
        rev.set(EKEY.ENV_CLASSPATH, System.getProperty("java.class.path"));
        rev.set(EKEY.ENV_EXT_DIRS, System.getProperty("java.ext.dirs"));
        TmPropertiesLoader.loadProperties();
        if (TmProperty.LOGGING_CONFIG_FILE.isSet()) {
            String oldLoggingConfigFile = System.getProperty(LOGGING_CONFIG_FILE_KEY);
            String newLoggingConfigFile = TmProperty.LOGGING_CONFIG_FILE.getValue();
            System.setProperty(LOGGING_CONFIG_FILE_KEY, newLoggingConfigFile);
            LogManager.getLogManager().readConfiguration();
            LOG.info(TmUtilities.getLogMessage("Replaced java logging config file:{0}{1}{0}with{0}{2}{0}"), "\n      ", oldLoggingConfigFile, newLoggingConfigFile);
        }
        LOG.info("CLI arguments: {0}", CliArguments.CLI_ARGUMENTS.toString());
        LOG.finest("Properties after Test Mode properties has been taken care of: {0}", CliArguments.CLI_ARGUMENTS.getProperties());
        ClassLoader clThis = Starter.class.getClassLoader();
        System.out.println(" System class loader : " + ClassLoader.getSystemClassLoader());
        System.out.println(" This class loader   : " + clThis);
        Object clPrev = null;
        ClassLoader classLoader = clThis.getParent();
        while (var3_5 != null) {
            System.out.println(" Parent class loader : " + var3_5);
            if (clPrev == var3_5) break;
            clPrev = var3_5;
            ClassLoader classLoader2 = var3_5.getParent();
        }
        System.out.println("java.ext.dirs = " + System.getProperty("java.ext.dirs"));
        System.out.println("java.class.path" + System.getProperty("java.class.path") + "\n");
        for (Method method : clThis.getClass().getDeclaredMethods()) {
            System.out.println("   Publ method : " + method.toString());
        }
        for (Class<?> clazz : clThis.getClass().getInterfaces()) {
            System.out.println("   Imlemented Interfaces : " + clazz.toString());
        }
        Class<?> clazz = clThis.getClass();
        while (var3_10 != null) {
            System.out.println("   Superclass : " + var3_10.toString());
            if (var3_10 == Object.class) break;
            Class<?> clazz2 = var3_10.getClass().getSuperclass();
        }
        System.out.println("\n");
        for (TmProperty tmProperty : TmProperty.values()) {
            System.out.println((Object)tmProperty);
        }
        System.out.println("\n\n");
        if (TmProperty.HTTP_ROOT.isSet() && TmProperty.SEMLA.isSet()) {
            try {
                TmUtilitiesExt.startStubbedWebServer();
                LOG.fine("Properties when stubbed WEB server has started: {0}", CliArguments.CLI_ARGUMENTS.getProperties());
            }
            catch (Exception e) {
                Starter.exitDueToProblemWithStubbedEnvironment("Failed starting stubbed WEB server!", e);
            }
        }
        Starter starter = new Starter();
        LOG.fine("About to start an application.", new Object[0]);
        starter.startApplication();
        LOG.fine("Start of application is done.", new Object[0]);
        if (OK_TO_CALL_SYSTEM_EXIT && !starter.isServerStartedByMe()) {
            LOG.fine("This Starter did not start the Server, kill the process to avoid hangings.", new Object[0]);
            System.exit(0);
        }
    }

    public static boolean isWaiting() {
        return isWaiting;
    }

    private static void exitDueToProblemWithStubbedEnvironment(String msg, Exception e) {
        LOG.severe(TmUtilities.getLogMessage(msg), e);
        System.exit(1);
    }

    public boolean isServerStartedByMe() {
        return this.serverStartedByMe;
    }

    public void setServerStartedByMe(boolean serverStartedByMe) {
        this.serverStartedByMe = serverStartedByMe;
    }

    private void startApplication() throws Exception {
        String remote_host;
        String value;
        URL url;
        LOG.finest("Initial properties for startApplication(): {0}", CliArguments.CLI_ARGUMENTS.getProperties());
        Properties properties = CliArguments.CLI_ARGUMENTS.getProperties();
        if (CliArguments.CLI_ARGUMENTS.iconPathExist()) {
            String iconPath = this.findIconFile(CliArguments.CLI_ARGUMENTS.getIconPath());
            properties.setProperty("TOOL_ICON", iconPath);
        }
        if (properties.containsKey("hostname") && (url = this.getUrl(value = properties.getProperty("hostname"))) != null) {
            this.setHostProperties(properties, url, value);
        }
        if ((url = this.getUrl(remote_host = System.getProperty("se.ericsson.security.launcher.remote_host"))) != null) {
            this.setHostProperties(properties, url, remote_host);
        }
        LOG.finest("Initial properties for startApplication() after modification: {0}", CliArguments.CLI_ARGUMENTS.getProperties());
        if (!properties.containsKey("hostname")) {
            this.showNEAddressDialog(properties);
        } else {
            String appToStart = properties.getProperty("applicationToStart", "");
            if (appToStart.equalsIgnoreCase("em")) {
                // empty if block
            }
            if (!properties.containsKey("applPath")) {
                LOG.info("PROPERTY_APPLPATH not set, trying to download configuration", new Object[0]);
                NodeTypeInvestigator investigator = new NodeTypeInvestigator();
                investigator.init();
                URL nodeUrl = this.getUrl(properties.getProperty("hostname") + ":" + properties.getProperty("httpPort"));
                if (nodeUrl == null && OK_TO_CALL_SYSTEM_EXIT) {
                    System.exit(1);
                }
                if (investigator.contactWithNode(nodeUrl)) {
                    LOG.info("Investigator has contact with Node, url=" + nodeUrl.toString(), nodeUrl);
                    ArrayList<EmApplicationInfo> emApps = this.getEmAppInfo(investigator, nodeUrl);
                    if (emApps != null) {
                        for (int i = 0; i < emApps.size(); ++i) {
                            if (!"EM".equals(emApps.get(i).getApplicationType())) continue;
                            LOG.info("Set PROPERTY_APPLPATH to = " + emApps.get(i).getConfigFileName(), new Object[0]);
                            properties.setProperty("applPath", emApps.get(i).getConfigFileName());
                        }
                    }
                } else {
                    LOG.info("Investigator has NO contact with Node, url=" + nodeUrl.toString(), nodeUrl);
                }
            }
            if (!properties.containsKey("applPath")) {
                LOG.info("No application path specified and could not be downloaded.", new Object[0]);
                ErrorDialog errorDialog = new ErrorDialog(Localizer.getString("missing_path_to_app") + " - " + Localizer.getString("application_cannot_start"));
                errorDialog.setVisible(OK_TO_SHOW_DIALOG);
                if (OK_TO_CALL_SYSTEM_EXIT) {
                    System.exit(1);
                }
            }
        }
        LOG.finest("Initial properties for startApplication() after user intervention: {0}", CliArguments.CLI_ARGUMENTS.getProperties());
        if (properties.getProperty("address") != null) {
            LOG.finest("applPath now: " + properties.getProperty("applPath"), new Object[0]);
            if (Boolean.getBoolean(SYS_PROPERTY_ON_APPLICATION_SERVER)) {
                System.setProperty(SYS_PROPERTY_ORIGINAL_APPLICATION_NAME, System.getProperty(SYS_PROPERTY_DISPLAY_NAME));
                System.setProperty(SYS_PROPERTY_APPLICATION_INDEX, "0");
            }
            properties.setProperty("StartTime", Long.toString(START_TIME));
            String address = properties.getProperty("address");
            String newPort = properties.getProperty("httpPort");
            Socket socket = null;
            ObjectOutputStream out = null;
            ObjectInputStream in = null;
            String root_path = this.propertyManager.getString("se.ericsson.security.launcher.launcherdir", true) + System.getProperty("file.separator") + ".launcher";
            String hostPathPart = Starter.getEnvOrProperty("HOST", "localhost");
            String displayPathPart = Starter.getEnvOrProperty("DISPLAY", "a_display");
            EProps.getRevisionProperties().set(EKEY.ENV_LOCAL_HOST, hostPathPart);
            EProps.getRevisionProperties().set(EKEY.ENV_LOCAL_DISPLAY, displayPathPart);
            ConnInfoHandler connInfoHandler = ConnInfoHandler.getInstance();
            connInfoHandler.init(new String[]{hostPathPart, displayPathPart}, root_path, address);
            int existingPort = 0;
            boolean exit = false;
            try {
                existingPort = connInfoHandler.getPort();
                if (existingPort == 0) {
                    LOG.fine("C: Server for " + address + " not started, starting it...", new Object[0]);
                    String timeout = this.propertyManager.getString("se.ericsson.security.launcher.connecttimeout", false);
                    if (timeout != null) {
                        System.setProperty("sun.net.client.defaultConnectTimeout", timeout);
                    }
                    this.createServerAndRunApplication(new String[]{hostPathPart, displayPathPart}, root_path, address, newPort, properties, false, connInfoHandler);
                    exit = true;
                    LOG.fine("C: Server for " + address + " started", new Object[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (OK_TO_CALL_SYSTEM_EXIT) {
                    System.exit(1);
                }
                exit = true;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if (OK_TO_CALL_SYSTEM_EXIT) {
                    System.exit(1);
                }
                exit = true;
            }
            if (!exit) {
                boolean isConnected = false;
                boolean serverRestarted = false;
                while (!isConnected) {
                    try {
                        LOG.fine("Connecting to server", new Object[0]);
                        socket = new Socket("localhost", existingPort);
                        socket.setSoTimeout(20000);
                        out = new ObjectOutputStream(socket.getOutputStream());
                        in = new ObjectInputStream(socket.getInputStream());
                        isConnected = true;
                    }
                    catch (UnknownHostException e) {
                        if (Boolean.getBoolean("se.ericsson.security.launcher.debug")) {
                            e.printStackTrace();
                        }
                        if (OK_TO_CALL_SYSTEM_EXIT) {
                            System.exit(1);
                        }
                        exit = true;
                        break;
                    }
                    catch (IOException e) {
                        if (serverRestarted) {
                            if (Boolean.getBoolean("se.ericsson.security.launcher.debug")) {
                                e.printStackTrace();
                            }
                            if (OK_TO_CALL_SYSTEM_EXIT) {
                                System.exit(1);
                            }
                            exit = true;
                            break;
                        }
                        this.createServerAndRunApplication(new String[]{hostPathPart, displayPathPart}, root_path, address, newPort, properties, true, connInfoHandler);
                        exit = true;
                        isConnected = true;
                        serverRestarted = true;
                    }
                }
                if (!exit) {
                    try {
                        LOG.fine("Start authentication towards server", new Object[0]);
                        boolean auth = true;
                        Authenticator authenticator = Authenticator.getInstance();
                        authenticator.init(root_path + File.separator + hostPathPart + File.separator + displayPathPart, address);
                        auth = authenticator.authenticateTowardsServer(socket, in, out);
                        if (auth) {
                            Object o;
                            out.writeObject(new Request("runApplication", new Object[]{properties, System.getProperties()}));
                            LOG.fine("Sent the runApplication command!!", new Object[0]);
                            while (true) {
                                try {
                                    o = in.readObject();
                                }
                                catch (IOException e) {
                                    if (e instanceof SocketTimeoutException) continue;
                                    throw e;
                                }
                                break;
                            }
                            if (o instanceof Response) {
                                Response resp = (Response)o;
                                if (resp.getStatus() != 0) {
                                    LOG.fine(resp.getMsg(), new Object[0]);
                                }
                                out.writeObject(new CloseConnectionRequest());
                            }
                        } else {
                            LOG.severe("Could not authenticate user; exiting", new Object[0]);
                            out.writeObject(new CloseConnectionRequest());
                        }
                    }
                    catch (IOException e) {
                        System.out.println("An IOException occurred " + e.getClass().getName() + " at time " + System.currentTimeMillis());
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("The class to be deserialized was not found");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private ArrayList<EmApplicationInfo> getEmAppInfo(NodeTypeInvestigator nodeTypeInvestigator, URL url) {
        ArrayList<EmApplicationInfo> emApps = null;
        String fileContents = "";
        try {
            fileContents = nodeTypeInvestigator.getEmApplicationsFileContentsFromNode(url, "/em/emapplications.xml");
        }
        catch (Exception ex) {
            LOG.finer("Caught exception when reading emapplications.xml from node. " + ex, new Object[0]);
            if (null != ex.getCause() && ex.getCause().getClass().equals(FileNotFoundException.class)) {
                LOG.finer("getEmAppInfo, the emapplications.xml was not found on the node.", new Object[0]);
            }
            LOG.finer("getEmAppInfo, the emapplications.xml was not found on the node.", ex);
        }
        if ("" != fileContents) {
            LOG.finest("emapplications.xml file contents:\n    " + fileContents, new Object[0]);
            emApps = EmApplicationInfoFactory.constructEmAppInfos(fileContents);
        }
        return emApps;
    }

    private void showNEAddressDialog(Properties properties) {
        LOG.fine("Opening address dialog", new Object[0]);
        URL url = null;
        boolean noUrl = true;
        while (noUrl) {
            boolean showAllEmApps = false;
            if (properties.getProperty("displayAllEmApps", "no").toLowerCase().matches("yes|true")) {
                showAllEmApps = true;
            }
            NEAddressDialog dialog = new NEAddressDialog(properties.getProperty("TOOL_ICON", ""), showAllEmApps);
            LOG.fine("Read address from address dialog", new Object[0]);
            String host = dialog.getAddress();
            if (host == null) {
                if (!OK_TO_CALL_SYSTEM_EXIT) break;
                System.exit(1);
                break;
            }
            String defaultPath = properties.getProperty("applPath");
            String newPath = dialog.getSelectedEmApplicationConfigFilePath(defaultPath);
            String newIconPath = dialog.getSelectedEmApplicationIconFilePath(properties.getProperty("TOOL_ICON"), this.getUrl(host));
            LOG.finer("icon path:" + newIconPath, new Object[0]);
            if (null != newIconPath) {
                properties.setProperty("TOOL_ICON", newIconPath);
            }
            properties.setProperty("applPath", newPath);
            LOG.finer("Got applPath from NEAddressDialog: " + newPath, new Object[0]);
            dialog = null;
            url = this.getUrl(host);
            if (url == null) continue;
            this.setHostProperties(properties, url, host);
            break;
        }
    }

    private static String getEnvOrProperty(String key, String defaultValue) {
        String value = null;
        try {
            value = System.getenv(key);
        }
        catch (Error error) {
            // empty catch block
        }
        if (value == null || value.equals("")) {
            value = System.getProperty(key);
        }
        if (value == null || value.equals("")) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createServerAndRunApplication(String[] secret_dirs, String root_path, String networkElement, String remotePort, Properties arguments, boolean deletePortInfo, ConnInfoHandler connInfoHandler) throws Exception {
        LOG.entering(secret_dirs, root_path, networkElement, remotePort, arguments, deletePortInfo, connInfoHandler);
        if (deletePortInfo) {
            connInfoHandler.deleteConnInfo();
            connInfoHandler = ConnInfoHandler.getInstance();
            connInfoHandler.init(secret_dirs, root_path, networkElement);
        }
        ServerThreadGroup theThreadGroup = new ServerThreadGroup();
        Server serv = new Server(secret_dirs, root_path, networkElement, remotePort, theThreadGroup);
        StarterLocalThread slt = new StarterLocalThread(theThreadGroup, serv, arguments);
        slt.start();
        try {
            slt.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.exceptionInLocalRunAppl != null) {
            this.exceptionInLocalRunAppl.printStackTrace();
            Exception e_l = this.exceptionInLocalRunAppl;
            this.exceptionInLocalRunAppl = null;
            if (!OK_TO_CALL_SYSTEM_EXIT) throw e_l;
            System.exit(1);
            return;
        }
        new Thread((ThreadGroup)theThreadGroup, serv).start();
        Server server = serv;
        synchronized (server) {
            if (!serv.isUp()) {
                isWaiting = true;
                try {
                    serv.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                isWaiting = false;
            }
        }
        connInfoHandler.prepareForWrite(secret_dirs, root_path, networkElement);
        connInfoHandler.setPort();
        this.setServerStartedByMe(true);
    }

    private String findIconFile(String cliArgIconPath) {
        String iconPath;
        LOG.fine("Trying to find icon '" + cliArgIconPath + "'", new Object[0]);
        File iconFile = new File(cliArgIconPath);
        if (iconFile.isAbsolute() && iconFile.isFile()) {
            LOG.fine("Found absolut icon file '" + iconFile.getAbsolutePath() + "'", new Object[0]);
            iconPath = iconFile.getAbsolutePath();
        } else {
            String iconDir;
            if (cliArgIconPath.startsWith(System.getProperty("file.separator"))) {
                cliArgIconPath = cliArgIconPath.substring(1);
            }
            if ((iconDir = this.propertyManager.getString("lax.root.install.dir", true)) == null) {
                iconDir = this.propertyManager.getString("se.ericsson.security.launcher.cachedirname", true);
            }
            iconPath = iconDir + System.getProperty("file.separator") + cliArgIconPath;
        }
        return iconPath;
    }

    private URL getUrl(String host) {
        int port;
        URL url;
        if (host == null || host.equals("")) {
            return null;
        }
        try {
            url = new URL("http://" + host);
        }
        catch (MalformedURLException e) {
            this.showErrorDialog(host);
            return null;
        }
        String address = url.getHost();
        if (url.getPort() == -1) {
            int tmpPort = url.getDefaultPort();
            try {
                url = new URL(HTTP, address, tmpPort, "");
            }
            catch (MalformedURLException e) {
                this.showErrorDialog(host);
                return null;
            }
        }
        if (!this.isAddressAndPortValid(address, port = url.getPort())) {
            this.showErrorDialog(host);
            return null;
        }
        return url;
    }

    private boolean isAddressAndPortValid(String address, int port) {
        try {
            InetSocketAddress isa = new InetSocketAddress(address, port);
            if (isa.isUnresolved()) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void setHostProperties(Properties properties, URL url, String host) {
        properties.setProperty("address", url.getHost());
        properties.setProperty("httpPort", Integer.toString(url.getPort()));
        EProps.getRevisionProperties().set(EKEY.HOSTNAME, url.getHost());
        properties.setProperty("hostname", host);
    }

    private void showErrorDialog(String host) {
        ErrorDialog edial = new ErrorDialog(Localizer.getString("inv_ne_address") + ": " + host + ". " + Localizer.getString("try_again"), null, "Try again");
        edial.setVisible(OK_TO_SHOW_DIALOG);
    }

    private class StarterLocalThread
    extends Thread {
        Server server;
        Properties properties;

        StarterLocalThread(ThreadGroup threadGroup, Server server, Properties arguments) {
            super(threadGroup, "StarterLocalThread");
            this.server = server;
            this.properties = arguments;
        }

        public void run() {
            try {
                this.server.handleRequestLocal(this.properties);
            }
            catch (LauncherException e) {
                Starter.this.exceptionInLocalRunAppl = e;
            }
        }
    }
}

