/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.ui.NEAddressDialog;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.utils.EmLogger;

public class StarterArguments {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final boolean OK_TO_SHOW_DIALOG = !Boolean.getBoolean("launchertest.silent");
    private static final String ICON_PATH_PROPERTY_NAME = "TOOL_ICON";
    private String theIconPath = "";

    public Properties getApplicationProperties(String[] arguments, String cachePath) throws Exception {
        Properties arg = this.parseArguments(arguments, cachePath);
        Properties properties = this.setHostnameProperties(arg);
        return properties;
    }

    private Properties parseArguments(String[] argv, String cachePath) throws Exception {
        Properties arguments = new Properties();
        arguments.put("applPath", argv[0]);
        int hostnameIndex = 1;
        if (argv.length > 1) {
            if (argv[1].indexOf("=") == -1) {
                if (argv[1].startsWith(System.getProperty("file.separator"))) {
                    argv[1] = argv[1].substring(1);
                }
                this.theIconPath = cachePath + System.getProperty("file.separator") + argv[1];
                arguments.setProperty(ICON_PATH_PROPERTY_NAME, this.theIconPath);
                hostnameIndex = 2;
            }
            for (int i = hostnameIndex; i < argv.length; ++i) {
                String[] t = argv[i].split("=", 2);
                arguments.put(t[0], t.length < 2 ? "" : t[1]);
            }
        }
        return arguments;
    }

    private Properties setHostnameProperties(Properties arguments) throws Exception {
        String hostname;
        if (Boolean.getBoolean("se.ericsson.security.onapplicationserver")) {
            System.setProperty("se.ericsson.security.launcher.origAppName", System.getProperty("se.ericsson.security.display_name"));
            System.setProperty("se.ericsson.security.launcher.applIndex", "0");
        }
        if ((hostname = System.getProperty("se.ericsson.security.launcher.remote_host")) != null && !hostname.equals("")) {
            arguments.put("hostname", hostname);
        }
        ErrorDialog edial = null;
        boolean validHostname = false;
        String address = arguments.getProperty("hostname");
        String port = null;
        while (!validHostname) {
            if (address != null) {
                String[] hostnameAndPort = StarterArguments.getHostnameAndPort(address);
                hostname = hostnameAndPort[0];
                port = hostnameAndPort[1];
                arguments.put("networkElement", hostname);
                try {
                    InetAddress.getByName(hostname);
                    LOG.fine("Valid hostname", new Object[0]);
                    if (port == null) {
                        validHostname = true;
                    } else if (0 <= Integer.parseInt(port) && Integer.parseInt(port) <= 65535) {
                        arguments.put("port", port);
                        validHostname = true;
                    }
                }
                catch (UnknownHostException e) {
                    validHostname = false;
                }
            }
            if (validHostname) continue;
            if (address != null) {
                edial = new ErrorDialog(Localizer.getString("inv_ne_address") + ": " + address + ". " + Localizer.getString("try_again"), null, "Try again");
                edial.setVisible(OK_TO_SHOW_DIALOG);
            }
            LOG.fine("Opening address dialog", new Object[0]);
            NEAddressDialog dialog = new NEAddressDialog(this.theIconPath);
            address = dialog.getAddress();
            LOG.fine("Read address from address dialog", new Object[0]);
            dialog = null;
            if (address != null) continue;
        }
        if (validHostname) {
            arguments.put("host", address);
            arguments.put("hostname", address);
            return arguments;
        }
        return null;
    }

    private static String[] getHostnameAndPort(String address) {
        String[] hostnameAndPort = new String[2];
        int portStart = address.indexOf(":");
        if (portStart == -1) {
            hostnameAndPort[0] = address.trim();
        } else if (address.endsWith(":")) {
            hostnameAndPort[0] = address.substring(0, portStart).trim();
        } else {
            hostnameAndPort[0] = address.substring(0, portStart).trim();
            hostnameAndPort[1] = address.substring(portStart + 1).trim();
        }
        return hostnameAndPort;
    }
}

