/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.masu.applications;

import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractWizardController;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.proxy.BaseException;
import se.ericsson.cello.support.proxy.NameValue;

public abstract class AbstractSmartWizardController
extends AbstractWizardController {
    protected boolean next() {
        this.addToHistory();
        return true;
    }

    protected boolean previous() {
        this.removeFromHistory();
        return true;
    }

    private void addToHistory() {
        int traversedBefore = this.slideInHistory(this.getThisSlideClassName());
        this.storeData(this.getThisSlideClassName(), new Integer(traversedBefore + 1));
        Log.trace("Now in history " + (traversedBefore + 1) + " times");
    }

    private void removeFromHistory() {
        int traversedBefore = this.slideInHistory(this.getThisSlideClassName());
        if (traversedBefore > 0) {
            this.storeData(this.getThisSlideClassName(), new Integer(traversedBefore - 1));
        }
        Log.trace("Now in history " + (traversedBefore > 0 ? traversedBefore - 1 : traversedBefore) + " times");
    }

    protected boolean isSlideInHistory(String slideFullClassName) {
        return this.slideInHistory(slideFullClassName) > 0;
    }

    protected int slideInHistory(String slideFullClassName) {
        int numTimes;
        Object record = this.retrieveData(slideFullClassName);
        if (record == null) {
            return 0;
        }
        try {
            numTimes = (Integer)record;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("history record for supplied classname corrupt!");
        }
        return numTimes;
    }

    protected String getThisSlideClassName() {
        return this.getClass().getName();
    }

    protected void stop() {
        final AbstractApplication application = this.getApplication();
        if (this.retrieveData("***closed***") == null) {
            this.storeData("***closed***", Boolean.valueOf("true"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    application.stopApplicationNoCheck();
                }
            });
        }
    }

    protected String getMyScreenBufName() {
        int delPosition;
        String myFullClassName = this.getThisSlideClassName();
        StringTokenizer st = new StringTokenizer(myFullClassName, ".");
        String myShortClassName = myFullClassName;
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                myShortClassName = st.nextToken();
            }
        }
        if ((delPosition = myShortClassName.indexOf("Controller")) == -1) {
            throw new RuntimeException("Illegal controller class name");
        }
        myShortClassName = new StringBuffer(myShortClassName).delete(delPosition, 100).toString();
        String myBufName = myShortClassName.concat("Buf");
        return myBufName;
    }

    protected void putInMyScreenBuffer(String variableName, Object variableValue) {
        String myScreenBufName = this.getMyScreenBufName();
        AttributeBuffer myScreenBuf = (AttributeBuffer)this.retrieveData(myScreenBufName);
        if (myScreenBuf == null) {
            AttributeBuffer newBuf = new AttributeBuffer();
            newBuf.setAttribute(variableName, variableValue);
            this.storeData(myScreenBufName, newBuf);
        } else {
            myScreenBuf.setAttribute(variableName, variableValue);
        }
    }

    protected Object getFromScreenBuffer(String bufferName, String variableName) {
        AttributeBuffer theBuffer = (AttributeBuffer)this.retrieveData(bufferName);
        return theBuffer.getAttribute(variableName);
    }

    protected Object getFromMyScreenBuffer(String variableName) {
        String myScreenBufName = this.getMyScreenBufName();
        AttributeBuffer myScreenBuffer = (AttributeBuffer)this.retrieveData(myScreenBufName);
        return myScreenBuffer.getAttribute(variableName);
    }

    protected void dumpMyScreenBuffer() {
        String myScreenBufName = this.getMyScreenBufName();
        AttributeBuffer myScreenBuffer = (AttributeBuffer)this.retrieveData(myScreenBufName);
        NameValue[] content = myScreenBuffer.getNameValues();
        System.out.println("------ DUMP OF " + myScreenBufName + " ------");
        for (int i = 0; i < content.length; ++i) {
            System.out.println(content[i].name + " = " + content[i].value);
        }
        System.out.println("------------------------------------ ");
    }

    protected void storePreconCheckBuffer(AttributeBuffer preconCheckResults) {
        this.storeData("PreconCheckBuf", preconCheckResults);
    }

    protected Object getFromPreconCheckBuffer(String variableName) {
        AttributeBuffer preconCheckBuffer = (AttributeBuffer)this.retrieveData("PreconCheckBuf");
        return preconCheckBuffer.getAttribute(variableName);
    }

    protected void reportError(String errorMessage, BaseException e) {
        this.reportException(e, errorMessage, null);
    }

    protected void viewClosing() {
        this.stopWizard();
    }
}

