/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.omg.CORBA.Object;
import se.ericsson.cello.support.gui.ConnectionSupervisionInterface;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ConnectionSupervisionService
extends Thread
implements ActionListener {
    private Object server;
    private ConnectionSupervisionInterface requestor;
    private int interval;
    private int timeDelay = 0;
    private Timer timeOut;
    private volatile boolean alreadyWarned = false;
    private Boolean continueChecking = Boolean.TRUE;
    private static final int TIME_BETWEEN_NODE_CHECKS = 10000;
    protected static final boolean CONNECTION_OK = true;
    protected static final boolean CONNECTION_NOT_OK = false;

    public ConnectionSupervisionService(Object server, ConnectionSupervisionInterface requestor, int interval) {
        super("Connection Supervisor ");
        Log.trace("ConnectionSupervisionController - Constructor");
        this.server = server;
        this.requestor = requestor;
        this.interval = interval * 1000;
    }

    private synchronized boolean testConnection() {
        boolean testStatus = true;
        try {
            if (this.server._non_existent()) {
                testStatus = false;
            } else {
                Log.trace("Connection still up");
                if (this.alreadyWarned) {
                    // empty if block
                }
                this.requestor.connectionRestored();
                this.alreadyWarned = false;
            }
        }
        catch (Exception e) {
            testStatus = false;
        }
        this.timeDelay = 0;
        return testStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeoutWarning(int timeoutValue) {
        Boolean bl = this.continueChecking;
        synchronized (bl) {
            if (this.continueChecking == Boolean.TRUE) {
                Log.trace("timeoutWarning( int timeout )");
                this.alreadyWarned = true;
                this.timeDelay += timeoutValue;
                this.requestor.connectionWarning(this.timeDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        this.timeOut = new Timer(this.interval, this);
        this.timeOut.setRepeats(true);
        boolean connectionStatus = true;
        while (connectionStatus && this.continueChecking == Boolean.TRUE) {
            try {
                this.wait(10000L);
                this.timeOut.start();
                connectionStatus = this.testConnection();
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                Log.logError("ConnectionSupervisionService interrupted. ", e);
            }
            finally {
                this.timeOut.stop();
            }
        }
        if (!connectionStatus) {
            this.requestor.connectionError();
            return;
        }
        Log.trace("Connection ok");
    }

    public void actionPerformed(ActionEvent evt) {
        java.lang.Object source = evt.getSource();
        if (source == this.timeOut) {
            this.timeoutWarning(this.interval);
        } else {
            Log.logWarning("An event from an unknown source!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quit() {
        Boolean bl = this.continueChecking;
        synchronized (bl) {
            this.continueChecking = Boolean.FALSE;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }
}

