/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.EmasGuilibMediator;

public class EmasProgressMonitor {
    private EmasProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object title;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int lastDisp;
    private int reportDelta;
    private static Vector openProgressMonitors = new Vector();

    public EmasProgressMonitor(Component parentComponent, Object title, Object message, String note, int min, int max) {
        this(parentComponent, title, message, note, min, max, null);
    }

    private EmasProgressMonitor(Component parentComponent, Object title, Object message, String note, int min, int max, EmasProgressMonitor group) {
        this.min = min;
        this.max = max;
        this.parentComponent = parentComponent;
        this.reportDelta = (max - min) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.title = title;
        this.message = message;
        this.note = note;
        if (group != null) {
            this.root = group.root != null ? group.root : group;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
        openProgressMonitors.add(this);
    }

    public void setProgress(int nv) {
        if (nv >= this.max) {
            this.close();
        } else if (nv >= this.lastDisp + this.reportDelta) {
            this.lastDisp = nv;
            if (this.myBar != null) {
                this.myBar.setValue(nv);
                this.repaintImmediately();
            } else {
                int predictedCompletionTime;
                long T = System.currentTimeMillis();
                long dT = (int)(T - this.T0);
                if (dT >= (long)this.millisToDecideToPopup && (predictedCompletionTime = nv > this.min ? (int)(dT * (long)(this.max - this.min) / (long)(nv - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                    this.myBar = new JProgressBar();
                    this.myBar.setMinimum(this.min);
                    this.myBar.setMaximum(this.max);
                    this.myBar.setValue(nv);
                    if (this.note != null) {
                        this.noteLabel = new JLabel(this.note);
                    }
                    this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                    this.dialog = this.pane.createDialog(this.parentComponent, this.title.toString());
                    this.dialog.show();
                    this.repaintImmediately();
                }
            }
        }
    }

    private void repaintImmediately() {
        Container comp = this.dialog.getContentPane();
        if (comp instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                comp.paintAll(comp.getGraphics());
            } else {
                comp.repaint();
            }
        } else {
            comp.repaint(0, 0, comp.getWidth(), comp.getHeight());
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
        openProgressMonitors.remove(this);
    }

    public static void closeAllOpenProgressMonitors() {
        for (int i = 0; i < openProgressMonitors.size(); ++i) {
            EmasProgressMonitor vectorProgressMonitor = (EmasProgressMonitor)openProgressMonitors.get(i);
            vectorProgressMonitor.close();
        }
        openProgressMonitors.clear();
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        this.max = m;
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
            this.repaintImmediately();
        }
    }

    public String getNote() {
        return this.note;
    }

    public void resetProgressBar() {
        this.myBar.setValue(this.min);
        this.lastDisp = this.min;
    }

    private static class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object messageList) {
            super(messageList, 1, -1, null, new Object[]{new JPanel()}, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component parentComponent, String title) {
            if (null == parentComponent) {
                parentComponent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
            }
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            final JDialog dialog = new JDialog(frame, title, false);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(null);
                }

                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == ProgressOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }
    }
}

