/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporterInterface;
import se.ericsson.cello.support.proxy.BaseException;

public class EmasSecondErrorReporterImpl
implements ErrorReporterInterface {
    private static final String unresolvedTag = "UNRESOLVED MESSAGE";
    private static final String equalTag = " = ";
    private static final String dollarTag = "$";
    private static final String commaTag = ", ";
    private static final String quoteTag = "\"";
    private static final String variablesTag = "VARIABLES";
    private static final String quoteDollarTag = "\"$";
    private volatile String lastMsg;
    private volatile ErrorDialog lastDialog;

    public void reportException(AbstractController controller, Exception e, String msgFromView, boolean modal) {
        String trace = "";
        String exMsg = "";
        String mess = "";
        if (null != e) {
            if (e.toString().indexOf("stack trace = ") != -1) {
                trace = e.toString();
            } else {
                StringWriter eStr = new StringWriter();
                e.printStackTrace(new PrintWriter(eStr));
                trace = eStr.toString();
            }
            exMsg = "Exception: " + this.getErrorTag(e);
            mess = e.getMessage();
        }
        if (null != mess && !mess.equals("") && exMsg.indexOf(mess) == -1) {
            exMsg = exMsg + "\n" + mess;
        }
        String vars = this.getVariablesString(trace);
        String msg = msgFromView + "\n\n" + exMsg + vars;
        Log.logNotify("\n- - - -\n" + msg + "- - - -\n\n" + trace + "\n");
        AbstractView parent = null;
        if (controller != null) {
            parent = controller.getView();
        }
        if (null == parent || !parent.isShowing()) {
            parent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
        }
        if (null != this.lastDialog && this.lastDialog.isShowing() && null != this.lastMsg && this.lastMsg.equals(msg)) {
            return;
        }
        this.lastMsg = msg;
        if (controller != null) {
            ErrorDialog errDia;
            String cl = controller.getString("CLOSE", null);
            cl = -1 == cl.indexOf(unresolvedTag) ? cl : null;
            String m = controller.getString("MORE", null);
            m = -1 == m.indexOf(unresolvedTag) ? m : null;
            String le = controller.getString("LESS", null);
            le = -1 == le.indexOf(unresolvedTag) ? le : null;
            String ti = controller.getString("ERROR_TITLE", null);
            ti = -1 == ti.indexOf(unresolvedTag) ? ti : null;
            this.lastDialog = errDia = ErrorDialog.create(parent, msg, trace, cl, m, le, ti);
            errDia.setModal(modal);
            errDia.show();
        } else {
            ErrorDialog errDia;
            this.lastDialog = errDia = ErrorDialog.create(parent, msg, trace);
            errDia.setModal(modal);
            errDia.show();
        }
    }

    public void reportException(AbstractController controller, Exception e, String msgFromView) {
        this.reportException(controller, e, msgFromView, true);
    }

    public void reportException(AbstractController controller, Exception e, String msgKey, Object[] msgArgs, boolean modal) {
        String msgFromView = controller.getString(msgKey, msgArgs);
        this.reportException(controller, e, msgFromView, modal);
    }

    public void reportException(AbstractController controller, Exception e, String msgKey, Object[] msgArgs) {
        String msgFromView = controller.getString(msgKey, msgArgs);
        this.reportException(controller, e, msgFromView);
    }

    private String getVariablesString(String trace) {
        int begin = trace.indexOf(quoteDollarTag);
        if (-1 == trace.indexOf(variablesTag) || -1 == begin) {
            return "";
        }
        int end = trace.indexOf("stack trace = ");
        if (-1 == end) {
            end = trace.lastIndexOf(quoteTag);
        }
        if (begin >= end) {
            return "";
        }
        String vars = trace.substring(begin, end);
        StringTokenizer tok = new StringTokenizer(vars, quoteDollarTag, true);
        StringBuffer strBuf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equals(quoteTag) || s.equals(commaTag)) continue;
            if (s.equals(dollarTag)) {
                strBuf.append("\n");
                continue;
            }
            if (s.equals(equalTag)) {
                strBuf.append(": ");
                continue;
            }
            strBuf.append(s);
        }
        return strBuf.toString();
    }

    private String getShortName(Exception e) {
        String fullName = e.getClass().getName();
        String shortName = fullName.substring(fullName.lastIndexOf(".") + 1);
        return shortName;
    }

    private String getErrorTag(Exception e) {
        String tag = "";
        if (e instanceof BaseException) {
            tag = ((BaseException)e).getExceptionTag();
            if (tag.equals("Unknown")) {
                tag = this.getShortName(e);
            }
        } else {
            tag = this.getShortName(e);
        }
        return tag;
    }
}

