/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Enumeration
implements Comparable {
    public final int ord;
    private String enumName;
    private Integer enumValue;
    private static SortedSet elements = new TreeSet();
    private static Set elementsImmutable = Collections.unmodifiableSet(elements);
    private static HashMap elementHash = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration(int aValue, String aName) {
        this.ord = aValue;
        this.enumValue = new Integer(aValue);
        this.enumName = aName;
        SortedSet sortedSet = elements;
        synchronized (sortedSet) {
            if (elementHash.containsKey(this.enumValue)) {
                throw new IllegalArgumentException("Value " + aValue + " already taken by element " + elementHash.get(this.enumValue));
            }
            elements.add(this);
            elementHash.put(this.enumValue, this);
            elementHash.put(this.enumName, this);
        }
    }

    public final Iterator iterator() {
        return elementsImmutable.iterator();
    }

    public final Set getElements() {
        return elementsImmutable;
    }

    public final Integer toInteger() {
        return this.enumValue;
    }

    public final int intValue() {
        return this.ord;
    }

    public final String toString() {
        return this.enumName;
    }

    public int compareTo(Object o) {
        Enumeration other = (Enumeration)o;
        return this.ord - other.ord;
    }

    public static Enumeration getEnum(int ord) {
        Object result = elementHash.get(new Integer(ord));
        if (result != null) {
            return (Enumeration)result;
        }
        throw new IllegalArgumentException("Enumeration does not contain elementwith ord=" + ord);
    }

    public static Enumeration getEnum(String aName) {
        Object result = elementHash.get(aName);
        if (result != null) {
            return (Enumeration)result;
        }
        throw new IllegalArgumentException("Enumeration does not contain elementwith name=" + aName);
    }
}

