/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;
import se.ericsson.cello.support.gui.LDNIndexService;
import se.ericsson.cello.support.gui.ReservedByServiceView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;

public class ReservedByServiceController
extends AbstractApplicationController
implements ActionListener {
    private ReservedByServiceView viewer = null;
    private Vector ReserversVector = null;

    protected void init() {
        this.getApplication().setTitle("EMAS_RESERVEDBY_SERVICE", null);
        this.viewer = (ReservedByServiceView)this.getView();
        this.addActionListener(this);
        this.ReserversVector = (Vector)this.getParameter("reservers");
        this.showReserversList();
    }

    void addActionListener(ActionListener listener) {
        this.viewer.btnDone.setActionListener(listener, "btDone");
        this.viewer.btnGoTo.setActionListener(listener, "btGoTo");
        this.viewer.btnCopyLDN.setActionListener(listener, "btCopyLdn");
    }

    public void setSearchResultActions(Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            this.viewer.searchResultModel.addElement(actions[i]);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Log.log(7, "Action event" + event.toString());
        this.getApplication().setStatus("");
        String cmd = event.getActionCommand();
        if (cmd == "btGoTo") {
            int index = this.viewer.searchResult.getSelectedIndex();
            if (index >= 0) {
                this.viewer.searchResultModel.executeActionAt(index, null);
            }
        } else if (cmd.equals("btCopyLdn")) {
            int index = this.viewer.searchResult.getSelectedIndex();
            if (index >= 0) {
                String ldnString = this.viewer.searchResultModel.getLDN(index);
                JTextField tf = new JTextField(ldnString);
                tf.selectAll();
                tf.copy();
            }
        } else if (cmd == "btDone") {
            this.getApplication().stopApplication();
        } else {
            this.getApplication().setStatus("");
        }
    }

    public boolean canStop() {
        return true;
    }

    private Action[] getDummyActionArr(final String ldn) {
        Action[] actionArr = new AbstractAction[]{new AbstractAction(){
            public final String orginalLDN;
            {
                this.orginalLDN = ldn;
            }

            public void actionPerformed(ActionEvent e) {
                Object[] exceptionMessage = new Object[]{""};
                ReservedByServiceController.this.showMessageDialog("RESERVEDBY_NOT_LOADED", null, "INFORMATION_MESSAGE_BOX_TITLE", exceptionMessage, 0, null);
            }

            public Object getValue(String value) {
                return this.orginalLDN;
            }
        }};
        return actionArr;
    }

    protected void showReserversList() {
        Log.trace("Show reservers: ");
        LDNIndexService is = LDNIndexService.getInstance();
        for (int i = 0; i < this.ReserversVector.size(); ++i) {
            String ldn = (String)this.ReserversVector.get(i);
            Action[] hyperlinkActions = is.getHyperlinks(ldn);
            if (hyperlinkActions.length > 0) {
                this.setSearchResultActions(hyperlinkActions);
                continue;
            }
            this.setSearchResultActions(this.getDummyActionArr(ldn));
        }
    }
}

