/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.util.Enumeration;
import java.util.Hashtable;

public class Tracer {
    private static final String CLASS_NAME = "Tracer";
    public static final int TRACER_CON = 1;
    public static final int TRACER_PRI = 2;
    public static final int TRACER_PRO = 3;
    public static final int TRACER_PUB = 4;
    private static int currentNrOfPerformedTraces = 0;
    private static int currentNrOfNotPerformedTraces = 0;
    private static boolean tracingEnabled = false;
    private static boolean[] defaultTraceSettings = new boolean[]{true, true, true, true, true};
    private static Hashtable tracingTable = new Hashtable();

    public static void setEnabled(boolean enabled) {
        tracingEnabled = enabled;
    }

    public static void setEnabled(String source, boolean enabled) {
        boolean[] traceSettings = (boolean[])tracingTable.get(source);
        traceSettings[0] = enabled;
        tracingTable.put(source, traceSettings);
    }

    public static void setEnabled(int type, boolean enabled) {
        Enumeration sources = tracingTable.keys();
        while (sources.hasMoreElements()) {
            String currentSource = (String)sources.nextElement();
            boolean[] traceSettings = (boolean[])tracingTable.get(currentSource);
            traceSettings[type] = enabled;
            tracingTable.put(currentSource, traceSettings);
        }
    }

    public static void setEnabled(String source, int type, boolean enabled) {
        boolean[] traceSettings = (boolean[])tracingTable.get(source);
        traceSettings[type] = enabled;
        tracingTable.put(source, traceSettings);
    }

    public static void trace(String source, int type, String text) {
        if (tracingEnabled) {
            if (source != null) {
                boolean[] traceSettings = (boolean[])tracingTable.get(source);
                if (traceSettings == null) {
                    System.out.println("Tracer: Class \"" + source + "\" is not known yet, using defaults");
                    traceSettings = defaultTraceSettings;
                    tracingTable.put(source, traceSettings);
                }
                int nrOfTypes = traceSettings.length;
                if (type >= 0 && type <= nrOfTypes - 1) {
                    if (traceSettings[0] && traceSettings[type]) {
                        System.out.println(type + ") " + source + ":" + text);
                        ++currentNrOfPerformedTraces;
                    } else {
                        ++currentNrOfNotPerformedTraces;
                    }
                } else {
                    ++currentNrOfNotPerformedTraces;
                    System.out.println("Tracer : Trace request ignored! (type " + type + " not allowed: min=0, max=" + (nrOfTypes - 1) + ")");
                }
            } else {
                ++currentNrOfNotPerformedTraces;
                System.out.println("Tracer : Trace request ignored! (source = null)");
            }
        } else {
            ++currentNrOfNotPerformedTraces;
        }
    }

    public static String myToString() {
        String tempString = null;
        boolean[] traceSettings = null;
        tempString = "\nTracer\n------\ntracingEnabled               : " + tracingEnabled + "\n" + "currentNrOfPerformedTraces   : " + currentNrOfPerformedTraces + "\n" + "currentNrOfNotPerformedTraces: " + currentNrOfNotPerformedTraces + "\n";
        tempString = tempString + "defaultTraceSettings          :";
        int currentType = 0;
        while (currentType < defaultTraceSettings.length) {
        }
        tempString = tempString + " " + currentType + "=" + defaultTraceSettings[currentType];
        ++currentType;
        tempString = tempString + "\n";
        tempString = tempString + "tracingTable                  : \n";
        Enumeration sources = tracingTable.keys();
        while (sources.hasMoreElements()) {
            String currentSource = (String)sources.nextElement();
            tempString = tempString + "\t" + currentSource + " :";
            traceSettings = (boolean[])tracingTable.get(currentSource);
            for (currentType = 0; currentType < traceSettings.length; ++currentType) {
                tempString = tempString + " " + currentType + "=" + traceSettings[currentType];
            }
            tempString = tempString + "\n";
        }
        tempString = tempString + "------\n";
        return tempString;
    }
}

