/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import se.ericsson.cello.support.gui.gengui.EntryField;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenFloatField
extends EntryField {
    protected Float value = null;
    private float minValue = 0.0f;
    private float maxValue = 0.0f;
    boolean checkMinValue = false;
    boolean checkMaxValue = false;
    private Locale theSetLanguage = Locale.getDefault();

    public GenFloatField(String translations, String tag, Integer length) {
        super(translations, tag, length);
        Log.trace("GenFloatField");
        this.textField.setHorizontalAlignment(4);
    }

    public GenFloatField(String tag, Integer length) {
        super(tag, length);
        Log.trace("GenFloatField()");
    }

    public boolean setValue(Float setvalue) {
        Log.trace("setValue()");
        if (this.isValidSyntax(setvalue)) {
            this.textField.setForeground(Color.black);
            this.textField.setText(setvalue.toString());
            this.value = setvalue;
            this.faultyValueEntered = false;
            return true;
        }
        return false;
    }

    public Float getValue() {
        Log.trace("getValue()");
        return this.value;
    }

    protected boolean isValidSyntax() {
        Log.trace("isValidSyntax()");
        boolean check = false;
        String newValue = this.textField.getText();
        try {
            Float test = new Float(newValue);
            float filledInValue = test.floatValue();
            if (!(this.checkMinValue && filledInValue < this.minValue || this.checkMaxValue && filledInValue > this.maxValue)) {
                check = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return check;
    }

    protected String getTag() {
        return null;
    }

    protected boolean fillInValue(String text) {
        Log.trace("fillInValue()");
        if (text.equals("")) {
            if (this.value == null) {
                return false;
            }
            this.value = null;
            return true;
        }
        String newValue = text;
        Float test = null;
        try {
            test = new Float(newValue);
        }
        catch (Exception e) {
            return false;
        }
        if (this.value != null && test.floatValue() == this.value.floatValue()) {
            return false;
        }
        this.value = new Float(newValue);
        return true;
    }

    public void setMinimumValue(Float min) {
        Log.trace("setMinimumValue()");
        this.checkMinValue = true;
        this.minValue = min.floatValue();
        if (this.checkMaxValue) {
            this.textField.setToolTipText("[" + this.minValue + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[" + this.minValue + ",...]");
        }
    }

    public void setMaximumValue(Float max) {
        Log.trace("setMaximumValue()");
        this.checkMaxValue = true;
        this.maxValue = max.floatValue();
        if (this.checkMinValue) {
            this.textField.setToolTipText("[" + this.minValue + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[...," + this.maxValue + "]");
        }
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        if (this.value != null) {
            this.theSetLanguage = locale;
            String text = this.value.toString();
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.theSetLanguage);
            text = text.replace('.', dfs.getDecimalSeparator());
            this.textField.setText(text);
        }
    }

    private boolean isValidSyntax(Float test) {
        Log.trace("isValidSyntax()");
        boolean check = false;
        float filledInValue = test.floatValue();
        if (!(this.checkMinValue && filledInValue < this.minValue || this.checkMaxValue && filledInValue > this.maxValue)) {
            check = true;
        }
        return check;
    }
}

